/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.open.ebsx.cloudutil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.OpenDept;
import net.ibizsys.central.cloud.core.util.domain.OpenUser;
import net.ibizsys.central.cloud.open.core.addin.IOpenAccessAgent;
import net.ibizsys.central.cloud.open.core.cloudutil.CloudOpenUtilRuntimeBase;
import net.ibizsys.central.cloud.saas.ebsx.EBSXSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.OpenAccessDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.OpenDeptDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.uaa.dto.OpenUserDTO;
import net.ibizsys.central.cloud.saas.ebsx.util.StaticDict;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EBSXCloudOpenUtilRuntime
extends CloudOpenUtilRuntimeBase {
    private static final Log log = LogFactory.getLog(EBSXCloudOpenUtilRuntime.class);

    protected void onSyncOrganizationUnits(String strOpenAccessId) throws Throwable {
        Collection openUsers;
        Collection openDepts;
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        IOpenAccessAgent iOpenAccessAgent = this.getOpenAccessAgent(strOpenAccessId);
        String strOpenType = iOpenAccessAgent.getOpenType().toLowerCase();
        String strDefaultAccessId = KeyValueUtils.genUniqueId((Object)iEmployeeContext.getTenant(), (Object)strOpenType.toUpperCase());
        OpenAccessDTO openAccessDTO = (OpenAccessDTO)EBSXSystemRuntime.getInstance().getOpenAccessService().get((Object)strDefaultAccessId, true);
        if (openAccessDTO == null) {
            openAccessDTO = new OpenAccessDTO();
            openAccessDTO.setId(strDefaultAccessId);
            openAccessDTO.setName(String.format("\u9ed8\u8ba4\u5e94\u7528[%1$s]", StaticDict.OpenAccessType.valueOf((String)strOpenType.toUpperCase()).getText()));
            openAccessDTO.setOpenType(iOpenAccessAgent.getOpenType().toLowerCase());
            openAccessDTO.setDefaultflag(Integer.valueOf(1));
            EBSXSystemRuntime.getInstance().getOpenAccessService().create(openAccessDTO);
        }
        if (!ObjectUtils.isEmpty((Object)(openDepts = iOpenAccessAgent.selectOpenDepts((ISearchContext)new SearchContextDTO())))) {
            ArrayList<OpenDeptDTO> list = EBSXSystemRuntime.getInstance().getOpenDeptService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().eq("OPEN_TYPE", (Object)strOpenType));
            HashMap<String, OpenDeptDTO> map = new HashMap<String, OpenDeptDTO>();
            if (!ObjectUtils.isEmpty((Object)list)) {
                list.forEach(t -> map.put(t.getRealId(), (OpenDeptDTO)t));
            }
            list = new ArrayList<OpenDeptDTO>();
            for (OpenDept openDept : openDepts) {
                OpenDeptDTO item = (OpenDeptDTO)map.get(openDept.getRealId());
                if (item != null) continue;
                item = new OpenDeptDTO();
                item.reload((Object)openDept, true);
                item.setOpenType(strOpenType);
                item.setOpenDeptId(KeyValueUtils.genUniqueId());
                item.setIsBinding(Integer.valueOf(0));
                list.add(item);
                map.put(openDept.getRealId(), item);
            }
            if (!ObjectUtils.isEmpty(list)) {
                EBSXSystemRuntime.getInstance().getOpenDeptService().rawCreate(list, false);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(openUsers = iOpenAccessAgent.selectOpenUsers((ISearchContext)new SearchContextDTO())))) {
            ArrayList<OpenUserDTO> list = EBSXSystemRuntime.getInstance().getOpenUserService().selectDefault((ISearchContextDTO)new SearchContextDTO().all().eq("OPEN_TYPE", (Object)strOpenType));
            HashMap<String, OpenUserDTO> map = new HashMap<String, OpenUserDTO>();
            if (!ObjectUtils.isEmpty((Object)list)) {
                list.forEach(t -> map.put(t.getUserId(), (OpenUserDTO)t));
            }
            list = new ArrayList<OpenUserDTO>();
            for (OpenUser openUser : openUsers) {
                OpenUserDTO item = (OpenUserDTO)map.get(openUser.getUserId());
                if (item != null) continue;
                item = new OpenUserDTO();
                item.reload((Object)openUser, true);
                item.setOpenType(strOpenType);
                item.setOpenUserId(KeyValueUtils.genUniqueId());
                item.setIsBinding(Integer.valueOf(0));
                list.add(item);
                map.put(openUser.getUserId(), item);
            }
            if (!ObjectUtils.isEmpty(list)) {
                EBSXSystemRuntime.getInstance().getOpenUserService().rawCreate(list, false);
            }
        }
    }

    protected OpenUser onGetOpenUserBySNSCode(String strOpenAccessId, String strCode) throws Throwable {
        OpenUser openUser = super.onGetOpenUserBySNSCode(strOpenAccessId, strCode);
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        IOpenAccessAgent iOpenAccessAgent = this.getOpenAccessAgent(strOpenAccessId);
        searchContextDTO.eq("OPEN_TYPE", (Object)iOpenAccessAgent.getOpenType());
        if (StringUtils.hasLength((String)openUser.getRealId())) {
            searchContextDTO.eq("REALID", (Object)openUser.getRealId());
        }
        if (StringUtils.hasLength((String)openUser.getUserId())) {
            searchContextDTO.eq("USERID", (Object)openUser.getUserId());
        }
        searchContextDTO.limit(1);
        List list = EBSXSystemRuntime.getInstance().getOpenUserService().selectDefault((ISearchContextDTO)searchContextDTO);
        if (!ObjectUtils.isEmpty((Object)list)) {
            ((OpenUserDTO)list.get(0)).copyTo((IEntity)openUser, true);
        }
        return openUser;
    }

    protected OpenUser onGetOpenUserByAuthCode(String strOpenAccessId, String strCode) throws Throwable {
        OpenUser openUser = super.onGetOpenUserByAuthCode(strOpenAccessId, strCode);
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        IOpenAccessAgent iOpenAccessAgent = this.getOpenAccessAgent(strOpenAccessId);
        searchContextDTO.eq("OPEN_TYPE", (Object)iOpenAccessAgent.getOpenType());
        searchContextDTO.eq("USERID", (Object)openUser.getUserId());
        searchContextDTO.limit(1);
        List list = EBSXSystemRuntime.getInstance().getOpenUserService().selectDefault((ISearchContextDTO)searchContextDTO);
        if (!ObjectUtils.isEmpty((Object)list)) {
            ((OpenUserDTO)list.get(0)).copyTo((IEntity)openUser, true);
        }
        return openUser;
    }
}

