/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.open.dingtalk.addin;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.request.OapiSnsGetuserinfoBycodeRequest;
import com.dingtalk.api.request.OapiUserGetuserinfoRequest;
import com.dingtalk.api.request.OapiV2DepartmentListsubRequest;
import com.dingtalk.api.request.OapiV2UserListRequest;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.dingtalk.api.response.OapiSnsGetuserinfoBycodeResponse;
import com.dingtalk.api.response.OapiUserGetuserinfoResponse;
import com.dingtalk.api.response.OapiV2DepartmentListsubResponse;
import com.dingtalk.api.response.OapiV2UserListResponse;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.taobao.api.TaobaoRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.util.domain.MsgTemplateType;
import net.ibizsys.central.cloud.core.util.domain.OpenAccess;
import net.ibizsys.central.cloud.core.util.domain.OpenDept;
import net.ibizsys.central.cloud.core.util.domain.OpenUser;
import net.ibizsys.central.cloud.open.core.addin.OpenAccessAgentBase;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.domain.MsgSendQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DingTalkOpenAccessAgent
extends OpenAccessAgentBase {
    private static final Log log = LogFactory.getLog(DingTalkOpenAccessAgent.class);

    protected void onInit() throws Exception {
        super.onInit();
    }

    public String getName() {
        return "DINGTALK";
    }

    protected String doRequestToken() throws Throwable {
        OpenAccess agentData = this.getAgentData();
        if (!StringUtils.hasLength((String)agentData.getAccessKey()) || !StringUtils.hasLength((String)agentData.getSecretKey())) {
            throw new Exception("\u672a\u6307\u5b9a appKey \u6216 appSecret");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("appKey", agentData.getAccessKey());
        map.put("appSecret", agentData.getSecretKey());
        String strUri = "https://api.dingtalk.com/v1.0/oauth2/accessToken";
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, null, null, map, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object errcode = ret.get("errcode");
        if (DataTypeUtils.getIntegerValue(errcode, (Integer)0) != 0) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("errmsg")));
        }
        Object expireIn = ret.get("expireIn");
        if (expireIn != null) {
            Integer nTimeout = Integer.parseInt(expireIn.toString());
            this.setTokenTimeout(System.currentTimeMillis() + (long)(nTimeout * 1000));
        }
        Object accessToken = ret.get("accessToken");
        return (String)accessToken;
    }

    protected Collection<OpenDept> onSelectOpenDepts(ISearchContext iSearchContext) throws Throwable {
        OapiV2DepartmentListsubResponse rsp;
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
        OapiV2DepartmentListsubRequest req = new OapiV2DepartmentListsubRequest();
        req.setLanguage("zh_CN");
        if (iSearchContext.get("dept_id") != null) {
            req.setDeptId(DataTypeUtils.getLongValue((Object)iSearchContext.get("dept_id"), (Long)0L));
        }
        if (!(rsp = (OapiV2DepartmentListsubResponse)client.execute((TaobaoRequest)req, this.getToken())).isSuccess()) {
            throw new Exception(rsp.getErrmsg());
        }
        List list = rsp.getResult();
        ArrayList<OpenDept> openDeptList = new ArrayList<OpenDept>();
        if (!ObjectUtils.isEmpty((Object)list)) {
            for (OapiV2DepartmentListsubResponse.DeptBaseResponse item : list) {
                OpenDept openDept = new OpenDept();
                openDept.setOpenDeptName(item.getName());
                openDept.setRealId(item.getDeptId().toString());
                openDept.setOpenDeptCode(item.getDeptId().toString());
                openDeptList.add(openDept);
                SearchContextDTO subSearchContext = new SearchContextDTO();
                subSearchContext.set("dept_id", (Object)item.getDeptId());
                Collection subDepts = this.selectOpenDepts((ISearchContext)subSearchContext);
                if (ObjectUtils.isEmpty((Object)subDepts)) continue;
                openDeptList.addAll(subDepts);
            }
        }
        return openDeptList;
    }

    protected Collection<OpenUser> onSelectOpenUsers(ISearchContext iSearchContext) throws Throwable {
        ArrayList<OpenUser> openUserList = new ArrayList<OpenUser>();
        Collection openDepts = this.selectOpenDepts((ISearchContext)new SearchContextDTO());
        if (!ObjectUtils.isEmpty((Object)openDepts)) {
            ArrayList<Long> deptIdList = new ArrayList<Long>();
            deptIdList.add(1L);
            for (OpenDept openDept : openDepts) {
                deptIdList.add(Long.parseLong(openDept.getRealId()));
            }
            for (Long nDeptId : deptIdList) {
                Collection<OapiV2UserListResponse.ListUserResponse> list = this.getUsersByDeptId(nDeptId);
                if (ObjectUtils.isEmpty(list)) continue;
                for (OapiV2UserListResponse.ListUserResponse item : list) {
                    OpenUser openUser = new OpenUser();
                    if (!ObjectUtils.isEmpty((Object)item.getDeptIdList())) {
                        openUser.setDepts(StringUtils.arrayToDelimitedString((Object[])item.getDeptIdList().toArray(), (String)","));
                    } else {
                        openUser.setDepts(nDeptId.toString());
                    }
                    openUser.setRealId(item.getUnionid());
                    openUser.setUserId(item.getUserid());
                    openUser.setOpenUserCode(item.getJobNumber());
                    openUser.setMobile(item.getMobile());
                    openUser.setOpenUserName(item.getName());
                    openUserList.add(openUser);
                }
            }
        }
        return openUserList;
    }

    protected Collection<OapiV2UserListResponse.ListUserResponse> getUsersByDeptId(Long deptId) throws Throwable {
        Collection<OapiV2UserListResponse.ListUserResponse> list = this.getUsersByDeptId(deptId, 0L, 100L);
        return list;
    }

    protected Collection<OapiV2UserListResponse.ListUserResponse> getUsersByDeptId(Long deptId, Long offset, Long size) throws Throwable {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/list");
        OapiV2UserListRequest req = new OapiV2UserListRequest();
        req.setDeptId(deptId);
        req.setCursor(Long.valueOf(offset * size));
        req.setSize(size);
        req.setOrderField("modify_desc");
        req.setContainAccessLimit(Boolean.valueOf(false));
        req.setLanguage("zh_CN");
        OapiV2UserListResponse rsp = (OapiV2UserListResponse)client.execute((TaobaoRequest)req, this.getToken());
        if (!rsp.isSuccess()) {
            throw new Exception(rsp.getErrmsg());
        }
        List list = rsp.getResult().getList();
        if (rsp.getResult().getHasMore().booleanValue()) {
            Long l = offset;
            Long l2 = offset = Long.valueOf(offset + 1L);
            list.addAll(this.getUsersByDeptId(deptId, l, size));
        }
        return list;
    }

    protected void onSendMessages(MsgSendQueue[] msgSendQueues) throws Throwable {
        for (MsgSendQueue msgSendQueue : msgSendQueues) {
            this.doSendMessage(msgSendQueue);
        }
    }

    protected void doSendMessage(MsgSendQueue msgSendQueue) throws Throwable {
        String strDstUsers = msgSendQueue.getDstUsers();
        if (ObjectUtils.isEmpty((Object)strDstUsers)) {
            throw new Exception("\u672a\u6307\u5b9a\u76ee\u6807\u7528\u6237");
        }
        if (strDstUsers.indexOf("[") == 0) {
            ArrayNode arrayNode = JsonUtils.toArrayNode((Object)strDstUsers);
            for (int i = 0; i < arrayNode.size(); ++i) {
                this.doSendMessage(arrayNode.get(i).asText(), msgSendQueue);
            }
        } else {
            String[] userIds;
            for (String strUserId : userIds = strDstUsers.split("[,]")) {
                this.doSendMessage(strUserId, msgSendQueue);
            }
        }
    }

    protected void doSendMessage(String strUserId, MsgSendQueue msgSendQueue) throws Throwable {
        OpenUser openUser = this.getContext().getOpenUser("DINGTALK", strUserId);
        if (!StringUtils.hasLength((String)openUser.getUserId())) {
            throw new Exception(String.format("\u7528\u6237[%1$s]\u672a\u7ed1\u5b9a\u9489\u9489\u8d26\u6237", openUser.getOpenUserName()));
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2");
        OapiMessageCorpconversationAsyncsendV2Request req = new OapiMessageCorpconversationAsyncsendV2Request();
        req.setAgentId(this.getAgentData().getAgentId());
        req.setUseridList(openUser.getUserId());
        String strDDContent = msgSendQueue.getDDContent();
        if (!StringUtils.hasLength((String)strDDContent)) {
            strDDContent = this.getRealContent(msgSendQueue, MsgTemplateType.MSG.getValue());
        }
        OapiMessageCorpconversationAsyncsendV2Request.Msg obj1 = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        obj1.setMsgtype("text");
        OapiMessageCorpconversationAsyncsendV2Request.Text obj2 = new OapiMessageCorpconversationAsyncsendV2Request.Text();
        obj2.setContent(strDDContent);
        obj1.setText(obj2);
        OapiMessageCorpconversationAsyncsendV2Request.OA obj3 = new OapiMessageCorpconversationAsyncsendV2Request.OA();
        OapiMessageCorpconversationAsyncsendV2Request.Body obj4 = new OapiMessageCorpconversationAsyncsendV2Request.Body();
        obj4.setContent(strDDContent);
        obj3.setBody(obj4);
        obj1.setOa(obj3);
        req.setMsg(obj1);
        OapiMessageCorpconversationAsyncsendV2Response rsp = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)req, this.getToken());
        if (!rsp.isSuccess()) {
            throw new Exception(rsp.getErrmsg());
        }
    }

    protected OpenUser onGetOpenUserBySNSCode(String strCode) throws Throwable {
        OpenAccess agentData = this.getAgentData();
        if (!StringUtils.hasLength((String)agentData.getAccessKey()) || !StringUtils.hasLength((String)agentData.getSecretKey())) {
            throw new Exception("\u672a\u6307\u5b9a appKey \u6216 appSecret");
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/sns/getuserinfo_bycode");
        OapiSnsGetuserinfoBycodeRequest req = new OapiSnsGetuserinfoBycodeRequest();
        req.setTmpAuthCode(strCode);
        OapiSnsGetuserinfoBycodeResponse response = (OapiSnsGetuserinfoBycodeResponse)client.execute((TaobaoRequest)req, agentData.getAccessKey(), agentData.getSecretKey());
        if (!response.isSuccess()) {
            throw new Exception(response.getErrmsg());
        }
        OapiSnsGetuserinfoBycodeResponse.UserInfo userInfo = response.getUserInfo();
        OpenUser openUser = new OpenUser();
        openUser.setRealId(userInfo.getUnionid());
        openUser.setOpenUserName(userInfo.getNick());
        return openUser;
    }

    protected OpenUser onGetOpenUserByAuthCode(String strCode) throws Throwable {
        OpenAccess agentData = this.getAgentData();
        if (!StringUtils.hasLength((String)agentData.getAccessKey()) || !StringUtils.hasLength((String)agentData.getSecretKey())) {
            throw new Exception("\u672a\u6307\u5b9a appKey \u6216 appSecret");
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/getuserinfo");
        OapiUserGetuserinfoRequest request = new OapiUserGetuserinfoRequest();
        request.setCode(strCode);
        request.setHttpMethod("GET");
        OapiUserGetuserinfoResponse response = (OapiUserGetuserinfoResponse)client.execute((TaobaoRequest)request, this.getToken());
        if (!response.isSuccess()) {
            throw new Exception(response.getErrmsg());
        }
        OpenUser openUser = new OpenUser();
        openUser.setUserId(response.getUserid());
        return openUser;
    }
}

