/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.notify.ebsx.cloudutil;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.CarbonCopy;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.cloud.core.util.domain.Todo;
import net.ibizsys.central.cloud.core.util.domain.TodoState;
import net.ibizsys.central.cloud.notify.core.cloudutil.CloudNotifyUtilRuntimeBase;
import net.ibizsys.central.cloud.saas.ebsx.EBSXSystemRuntime;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.MsgSendQueueDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.MsgSendQueueHisDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.SysMsgSendQueueDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.TodoDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.dto.TodoHisDTO;
import net.ibizsys.central.cloud.saas.ebsx.spring.core.notify.service.IMsgSendQueueService;
import net.ibizsys.central.cloud.saas.ebsx.util.StaticDict;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.domain.MsgSendQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EBSXCloudNotifyUtilRuntime
extends CloudNotifyUtilRuntimeBase {
    private static final Log log = LogFactory.getLog(EBSXCloudNotifyUtilRuntime.class);

    protected void onInstall() throws Exception {
        super.onInstall();
    }

    protected void onNotifyTimer() throws Throwable {
        long nCurrentTime = System.currentTimeMillis();
        Timestamp fromDate = new Timestamp(nCurrentTime - (long)this.getNotifyTimeRangeFrom());
        Timestamp toDate = new Timestamp(nCurrentTime + (long)this.getNotifyTimeRangeTo());
        SearchContextDTO searchContextDTO = new SearchContextDTO();
        searchContextDTO.eq("ISSEND", (Object)0);
        searchContextDTO.eq("ISERROR", (Object)0);
        searchContextDTO.nn("PLANSENDTIME");
        searchContextDTO.gt("PLANSENDTIME", (Object)fromDate);
        searchContextDTO.lte("PLANSENDTIME", (Object)toDate);
        searchContextDTO.count(false);
        searchContextDTO.limit(1000);
        List list = EBSXSystemRuntime.getInstance().getSysMsgSendQueueService().selectView((ISearchContextDTO)searchContextDTO);
        if (ObjectUtils.isEmpty((Object)list)) {
            return;
        }
        for (SysMsgSendQueueDTO item : list) {
            MsgSendQueue msgSendQueue = new MsgSendQueue();
            item.copyTo((IEntity)msgSendQueue, true);
            this.doSendMsg(msgSendQueue, true);
        }
    }

    protected void onCreateTodos(Todo[] todos) throws Throwable {
        for (Todo todo : todos) {
            TodoDTO todoDTO;
            if (StringUtils.hasLength((String)todo.getTodoState()) && todo.getTodoState().equals(TodoState.COMPLETED.getValue())) {
                todoDTO = new TodoHisDTO();
                todo.copyTo((IEntity)todoDTO);
                EBSXSystemRuntime.getInstance().getTodoHisService().create((TodoHisDTO)todoDTO);
                todoDTO.copyTo((IEntity)todo, true);
                continue;
            }
            todoDTO = new TodoDTO();
            todo.copyTo((IEntity)todoDTO);
            EBSXSystemRuntime.getInstance().getTodoService().create(todoDTO);
            todoDTO.copyTo((IEntity)todo, true);
        }
    }

    protected Todo onMarkReadTodo(String strTodoId) throws Throwable {
        return super.onMarkReadTodo(strTodoId);
    }

    protected Todo onMarkReadTodo(String strTaskType, String strTaskId) throws Throwable {
        return super.onMarkReadTodo(strTaskType, strTaskId);
    }

    protected Todo onCompleteTodo(String strTaskType, String strTaskId) throws Throwable {
        return super.onCompleteTodo(strTaskType, strTaskId);
    }

    protected Todo onCancelTodo(String strTaskType, String strTaskId) throws Throwable {
        return super.onCancelTodo(strTaskType, strTaskId);
    }

    protected Todo onDelegateTodo(String strTaskType, String strTaskId, String strTargetUserId) throws Throwable {
        return super.onDelegateTodo(strTaskType, strTaskId, strTargetUserId);
    }

    protected Todo onResolveTodo(String strTaskType, String strTaskId) throws Throwable {
        return super.onResolveTodo(strTaskType, strTaskId);
    }

    protected Todo onReassignTodo(String strTaskType, String strTaskId, String strTargetUserId) throws Throwable {
        return super.onReassignTodo(strTaskType, strTaskId, strTargetUserId);
    }

    protected Page<Todo> onFetchTodos(String strTaskType, Map<String, Object> conds) throws Throwable {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        ISearchContextDTO iSearchContextDTO = EBSXSystemRuntime.getInstance().getTodoService().createSearchContextDTO(conds);
        iSearchContextDTO.eq("TODOTYPE", (Object)strTaskType);
        iSearchContextDTO.set("n_todosubtype_eq", StaticDict.TodoSubType.TODO.toString());
        if (!ObjectUtils.isEmpty((Object)iEmployeeContext.getDcsystemid())) {
            iSearchContextDTO.eq("DCSYSTEMID", (Object)iEmployeeContext.getDcsystemid());
        }
        Page page = EBSXSystemRuntime.getInstance().getTodoService().fetchCurUser(iSearchContextDTO);
        ArrayList<Todo> list = new ArrayList<Todo>();
        if (page != null && !ObjectUtils.isEmpty((Object)page.getContent())) {
            for (TodoDTO dto : page.getContent()) {
                Todo todo = new Todo();
                dto.copyTo((IEntity)todo, true);
                list.add(todo);
            }
        }
        if (page != null) {
            return new PageImpl(list, page.getPageable(), page.getTotalElements());
        }
        return new PageImpl(list);
    }

    protected void onCreateCarbonCopies(CarbonCopy[] todos) throws Throwable {
        super.onCreateCarbonCopies(todos);
    }

    protected CarbonCopy onMarkReadCarbonCopy(String strCarbonCopyId) throws Throwable {
        return super.onMarkReadCarbonCopy(strCarbonCopyId);
    }

    protected CarbonCopy onMarkReadCarbonCopy(String strTaskType, String strTaskId) throws Throwable {
        return super.onMarkReadCarbonCopy(strTaskType, strTaskId);
    }

    protected void onSendMessages(MsgSendQueue[] msgSendQueues) throws Throwable {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        ArrayList<MsgSendQueueDTO> list = new ArrayList<MsgSendQueueDTO>();
        for (MsgSendQueue msgSendQueue : msgSendQueues) {
            MsgSendQueueDTO msgSendQueueDTO = new MsgSendQueueDTO();
            msgSendQueueDTO.reload((Object)msgSendQueue, true);
            if (StringUtils.hasLength((String)msgSendQueueDTO.getMsgSendQueueId())) {
                msgSendQueueDTO.setMsgSendQueueId(KeyValueUtils.genUniqueId((Object)iEmployeeContext.getDcsystemid(), (Object)msgSendQueueDTO.getMsgSendQueueId()));
            } else {
                msgSendQueueDTO.setMsgSendQueueId(KeyValueUtils.genUniqueId());
            }
            msgSendQueueDTO.setIsError(Integer.valueOf(0));
            msgSendQueueDTO.setIsSend(Integer.valueOf(0));
            msgSendQueueDTO.setDCSystemId(iEmployeeContext.getDcsystemid());
            msgSendQueueDTO.setSystemId(iEmployeeContext.getSystemid());
            list.add(msgSendQueueDTO);
        }
        IMsgSendQueueService msgSendQueueService = EBSXSystemRuntime.getInstance().getMsgSendQueueService();
        msgSendQueueService.rawCreate(list, false);
        for (MsgSendQueueDTO item : list) {
            MsgSendQueue msgSendQueue;
            if (item.getPlanSendTime() != null) continue;
            msgSendQueue = new MsgSendQueue();
            item.copyTo((IEntity)msgSendQueue, true);
            msgSendQueue.set("srfdcid", (Object)iEmployeeContext.getTenant());
            this.doSendMsg(msgSendQueue, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendMsgReal(MsgSendQueue msgSendQueue) {
        super.doSendMsgReal(msgSendQueue);
        String strDCId = (String)msgSendQueue.get("srfdcid");
        String strDCSystemId = (String)msgSendQueue.get("dcsystemid");
        String strSystemId = (String)msgSendQueue.get("systemid");
        Employee employee = new Employee();
        employee.setSrfdcid(strDCId);
        employee.setUserId("SYSTEM");
        employee.setUserName("\u901a\u77e5\u4f5c\u4e1a");
        employee.setPersonName("\u901a\u77e5\u4f5c\u4e1a");
        employee.setDCSystemId(strDCSystemId);
        IEmployeeContext lastEmployeeContext = EmployeeContext.getCurrent();
        EmployeeContext iEmployeeContext = new EmployeeContext(employee, null, strSystemId);
        EmployeeContext.setCurrent((IEmployeeContext)iEmployeeContext);
        try {
            int nError = DataTypeUtils.getIntegerValue((Object)msgSendQueue.getIsError(), (Integer)0);
            MsgSendQueueHisDTO msgSendQueueHisDTO = new MsgSendQueueHisDTO();
            msgSendQueueHisDTO.reload((Object)msgSendQueue, true);
            msgSendQueueHisDTO.setMsgSendQueueHisId(KeyValueUtils.genUniqueId());
            msgSendQueueHisDTO.setMsgSendQueueHisName(msgSendQueue.getMsgSendQueueName());
            EBSXSystemRuntime.getInstance().getMsgSendQueueHisService().rawCreate(Arrays.asList(msgSendQueueHisDTO), false);
            EBSXSystemRuntime.getInstance().getMsgSendQueueService().rawRemove(Arrays.asList(msgSendQueue.getMsgSendQueueId()));
        }
        catch (Throwable ex) {
            log.error((Object)String.format("[%1$s]\u53d1\u9001\u6d88\u606f\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getLogicName(), ex.getMessage()), ex);
            this.getSystemRuntime().log(40000, this.getLogCat(), String.format("[%1$s]\u53d1\u9001\u6d88\u606f\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getLogicName(), ex.getMessage()), null);
        }
        finally {
            EmployeeContext.setCurrent((IEmployeeContext)lastEmployeeContext);
        }
    }

    protected MsgSendQueue onSendMessage(String strMsgId) throws Throwable {
        return super.onSendMessage(strMsgId);
    }

    protected Collection<MsgSendQueue> onGetMessages(String[] ids) throws Throwable {
        return super.onGetMessages(ids);
    }
}

