package net.ibizsys.central.cloud.devops.metersphere.service.client;

import java.util.Collection;

import org.springframework.data.domain.Page;

import net.ibizsys.central.cloud.devops.metersphere.service.dto.ProjectDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestCaseDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestCaseNodeDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestPlanCaseDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestPlanDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.WorkspaceDTO;
import net.ibizsys.central.cloud.devops.metersphere.util.MSSearchContextDTO;

public interface IMeterSphereClient {

	/**
	 * 列出工作空间
	 * @param msSearchContextDTO
	 * @return
	 * @throws Throwable
	 */
	Page<WorkspaceDTO> listWorkspace(MSSearchContextDTO msSearchContextDTO) throws Throwable;
	
	
	/**
	 * 建立工作空间
	 * @param workspaceDTO
	 * @return
	 * @throws Throwable
	 */
	WorkspaceDTO createWorkspace(WorkspaceDTO workspaceDTO) throws Throwable;
	
	
	/**
	 * 列出项目
	 * @param msSearchContextDTO
	 * @return
	 * @throws Throwable
	 */
	Page<ProjectDTO> listProject(MSSearchContextDTO msSearchContextDTO) throws Throwable;
	
	
	/**
	 * 建立项目
	 * @param projectDTO
	 * @return
	 * @throws Throwable
	 */
	ProjectDTO createProject(ProjectDTO projectDTO) throws Throwable;
	
	
	
	/**
	 * 列出测试用例节点
	 * @param msSearchContextDTO
	 * @return
	 * @throws Throwable
	 */
	Page<TestCaseNodeDTO> listTestCaseNode(MSSearchContextDTO msSearchContextDTO) throws Throwable;
	
	
	/**
	 * 建立测试用例节点
	 * @param testCaseNodeDTO
	 * @return
	 * @throws Throwable
	 */
	TestCaseNodeDTO createTestCaseNode(TestCaseNodeDTO testCaseNodeDTO) throws Throwable;
	
	
	/**
	 * 列出测试用例
	 * @param msSearchContextDTO
	 * @return
	 * @throws Throwable
	 */
	Page<TestCaseDTO> listTestCase(MSSearchContextDTO msSearchContextDTO) throws Throwable;
	
	
	/**
	 * 建立测试用例
	 * @param testCaseDTO
	 * @return
	 * @throws Throwable
	 */
	TestCaseDTO createTestCase(TestCaseDTO testCaseDTO) throws Throwable;
	
	
	
	/**
	 * 列出测试计划
	 * @param msSearchContextDTO
	 * @return
	 * @throws Throwable
	 */
	Page<TestPlanDTO> listTestPlan(MSSearchContextDTO msSearchContextDTO) throws Throwable;
	
	
	/**
	 * 建立测试计划
	 * @param testPlanDTO
	 * @return
	 * @throws Throwable
	 */
	TestPlanDTO createTestPlan(TestPlanDTO testPlanDTO) throws Throwable;
	
	
	
	/**
	 * 建立测试计划
	 * @param testPlanDTO
	 * @param testCaseIds 关联用例
	 * @return
	 * @throws Throwable
	 */
	void relevanceTestPlan(TestPlanDTO testPlanDTO, Collection<String> testCaseIds) throws Throwable;
	
	
	
	/**
	 * 列出测试计划相关用例
	 * @param msSearchContextDTO
	 * @return
	 * @throws Throwable
	 */
	Page<TestPlanCaseDTO> listTestPlanCase(MSSearchContextDTO msSearchContextDTO) throws Throwable;
	
	
	
	/**
	 * 编辑测试计划用例
	 * @param testPlanCaseDTO
	 * @return
	 * @throws Throwable
	 */
	void editTestPlanCase(TestPlanCaseDTO testPlanCaseDTO) throws Throwable;
}
