/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.devops.metersphere.service.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.cloud.devops.metersphere.service.client.IMeterSphereClient;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.ProjectDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestCaseDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestCaseNodeDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestPlanCaseDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestPlanDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.WorkspaceDTO;
import net.ibizsys.central.cloud.devops.metersphere.util.MSSearchContextDTO;
import net.ibizsys.central.service.client.ITokenUtil;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.central.service.client.TokenUtilBase;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MeterSphereClient
implements IMeterSphereClient {
    private static final Log log = LogFactory.getLog(MeterSphereClient.class);
    private ISystemRuntime iSystemRuntime = null;
    private IModelRuntime iModelRuntime = null;
    private String strServiceUrl = null;
    private String strClientId = null;
    private String strClientSecret = null;
    private ITokenUtil iTokenUtil = null;

    public MeterSphereClient(ISystemRuntime iSystemRuntime, IModelRuntime iModelRuntime) {
        Assert.notNull((Object)iSystemRuntime, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iModelRuntime, (String)"\u4f20\u5165\u6240\u5c5e\u6a21\u578b\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        this.setSystemRuntime(iSystemRuntime);
        this.setModelRuntime(iModelRuntime);
    }

    protected ISystemRuntime getSystemRuntime() {
        return this.iSystemRuntime;
    }

    protected void setSystemRuntime(ISystemRuntime iSystemRuntime) {
        this.iSystemRuntime = iSystemRuntime;
    }

    protected IModelRuntime getModelRuntime() {
        return this.iModelRuntime;
    }

    protected void setModelRuntime(IModelRuntime iModelRuntime) {
        this.iModelRuntime = iModelRuntime;
    }

    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    public void setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
    }

    public String getClientId() {
        return this.strClientId;
    }

    public void setClientId(String strClientId) {
        this.strClientId = strClientId;
    }

    public String getClientSecret() {
        return this.strClientSecret;
    }

    public void setClientSecret(String strClientSecret) {
        this.strClientSecret = strClientSecret;
    }

    protected String getToken() {
        return this.getTokenUtil().getToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ITokenUtil getTokenUtil() {
        if (this.iTokenUtil != null) {
            return this.iTokenUtil;
        }
        MeterSphereClient meterSphereClient = this;
        synchronized (meterSphereClient) {
            if (this.iTokenUtil == null) {
                this.iTokenUtil = this.createTokenUtil();
            }
        }
        return this.iTokenUtil;
    }

    protected ITokenUtil createTokenUtil() {
        return new TokenUtilBase(this.getSystemRuntime(), this.getModelRuntime()){

            protected String doRequestToken() throws Throwable {
                List list;
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                if (StringUtils.hasLength((String)MeterSphereClient.this.getClientId())) {
                    map.put("username", MeterSphereClient.this.getClientId());
                }
                if (StringUtils.hasLength((String)MeterSphereClient.this.getClientSecret())) {
                    map.put("password", MeterSphereClient.this.getClientSecret());
                }
                map.put("authenticate", "LDAP");
                String strUri = String.format("%1$s/ldap/signin", MeterSphereClient.this.getServiceUrl());
                IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, null, null, map, null, Map.class, null);
                Map ret = (Map)rep.getBody();
                Object success = ret.get("success");
                if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
                    throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
                }
                String accessToken = null;
                Object data = ret.get("data");
                if (data instanceof Map) {
                    accessToken = (String)((Map)data).get("csrfToken");
                }
                if (!ObjectUtils.isEmpty((Object)(list = rep.getHeaderValues("Set-Cookie")))) {
                    block0: for (String strValue : list) {
                        String[] items;
                        if (!StringUtils.hasLength((String)strValue) || strValue.indexOf("MS_SESSION_ID=") == -1) continue;
                        for (String strItem : items = strValue.split("[;]")) {
                            if (strValue.indexOf("MS_SESSION_ID=") != 0) continue;
                            accessToken = accessToken + ";";
                            accessToken = accessToken + strItem;
                            continue block0;
                        }
                    }
                }
                return accessToken;
            }
        };
    }

    protected Map<String, String> getHeaders() {
        String strToken = this.getToken();
        String[] items = strToken.split("[;]");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CSRF-TOKEN", items[0]);
        if (items.length > 1) {
            headers.put("Cookie", items[1]);
        }
        return headers;
    }

    @Override
    public Page<WorkspaceDTO> listWorkspace(MSSearchContextDTO msSearchContextDTO) throws Throwable {
        HashMap<String, Integer> uriParams = new HashMap<String, Integer>();
        uriParams.put("goPage", 1);
        uriParams.put("pageSize", 500);
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/workspace/list/all/{goPage}/{pageSize}", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, (Object)msSearchContextDTO, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof Map) {
            Object listObject = ((Map)data).get("listObject");
            List list = (List)JsonUtils.MAPPER.convertValue(listObject, (TypeReference)new TypeReference<List<WorkspaceDTO>>(){});
            return new PageImpl(list);
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public WorkspaceDTO createWorkspace(WorkspaceDTO workspaceDTO) throws Throwable {
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/workspace/add", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, (Object)workspaceDTO, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof Map) {
            return (WorkspaceDTO)((Object)JsonUtils.MAPPER.convertValue(data, WorkspaceDTO.class));
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public Page<ProjectDTO> listProject(MSSearchContextDTO msSearchContextDTO) throws Throwable {
        HashMap<String, Integer> uriParams = new HashMap<String, Integer>();
        uriParams.put("goPage", 1);
        uriParams.put("pageSize", 500);
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/project/list/{goPage}/{pageSize}", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, (Object)msSearchContextDTO, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof Map) {
            Object listObject = ((Map)data).get("listObject");
            List list = (List)JsonUtils.MAPPER.convertValue(listObject, (TypeReference)new TypeReference<List<ProjectDTO>>(){});
            return new PageImpl(list);
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public ProjectDTO createProject(ProjectDTO projectDTO) throws Throwable {
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/project/add", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, (Object)projectDTO, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof Map) {
            return (ProjectDTO)((Object)JsonUtils.MAPPER.convertValue(data, ProjectDTO.class));
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public Page<TestCaseNodeDTO> listTestCaseNode(MSSearchContextDTO msSearchContextDTO) throws Throwable {
        HashMap<String, Integer> uriParams = new HashMap<String, Integer>();
        uriParams.put("goPage", 1);
        uriParams.put("pageSize", 500);
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/case/node/list/project", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, (Object)msSearchContextDTO, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof List) {
            List list = (List)JsonUtils.MAPPER.convertValue(data, (TypeReference)new TypeReference<List<TestCaseNodeDTO>>(){});
            return new PageImpl(list);
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public TestCaseNodeDTO createTestCaseNode(TestCaseNodeDTO testCaseNodeDTO) throws Throwable {
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/case/node/add", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, (Object)testCaseNodeDTO, null, String.class, null);
        ObjectNode objectNode = JsonUtils.toObjectNode((Object)rep.getBody());
        Map ret = (Map)JsonUtils.MAPPER.convertValue((Object)objectNode, Map.class);
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof Map) {
            return (TestCaseNodeDTO)((Object)JsonUtils.MAPPER.convertValue(data, TestCaseNodeDTO.class));
        }
        if (data instanceof String) {
            testCaseNodeDTO.setId((String)data);
            return testCaseNodeDTO;
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public Page<TestCaseDTO> listTestCase(MSSearchContextDTO msSearchContextDTO) throws Throwable {
        HashMap<String, Integer> uriParams = new HashMap<String, Integer>();
        uriParams.put("goPage", 1);
        uriParams.put("pageSize", 500);
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/test/case/list/{goPage}/{pageSize}", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, (Object)msSearchContextDTO, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof Map) {
            Object listObject = ((Map)data).get("listObject");
            List list = (List)JsonUtils.MAPPER.convertValue(listObject, (TypeReference)new TypeReference<List<TestCaseDTO>>(){});
            return new PageImpl(list);
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public TestCaseDTO createTestCase(TestCaseDTO testCaseDTO) throws Throwable {
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/test/case/save", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, (Object)testCaseDTO, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof Map) {
            return (TestCaseDTO)((Object)JsonUtils.MAPPER.convertValue(data, TestCaseDTO.class));
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public Page<TestPlanDTO> listTestPlan(MSSearchContextDTO msSearchContextDTO) throws Throwable {
        HashMap<String, Integer> uriParams = new HashMap<String, Integer>();
        uriParams.put("goPage", 1);
        uriParams.put("pageSize", 500);
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/test/plan/list/{goPage}/{pageSize}", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, (Object)msSearchContextDTO, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof Map) {
            Object listObject = ((Map)data).get("listObject");
            List list = (List)JsonUtils.MAPPER.convertValue(listObject, (TypeReference)new TypeReference<List<TestPlanDTO>>(){});
            return new PageImpl(list);
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public TestPlanDTO createTestPlan(TestPlanDTO testCaseDTO) throws Throwable {
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/test/plan/add", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, (Object)testCaseDTO, null, Map.class, null);
        Map ret = (Map)rep.getBody();
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof Map) {
            return (TestPlanDTO)((Object)JsonUtils.MAPPER.convertValue(data, TestPlanDTO.class));
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public void relevanceTestPlan(TestPlanDTO testPlanDTO, Collection<String> testCaseIds) throws Throwable {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("ids", testCaseIds);
        data.put("planId", testPlanDTO.getId());
        data.put("checked", true);
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/test/plan/relevance", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, data, null, String.class, null);
        ObjectNode objectNode = JsonUtils.toObjectNode((Object)rep.getBody());
        Map ret = (Map)JsonUtils.MAPPER.convertValue((Object)objectNode, Map.class);
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
    }

    @Override
    public Page<TestPlanCaseDTO> listTestPlanCase(MSSearchContextDTO msSearchContextDTO) throws Throwable {
        HashMap<String, Integer> uriParams = new HashMap<String, Integer>();
        uriParams.put("goPage", 1);
        uriParams.put("pageSize", 500);
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/test/plan/case/list/ids", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, uriParams, headers, null, (Object)msSearchContextDTO, null, String.class, null);
        ObjectNode objectNode = JsonUtils.toObjectNode((Object)rep.getBody());
        Map ret = (Map)JsonUtils.MAPPER.convertValue((Object)objectNode, Map.class);
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
        Object data = ret.get("data");
        if (data instanceof List) {
            List list = (List)JsonUtils.MAPPER.convertValue(data, (TypeReference)new TypeReference<List<TestPlanCaseDTO>>(){});
            return new PageImpl(list);
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u5185\u5bb9");
    }

    @Override
    public void editTestPlanCase(TestPlanCaseDTO testPlanCaseDTO) throws Throwable {
        Map<String, String> headers = this.getHeaders();
        String strUri = String.format("%1$s/test/plan/case/edit", this.getServiceUrl());
        IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().post(strUri, null, headers, null, (Object)testPlanCaseDTO, null, String.class, null);
        ObjectNode objectNode = JsonUtils.toObjectNode((Object)rep.getBody());
        Map ret = (Map)JsonUtils.MAPPER.convertValue((Object)objectNode, Map.class);
        Object success = ret.get("success");
        if (!DataTypeUtils.getBooleanValue(success, (Boolean)false).booleanValue()) {
            throw new Exception(String.format("\u8fd4\u56de\u9519\u8bef\uff0c%1$s", ret.get("message")));
        }
    }
}

