/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.devops.metersphere.addin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.cloudutil.CloudUtilRuntimeBase;
import net.ibizsys.central.cloud.core.util.domain.DCSystem;
import net.ibizsys.central.cloud.core.util.domain.DepCenter;
import net.ibizsys.central.cloud.devops.core.addin.DevOpsTestToolBase;
import net.ibizsys.central.cloud.devops.metersphere.service.client.IMeterSphereClient;
import net.ibizsys.central.cloud.devops.metersphere.service.client.MeterSphereClient;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.ProjectDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestCaseDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestCaseNodeDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestPlanCaseDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestPlanDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.WorkspaceDTO;
import net.ibizsys.central.cloud.devops.metersphere.util.MSSearchContextDTO;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.central.service.client.WebClientBase;
import net.ibizsys.central.testing.TestCaseRunResult;
import net.ibizsys.centralstudio.dto.PSSysTestPrjDTO;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.model.testing.IPSDEActionTestCase;
import net.ibizsys.model.testing.IPSSysTestCase;
import net.ibizsys.model.testing.IPSSysTestCaseAssert;
import net.ibizsys.model.testing.IPSSysTestCaseInput;
import net.ibizsys.model.testing.IPSSysTestPrj;
import net.ibizsys.model.wf.IPSWorkflow;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.DateUtils;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MeterSphereDevOpsTestTool
extends DevOpsTestToolBase {
    private static final Log log = LogFactory.getLog(MeterSphereDevOpsTestTool.class);
    private IMeterSphereClient iMeterSphereClient = null;

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getMeterSphereClient(true) == null) {
            this.prepareMeterSphereClient();
        }
    }

    protected IMeterSphereClient getMeterSphereClient() {
        return this.getMeterSphereClient(false);
    }

    protected IMeterSphereClient getMeterSphereClient(boolean bTryMode) {
        if (this.iMeterSphereClient != null || bTryMode) {
            return this.iMeterSphereClient;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this.getCloudDevOpsUtilRuntime(), String.format("\u672a\u6307\u5b9aMeterSphere\u5ba2\u6237\u7aef\u5bf9\u8c61", new Object[0]));
    }

    protected void setMeterSphereClient(IMeterSphereClient iMeterSphereClient) {
        this.iMeterSphereClient = iMeterSphereClient;
    }

    protected void prepareMeterSphereClient() {
        MeterSphereClient meterSphereClient = new MeterSphereClient(this.getSystemRuntime(), (IModelRuntime)this.getCloudDevOpsUtilRuntime());
        meterSphereClient.setServiceUrl(this.getServiceUrl());
        meterSphereClient.setClientId(this.getClientId());
        meterSphereClient.setClientSecret(this.getClientSecret());
        this.setMeterSphereClient(meterSphereClient);
    }

    protected WorkspaceDTO getWorkspace(DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
        DepCenter depCenter = this.getCloudSaaSUtilRuntime().getDepCenter(dcSystem.getSrfdcid());
        MSSearchContextDTO msSearchContextDTO = new MSSearchContextDTO();
        msSearchContextDTO.set("name", depCenter.getCenterName());
        WorkspaceDTO workspaceDTO = null;
        Page<WorkspaceDTO> workspaceDTOPage = this.getMeterSphereClient().listWorkspace(msSearchContextDTO);
        if (!ObjectUtils.isEmpty((Object)workspaceDTOPage.getContent())) {
            workspaceDTO = (WorkspaceDTO)((Object)workspaceDTOPage.getContent().get(0));
        } else {
            workspaceDTO = new WorkspaceDTO();
            workspaceDTO.setName(depCenter.getCenterName());
            workspaceDTO = this.getMeterSphereClient().createWorkspace(workspaceDTO);
        }
        return workspaceDTO;
    }

    protected Map<String, ProjectDTO> getProjectMap(WorkspaceDTO workspaceDTO, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
        MSSearchContextDTO projectSearchContextDTO = new MSSearchContextDTO();
        projectSearchContextDTO.set("workspaceId", workspaceDTO.getId());
        Page<ProjectDTO> projectDTOPage = this.getMeterSphereClient().listProject(projectSearchContextDTO);
        HashMap<String, ProjectDTO> projectDTOMap = new HashMap<String, ProjectDTO>();
        if (!ObjectUtils.isEmpty((Object)projectDTOPage.getContent())) {
            for (ProjectDTO projectDTO : projectDTOPage.getContent()) {
                if (!StringUtils.hasLength((String)projectDTO.getAzureDevopsId())) continue;
                projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
            }
        }
        return projectDTOMap;
    }

    protected Collection<PSSysTestPrjDTO> onInitTestProjects(DCSystem dcSystem, IPSSystemService iPSSystemService, Map<String, Object> params) throws Throwable {
        String strDefaultId;
        WorkspaceDTO workspaceDTO = this.getWorkspace(dcSystem, iPSSystemService);
        Map<String, ProjectDTO> projectDTOMap = this.getProjectMap(workspaceDTO, dcSystem, iPSSystemService);
        Object projectDTO = projectDTOMap.get(strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId((Object)dcSystem.getDCSystemId(), (Object)"UNITTEST", (Object)"DEFAULT"));
        if (projectDTO == null) {
            projectDTO = new ProjectDTO();
            projectDTO.setWorkspaceId(workspaceDTO.getId());
            projectDTO.setName(String.format("%1$s[\u9ed8\u8ba4\u5355\u5143\u6d4b\u8bd5]", dcSystem.getDCSystemName()));
            projectDTO.setAzureDevopsId(strDefaultId);
            projectDTO = this.getMeterSphereClient().createProject((ProjectDTO)((Object)projectDTO));
            projectDTOMap.put(projectDTO.getAzureDevopsId(), (ProjectDTO)((Object)projectDTO));
        }
        this.initTestProject((ProjectDTO)((Object)projectDTO), "UNITTEST", null, dcSystem, iPSSystemService);
        strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId((Object)dcSystem.getDCSystemId(), (Object)"MODELTEST", (Object)"DEFAULT");
        projectDTO = projectDTOMap.get(strDefaultId);
        if (projectDTO == null) {
            projectDTO = new ProjectDTO();
            projectDTO.setWorkspaceId(workspaceDTO.getId());
            projectDTO.setName(String.format("%1$s[\u9ed8\u8ba4\u6a21\u578b\u6d4b\u8bd5]", dcSystem.getDCSystemName()));
            projectDTO.setAzureDevopsId(strDefaultId);
            projectDTO = this.getMeterSphereClient().createProject((ProjectDTO)((Object)projectDTO));
            projectDTOMap.put(projectDTO.getAzureDevopsId(), (ProjectDTO)((Object)projectDTO));
        }
        this.initTestProject((ProjectDTO)((Object)projectDTO), "MODELTEST", null, dcSystem, iPSSystemService);
        strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId((Object)dcSystem.getDCSystemId(), (Object)"WFTEST", (Object)"DEFAULT");
        projectDTO = projectDTOMap.get(strDefaultId);
        if (projectDTO == null) {
            projectDTO = new ProjectDTO();
            projectDTO.setWorkspaceId(workspaceDTO.getId());
            projectDTO.setName(String.format("%1$s[\u9ed8\u8ba4\u5de5\u4f5c\u6d41\u6d4b\u8bd5]", dcSystem.getDCSystemName()));
            projectDTO.setAzureDevopsId(strDefaultId);
            projectDTO = this.getMeterSphereClient().createProject((ProjectDTO)((Object)projectDTO));
            projectDTOMap.put(projectDTO.getAzureDevopsId(), (ProjectDTO)((Object)projectDTO));
        }
        this.initTestProject((ProjectDTO)((Object)projectDTO), "WFTEST", null, dcSystem, iPSSystemService);
        List psSysTestPrjList = iPSSystemService.getPSSystem().getAllPSSysTestPrjs();
        if (!ObjectUtils.isEmpty((Object)psSysTestPrjList)) {
            for (IPSSysTestPrj iPSSysTestPrj : psSysTestPrjList) {
                String strDefaultId2 = "ibiz-" + KeyValueUtils.genUniqueId((Object)dcSystem.getDCSystemId(), (Object)iPSSysTestPrj.getPrjType(), (Object)iPSSysTestPrj.getCodeName());
                ProjectDTO projectDTO2 = projectDTOMap.get(strDefaultId2);
                if (projectDTO2 != null) continue;
                projectDTO2 = new ProjectDTO();
                projectDTO2.setWorkspaceId(workspaceDTO.getId());
                projectDTO2.setName(String.format("%1$s[%2$s(%3$s)]", dcSystem.getDCSystemName(), iPSSysTestPrj.getName(), iPSSysTestPrj.getCodeName()));
                projectDTO2.setAzureDevopsId(strDefaultId2);
                projectDTO2 = this.getMeterSphereClient().createProject(projectDTO2);
                projectDTOMap.put(projectDTO2.getAzureDevopsId(), projectDTO2);
            }
        }
        ArrayList<PSSysTestPrjDTO> list = new ArrayList<PSSysTestPrjDTO>();
        for (ProjectDTO projectDTO3 : projectDTOMap.values()) {
            PSSysTestPrjDTO psSysTestPrj = new PSSysTestPrjDTO();
            psSysTestPrj.setPSSysTestPrjId(projectDTO3.getId());
            psSysTestPrj.setPSSysTestPrjName(projectDTO3.getName());
            list.add(psSysTestPrj);
        }
        return list;
    }

    protected void initTestProject(ProjectDTO projectDTO, String strProjectType, Object projectData, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
        TestCaseNodeDTO testCaseNodeDTO;
        MSSearchContextDTO testCaseNodeSearchContextDTO = new MSSearchContextDTO();
        testCaseNodeSearchContextDTO.set("projectId", projectDTO.getId());
        Page<TestCaseNodeDTO> testCaseNodeDTOPage = this.getMeterSphereClient().listTestCaseNode(testCaseNodeSearchContextDTO);
        MSSearchContextDTO testCaseSearchContextDTO = new MSSearchContextDTO();
        testCaseSearchContextDTO.set("projectId", projectDTO.getId());
        Page<TestCaseDTO> testCaseDTOPage = this.getMeterSphereClient().listTestCase(testCaseSearchContextDTO);
        HashMap<String, TestCaseDTO> testCaseDTOMap = new HashMap<String, TestCaseDTO>();
        if (!ObjectUtils.isEmpty((Object)testCaseDTOPage.getContent())) {
            block0: for (TestCaseDTO testCaseDTO : testCaseDTOPage.getContent()) {
                if (!StringUtils.hasLength((String)testCaseDTO.getTags())) continue;
                testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);
                ArrayNode tags = JsonUtils.toArrayNode((Object)testCaseDTO.getTags());
                if (ObjectUtils.isEmpty((Object)tags)) continue;
                for (Object objTag : tags) {
                    String strTag;
                    if (!(objTag instanceof JsonNode) || ObjectUtils.isEmpty((Object)(strTag = ((JsonNode)objTag).asText())) || strTag.toLowerCase().indexOf("ibiz-") != 0) continue;
                    testCaseDTOMap.put(strTag.toLowerCase(), testCaseDTO);
                    continue block0;
                }
            }
        }
        if ("UNITTEST".equals(strProjectType)) {
            List psDataEntityList = iPSSystemService.getPSSystem().getAllPSDataEntities();
            if (ObjectUtils.isEmpty((Object)psDataEntityList)) {
                return;
            }
            for (IPSDataEntity iPSDataEntity : psDataEntityList) {
                List psSysTestCaseList = iPSDataEntity.getAllPSSysTestCases();
                if (ObjectUtils.isEmpty((Object)psSysTestCaseList)) continue;
                testCaseNodeDTO = null;
                if (!ObjectUtils.isEmpty((Object)testCaseNodeDTOPage.getContent())) {
                    Iterator strName = String.format("(%1$s)", iPSDataEntity.getName());
                    for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
                        if (!StringUtils.hasLength((String)item.getName()) || item.getName().indexOf((String)((Object)strName)) == -1) continue;
                        testCaseNodeDTO = item;
                        break;
                    }
                }
                if (testCaseNodeDTO == null) {
                    testCaseNodeDTO = new TestCaseNodeDTO();
                    testCaseNodeDTO.setProjectId(projectDTO.getId());
                    testCaseNodeDTO.setName(String.format("%1$s(%2$s)", iPSDataEntity.getLogicName(), iPSDataEntity.getName()));
                    testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
                    testCaseNodeDTO.set("level", 1);
                    testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
                }
                for (IPSSysTestCase iPSSysTestCase : psSysTestCaseList) {
                    IPSDEAction iPSDEAction;
                    String strTag = String.format("ibiz-%1$s-%2$s", iPSDataEntity.getName(), iPSSysTestCase.getCodeName()).toLowerCase();
                    TestCaseDTO testCaseDTO = (TestCaseDTO)((Object)testCaseDTOMap.get(strTag));
                    if (testCaseDTO != null) continue;
                    testCaseDTO = new TestCaseDTO();
                    testCaseDTO.setName(iPSSysTestCase.getName());
                    testCaseDTO.setNodeId(testCaseNodeDTO.getId());
                    testCaseDTO.setNodePath("/" + testCaseNodeDTO.getName());
                    testCaseDTO.setPriority("P2");
                    testCaseDTO.setProjectId(projectDTO.getId());
                    testCaseDTO.setOrder(iPSSysTestCase.getOrderValue());
                    testCaseDTO.setReviewStatus("Prepare");
                    testCaseDTO.setStatus("Prepare");
                    testCaseDTO.setType("functional");
                    testCaseDTO.setStepModel("STEP");
                    ArrayNode tags = JsonUtils.createArrayNode();
                    tags.add(strTag);
                    tags.add(iPSSysTestCase.getTestCaseType());
                    if (iPSSysTestCase instanceof IPSDEActionTestCase && (iPSDEAction = ((IPSDEActionTestCase)iPSSysTestCase).getPSDEAction()) != null) {
                        tags.add(iPSDEAction.getName());
                    }
                    testCaseDTO.setTags(tags.toString());
                    ArrayNode steps = JsonUtils.createArrayNode();
                    List inputs = iPSSysTestCase.getPSSysTestCaseInputs();
                    if (!ObjectUtils.isEmpty((Object)inputs)) {
                        int nNum = 0;
                        for (IPSSysTestCaseInput iPSSysTestCaseInput : inputs) {
                            ObjectNode step = steps.addObject();
                            step.put("num", ++nNum);
                            String strDesc = iPSSysTestCaseInput.getMemo();
                            if (!StringUtils.hasLength((String)strDesc)) {
                                strDesc = iPSSysTestCaseInput.getName();
                            }
                            step.put("desc", strDesc);
                            String strResultList = "";
                            if (!ObjectUtils.isEmpty((Object)iPSSysTestCaseInput.getPSSysTestCaseAsserts())) {
                                for (IPSSysTestCaseAssert iPSSysTestCaseAssert : iPSSysTestCaseInput.getPSSysTestCaseAsserts()) {
                                    String strResult = this.getExpectedResult(iPSSysTestCaseAssert);
                                    if (StringUtils.hasLength((String)strResultList)) {
                                        strResultList = strResultList + "\u3001";
                                    }
                                    strResultList = strResultList + strResult;
                                }
                            }
                            step.put("result", strResultList);
                        }
                    }
                    testCaseDTO.setSteps(steps.toString());
                    testCaseDTO.set("maintainer", this.getClientId());
                    testCaseDTO = this.getMeterSphereClient().createTestCase(testCaseDTO);
                    testCaseDTOMap.put(strTag, testCaseDTO);
                    testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);
                }
            }
            return;
        }
        if ("WFTEST".equals(strProjectType)) {
            List psWorkflowList = iPSSystemService.getPSSystem().getAllPSWorkflows();
            if (ObjectUtils.isEmpty((Object)psWorkflowList)) {
                return;
            }
            for (IPSWorkflow iPSWorkflow : psWorkflowList) {
                TestCaseNodeDTO testCaseNodeDTO2 = null;
                if (!ObjectUtils.isEmpty((Object)testCaseNodeDTOPage.getContent())) {
                    String strName = String.format("(%1$s)", iPSWorkflow.getCodeName());
                    for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
                        if (!StringUtils.hasLength((String)item.getName()) || item.getName().indexOf(strName) == -1) continue;
                        testCaseNodeDTO2 = item;
                        break;
                    }
                }
                if (testCaseNodeDTO2 != null) continue;
                testCaseNodeDTO2 = new TestCaseNodeDTO();
                testCaseNodeDTO2.setProjectId(projectDTO.getId());
                testCaseNodeDTO2.setName(String.format("%1$s(%2$s)", iPSWorkflow.getName(), iPSWorkflow.getCodeName()));
                testCaseNodeDTO2.set("label", testCaseNodeDTO2.getName());
                testCaseNodeDTO2.set("level", 1);
                testCaseNodeDTO2 = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO2);
            }
            return;
        }
        if ("MODELTEST".equals(strProjectType)) {
            List psSysServiceAPIList = iPSSystemService.getPSSystem().getAllPSSysServiceAPIs();
            if (!ObjectUtils.isEmpty((Object)psSysServiceAPIList)) {
                for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIList) {
                    String strTag;
                    TestCaseDTO testCaseDTO;
                    List psDEServiceAPIRSList;
                    String strName = String.format("\u670d\u52a1\u63a5\u53e3[%1$s(%2$s)]", iPSSysServiceAPI.getName(), iPSSysServiceAPI.getCodeName());
                    testCaseNodeDTO = null;
                    if (!ObjectUtils.isEmpty((Object)testCaseNodeDTOPage.getContent())) {
                        for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
                            if (!StringUtils.hasLength((String)item.getName()) || item.getName().indexOf(strName) == -1) continue;
                            testCaseNodeDTO = item;
                            break;
                        }
                    }
                    if (testCaseNodeDTO == null) {
                        testCaseNodeDTO = new TestCaseNodeDTO();
                        testCaseNodeDTO.setProjectId(projectDTO.getId());
                        testCaseNodeDTO.setName(strName);
                        testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
                        testCaseNodeDTO.set("level", 1);
                        testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
                    }
                    if (ObjectUtils.isEmpty((Object)(psDEServiceAPIRSList = iPSSysServiceAPI.getPSDEServiceAPIRSs())) || (testCaseDTO = (TestCaseDTO)((Object)testCaseDTOMap.get(strTag = String.format("ibiz-%1$s-%2$s", "desars", iPSSysServiceAPI.getCodeName()).toLowerCase()))) != null) continue;
                    testCaseDTO = new TestCaseDTO();
                    testCaseDTO.setName("\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb\u5408\u7406\u6027\u6821\u9a8c");
                    testCaseDTO.setNodeId(testCaseNodeDTO.getId());
                    testCaseDTO.setNodePath("/" + testCaseNodeDTO.getName());
                    testCaseDTO.setPriority("P2");
                    testCaseDTO.setProjectId(projectDTO.getId());
                    testCaseDTO.setReviewStatus("Prepare");
                    testCaseDTO.setStatus("Prepare");
                    testCaseDTO.setType("functional");
                    testCaseDTO.setStepModel("TEXT");
                    testCaseDTO.setStepDescription("\u5224\u65ad\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb\u662f\u5426\u5b58\u5728\u9644\u5c5e\u6216\u63a7\u5236\u5173\u7cfb");
                    testCaseDTO.setExpectedResult("\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb\u90fd\u5b58\u5728\u9644\u5c5e\u6216\u63a7\u5236\u5173\u7cfb");
                    ArrayNode tags = JsonUtils.createArrayNode();
                    tags.add(strTag);
                    testCaseDTO.setTags(tags.toString());
                    testCaseDTO.set("maintainer", this.getClientId());
                    testCaseDTO = this.getMeterSphereClient().createTestCase(testCaseDTO);
                    testCaseDTOMap.put(strTag, testCaseDTO);
                    testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);
                }
            }
            return;
        }
    }

    protected PSSysTestPrjDTO onRunTestProject(DCSystem dcSystem, IPSSystemService iPSSystemService, Map<String, Object> params) throws Throwable {
        String strDefaultId;
        String strProjectType = (String)params.get("projecttype");
        String strProjectTag = (String)params.get("projecttag");
        if (!StringUtils.hasLength((String)strProjectTag)) {
            strProjectTag = "DEFAULT";
        }
        if (!StringUtils.hasLength((String)strProjectType) || !StringUtils.hasLength((String)strProjectTag)) {
            throw new Exception("\u4f20\u5165\u53c2\u6570\u6709\u8bef");
        }
        WorkspaceDTO workspaceDTO = this.getWorkspace(dcSystem, iPSSystemService);
        Map<String, ProjectDTO> projectDTOMap = this.getProjectMap(workspaceDTO, dcSystem, iPSSystemService);
        ProjectDTO projectDTO = projectDTOMap.get(strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId((Object)dcSystem.getDCSystemId(), (Object)strProjectType, (Object)strProjectTag));
        if (projectDTO == null) {
            throw new Exception("\u6d4b\u8bd5\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        this.runTestProject(projectDTO, strProjectType, strProjectTag, dcSystem, iPSSystemService);
        PSSysTestPrjDTO psSysTestPrj = new PSSysTestPrjDTO();
        psSysTestPrj.setPSSysTestPrjId(projectDTO.getId());
        psSysTestPrj.setPSSysTestPrjName(projectDTO.getName());
        return psSysTestPrj;
    }

    protected void runTestProject(ProjectDTO projectDTO, String strProjectType, Object projectData, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
        MSSearchContextDTO testCaseSearchContextDTO = new MSSearchContextDTO();
        testCaseSearchContextDTO.set("projectId", projectDTO.getId());
        Page<TestCaseDTO> testCaseDTOPage = this.getMeterSphereClient().listTestCase(testCaseSearchContextDTO);
        TestPlanDTO testPlanDTO = new TestPlanDTO();
        testPlanDTO.setWorkspaceId(projectDTO.getWorkspaceId());
        testPlanDTO.setProjectId(projectDTO.getId());
        testPlanDTO.setName(String.format("%1$s[%2$s]", projectDTO.getName(), DateUtils.getCurTimeString()));
        testPlanDTO.setStage("smoke");
        ArrayList<String> principals = new ArrayList<String>();
        principals.add(this.getClientId());
        testPlanDTO.set("principals", principals);
        testPlanDTO = this.getMeterSphereClient().createTestPlan(testPlanDTO);
        LinkedHashMap<String, TestCaseDTO> testCaseIdMap = new LinkedHashMap<String, TestCaseDTO>();
        if (!ObjectUtils.isEmpty((Object)testCaseDTOPage.getContent())) {
            for (TestCaseDTO testCaseDTO : testCaseDTOPage.getContent()) {
                testCaseIdMap.put(testCaseDTO.getId(), testCaseDTO);
            }
        }
        this.getMeterSphereClient().relevanceTestPlan(testPlanDTO, testCaseIdMap.keySet());
        HashMap<String, TestPlanCaseDTO> testPlanCaseDTOMap = new HashMap<String, TestPlanCaseDTO>();
        MSSearchContextDTO testPlanTestCaseSearchContextDTO = new MSSearchContextDTO();
        testPlanTestCaseSearchContextDTO.set("planId", testPlanDTO.getId());
        Page<TestPlanCaseDTO> testCaseDTOPage2 = this.getMeterSphereClient().listTestPlanCase(testPlanTestCaseSearchContextDTO);
        if (!ObjectUtils.isEmpty((Object)testCaseDTOPage2.getContent())) {
            block1: for (TestPlanCaseDTO testPlanCaseDTO2 : testCaseDTOPage2.getContent()) {
                ArrayNode tags;
                if (!StringUtils.hasLength((String)testPlanCaseDTO2.getTags()) || ObjectUtils.isEmpty((Object)(tags = JsonUtils.toArrayNode((Object)testPlanCaseDTO2.getTags())))) continue;
                for (Object objTag : tags) {
                    String strTag;
                    if (!(objTag instanceof JsonNode) || ObjectUtils.isEmpty((Object)(strTag = ((JsonNode)objTag).asText())) || strTag.toLowerCase().indexOf("ibiz-") != 0) continue;
                    testPlanCaseDTOMap.put(strTag.toLowerCase(), testPlanCaseDTO2);
                    continue block1;
                }
            }
        }
        if ("MODELTEST".equals(strProjectType)) {
            this.onRunModelTestProject(projectDTO, testPlanDTO, testPlanCaseDTOMap, projectData, dcSystem, iPSSystemService);
            return;
        }
        if ("UNITTEST".equals(strProjectType)) {
            this.onRunUnitTestProject(projectDTO, testPlanDTO, testPlanCaseDTOMap, projectData, dcSystem, iPSSystemService);
        }
    }

    protected void onRunModelTestProject(ProjectDTO projectDTO, TestPlanDTO testPlanDTO, Map<String, TestPlanCaseDTO> testPlanCaseDTOMap, Object projectData, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
        List psSysServiceAPIList = iPSSystemService.getPSSystem().getAllPSSysServiceAPIs();
        if (!ObjectUtils.isEmpty((Object)psSysServiceAPIList)) {
            for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIList) {
                String strTag;
                TestPlanCaseDTO testPlanCaseDTO2;
                List psDEServiceAPIRSList = iPSSysServiceAPI.getPSDEServiceAPIRSs();
                if (ObjectUtils.isEmpty((Object)psDEServiceAPIRSList) || (testPlanCaseDTO2 = testPlanCaseDTOMap.get(strTag = String.format("ibiz-%1$s-%2$s", "desars", iPSSysServiceAPI.getCodeName()).toLowerCase())) == null) continue;
                TestPlanCaseDTO testPlanCaseDTO = new TestPlanCaseDTO();
                testPlanCaseDTO.setId(testPlanCaseDTO2.getId());
                testPlanCaseDTO.setProjectId(testPlanCaseDTO2.getProjectId());
                testPlanCaseDTO.setStatus("Pass");
                StringBuilder sb = new StringBuilder();
                boolean bFirst = true;
                try {
                    for (IPSDEServiceAPIRS iPSDEServiceAPIRS : psDEServiceAPIRSList) {
                        if (bFirst) {
                            bFirst = false;
                        } else {
                            sb.append("\n");
                        }
                        IPSDERBase iPSDERBase = iPSDEServiceAPIRS.getPSDER();
                        if (iPSDEServiceAPIRS.getPSDER() == null) {
                            sb.append(String.format("\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb[%1$s]\u672a\u6307\u5b9a\u5b9e\u4f53\u5173\u7cfb\uff0c\u65e0\u6cd5\u5224\u65ad", iPSDEServiceAPIRS.getName()));
                            if (testPlanCaseDTO.getStatus().equals("Failure")) continue;
                            testPlanCaseDTO.setStatus("Blocking");
                            continue;
                        }
                        if (iPSDERBase instanceof IPSDER1N) {
                            IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                            if ((iPSDER1N.getMasterRS() & 1) == 1) {
                                sb.append(String.format("\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb[%1$s]\u6307\u5b9a\u5b9e\u4f53\u5173\u7cfb[%2$s]\u4e3a\u9644\u5c5e\u5173\u7cfb\uff0c\u901a\u8fc7", iPSDEServiceAPIRS.getName(), iPSDERBase.getName()));
                                continue;
                            }
                            sb.append(String.format("\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb[%1$s]\u6307\u5b9a\u5b9e\u4f53\u5173\u7cfb[%2$s]\u4e0d\u4e3a\u9644\u5c5e\u5173\u7cfb\uff0c\u672a\u901a\u8fc7", iPSDEServiceAPIRS.getName(), iPSDERBase.getName()));
                            testPlanCaseDTO.setStatus("Failure");
                            continue;
                        }
                        sb.append(String.format("\u5b9e\u4f53\u63a5\u53e3\u5173\u7cfb[%1$s]\u6307\u5b9a\u5b9e\u4f53\u5173\u7cfb[%2$s]\uff0c\u65e0\u6cd5\u5224\u65ad", iPSDEServiceAPIRS.getName(), iPSDERBase.getName()));
                        if (testPlanCaseDTO.getStatus().equals("Failure")) continue;
                        testPlanCaseDTO.setStatus("Blocking");
                    }
                    testPlanCaseDTO.setActualResult(sb.toString());
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                    testPlanCaseDTO.setActualResult(String.format("\u6267\u884c\u6d4b\u8bd5\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
                    testPlanCaseDTO.setStatus("Failure");
                }
                this.getMeterSphereClient().editTestPlanCase(testPlanCaseDTO);
            }
        }
    }

    protected void onRunUnitTestProject(ProjectDTO projectDTO, TestPlanDTO testPlanDTO, Map<String, TestPlanCaseDTO> testPlanCaseDTOMap, Object projectData, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("projecttype", "UNITTEST");
        params.put("projecttag", projectData);
        IWebClientRep rep = this.getContext().invokeDCSystemDevOpsAction(dcSystem.getDCSystemId(), "RUNTESTPROJECT", params, null);
        String strBody = (String)rep.getBody();
        if (!StringUtils.hasLength((String)strBody)) {
            return;
        }
        Collection list = (Collection)WebClientBase.MAPPER.readValue(strBody, TestCaseRunResultListType);
        for (TestCaseRunResult testCaseRunResult : list) {
            Collection list2;
            String strTag = String.format("ibiz-%1$s-%2$s", testCaseRunResult.getDEName(), testCaseRunResult.getTestCaseTag()).toLowerCase();
            TestPlanCaseDTO testPlanCaseDTO2 = testPlanCaseDTOMap.get(strTag);
            if (testPlanCaseDTO2 == null) continue;
            TestPlanCaseDTO testPlanCaseDTO = new TestPlanCaseDTO();
            testPlanCaseDTO.setId(testPlanCaseDTO2.getId());
            testPlanCaseDTO.setProjectId(testPlanCaseDTO2.getProjectId());
            String strResults = testCaseRunResult.getResults();
            if (StringUtils.hasLength((String)strResults) && !ObjectUtils.isEmpty((Object)(list2 = (Collection)JsonUtils.MAPPER.readValue(strResults, CloudUtilRuntimeBase.ObjectNodeListType)))) {
                ArrayNode arrayNode = JsonUtils.createArrayNode();
                for (ObjectNode resultNode : list2) {
                    ObjectNode objectNode = arrayNode.addObject();
                    JsonNode node = resultNode.get("inputtag");
                    if (node != null) {
                        objectNode.put("inputtag", node.asText());
                    }
                    if ((node = resultNode.get("actualresult")) != null) {
                        objectNode.put("actualResult", node.asText());
                    }
                    if ((node = resultNode.get("executeresult")) == null) continue;
                    objectNode.put("executeResult", this.getExecuteStatus(node.asText()));
                }
                testPlanCaseDTO.setResults(arrayNode.toString());
            }
            testPlanCaseDTO.setActualResult(testCaseRunResult.getActualResult());
            testPlanCaseDTO.setStatus(this.getExecuteStatus(testCaseRunResult.getStatus()));
            this.getMeterSphereClient().editTestPlanCase(testPlanCaseDTO);
        }
    }

    protected String getExecuteStatus(String strResult) {
        if ("PASS".equals(strResult)) {
            return "Pass";
        }
        if ("FAILURE".equals(strResult)) {
            return "Failure";
        }
        if ("BLOCKING".equals(strResult)) {
            return "Blocking";
        }
        return null;
    }
}

