package net.ibizsys.central.cloud.devops.metersphere.addin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.ibizsys.central.cloud.core.cloudutil.CloudUtilRuntimeBase;
import net.ibizsys.central.cloud.core.sysutil.ISysDevOpsUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.DCSystem;
import net.ibizsys.central.cloud.core.util.domain.DepCenter;
import net.ibizsys.central.cloud.devops.core.addin.DevOpsTestToolBase;
import net.ibizsys.central.cloud.devops.metersphere.service.client.IMeterSphereClient;
import net.ibizsys.central.cloud.devops.metersphere.service.client.MeterSphereClient;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.ProjectDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestCaseDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestCaseNodeDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestPlanCaseDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.TestPlanDTO;
import net.ibizsys.central.cloud.devops.metersphere.service.dto.WorkspaceDTO;
import net.ibizsys.central.cloud.devops.metersphere.util.MSSearchContextDTO;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.central.service.client.WebClientBase;
import net.ibizsys.central.testing.TestCaseRunResult;
import net.ibizsys.centralstudio.dto.PSSysTestPrjDTO;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.model.testing.IPSDEActionTestCase;
import net.ibizsys.model.testing.IPSSysTestCase;
import net.ibizsys.model.testing.IPSSysTestCaseAssert;
import net.ibizsys.model.testing.IPSSysTestCaseInput;
import net.ibizsys.model.testing.IPSSysTestPrj;
import net.ibizsys.model.wf.IPSWorkflow;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.der.DER1NMasterRSTypes;
import net.ibizsys.runtime.util.DateUtils;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;

public class MeterSphereDevOpsTestTool extends DevOpsTestToolBase {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(MeterSphereDevOpsTestTool.class);

	private IMeterSphereClient iMeterSphereClient = null;

	@Override
	protected void onInit() throws Exception {
		super.onInit();

		if (this.getMeterSphereClient(true) == null) {
			this.prepareMeterSphereClient();
		}
	}

	protected IMeterSphereClient getMeterSphereClient() {
		return getMeterSphereClient(false);
	}

	protected IMeterSphereClient getMeterSphereClient(boolean bTryMode) {
		if (this.iMeterSphereClient != null || bTryMode) {
			return this.iMeterSphereClient;
		}
		throw new SystemRuntimeException(this.getSystemRuntime(), this.getCloudDevOpsUtilRuntime(), String.format("未指定MeterSphere客户端对象"));
	}

	protected void setMeterSphereClient(IMeterSphereClient iMeterSphereClient) {
		this.iMeterSphereClient = iMeterSphereClient;
	}

	protected void prepareMeterSphereClient() {
		MeterSphereClient meterSphereClient = new MeterSphereClient(this.getSystemRuntime(), this.getCloudDevOpsUtilRuntime());
		meterSphereClient.setServiceUrl(this.getServiceUrl());
		meterSphereClient.setClientId(this.getClientId());
		meterSphereClient.setClientSecret(this.getClientSecret());
		this.setMeterSphereClient(meterSphereClient);
	}
	
	
	protected WorkspaceDTO getWorkspace(DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
		DepCenter depCenter = this.getCloudSaaSUtilRuntime().getDepCenter(dcSystem.getSrfdcid());

		// 获取中心
		// this.getCloudSaaSUtilRuntime().getc
		MSSearchContextDTO msSearchContextDTO = new MSSearchContextDTO();
		msSearchContextDTO.set("name", depCenter.getCenterName());

		WorkspaceDTO workspaceDTO = null;
		Page<WorkspaceDTO> workspaceDTOPage = this.getMeterSphereClient().listWorkspace(msSearchContextDTO);
		if (!ObjectUtils.isEmpty(workspaceDTOPage.getContent())) {
			// 存在
			workspaceDTO = workspaceDTOPage.getContent().get(0);
		} else {
			// 新建
			workspaceDTO = new WorkspaceDTO();
			workspaceDTO.setName(depCenter.getCenterName());
			workspaceDTO = this.getMeterSphereClient().createWorkspace(workspaceDTO);
		}

		return workspaceDTO;
	}
	
	
	protected Map<String, ProjectDTO> getProjectMap(WorkspaceDTO workspaceDTO, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
		
		// 列出全部项目
		MSSearchContextDTO projectSearchContextDTO = new MSSearchContextDTO();
		projectSearchContextDTO.set(ProjectDTO.FIELD_WORKSPACEID, workspaceDTO.getId());
		Page<ProjectDTO> projectDTOPage = this.getMeterSphereClient().listProject(projectSearchContextDTO);

		Map<String, ProjectDTO> projectDTOMap = new HashMap<String, ProjectDTO>();

		if (!ObjectUtils.isEmpty(projectDTOPage.getContent())) {
			for (ProjectDTO projectDTO : projectDTOPage.getContent()) {
				if (!StringUtils.hasLength(projectDTO.getAzureDevopsId())) {
					continue;
				}
				projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
			}
		}
		
		return projectDTOMap;
	}
	

	@Override
	protected Collection<PSSysTestPrjDTO> onInitTestProjects(DCSystem dcSystem, IPSSystemService iPSSystemService, Map<String, Object> params) throws Throwable {

		WorkspaceDTO workspaceDTO = this.getWorkspace(dcSystem, iPSSystemService);
		
		Map<String, ProjectDTO> projectDTOMap = this.getProjectMap(workspaceDTO, dcSystem, iPSSystemService);

		// 判断各项目
		if (true) {
			String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(dcSystem.getDCSystemId(), TESTPRJTYPE_UNITTEST, "DEFAULT");
			ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
			if (projectDTO == null) {
				projectDTO = new ProjectDTO();
				projectDTO.setWorkspaceId(workspaceDTO.getId());
				projectDTO.setName(String.format("%1$s[默认单元测试]", dcSystem.getDCSystemName()));
				projectDTO.setAzureDevopsId(strDefaultId);
				projectDTO = this.getMeterSphereClient().createProject(projectDTO);
				projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
			}
			initTestProject(projectDTO, TESTPRJTYPE_UNITTEST, null, dcSystem, iPSSystemService);
		}

		if (true) {
			String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(dcSystem.getDCSystemId(), TESTPRJTYPE_MODELTEST, "DEFAULT");
			ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
			if (projectDTO == null) {
				projectDTO = new ProjectDTO();
				projectDTO.setWorkspaceId(workspaceDTO.getId());
				projectDTO.setName(String.format("%1$s[默认模型测试]", dcSystem.getDCSystemName()));
				projectDTO.setAzureDevopsId(strDefaultId);
				projectDTO = this.getMeterSphereClient().createProject(projectDTO);
				projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
			}
			initTestProject(projectDTO, TESTPRJTYPE_MODELTEST, null, dcSystem, iPSSystemService);
		}
		
		if (true) {
			String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(dcSystem.getDCSystemId(), TESTPRJTYPE_WFTEST, "DEFAULT");
			ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
			if (projectDTO == null) {
				projectDTO = new ProjectDTO();
				projectDTO.setWorkspaceId(workspaceDTO.getId());
				projectDTO.setName(String.format("%1$s[默认工作流测试]", dcSystem.getDCSystemName()));
				projectDTO.setAzureDevopsId(strDefaultId);
				projectDTO = this.getMeterSphereClient().createProject(projectDTO);
				projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
			}
			initTestProject(projectDTO, TESTPRJTYPE_WFTEST, null, dcSystem, iPSSystemService);
		}
		
//		java.util.List<IPSWorkflow> psWorkflowList = iPSSystemService.getPSSystem().getAllPSWorkflows();
//		if (!ObjectUtils.isEmpty(projectDTOPage.getContent())) {
//			for (IPSWorkflow iPSWorkflow : psWorkflowList) {
//				String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(dcSystem.getDCSystemId(), TESTPRJTYPE_WFTEST, iPSWorkflow.getCodeName());
//				ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
//				if (projectDTO == null) {
//					projectDTO = new ProjectDTO();
//					projectDTO.setWorkspaceId(workspaceDTO.getId());
//					projectDTO.setName(String.format("%1$s[工作流测试-%2$s]", dcSystem.getDCSystemName(), iPSWorkflow.getName()));
//					projectDTO.setAzureDevopsId(strDefaultId);
//					projectDTO = this.getMeterSphereClient().createProject(projectDTO);
//					projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
//				}
//				initTestProject(projectDTO, TESTPRJTYPE_WFTEST, iPSWorkflow, dcSystem, iPSSystemService);
//				// initTestProject(projectDTO, dcSystem, iPSSystemService);
//			}
//		}
//		
		
		java.util.List<IPSSysTestPrj> psSysTestPrjList = iPSSystemService.getPSSystem().getAllPSSysTestPrjs();
		if (!ObjectUtils.isEmpty(psSysTestPrjList)) {
			for (IPSSysTestPrj iPSSysTestPrj : psSysTestPrjList) {
				String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(dcSystem.getDCSystemId(), iPSSysTestPrj.getPrjType(), iPSSysTestPrj.getCodeName());
				ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
				if (projectDTO == null) {
					projectDTO = new ProjectDTO();
					projectDTO.setWorkspaceId(workspaceDTO.getId());
					projectDTO.setName(String.format("%1$s[%2$s(%3$s)]", dcSystem.getDCSystemName(), iPSSysTestPrj.getName(), iPSSysTestPrj.getCodeName()));
					projectDTO.setAzureDevopsId(strDefaultId);
					projectDTO = this.getMeterSphereClient().createProject(projectDTO);
					projectDTOMap.put(projectDTO.getAzureDevopsId(), projectDTO);
				}
				// initTestProject(projectDTO, dcSystem, iPSSystemService);
			}
		}

		List<PSSysTestPrjDTO> list = new ArrayList<PSSysTestPrjDTO>();
		for (ProjectDTO projectDTO : projectDTOMap.values()) {
			PSSysTestPrjDTO psSysTestPrj = new PSSysTestPrjDTO();
			psSysTestPrj.setPSSysTestPrjId(projectDTO.getId());
			psSysTestPrj.setPSSysTestPrjName(projectDTO.getName());
			list.add(psSysTestPrj);
		}

		return list;

	}

	protected void initTestProject(ProjectDTO projectDTO, String strProjectType, Object projectData, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {

		

		// 列出全部节点
		MSSearchContextDTO testCaseNodeSearchContextDTO = new MSSearchContextDTO();
		testCaseNodeSearchContextDTO.set(TestCaseNodeDTO.FIELD_PROJECTID, projectDTO.getId());
		Page<TestCaseNodeDTO> testCaseNodeDTOPage = this.getMeterSphereClient().listTestCaseNode(testCaseNodeSearchContextDTO);

		// 列出全部用例
		MSSearchContextDTO testCaseSearchContextDTO = new MSSearchContextDTO();
		testCaseSearchContextDTO.set(TestCaseNodeDTO.FIELD_PROJECTID, projectDTO.getId());
		Page<TestCaseDTO> testCaseDTOPage = this.getMeterSphereClient().listTestCase(testCaseSearchContextDTO);

		Map<String, TestCaseDTO> testCaseDTOMap = new HashMap<String, TestCaseDTO>();

		if (!ObjectUtils.isEmpty(testCaseDTOPage.getContent())) {
			for (TestCaseDTO testCaseDTO : testCaseDTOPage.getContent()) {
				if (!StringUtils.hasLength(testCaseDTO.getTags())) {
					continue;
				}

				testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);

				ArrayNode tags = JsonUtils.toArrayNode(testCaseDTO.getTags());
				if (!ObjectUtils.isEmpty(tags)) {
					for (Object objTag : tags) {
						if (!(objTag instanceof JsonNode)) {
							continue;
						}
						String strTag = ((JsonNode) objTag).asText();
						if (ObjectUtils.isEmpty(strTag)) {
							continue;
						}
						if (strTag.toLowerCase().indexOf("ibiz-") == 0) {
							testCaseDTOMap.put(strTag.toLowerCase(), testCaseDTO);
							break;
						}
					}
				}
			}
		}

		if (TESTPRJTYPE_UNITTEST.equals(strProjectType)) {
			List<IPSDataEntity> psDataEntityList = iPSSystemService.getPSSystem().getAllPSDataEntities();
			if (ObjectUtils.isEmpty(psDataEntityList)) {
				return;
			}
			for (IPSDataEntity iPSDataEntity : psDataEntityList) {

				List<IPSSysTestCase> psSysTestCaseList = iPSDataEntity.getAllPSSysTestCases();
				if (ObjectUtils.isEmpty(psSysTestCaseList)) {
					continue;
				}

				// 判断目录是否存在
				TestCaseNodeDTO testCaseNodeDTO = null;
				if (!ObjectUtils.isEmpty(testCaseNodeDTOPage.getContent())) {
					String strName = String.format("(%1$s)", iPSDataEntity.getName());
					for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
						if (!StringUtils.hasLength(item.getName())) {
							continue;
						}
						if (item.getName().indexOf(strName) != -1) {
							testCaseNodeDTO = item;
							break;
						}
					}
				}

				if (testCaseNodeDTO == null) {
					testCaseNodeDTO = new TestCaseNodeDTO();
					testCaseNodeDTO.setProjectId(projectDTO.getId());
					testCaseNodeDTO.setName(String.format("%1$s(%2$s)", iPSDataEntity.getLogicName(), iPSDataEntity.getName()));
					testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
					testCaseNodeDTO.set("level", 1);

					testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
				}

				for (IPSSysTestCase iPSSysTestCase : psSysTestCaseList) {

					String strTag = String.format("ibiz-%1$s-%2$s", iPSDataEntity.getName(), iPSSysTestCase.getCodeName()).toLowerCase();
					TestCaseDTO testCaseDTO = testCaseDTOMap.get(strTag);
					if (testCaseDTO != null) {
						continue;
					}

					testCaseDTO = new TestCaseDTO();
					testCaseDTO.setName(iPSSysTestCase.getName());
					testCaseDTO.setNodeId(testCaseNodeDTO.getId());
					testCaseDTO.setNodePath("/" + testCaseNodeDTO.getName());
					testCaseDTO.setPriority("P2");
					testCaseDTO.setProjectId(projectDTO.getId());
					testCaseDTO.setOrder(iPSSysTestCase.getOrderValue());
					testCaseDTO.setReviewStatus("Prepare");
					testCaseDTO.setStatus("Prepare");
					testCaseDTO.setType("functional");

					testCaseDTO.setStepModel("STEP");

					// 放入标记
					ArrayNode tags = JsonUtils.createArrayNode();
					tags.add(strTag);
					tags.add(iPSSysTestCase.getTestCaseType());
					if (iPSSysTestCase instanceof IPSDEActionTestCase) {
						IPSDEAction iPSDEAction = ((IPSDEActionTestCase) iPSSysTestCase).getPSDEAction();
						if (iPSDEAction != null) {
							tags.add(iPSDEAction.getName());
						}
					}
					testCaseDTO.setTags(tags.toString());

					// 放入步骤
					ArrayNode steps = JsonUtils.createArrayNode();
					// steps:
					// "[{\"num\":1,\"desc\":\"ddd\",\"result\":\"ddd\"}]"
					List<IPSSysTestCaseInput> inputs = iPSSysTestCase.getPSSysTestCaseInputs();
					if (!ObjectUtils.isEmpty(inputs)) {
						int nNum = 0;
						for (IPSSysTestCaseInput iPSSysTestCaseInput : inputs) {
							nNum++;
							ObjectNode step = steps.addObject();
							step.put("num", nNum);
							String strDesc = iPSSysTestCaseInput.getMemo();
							if (!StringUtils.hasLength(strDesc)) {
								strDesc = iPSSysTestCaseInput.getName();
							}
							step.put("desc", strDesc);
							String strResultList = "";
							if (!ObjectUtils.isEmpty(iPSSysTestCaseInput.getPSSysTestCaseAsserts())) {
								for (IPSSysTestCaseAssert iPSSysTestCaseAssert : iPSSysTestCaseInput.getPSSysTestCaseAsserts()) {
									String strResult = getExpectedResult(iPSSysTestCaseAssert);
									if (StringUtils.hasLength(strResultList)) {
										strResultList += "、";
									}
									strResultList += strResult;
								}
							}

							step.put("result", strResultList);
						}
					}

					testCaseDTO.setSteps(steps.toString());

					testCaseDTO.set("maintainer", this.getClientId());

					testCaseDTO = this.getMeterSphereClient().createTestCase(testCaseDTO);
					testCaseDTOMap.put(strTag, testCaseDTO);
					testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);

				}
			}
			return;
		}

		
		if (TESTPRJTYPE_WFTEST.equals(strProjectType)) {
			List<IPSWorkflow> psWorkflowList = iPSSystemService.getPSSystem().getAllPSWorkflows();
			if (ObjectUtils.isEmpty(psWorkflowList)) {
				return;
			}
			for (IPSWorkflow iPSWorkflow : psWorkflowList) {

				// 判断目录是否存在
				TestCaseNodeDTO testCaseNodeDTO = null;
				if (!ObjectUtils.isEmpty(testCaseNodeDTOPage.getContent())) {
					String strName = String.format("(%1$s)", iPSWorkflow.getCodeName());
					for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
						if (!StringUtils.hasLength(item.getName())) {
							continue;
						}
						if (item.getName().indexOf(strName) != -1) {
							testCaseNodeDTO = item;
							break;
						}
					}
				}

				if (testCaseNodeDTO == null) {
					testCaseNodeDTO = new TestCaseNodeDTO();
					testCaseNodeDTO.setProjectId(projectDTO.getId());
					testCaseNodeDTO.setName(String.format("%1$s(%2$s)", iPSWorkflow.getName(), iPSWorkflow.getCodeName()));
					testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
					testCaseNodeDTO.set("level", 1);

					testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
				}
			}
			
			return;
		}
		
		if (TESTPRJTYPE_MODELTEST.equals(strProjectType)) {
			
			//服务接口检查
			List<IPSSysServiceAPI> psSysServiceAPIList = iPSSystemService.getPSSystem().getAllPSSysServiceAPIs();
			if (!ObjectUtils.isEmpty(psSysServiceAPIList)) {
				for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIList) {
					String strName = String.format("服务接口[%1$s(%2$s)]", iPSSysServiceAPI.getName(), iPSSysServiceAPI.getCodeName());
					// 判断目录是否存在
					TestCaseNodeDTO testCaseNodeDTO = null;
					if (!ObjectUtils.isEmpty(testCaseNodeDTOPage.getContent())) {
						
						for (TestCaseNodeDTO item : testCaseNodeDTOPage.getContent()) {
							if (!StringUtils.hasLength(item.getName())) {
								continue;
							}
							if (item.getName().indexOf(strName) != -1) {
								testCaseNodeDTO = item;
								break;
							}
						}
					}

					if (testCaseNodeDTO == null) {
						testCaseNodeDTO = new TestCaseNodeDTO();
						testCaseNodeDTO.setProjectId(projectDTO.getId());
						testCaseNodeDTO.setName(strName);
						testCaseNodeDTO.set("label", testCaseNodeDTO.getName());
						testCaseNodeDTO.set("level", 1);

						testCaseNodeDTO = this.getMeterSphereClient().createTestCaseNode(testCaseNodeDTO);
					}
					
					//实体接口访问
					
					
					//实体接口关系
					List<IPSDEServiceAPIRS> psDEServiceAPIRSList = iPSSysServiceAPI.getPSDEServiceAPIRSs();
					if(!ObjectUtils.isEmpty(psDEServiceAPIRSList)) {
						String strTag = String.format("ibiz-%1$s-%2$s", "desars", iPSSysServiceAPI.getCodeName()).toLowerCase();
						TestCaseDTO testCaseDTO = testCaseDTOMap.get(strTag);
						if (testCaseDTO == null) {

							testCaseDTO = new TestCaseDTO();
							testCaseDTO.setName("实体接口关系合理性校验");
							testCaseDTO.setNodeId(testCaseNodeDTO.getId());
							testCaseDTO.setNodePath("/" + testCaseNodeDTO.getName());
							testCaseDTO.setPriority("P2");
							testCaseDTO.setProjectId(projectDTO.getId());
							//testCaseDTO.setOrder(iPSSysTestCase.getOrderValue());
							testCaseDTO.setReviewStatus("Prepare");
							testCaseDTO.setStatus("Prepare");
							testCaseDTO.setType("functional");

							testCaseDTO.setStepModel("TEXT");
							testCaseDTO.setStepDescription("判断实体接口关系是否存在附属或控制关系");
							testCaseDTO.setExpectedResult("实体接口关系都存在附属或控制关系");

							// 放入标记
							ArrayNode tags = JsonUtils.createArrayNode();
							tags.add(strTag);
							
							testCaseDTO.setTags(tags.toString());

//							// 放入步骤
//							ArrayNode steps = JsonUtils.createArrayNode();
//							// steps:
//							int nNum = 0;
//							for (IPSDEServiceAPIRS iPSDEServiceAPIRS : psDEServiceAPIRSList) {
//								nNum++;
//								ObjectNode step = steps.addObject();
//								step.put("num", nNum);
//								String strDesc = iPSDEServiceAPIRS.getMemo();
//								if (!StringUtils.hasLength(strDesc)) {
//									strDesc = iPSDEServiceAPIRS.getName();
//								}
//								step.put("desc", strDesc);
//								step.put("name", iPSDEServiceAPIRS.getName());
//								
//
//								step.put("result", "存在附属、控制关系");
//							}
//
//							testCaseDTO.setSteps(steps.toString());

							testCaseDTO.set("maintainer", this.getClientId());

							testCaseDTO = this.getMeterSphereClient().createTestCase(testCaseDTO);
							testCaseDTOMap.put(strTag, testCaseDTO);
							testCaseDTOMap.put(testCaseDTO.getName(), testCaseDTO);
							

							
						}
					}
					
					
					
				}
			}
			
			
			return;
		}
		
	}
	
	@Override
	protected PSSysTestPrjDTO onRunTestProject(DCSystem dcSystem, IPSSystemService iPSSystemService, Map<String, Object> params) throws Throwable {
		
		String strProjectType = (String)params.get("projecttype");
		String strProjectTag = (String)params.get("projecttag");
		if(!StringUtils.hasLength(strProjectTag)) {
			strProjectTag = "DEFAULT";
		}
		if(!StringUtils.hasLength(strProjectType)
				|| !StringUtils.hasLength(strProjectTag)) {
			throw new Exception("传入参数有误");
		}
		
		WorkspaceDTO workspaceDTO = this.getWorkspace(dcSystem, iPSSystemService);
		
		Map<String, ProjectDTO> projectDTOMap = this.getProjectMap(workspaceDTO, dcSystem, iPSSystemService);
		String strDefaultId = "ibiz-" + KeyValueUtils.genUniqueId(dcSystem.getDCSystemId(), strProjectType, strProjectTag);
		ProjectDTO projectDTO = projectDTOMap.get(strDefaultId);
		if (projectDTO == null) {
			throw new Exception("测试项目不存在");
		}
		
		runTestProject(projectDTO, strProjectType, strProjectTag, dcSystem, iPSSystemService);
		
		
		PSSysTestPrjDTO psSysTestPrj = new PSSysTestPrjDTO();
		psSysTestPrj.setPSSysTestPrjId(projectDTO.getId());
		psSysTestPrj.setPSSysTestPrjName(projectDTO.getName());
		return psSysTestPrj;
	}
	
	

	protected void runTestProject(ProjectDTO projectDTO, String strProjectType, Object projectData, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {

		// 列出全部用例
		MSSearchContextDTO testCaseSearchContextDTO = new MSSearchContextDTO();
		testCaseSearchContextDTO.set(TestCaseNodeDTO.FIELD_PROJECTID, projectDTO.getId());
		Page<TestCaseDTO> testCaseDTOPage = this.getMeterSphereClient().listTestCase(testCaseSearchContextDTO);

		
		
		//插入测试计划
		TestPlanDTO testPlanDTO = new TestPlanDTO();
		testPlanDTO.setWorkspaceId(projectDTO.getWorkspaceId());
		testPlanDTO.setProjectId(projectDTO.getId());
		testPlanDTO.setName(String.format("%1$s[%2$s]", projectDTO.getName(), DateUtils.getCurTimeString()));
		testPlanDTO.setStage("smoke");
		List<String> principals = new ArrayList<String>();
		principals.add(this.getClientId());
		testPlanDTO.set(TestPlanDTO.FIELD_PRINCIPALS, principals);
		testPlanDTO = this.getMeterSphereClient().createTestPlan(testPlanDTO);
		
		//添加测试计划用例
		Map<String, TestCaseDTO> testCaseIdMap = new LinkedHashMap<String, TestCaseDTO>();
		if (!ObjectUtils.isEmpty(testCaseDTOPage.getContent())) {
			for (TestCaseDTO testCaseDTO : testCaseDTOPage.getContent()) {
				testCaseIdMap.put(testCaseDTO.getId(), testCaseDTO);
			}
		}
		this.getMeterSphereClient().relevanceTestPlan(testPlanDTO, testCaseIdMap.keySet());
		
		Map<String, TestPlanCaseDTO> testPlanCaseDTOMap = new HashMap<String, TestPlanCaseDTO>();

		MSSearchContextDTO testPlanTestCaseSearchContextDTO = new MSSearchContextDTO();
		testPlanTestCaseSearchContextDTO.set("planId", testPlanDTO.getId());
		Page<TestPlanCaseDTO> testCaseDTOPage2 = this.getMeterSphereClient().listTestPlanCase(testPlanTestCaseSearchContextDTO);
		if(!ObjectUtils.isEmpty(testCaseDTOPage2.getContent())) {
			for(TestPlanCaseDTO testPlanCaseDTO2 : testCaseDTOPage2.getContent()) {
				if (!StringUtils.hasLength(testPlanCaseDTO2.getTags())) {
					continue;
				}
				
				ArrayNode tags = JsonUtils.toArrayNode(testPlanCaseDTO2.getTags());
				if (!ObjectUtils.isEmpty(tags)) {
					for (Object objTag : tags) {
						if (!(objTag instanceof JsonNode)) {
							continue;
						}
						String strTag = ((JsonNode) objTag).asText();
						if (ObjectUtils.isEmpty(strTag)) {
							continue;
						}
						if (strTag.toLowerCase().indexOf("ibiz-") == 0) {
							testPlanCaseDTOMap.put(strTag.toLowerCase(), testPlanCaseDTO2);
							break;
						}
					}
				}
				
			}
		}
		
//		MSSearchContextDTO testPlanTestCaseSearchContextDTO = new MSSearchContextDTO();
//		testPlanTestCaseSearchContextDTO.set("planId", testPlanDTO.getId());
//		Page<TestPlanCaseDTO> testCaseDTOPage2 = this.getMeterSphereClient().listTestPlanCase(testPlanTestCaseSearchContextDTO);
//		if(!ObjectUtils.isEmpty(testCaseDTOPage2.getContent())) {
//			for(TestPlanCaseDTO testPlanCaseDTO2 : testCaseDTOPage2.getContent()) {
//				
//				TestPlanCaseDTO testPlanCaseDTO = new TestPlanCaseDTO();
//				testPlanCaseDTO.setId(testPlanCaseDTO2.getId());
//				testPlanCaseDTO.setProjectId(testPlanCaseDTO2.getProjectId());
//				ArrayNode results = JsonUtils.createArrayNode();
//				ObjectNode objectNode = results.addObject();
//				
//				objectNode.put("actualResult","正确内容");
//				objectNode.put("executeResult","Pass");
//
//				testPlanCaseDTO.setResults(results.toString());
//				testPlanCaseDTO.setStatus("Pass");
//				
//				this.getMeterSphereClient().editTestPlanCase(testPlanCaseDTO);
//			}
//		}
		
		//根据类型，回填
		if(TESTPRJTYPE_MODELTEST.equals(strProjectType)) {
			
			this.onRunModelTestProject(projectDTO, testPlanDTO, testPlanCaseDTOMap, projectData, dcSystem, iPSSystemService);
			return;
			
		}
		
		//当前，回调业务系统
		if(TESTPRJTYPE_UNITTEST.equals(strProjectType)) {
			this.onRunUnitTestProject(projectDTO, testPlanDTO, testPlanCaseDTOMap, projectData, dcSystem, iPSSystemService);
			
		}
		
	}
	
	protected void onRunModelTestProject(ProjectDTO projectDTO, TestPlanDTO testPlanDTO, Map<String, TestPlanCaseDTO> testPlanCaseDTOMap, Object projectData, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
		//服务接口检查
		List<IPSSysServiceAPI> psSysServiceAPIList = iPSSystemService.getPSSystem().getAllPSSysServiceAPIs();
		if (!ObjectUtils.isEmpty(psSysServiceAPIList)) {
			for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIList) {
				//实体接口关系
				List<IPSDEServiceAPIRS> psDEServiceAPIRSList = iPSSysServiceAPI.getPSDEServiceAPIRSs();
				if(!ObjectUtils.isEmpty(psDEServiceAPIRSList)) {
					String strTag = String.format("ibiz-%1$s-%2$s", "desars", iPSSysServiceAPI.getCodeName()).toLowerCase();
					TestPlanCaseDTO testPlanCaseDTO2 = testPlanCaseDTOMap.get(strTag);
					if (testPlanCaseDTO2 != null) {

						TestPlanCaseDTO testPlanCaseDTO = new TestPlanCaseDTO();
						testPlanCaseDTO.setId(testPlanCaseDTO2.getId());
						testPlanCaseDTO.setProjectId(testPlanCaseDTO2.getProjectId());
//						ArrayNode results = JsonUtils.createArrayNode();
//						ObjectNode objectNode = results.addObject();
//						
//						objectNode.put("actualResult","正确内容");
//						objectNode.put("executeResult","Pass");
//		
//						testPlanCaseDTO.setResults(results.toString());
						testPlanCaseDTO.setStatus(TestPlanCaseDTO.STATUS_PASS);
						StringBuilder sb = new StringBuilder();
						boolean bFirst = true;
						try {
							for(IPSDEServiceAPIRS iPSDEServiceAPIRS : psDEServiceAPIRSList) {
								if(bFirst) {
									bFirst = false;
								}
								else {
									sb.append("\n");
								}
								IPSDERBase iPSDERBase = iPSDEServiceAPIRS.getPSDER();
								if(iPSDEServiceAPIRS.getPSDER() == null) {
									sb.append(String.format("实体接口关系[%1$s]未指定实体关系，无法判断", iPSDEServiceAPIRS.getName()));
									if(!testPlanCaseDTO.getStatus().equals(TestPlanCaseDTO.STATUS_FAILURE)) {
										testPlanCaseDTO.setStatus(TestPlanCaseDTO.STATUS_BLOCKING);
									}
									continue;
								}
								
								if(iPSDERBase instanceof IPSDER1N) {
									IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
									if ((iPSDER1N.getMasterRS() & DER1NMasterRSTypes.RELATED) == DER1NMasterRSTypes.RELATED) {
										sb.append(String.format("实体接口关系[%1$s]指定实体关系[%2$s]为附属关系，通过", iPSDEServiceAPIRS.getName(), iPSDERBase.getName()));
									}
									else {
										sb.append(String.format("实体接口关系[%1$s]指定实体关系[%2$s]不为附属关系，未通过", iPSDEServiceAPIRS.getName(), iPSDERBase.getName()));
										testPlanCaseDTO.setStatus(TestPlanCaseDTO.STATUS_FAILURE);
									}
								}
								else {
									sb.append(String.format("实体接口关系[%1$s]指定实体关系[%2$s]，无法判断", iPSDEServiceAPIRS.getName(), iPSDERBase.getName()));
									if(!testPlanCaseDTO.getStatus().equals(TestPlanCaseDTO.STATUS_FAILURE)) {
										testPlanCaseDTO.setStatus(TestPlanCaseDTO.STATUS_BLOCKING);
									}
								}
							}
							testPlanCaseDTO.setActualResult(sb.toString());
						}
						catch(Throwable ex) {
							log.error(ex);
							testPlanCaseDTO.setActualResult(String.format("执行测试发生异常，%1$s", ex.getMessage()));
							testPlanCaseDTO.setStatus(TestPlanCaseDTO.STATUS_FAILURE);
						}
					
						
						this.getMeterSphereClient().editTestPlanCase(testPlanCaseDTO);

						
					}
				}
			}
		}
	}
	
	
	protected void onRunUnitTestProject(ProjectDTO projectDTO, TestPlanDTO testPlanDTO, Map<String, TestPlanCaseDTO> testPlanCaseDTOMap, Object projectData, DCSystem dcSystem, IPSSystemService iPSSystemService) throws Throwable {
		
		//执行回调操作
		Map<String, Object> params = new LinkedHashMap<String, Object>();
		
		params.put("projecttype", ISysDevOpsUtilRuntime.TESTPRJTYPE_UNITTEST);
		params.put("projecttag", projectData);
		
		IWebClientRep<String> rep =	this.getContext().invokeDCSystemDevOpsAction(dcSystem.getDCSystemId(), ISysDevOpsUtilRuntime.DEVOPSACTION_RUNTESTPROJECT, params, null);
		String strBody = rep.getBody();
		if(!StringUtils.hasLength(strBody)) {
			return;
		}
		
		Collection<TestCaseRunResult> list = WebClientBase.MAPPER.readValue(strBody, TestCaseRunResultListType);
		
		for(TestCaseRunResult testCaseRunResult : list) {
			String strTag = String.format("ibiz-%1$s-%2$s", testCaseRunResult.getDEName(), testCaseRunResult.getTestCaseTag()).toLowerCase();
			TestPlanCaseDTO testPlanCaseDTO2 = testPlanCaseDTOMap.get(strTag);
			if (testPlanCaseDTO2 != null) {

				TestPlanCaseDTO testPlanCaseDTO = new TestPlanCaseDTO();
				testPlanCaseDTO.setId(testPlanCaseDTO2.getId());
				testPlanCaseDTO.setProjectId(testPlanCaseDTO2.getProjectId());
				
				String strResults = testCaseRunResult.getResults();
				if(StringUtils.hasLength(strResults)) {
					
					Collection<ObjectNode> list2 = JsonUtils.MAPPER.readValue(strResults, CloudUtilRuntimeBase.ObjectNodeListType);
					if(!ObjectUtils.isEmpty(list2)) {
						ArrayNode arrayNode = JsonUtils.createArrayNode();
						
						for(ObjectNode resultNode : list2) {
							ObjectNode objectNode = arrayNode.addObject();
							
							JsonNode node =	resultNode.get(TestCaseRunResult.FIELD_RESULTS_INPUTTAG);
							if(node != null) {
								objectNode.put("inputtag", node.asText());
							}
							
							node =	resultNode.get(TestCaseRunResult.FIELD_RESULTS_ACTUALRESULT);
							if(node != null) {
								objectNode.put("actualResult", node.asText());
							}
							
							node =	resultNode.get(TestCaseRunResult.FIELD_RESULTS_EXECUTERESULT);
							if(node != null) {
								objectNode.put("executeResult", getExecuteStatus(node.asText()));
							}
						}
						
						testPlanCaseDTO.setResults(arrayNode.toString());
					}
					
				}
				
				testPlanCaseDTO.setActualResult(testCaseRunResult.getActualResult());
				testPlanCaseDTO.setStatus(getExecuteStatus(testCaseRunResult.getStatus()));
				
				this.getMeterSphereClient().editTestPlanCase(testPlanCaseDTO);
			}
		}
		
	}
	
	
	protected String getExecuteStatus(String strResult) {
		
		if(TestCaseRunResult.STATUS_PASS.equals(strResult)) {
			return TestPlanCaseDTO.STATUS_PASS;
		}
		
		if(TestCaseRunResult.STATUS_FAILURE.equals(strResult)) {
			return TestPlanCaseDTO.STATUS_FAILURE;
		}
		
		if(TestCaseRunResult.STATUS_BLOCKING.equals(strResult)) {
			return TestPlanCaseDTO.STATUS_BLOCKING;
		}
		
		return null;
		
	}
}
