package net.ibizsys.central.cloud.devops.codegen.addin;

import java.util.Map;

import org.apache.commons.logging.LogFactory;

import net.ibizsys.central.cloud.core.util.domain.System;
import net.ibizsys.central.cloud.devops.core.addin.DevOpsCodeGenToolBase;
import net.ibizsys.central.cloud.devops.core.util.domain.CodeGenResult;
import net.ibizsys.codegen.core.engine.ICodeGenEngine;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.DataTypeUtils;

public class DefaultDevOpsCodeGenTool extends DevOpsCodeGenToolBase {
	
	private static final org.apache.commons.logging.Log log = LogFactory.getLog(DefaultDevOpsCodeGenTool.class);
	private ICodeGenEngine iCodeGenEngine = null;
	
	
	@Override
	protected void onInit() throws Exception {
		super.onInit();
		if(this.getCodeGenEngine(true) == null) {
			prepareCodeGenEngine();
			if(this.getCodeGenEngine(true) == null) {
				throw new Exception("引擎对象无效");
			}
		}
	}
	
	protected void prepareCodeGenEngine() throws Exception{
		DefaultCodeGenEngine codeGenEngine = new DefaultCodeGenEngine();
		codeGenEngine.init("", false, null);
		this.setCodeGenEngine(codeGenEngine);
	}
	
	protected ICodeGenEngine getCodeGenEngine() {
		return this.getCodeGenEngine(false);
	}
	
	protected ICodeGenEngine getCodeGenEngine(boolean bTryMode) {
		if(this.iCodeGenEngine != null || bTryMode) {
			return this.iCodeGenEngine;
		}
		throw new SystemRuntimeException(this.getSystemRuntime(), this.getCloudDevOpsUtilRuntime(), String.format("代码工具[%1$s]引擎对象无效", this.getName()));
	}
	
	
	protected void setCodeGenEngine(ICodeGenEngine iCodeGenEngine) {
		this.iCodeGenEngine = iCodeGenEngine;
	}
	
	
	@Override
	protected CodeGenResult onGenerateCodeSnippet(System system, IPSSystemService iPSSystemService, Map<String, Object> params) throws Throwable {
		String strPSModelType = DataTypeUtils.getStringValue(params.get("psmodeltype"), null);
		String strPSModelId = DataTypeUtils.getStringValue(params.get("psmodelid"), null);
		String strTemplCode = DataTypeUtils.getStringValue(params.get("templcode"), null);

		IPSModelObject iPSModelObject = iPSSystemService.getPSModelObject(strPSModelType, strPSModelId, false);
		
		String strCode = getCodeGenEngine().getContent(iPSModelObject, strTemplCode);
		CodeGenResult codeGenResult = new CodeGenResult();
		codeGenResult.setCode(strCode);
		
		return codeGenResult;
	}
}
