/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.util.groovy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.cloud.core.IServiceSystemRuntime;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.util.groovy.ISystemRTGroovyContext;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.security.IUserContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SystemRTGroovyContext
extends net.ibizsys.central.util.groovy.SystemRTGroovyContext
implements ISystemRTGroovyContext {
    private static final Log log = LogFactory.getLog(SystemRTGroovyContext.class);
    private Map<String, String> modelRuntimeTagMap = new HashMap<String, String>();

    public SystemRTGroovyContext(ISystemRuntimeContext systemRuntimeContext) {
        super(systemRuntimeContext);
        this.prepareModelRuntimeTagMap();
    }

    protected void prepareModelRuntimeTagMap() {
        if (this.getSystemRuntime() instanceof IServiceSystemRuntime) {
            IServiceSystemRuntime iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
            List psDataEntityList = this.getSystemRuntime().getPSSystem().getAllPSDataEntities();
            if (!ObjectUtils.isEmpty((Object)psDataEntityList)) {
                for (IPSDataEntity iPSDataEntity : psDataEntityList) {
                    try {
                        String strDEServiceObjectName = iServiceSystemRuntime.getRTCodeUtils().getDEServiceObjectName(iPSDataEntity);
                        if (!StringUtils.hasLength((String)strDEServiceObjectName)) continue;
                        String strKey = String.format("%1$s|%2$s", "deservice", strDEServiceObjectName);
                        this.modelRuntimeTagMap.put(strKey, PSModelUtils.calcUniqueTag((IPSSystemModule)iPSDataEntity.getPSSystemModule(), (String)iPSDataEntity.getName()));
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                    }
                }
            }
        }
    }

    public IUserContext user() {
        return EmployeeContext.getCurrentMust();
    }

    public Object getModelRuntime(Class<?> theClass, String tag) {
        if (IDEService.class.isAssignableFrom(theClass)) {
            String strKey;
            String strTag;
            if (theClass.isInterface() && StringUtils.hasLength((String)(strTag = this.modelRuntimeTagMap.get(strKey = String.format("%1$s|%2$s", "deservice", theClass.getCanonicalName()))))) {
                return this.getModelRuntime("deservice", strTag);
            }
            return this.getModelRuntime("deservice", tag);
        }
        return super.getModelRuntime(theClass, tag);
    }
}

