/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.CaseFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.cloud.core.util.IRTCodeUtils;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.IPSDataEntityObject;
import net.ibizsys.model.dataentity.ac.IPSDEACMode;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.res.IPSSysSFPlugin;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.io.FileUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RTCodeUtils
implements IRTCodeUtils {
    private static Map<String, CaseFormat> CaseFormatMap = new HashMap<String, CaseFormat>();
    private ISystemRuntimeContext iSystemRuntimeContext = null;
    private CaseFormat codeNameCaseFormat = null;

    public RTCodeUtils(ISystemRuntimeContext iSystemRuntimeContext) {
        Assert.notNull((Object)iSystemRuntimeContext, (String)"\u4f20\u5165\u7cfb\u7edf\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        this.iSystemRuntimeContext = iSystemRuntimeContext;
        this.codeNameCaseFormat = CaseFormat.UPPER_CAMEL;
    }

    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    public CaseFormat getCodeNameCaseFormat() {
        return this.codeNameCaseFormat;
    }

    public static List<IPSSysSFPlugin> buildPSSysSFPlugins(IPSSystemService iPSSystemService, File folder) throws Exception {
        ArrayList<IPSSysSFPlugin> list = new ArrayList<IPSSysSFPlugin>();
        HashMap<String, File> fileMap = new HashMap<String, File>();
        RTCodeUtils.fillGroovySourceFileMap("", folder, fileMap);
        for (Map.Entry entry : fileMap.entrySet()) {
            ObjectNode objectNode = JsonUtils.createObjectNode();
            objectNode.put("id", (String)entry.getKey());
            objectNode.put("name", ((File)entry.getValue()).getName());
            objectNode.put("pluginType", PSModelEnums.SFPluginType.USER.value);
            objectNode.put("runtimeObject", true);
            objectNode.put("rTObjectName", (String)entry.getKey());
            objectNode.put("rTObjectSource", 1);
            objectNode.put("tryMode", true);
            objectNode.put("templCode", FileUtils.readFileToString((File)((File)entry.getValue()), (String)"UTF-8"));
            IPSSysSFPlugin iPSSysSFPlugin = (IPSSysSFPlugin)iPSSystemService.createAndInitPSModelObject((IPSModelObjectRuntime)iPSSystemService.getPSSystem(), IPSSysSFPlugin.class, objectNode);
            list.add(iPSSysSFPlugin);
        }
        return list;
    }

    private static void fillGroovySourceFileMap(String strPackage, File folder, Map<String, File> fileMap) throws Exception {
        File[] files;
        if (StringUtils.hasLength((String)strPackage)) {
            strPackage = strPackage + ".";
        }
        if ((files = folder.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                RTCodeUtils.fillGroovySourceFileMap(strPackage + file.getName(), file, fileMap);
                continue;
            }
            String[] items = file.getName().split("[.]");
            if (items.length != 2 || !"groovy".equals(items[1])) continue;
            fileMap.put(strPackage + items[0], file);
        }
    }

    public ISystemRuntime getSystemRuntime() {
        return this.getSystemRuntimeContext().getSystemRuntime();
    }

    @Override
    public String getRTObjectName(IPSDataEntity iPSDataEntity) throws Exception {
        if (!StringUtils.hasLength((String)iPSDataEntity.getCodeName())) {
            throw new Exception("\u5b9e\u4f53\u4ee3\u7801\u6807\u8bc6\u65e0\u6548");
        }
        if (!StringUtils.hasLength((String)iPSDataEntity.getPSSystemModuleMust().getCodeName())) {
            throw new Exception("\u7cfb\u7edf\u6a21\u5757\u4ee3\u7801\u6807\u8bc6\u65e0\u6548");
        }
        String strPKGCodeName = this.getPKGCodeName(iPSDataEntity.getPSSystemModuleMust());
        return String.format("%1$s.%2$s.dataentity.%3$sDERuntime", strPKGCodeName, this.getUpperCamelCodeName(iPSDataEntity.getPSSystemModuleMust().getCodeName()).toLowerCase(), this.getUpperCamelCodeName(iPSDataEntity.getCodeName()));
    }

    @Override
    public String getDEServiceObjectName(IPSDataEntity iPSDataEntity) throws Exception {
        if (!StringUtils.hasLength((String)iPSDataEntity.getCodeName())) {
            throw new Exception("\u5b9e\u4f53\u4ee3\u7801\u6807\u8bc6\u65e0\u6548");
        }
        if (!StringUtils.hasLength((String)iPSDataEntity.getPSSystemModuleMust().getCodeName())) {
            throw new Exception("\u7cfb\u7edf\u6a21\u5757\u4ee3\u7801\u6807\u8bc6\u65e0\u6548");
        }
        String strPKGCodeName = this.getPKGCodeName(iPSDataEntity.getPSSystemModuleMust());
        return String.format("%1$s.%2$s.service.I%3$sService", strPKGCodeName, this.getUpperCamelCodeName(iPSDataEntity.getPSSystemModuleMust().getCodeName()).toLowerCase(), this.getUpperCamelCodeName(iPSDataEntity.getCodeName()));
    }

    @Override
    public String getDEAccessManagerObjectName(IPSDataEntity iPSDataEntity) throws Exception {
        if (!StringUtils.hasLength((String)iPSDataEntity.getCodeName())) {
            throw new Exception("\u5b9e\u4f53\u4ee3\u7801\u6807\u8bc6\u65e0\u6548");
        }
        if (!StringUtils.hasLength((String)iPSDataEntity.getPSSystemModuleMust().getCodeName())) {
            throw new Exception("\u7cfb\u7edf\u6a21\u5757\u4ee3\u7801\u6807\u8bc6\u65e0\u6548");
        }
        String strPKGCodeName = this.getPKGCodeName(iPSDataEntity.getPSSystemModuleMust());
        return String.format("%1$s.%2$s.security.%3$sAccessManager", strPKGCodeName, this.getUpperCamelCodeName(iPSDataEntity.getPSSystemModuleMust().getCodeName()).toLowerCase(), this.getUpperCamelCodeName(iPSDataEntity.getCodeName()));
    }

    @Override
    public String getRTObjectName(IPSDELogic iPSDELogic) throws Exception {
        if (!StringUtils.hasLength((String)iPSDELogic.getCodeName())) {
            throw new Exception("\u5b9e\u4f53\u903b\u8f91\u6a21\u578b\u6807\u8bc6\u65e0\u6548");
        }
        String strPKGCodeName = this.getPKGCodeName((IPSDataEntityObject)iPSDELogic, "logic");
        return String.format("%1$s.%2$sDELogicRuntime", strPKGCodeName, this.getUpperCamelCodeName(iPSDELogic.getCodeName()));
    }

    @Override
    public String getRTObjectName(IPSDEMethodDTO iPSDEMethodDTO) throws Exception {
        String strDTOName = iPSDEMethodDTO.getCodeName();
        if (!StringUtils.hasLength((String)strDTOName)) {
            strDTOName = iPSDEMethodDTO.getName();
        }
        if (!StringUtils.hasLength((String)strDTOName)) {
            throw new Exception("\u5b9e\u4f53\u65b9\u6cd5DTO\u6a21\u578b\u6807\u8bc6\u65e0\u6548");
        }
        String strPKGCodeName = this.getPKGCodeName((IPSDataEntityObject)iPSDEMethodDTO, "dto");
        return String.format("%1$s.%2$s", strPKGCodeName, StringUtils.capitalize((String)strDTOName));
    }

    @Override
    public String getRTObjectName(IPSDEACMode iPSDEACMode) throws Exception {
        if (!StringUtils.hasLength((String)iPSDEACMode.getCodeName())) {
            throw new Exception("\u5b9e\u4f53\u81ea\u586b\u6a21\u578b\u6807\u8bc6\u65e0\u6548");
        }
        String strPKGCodeName = this.getPKGCodeName((IPSDataEntityObject)iPSDEACMode, "ac");
        return String.format("%1$s.%2$sDELogicRuntime", strPKGCodeName, this.getUpperCamelCodeName(iPSDEACMode.getCodeName()));
    }

    @Override
    public String getPKGCodeName(IPSDataEntityObject iPSDataEntityObject, String strPackageName) throws Exception {
        IPSDataEntity iPSDataEntity = (IPSDataEntity)iPSDataEntityObject.getParentPSModelObject(IPSDataEntity.class);
        if (!StringUtils.hasLength((String)iPSDataEntity.getCodeName())) {
            throw new Exception("\u5b9e\u4f53\u4ee3\u7801\u6807\u8bc6\u65e0\u6548");
        }
        if (!StringUtils.hasLength((String)iPSDataEntity.getPSSystemModuleMust().getCodeName())) {
            throw new Exception("\u7cfb\u7edf\u6a21\u5757\u4ee3\u7801\u6807\u8bc6\u65e0\u6548");
        }
        String strPKGCodeName = this.getPKGCodeName(iPSDataEntity.getPSSystemModuleMust());
        return String.format("%1$s.%2$s.%3$s.%4$s", strPKGCodeName, this.getUpperCamelCodeName(iPSDataEntity.getPSSystemModuleMust().getCodeName()), strPackageName, this.getUpperCamelCodeName(iPSDataEntity.getCodeName())).toLowerCase();
    }

    @Override
    public String getPKGCodeName(IPSSystem iPSSystem) throws Exception {
        if (iPSSystem.getDefaultPSSysSFPub() == null) {
            throw new Exception("\u7cfb\u7edf\u672a\u5b9a\u4e49\u9ed8\u8ba4\u53d1\u5e03\u5bf9\u8c61");
        }
        if (!StringUtils.hasLength((String)iPSSystem.getDefaultPSSysSFPub().getPKGCodeName())) {
            if (!StringUtils.hasLength((String)iPSSystem.getDefaultPSSysSFPub().getCodeName())) {
                throw new Exception("\u9ed8\u8ba4\u53d1\u5e03\u5bf9\u8c61\u672a\u5b9a\u4e49\u4ee3\u7801\u6807\u8bc6");
            }
            return this.getUpperCamelCodeName(iPSSystem.getDefaultPSSysSFPub().getCodeName()).toLowerCase();
        }
        return String.format("%1$s", iPSSystem.getDefaultPSSysSFPub().getPKGCodeName()).toLowerCase();
    }

    @Override
    public String getPKGCodeName(IPSSystemModule iPSSystemModule) throws Exception {
        if (StringUtils.hasLength((String)iPSSystemModule.getPKGCodeName())) {
            return iPSSystemModule.getPKGCodeName();
        }
        IPSSysModelGroup iPSSysModelGroup = iPSSystemModule.getPSSysModelGroup();
        if (iPSSysModelGroup != null && StringUtils.hasLength((String)iPSSysModelGroup.getPKGCodeName())) {
            return String.format("%1$s.%2$s", iPSSysModelGroup.getPKGCodeName(), this.getUpperCamelCodeName(iPSSysModelGroup.getCodeName()).toLowerCase());
        }
        return this.getPKGCodeName((IPSSystem)iPSSystemModule.getParentPSModelObject(IPSSystem.class));
    }

    @Override
    public String getUpperCamelCodeName(String strCodeName) throws Exception {
        if (StringUtils.hasLength((String)strCodeName)) {
            return this.getCodeNameCaseFormat().to(CaseFormat.UPPER_CAMEL, strCodeName);
        }
        return strCodeName;
    }

    static {
        CaseFormatMap.put("LOWER_CAMEL", CaseFormat.LOWER_CAMEL);
        CaseFormatMap.put("LOWER_HYPHEN", CaseFormat.LOWER_HYPHEN);
        CaseFormatMap.put("LOWER_UNDERSCORE", CaseFormat.LOWER_UNDERSCORE);
        CaseFormatMap.put("UPPER_CAMEL", CaseFormat.UPPER_CAMEL);
        CaseFormatMap.put("UPPER_UNDERSCORE", CaseFormat.UPPER_UNDERSCORE);
    }
}

