/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Map;
import net.ibizsys.central.cloud.core.util.IConfigEntity;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.EntityBase;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class ConfigEntity
extends EntityBase
implements IConfigEntity {
    private boolean bOrigin = false;

    public ConfigEntity(String strContent) {
        this(strContent, false);
    }

    public ConfigEntity(Map<String, Object> config) {
        this(config, false);
    }

    public ConfigEntity(String strContent, boolean bOrigin) {
        this.bOrigin = bOrigin;
        if (StringUtils.hasLength((String)strContent)) {
            Map config = null;
            if (strContent.indexOf("{") == 0) {
                config = (Map)JsonUtils.MAPPER.convertValue((Object)strContent, Map.class);
            } else {
                Yaml yaml = new Yaml();
                config = (Map)yaml.loadAs(strContent, Map.class);
            }
            if (config != null) {
                this.putAll(config);
                if (this.isRemoveHyphen()) {
                    for (Map.Entry item : config.entrySet()) {
                        String strKey = ((String)item.getKey()).replace("-", "");
                        if (strKey.equals(item.getKey())) continue;
                        this.set(strKey, item.getValue());
                    }
                }
            }
        }
    }

    public ConfigEntity(Map<String, Object> config, boolean bOrigin) {
        this.bOrigin = bOrigin;
        if (!ObjectUtils.isEmpty(config)) {
            this.putAll(config);
            if (this.isRemoveHyphen()) {
                for (Map.Entry<String, Object> item : config.entrySet()) {
                    String strKey = item.getKey().replace("-", "");
                    if (strKey.equals(item.getKey())) continue;
                    this.set(strKey, item.getValue());
                }
            }
        }
    }

    @Override
    public Timestamp getTimestamp(String strName, Timestamp def) {
        try {
            return DataTypeUtils.getDateTimeValue((Object)this.get(strName), (Timestamp)def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String strName, BigDecimal fDefault) {
        try {
            return DataTypeUtils.getBigDecimalValue((Object)this.get(strName), (BigDecimal)fDefault);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public BigInteger getBigInteger(String strName, BigInteger nDefault) {
        try {
            return DataTypeUtils.getBigIntegerValue((Object)this.get(strName), (BigInteger)nDefault);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Boolean getBoolean(String strName, Boolean def) {
        try {
            return DataTypeUtils.getBooleanValue((Object)this.get(strName), (Boolean)def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Double getDouble(String strName, Double def) {
        try {
            return DataTypeUtils.getDoubleValue((Object)this.get(strName), (Double)def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Float getFloat(String strName, Float def) {
        try {
            return DataTypeUtils.getFloatValue((Object)this.get(strName), (Float)def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Integer getInteger(String strName, Integer def) {
        try {
            return DataTypeUtils.getIntegerValue((Object)this.get(strName), (Integer)def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Long getLong(String strName, Long def) {
        try {
            return DataTypeUtils.getLongValue((Object)this.get(strName), (Long)def);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getString(String strName, String strDefault) {
        try {
            return DataTypeUtils.getStringValue((Object)this.get(strName), (String)strDefault);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Object get(String strName, Object def) {
        Object value = this.get(strName);
        if (value == null) {
            return def;
        }
        return value;
    }

    protected boolean isLowerCaseName() {
        return !this.bOrigin;
    }

    protected boolean isRemoveHyphen() {
        return !this.bOrigin;
    }
}

