/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.util;

import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class CloudCacheTagUtils {
    private static final Log log = LogFactory.getLog(CloudCacheTagUtils.class);
    public static final String PREFIX = "ibiz-cloud";
    public static final String DEFAULTTAG = "$default$";
    public static final String GLOBALTAG = "$saas$";
    public static final String DCTAG = "$dc$";
    public static final String USERTAG = "$user$";
    public static final String USERTAG_PREFIX = "ex-";
    public static final String EMPLOYEETAG_PREFIX = "sysemp-";

    public static String getAuthenticationUserTag(String strUserName) {
        return String.format("%1$s-uaa-user-%2$s", PREFIX, strUserName);
    }

    public static String getAuthenticationUserCat(String strUserName, String strToken) {
        if (StringUtils.hasLength((String)strToken)) {
            return String.format("%1$s-uaa-cat-%2$s--%3$s", PREFIX, strUserName, KeyValueUtils.genUniqueId((Object)strToken));
        }
        log.warn((Object)String.format("\u8ba4\u8bc1\u7528\u6237\u5206\u7c7b[%1$s]\u672a\u6307\u5b9aToken\u503c\uff0c\u53ef\u80fd\u4f1a\u53d1\u751f\u95ee\u9898", new Object[0]));
        throw new RuntimeException(String.format("\u8ba4\u8bc1\u7528\u6237\u5206\u7c7b[%1$s]\u672a\u6307\u5b9aToken\u503c", new Object[0]));
    }

    public static String getUserEmployeeTag(String strSystemId, String strOrgId) {
        return String.format("sysemp-%1$s--%2$s", strSystemId, strOrgId);
    }

    public static String getUserAuthoritiesTag(String strDCSystemId) {
        return String.format("authorities-%1$s", strDCSystemId);
    }

    public static String getUserOrgSystemsTag(String strDCSystemId) {
        return String.format("orgsystems-%1$s", strDCSystemId);
    }

    public static String getUserAppDataTag(String strSystemId, String strOrgId) {
        return String.format("appdata-%1$s--%2$s", strSystemId, strOrgId);
    }

    public static String getUserSessionTag(String strDCSystemId) {
        return String.format("session-%1$s", strDCSystemId);
    }

    public static String getUserDynaRolesTag(String strDCSystemId) {
        return String.format("dynaroles-%1$s", strDCSystemId);
    }

    public static String getMetaDynaModelTag(String strSystemId, String strOrgId) {
        return String.format("%1$s-saas-dym-%2$s--%3$s", PREFIX, strSystemId, strOrgId);
    }

    public static String getConfigTag(String strSystemId, String strConfigType, String strTargetType, String strUserId) {
        return String.format("%1$s-saas-dym-%2$s--%3$s--%4$s", PREFIX, strSystemId, strConfigType, strTargetType, strUserId);
    }

    public static String getCodeListTag(String strSrfdcId, String strCodeListTag) {
        return String.format("%1$s-codelist-%2$s--%3$s", PREFIX, strSrfdcId, strCodeListTag);
    }

    public static String getCloudDataCat(String strDataType) {
        return CloudCacheTagUtils.getCloudDataCat(GLOBALTAG, strDataType);
    }

    public static String getCloudDataCat(String strSrfdcId, String strDataType) {
        return String.format("%1$s-clouddata-%2$s--%3$s", PREFIX, strSrfdcId, strDataType);
    }

    public static String getCloudDataCat(String strSrfdcId, String strUserId, String strDataType) {
        return String.format("%1$s-clouddata-%2$s-%3$s--%4$s", PREFIX, strSrfdcId, strUserId, strDataType);
    }

    public static String getPortalOpenDataCat(String strSystemId, String strEntity, String strKey) {
        return String.format("%1$s-portal-opendata-%2$s--%3$s--%4$s", PREFIX, strSystemId, strEntity, strKey);
    }

    public static String getPortalEmployeeCat(String strEmployeeId) {
        return String.format("%1$s-portal-employee-%2$s", PREFIX, strEmployeeId);
    }
}

