/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.sysutil;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudUAAClient;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.security.IAuthenticationUserRuntime;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.security.IUAAGrantedAuthority;
import net.ibizsys.central.cloud.core.servlet.IServiceHubFilter;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysUAAUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.SysUtilRuntimeBase;
import net.ibizsys.central.cloud.core.util.CloudCacheTagUtils;
import net.ibizsys.central.cloud.core.util.domain.AppData;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAction;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class SysUAAUtilRuntimeBase
extends SysUtilRuntimeBase
implements ISysUAAUtilRuntime,
IServiceHubFilter {
    private static final Log log = LogFactory.getLog(SysUAAUtilRuntimeBase.class);
    public final TypeReference<Collection<IUAAGrantedAuthority>> UAAGrantedAuthorityListType = new TypeReference<Collection<IUAAGrantedAuthority>>(){};
    public static final String UAAFILTERTAG = "_IBIZ_UAAFILTERTAG_";
    private String strTokenHeader = "Authorization";
    private String strTokenPrefix = "Bearer ";
    private ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = null;
    private String strPublicKeyString = null;

    protected void onPrepareDefaultSetting() throws Exception {
        String strTokenPrefix;
        String strTokenHeader = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".tokenheader", "Authorization");
        if (StringUtils.hasLength((String)strTokenHeader)) {
            this.setTokenHeader(strTokenHeader);
        }
        if (StringUtils.hasLength((String)(strTokenPrefix = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".tokenprefix", "Bearer ")))) {
            this.setTokenPrefix(strTokenPrefix);
        }
        super.onPrepareDefaultSetting();
    }

    protected void onInstall() throws Exception {
        super.onInstall();
        if (this.getSysCacheUtilRuntime(true) == null) {
            log.warn((Object)String.format("\u7cfb\u7edfUAA\u529f\u80fd\u7ec4\u4ef6\u672a\u6307\u5b9a\u7cfb\u7edf\u7f13\u5b58\u529f\u80fd\u7ec4\u4ef6\uff0c\u65e0\u6cd5\u63d0\u4f9b\u4e0e\u8ba4\u8bc1\u76f8\u5173\u80fd\u529b", new Object[0]));
            this.getSystemRuntime().log(30000, this.getLogCat(), String.format("\u7cfb\u7edfUAA\u529f\u80fd\u7ec4\u4ef6\u672a\u6307\u5b9a\u7cfb\u7edf\u7f13\u5b58\u529f\u80fd\u7ec4\u4ef6\uff0c\u65e0\u6cd5\u63d0\u4f9b\u4e0e\u8ba4\u8bc1\u76f8\u5173\u80fd\u529b", new Object[0]), null);
        }
    }

    protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime() {
        if (this.iSysCloudClientUtilRuntime == null) {
            this.iSysCloudClientUtilRuntime = (ISysCloudClientUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
        }
        return this.iSysCloudClientUtilRuntime;
    }

    @Override
    public String getTokenHeader() {
        return this.strTokenHeader;
    }

    protected void setTokenHeader(String strTokenHeader) {
        this.strTokenHeader = strTokenHeader;
    }

    @Override
    public String getTokenPrefix() {
        return this.strTokenPrefix;
    }

    protected void setTokenPrefix(String strTokenPrefix) {
        this.strTokenPrefix = strTokenPrefix;
    }

    @Override
    public boolean validateToken(String token, IAuthenticationUser iAuthenticationUser) {
        try {
            String strUaaToken;
            boolean bRet = this.onValidateToken(token, iAuthenticationUser);
            if (bRet && iAuthenticationUser.getApiuser() != 1 && !token.equals(strUaaToken = this.getSysCacheUtilRuntime().get(CloudCacheTagUtils.getAuthenticationUserCat(iAuthenticationUser.getUsername(), token), "srfuaatoken"))) {
                throw new Exception(String.format("\u9274\u522b\u51ed\u8bc1\u5df2\u6ce8\u9500", new Object[0]));
            }
            return bRet;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s\u9274\u522b\u51ed\u8bc1\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getLogicName(), ex.getMessage()), ex);
            throw this.dealException(String.format("\u9274\u522b\u51ed\u8bc1\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected boolean onValidateToken(String token, IAuthenticationUser iAuthenticationUser) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public String getUsernameFromToken(String token) {
        try {
            return this.onGetUsernameFromToken(token);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s\u83b7\u53d6Token\u7528\u6237\u6807\u8bc6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getLogicName(), ex.getMessage()), ex);
            throw this.dealException(String.format("\u83b7\u53d6Token\u7528\u6237\u6807\u8bc6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected String onGetUsernameFromToken(String token) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public Date getExpirationDateFromToken(String token) {
        try {
            return this.onGetExpirationDateFromToken(token);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("%1$s\u83b7\u53d6Token\u8fc7\u671f\u65f6\u95f4\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getLogicName(), ex.getMessage()), ex);
            throw this.dealException(String.format("\u83b7\u53d6Token\u8fc7\u671f\u65f6\u95f4\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Date onGetExpirationDateFromToken(String token) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public int getExpireInFromToken(String token) {
        Date expiredData = this.getExpirationDateFromToken(token);
        return Long.valueOf((expiredData.getTime() - System.currentTimeMillis()) / 1000L).intValue();
    }

    protected PublicKey getPublicKey(String publicKeyBase64) throws Throwable {
        byte[] byteKey = Base64.getDecoder().decode(publicKeyBase64);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byteKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    protected String getPublicKeyString() throws Throwable {
        if (StringUtils.hasLength((String)this.strPublicKeyString)) {
            return this.strPublicKeyString;
        }
        String usrHome = System.getProperty("user.home") + "/.ibzrt";
        File pubKeyFile = new File(usrHome, "ibzrt_rsa.pub");
        this.strPublicKeyString = !pubKeyFile.exists() ? IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/uaa/keypair/ibzrt_rsa.pub"), (Charset)Charset.defaultCharset()) : IOUtils.toString((InputStream)new FileInputStream(pubKeyFile), (Charset)Charset.defaultCharset());
        return this.strPublicKeyString;
    }

    @Override
    public boolean doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        return this.doFilterInternal((HttpServletRequest)request, (HttpServletResponse)response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doFilterInternal(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block33: {
            UserContext.setCurrent(null);
            request.setAttribute(UAAFILTERTAG, (Object)"TRUE");
            String requestHeader = request.getHeader(this.getTokenHeader());
            if (requestHeader == null || !requestHeader.startsWith(this.getTokenPrefix())) {
                log.debug((Object)String.format("\u8bf7\u6c42[%1$s]\u672a\u643a\u5e26Token", request.getRequestURI()));
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
                return false;
            }
            String username = null;
            String authToken = StringUtils.hasLength((String)this.getTokenPrefix()) ? requestHeader.substring(this.getTokenPrefix().length()) : requestHeader;
            try {
                username = this.getUsernameFromToken(authToken);
                if (!StringUtils.hasLength((String)username)) {
                    throw new Exception(String.format("Token\u672a\u5305\u542b\u7528\u6237\u6807\u8bc6", new Object[0]));
                }
            }
            catch (Throwable e) {
                log.debug((Object)e);
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
                return false;
            }
            String srforgid = request.getHeader("srforgid");
            String srfsystemid = request.getHeader("srfsystemid");
            if ("undefined".equals(srfsystemid)) {
                srfsystemid = null;
            }
            if ("undefined".equals(srforgid)) {
                srforgid = null;
            }
            String srfdcsystemid = request.getHeader("srfdcsystemid");
            String srfuserid = request.getHeader("srfuserid");
            String srfdcid = request.getHeader("srfdcid");
            IAuthenticationUser authenticationUser = null;
            ISysCacheUtilRuntime iSysCacheUtilRuntime = this.getSysCacheUtilRuntime(false);
            try {
                authenticationUser = (IAuthenticationUser)iSysCacheUtilRuntime.get(CloudCacheTagUtils.getAuthenticationUserTag(username), AuthenticationUser.class);
                if (authenticationUser == null) {
                    log.debug((Object)String.format("\u65e0\u6cd5\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5f53\u524d\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f", new Object[0]));
                    response.setStatus(HttpStatus.UNAUTHORIZED.value());
                    return false;
                }
            }
            catch (Throwable e) {
                throw new ServletException(e);
            }
            try {
                Map<String, Object> session;
                Collection<IUAAGrantedAuthority> authorities;
                Employee dcEmployee;
                block35: {
                    block36: {
                        block34: {
                            if (!this.validateToken(authToken, authenticationUser)) break block33;
                            if (authenticationUser instanceof IAuthenticationUserRuntime) {
                                ((IAuthenticationUserRuntime)((Object)authenticationUser)).setToken(authToken);
                                ((IAuthenticationUserRuntime)((Object)authenticationUser)).setExpirein(this.getExpireInFromToken(authToken));
                            }
                            dcEmployee = null;
                            authorities = null;
                            session = null;
                            if (!StringUtils.hasLength((String)srfsystemid) || !StringUtils.hasLength((String)srfdcid) || !StringUtils.hasLength((String)srfdcsystemid) || !StringUtils.hasLength((String)srfuserid)) break block34;
                            if (DataTypeUtils.getIntegerValue((Object)authenticationUser.getApiuser(), (Integer)0) != 1 && DataTypeUtils.getIntegerValue((Object)authenticationUser.getSuperuser(), (Integer)0) != 1) {
                                log.error((Object)String.format("\u7528\u6237[%1$s][%2$s]\u4f7f\u7528API\u6a21\u5f0f\u8bbf\u95ee\u7cfb\u7edf", authenticationUser.getUserid(), authenticationUser.getUsername()));
                                response.setStatus(HttpStatus.FORBIDDEN.value());
                                return false;
                            }
                            String srfusername = request.getHeader("srfusername");
                            dcEmployee = new Employee();
                            dcEmployee.setSrfdcid(srfdcid);
                            dcEmployee.setUserId(srfuserid);
                            dcEmployee.setDCSystemId(srfdcsystemid);
                            if (StringUtils.hasLength((String)srfusername)) {
                                try {
                                    dcEmployee.setPersonName(URLDecoder.decode(srfusername, "UTF-8"));
                                }
                                catch (Exception ex) {
                                    log.error((Object)ex);
                                    dcEmployee.setPersonName(srfusername);
                                }
                            }
                            if (DataTypeUtils.getIntegerValue((Object)authenticationUser.getApiuser(), (Integer)0) == 1) {
                                dcEmployee.setSuperUser(1);
                            }
                            dcEmployee.setOrgId(srforgid);
                            String strValue = request.getHeader("srforgcode");
                            if (StringUtils.hasLength((String)strValue)) {
                                dcEmployee.setOrgCode(strValue);
                            }
                            if (StringUtils.hasLength((String)(strValue = request.getHeader("srfdeptid")))) {
                                dcEmployee.setMDeptId(strValue);
                            }
                            if (StringUtils.hasLength((String)(strValue = request.getHeader("srfdeptcode")))) {
                                dcEmployee.setMDeptCode(strValue);
                            }
                            if (StringUtils.hasLength((String)(strValue = request.getHeader("srfporgids")))) {
                                dcEmployee.setPOrgIds(strValue);
                            }
                            if (StringUtils.hasLength((String)(strValue = request.getHeader("srfsorgids")))) {
                                dcEmployee.setSOrgIds(strValue);
                            }
                            if (StringUtils.hasLength((String)(strValue = request.getHeader("srfpdeptids")))) {
                                dcEmployee.setPDeptIds(strValue);
                            }
                            if (StringUtils.hasLength((String)(strValue = request.getHeader("srfsdeptids")))) {
                                dcEmployee.setSDeptIds(strValue);
                            }
                            break block35;
                        }
                        if (!StringUtils.hasLength((String)srfsystemid) || !StringUtils.hasLength((String)srforgid)) break block36;
                        dcEmployee = this.getEmployee(authenticationUser.getUsername(), authenticationUser.getToken(), srfsystemid, srforgid);
                        if (dcEmployee != null && authenticationUser.getSuperuser() == 1) {
                            dcEmployee.setSuperUser(1);
                        }
                        String strDCSystemId = null;
                        if (dcEmployee != null) {
                            strDCSystemId = dcEmployee.getDCSystemId();
                        }
                        if (StringUtils.hasLength(strDCSystemId)) {
                            authorities = (Collection<IUAAGrantedAuthority>)dcEmployee.get("_authorities");
                            if (authorities == null) {
                                authorities = this.getGrantedAuthorities(authenticationUser.getUsername(), authenticationUser.getToken(), strDCSystemId);
                            }
                            if ((session = (Map<String, Object>)dcEmployee.get("_session")) == null) {
                                session = this.getEmployeeSession(authenticationUser.getUsername(), authenticationUser.getToken(), strDCSystemId);
                            }
                        }
                        break block35;
                    }
                    if (StringUtils.hasLength((String)srfsystemid) && "iBizPortal".equalsIgnoreCase(srfsystemid)) {
                        dcEmployee = new Employee();
                        dcEmployee.setUserId(authenticationUser.getUserid());
                        dcEmployee.setUserName(authenticationUser.getUsername());
                        dcEmployee.setPersonName(authenticationUser.getPersonname());
                        dcEmployee.setUAAUserId(authenticationUser.getUserid());
                    } else if (DataTypeUtils.getIntegerValue((Object)authenticationUser.getSuperuser(), (Integer)0) == 1 || DataTypeUtils.getIntegerValue((Object)authenticationUser.getApiuser(), (Integer)0) == 1) {
                        dcEmployee = new Employee();
                        dcEmployee.setUserId(authenticationUser.getUserid());
                        dcEmployee.setUserName(authenticationUser.getUsername());
                        dcEmployee.setPersonName(authenticationUser.getPersonname());
                        dcEmployee.setUAAUserId(authenticationUser.getUserid());
                        dcEmployee.setSuperUser(1);
                    }
                }
                EmployeeContext iEmployeeContext = null;
                if (dcEmployee != null) {
                    iEmployeeContext = new EmployeeContext(dcEmployee, null, srfsystemid, (Collection<? extends GrantedAuthority>)authorities, session);
                }
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)authenticationUser, iEmployeeContext, authenticationUser.getAuthorities());
                authentication.setDetails((Object)iEmployeeContext);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                UserContext.setCurrent((IUserContext)iEmployeeContext);
                return true;
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        return false;
    }

    @Override
    public boolean redoFilter() throws IOException, ServletException {
        HttpServletRequest httpServletRequest = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        if (httpServletRequest == null) {
            return false;
        }
        Object uaaFilterTag = httpServletRequest.getAttribute(UAAFILTERTAG);
        if (!ObjectUtils.isEmpty((Object)uaaFilterTag)) {
            log.debug((Object)String.format("\u65e0\u6cd5\u91cd\u505a\u8fc7\u6ee4\u64cd\u4f5c\uff0c\u5df2\u7ecf\u8fdb\u884c\u8fc7\u6ee4\u64cd\u4f5c", new Object[0]));
            return false;
        }
        log.debug((Object)String.format("\u91cd\u505a\u8fc7\u6ee4\u64cd\u4f5c", new Object[0]));
        return this.redoFilterInternal(httpServletRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean redoFilterInternal(HttpServletRequest request) throws ServletException, IOException {
        UserContext.setCurrent(null);
        request.setAttribute(UAAFILTERTAG, (Object)"TRUE");
        String requestHeader = request.getHeader(this.getTokenHeader());
        if (requestHeader == null || !requestHeader.startsWith(this.getTokenPrefix())) {
            log.debug((Object)String.format("\u8bf7\u6c42[%1$s]\u672a\u643a\u5e26Token", request.getRequestURI()));
            return false;
        }
        String username = null;
        String authToken = StringUtils.hasLength((String)this.getTokenPrefix()) ? requestHeader.substring(this.getTokenPrefix().length()) : requestHeader;
        try {
            username = this.getUsernameFromToken(authToken);
            if (!StringUtils.hasLength((String)username)) {
                throw new Exception(String.format("Token\u672a\u5305\u542b\u7528\u6237\u6807\u8bc6", new Object[0]));
            }
        }
        catch (Throwable e) {
            log.debug((Object)e);
            return false;
        }
        String srforgid = request.getHeader("srforgid");
        String srfsystemid = request.getHeader("srfsystemid");
        if ("undefined".equals(srfsystemid)) {
            srfsystemid = null;
        }
        if ("undefined".equals(srforgid)) {
            srforgid = null;
        }
        String srfdcsystemid = request.getHeader("srfdcsystemid");
        String srfuserid = request.getHeader("srfuserid");
        String srfdcid = request.getHeader("srfdcid");
        IAuthenticationUser authenticationUser = null;
        ISysCacheUtilRuntime iSysCacheUtilRuntime = this.getSysCacheUtilRuntime(false);
        try {
            authenticationUser = (IAuthenticationUser)iSysCacheUtilRuntime.get(CloudCacheTagUtils.getAuthenticationUserTag(username), AuthenticationUser.class);
            if (authenticationUser == null) {
                log.debug((Object)String.format("\u65e0\u6cd5\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5f53\u524d\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f", new Object[0]));
                return false;
            }
        }
        catch (Throwable e) {
            log.debug((Object)e);
            return false;
        }
        try {
            Map<String, Object> session;
            Collection<IUAAGrantedAuthority> authorities;
            Employee dcEmployee;
            block34: {
                block35: {
                    block33: {
                        if (!this.validateToken(authToken, authenticationUser)) return false;
                        if (authenticationUser instanceof IAuthenticationUserRuntime) {
                            ((IAuthenticationUserRuntime)((Object)authenticationUser)).setToken(authToken);
                            ((IAuthenticationUserRuntime)((Object)authenticationUser)).setExpirein(this.getExpireInFromToken(authToken));
                        }
                        dcEmployee = null;
                        authorities = null;
                        session = null;
                        if (!StringUtils.hasLength((String)srfsystemid) || !StringUtils.hasLength((String)srfdcid) || !StringUtils.hasLength((String)srfdcsystemid) || !StringUtils.hasLength((String)srfuserid)) break block33;
                        if (DataTypeUtils.getIntegerValue((Object)authenticationUser.getApiuser(), (Integer)0) != 1 && DataTypeUtils.getIntegerValue((Object)authenticationUser.getSuperuser(), (Integer)0) != 1) {
                            log.error((Object)String.format("\u7528\u6237[%1$s][%2$s]\u4f7f\u7528API\u6a21\u5f0f\u8bbf\u95ee\u7cfb\u7edf", authenticationUser.getUserid(), authenticationUser.getUsername()));
                            return false;
                        }
                        String srfusername = request.getHeader("srfusername");
                        dcEmployee = new Employee();
                        dcEmployee.setSrfdcid(srfdcid);
                        dcEmployee.setUserId(srfuserid);
                        dcEmployee.setDCSystemId(srfdcsystemid);
                        if (StringUtils.hasLength((String)srfusername)) {
                            try {
                                dcEmployee.setPersonName(URLDecoder.decode(srfusername, "UTF-8"));
                            }
                            catch (Exception ex) {
                                log.error((Object)ex);
                                dcEmployee.setPersonName(srfusername);
                            }
                        }
                        if (DataTypeUtils.getIntegerValue((Object)authenticationUser.getApiuser(), (Integer)0) == 1) {
                            dcEmployee.setSuperUser(1);
                        }
                        dcEmployee.setOrgId(srforgid);
                        String strValue = request.getHeader("srforgcode");
                        if (StringUtils.hasLength((String)strValue)) {
                            dcEmployee.setOrgCode(strValue);
                        }
                        if (StringUtils.hasLength((String)(strValue = request.getHeader("srfdeptid")))) {
                            dcEmployee.setMDeptId(strValue);
                        }
                        if (StringUtils.hasLength((String)(strValue = request.getHeader("srfdeptcode")))) {
                            dcEmployee.setMDeptCode(strValue);
                        }
                        if (StringUtils.hasLength((String)(strValue = request.getHeader("srfporgids")))) {
                            dcEmployee.setPOrgIds(strValue);
                        }
                        if (StringUtils.hasLength((String)(strValue = request.getHeader("srfsorgids")))) {
                            dcEmployee.setSOrgIds(strValue);
                        }
                        if (StringUtils.hasLength((String)(strValue = request.getHeader("srfpdeptids")))) {
                            dcEmployee.setPDeptIds(strValue);
                        }
                        if (StringUtils.hasLength((String)(strValue = request.getHeader("srfsdeptids")))) {
                            dcEmployee.setSDeptIds(strValue);
                        }
                        break block34;
                    }
                    if (!StringUtils.hasLength((String)srfsystemid) || !StringUtils.hasLength((String)srforgid)) break block35;
                    dcEmployee = this.getEmployee(authenticationUser.getUsername(), authenticationUser.getToken(), srfsystemid, srforgid);
                    if (dcEmployee != null && authenticationUser.getSuperuser() == 1) {
                        dcEmployee.setSuperUser(1);
                    }
                    String strDCSystemId = null;
                    if (dcEmployee != null) {
                        strDCSystemId = dcEmployee.getDCSystemId();
                    }
                    if (StringUtils.hasLength(strDCSystemId)) {
                        authorities = (Collection<IUAAGrantedAuthority>)dcEmployee.get("_authorities");
                        if (authorities == null) {
                            authorities = this.getGrantedAuthorities(authenticationUser.getUsername(), authenticationUser.getToken(), strDCSystemId);
                        }
                        if ((session = (Map<String, Object>)dcEmployee.get("_session")) == null) {
                            session = this.getEmployeeSession(authenticationUser.getUsername(), authenticationUser.getToken(), strDCSystemId);
                        }
                    }
                    break block34;
                }
                if (StringUtils.hasLength((String)srfsystemid) && "iBizPortal".equalsIgnoreCase(srfsystemid)) {
                    dcEmployee = new Employee();
                    dcEmployee.setUserId(authenticationUser.getUserid());
                    dcEmployee.setUserName(authenticationUser.getUsername());
                    dcEmployee.setPersonName(authenticationUser.getPersonname());
                    dcEmployee.setUAAUserId(authenticationUser.getUserid());
                } else if (DataTypeUtils.getIntegerValue((Object)authenticationUser.getSuperuser(), (Integer)0) == 1 || DataTypeUtils.getIntegerValue((Object)authenticationUser.getApiuser(), (Integer)0) == 1) {
                    dcEmployee = new Employee();
                    dcEmployee.setUserId(authenticationUser.getUserid());
                    dcEmployee.setUserName(authenticationUser.getUsername());
                    dcEmployee.setPersonName(authenticationUser.getPersonname());
                    dcEmployee.setUAAUserId(authenticationUser.getUserid());
                    dcEmployee.setSuperUser(1);
                }
            }
            EmployeeContext iEmployeeContext = null;
            if (dcEmployee != null) {
                iEmployeeContext = new EmployeeContext(dcEmployee, null, srfsystemid, (Collection<? extends GrantedAuthority>)authorities, session);
            }
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)authenticationUser, iEmployeeContext, authenticationUser.getAuthorities());
            authentication.setDetails((Object)iEmployeeContext);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            UserContext.setCurrent((IUserContext)iEmployeeContext);
            return true;
        }
        catch (Throwable e) {
            log.debug((Object)e);
        }
        return false;
    }

    public String getLogicName() {
        return String.format("\u7cfb\u7edfUAA\u529f\u80fd\u7ec4\u4ef6[%1$s]", this.getName());
    }

    @Override
    public AppData getAppData(final String strSystemId, final String strOrgId) {
        final IAuthenticationUser iAuthenticationUser = AuthenticationUser.getCurrentMust();
        return (AppData)((Object)this.executeAction("\u83b7\u53d6\u7528\u6237\u5e94\u7528\u6570\u636e", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return SysUAAUtilRuntimeBase.this.onGetAppData(iAuthenticationUser, strSystemId, strOrgId);
            }
        }, null, AppData.class));
    }

    protected AppData onGetAppData(IAuthenticationUser iAuthenticationUser, String strSystemId, String strOrgId) throws Throwable {
        HttpServletRequest httpServletRequest = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        String clientIp = httpServletRequest.getHeader("X-Real-IP");
        ICloudUAAClient iCloudUAAClient = (ICloudUAAClient)this.getSysCloudClientUtilRuntime().getRawServiceClient("UAA").getProxyClient(ICloudUAAClient.class);
        return iCloudUAAClient.getAppData(strSystemId, strOrgId, StringUtils.hasLength((String)this.getTokenPrefix()) ? this.getTokenPrefix() + iAuthenticationUser.getToken() : iAuthenticationUser.getToken(), clientIp);
    }

    @Override
    public AppData getAppData(final String strDCSystemId) {
        final IAuthenticationUser iAuthenticationUser = AuthenticationUser.getCurrentMust();
        return (AppData)((Object)this.executeAction("\u83b7\u53d6\u7528\u6237\u5e94\u7528\u6570\u636e", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                return SysUAAUtilRuntimeBase.this.onGetAppData(iAuthenticationUser, strDCSystemId);
            }
        }, null, AppData.class));
    }

    protected AppData onGetAppData(IAuthenticationUser iAuthenticationUser, String strDCSystemId) throws Throwable {
        HttpServletRequest httpServletRequest = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        String clientIp = httpServletRequest.getHeader("X-Real-IP");
        ICloudUAAClient iCloudUAAClient = (ICloudUAAClient)this.getSysCloudClientUtilRuntime().getRawServiceClient("UAA").getProxyClient(ICloudUAAClient.class);
        return iCloudUAAClient.getAppData(strDCSystemId, StringUtils.hasLength((String)this.getTokenPrefix()) ? this.getTokenPrefix() + iAuthenticationUser.getToken() : iAuthenticationUser.getToken(), clientIp);
    }

    @Override
    public IEmployeeContext getEmployeeContext(final String strSystemId, final String strOrgId, final boolean bSetCurrent) {
        final IAuthenticationUser iAuthenticationUser = AuthenticationUser.getCurrentMust();
        return (IEmployeeContext)this.executeAction("\u83b7\u53d6\u673a\u6784\u7528\u6237\u4e0a\u4e0b\u6587", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                IEmployeeContext iEmployeeContext = SysUAAUtilRuntimeBase.this.onGetEmployeeContext(iAuthenticationUser, strSystemId, strOrgId);
                if (bSetCurrent) {
                    UserContext.setCurrent((IUserContext)iEmployeeContext);
                }
                return iEmployeeContext;
            }
        }, null, IEmployeeContext.class);
    }

    protected IEmployeeContext onGetEmployeeContext(IAuthenticationUser iAuthenticationUser, String strSystemId, String strOrgId) throws Throwable {
        Map<String, Object> session;
        Collection<IUAAGrantedAuthority> authorities;
        Employee employee = this.getEmployee(iAuthenticationUser.getUsername(), iAuthenticationUser.getToken(), strSystemId, strOrgId);
        if (employee == null) {
            throw new Exception(String.format("\u673a\u6784\u7528\u6237\u8eab\u4efd\u65e0\u6548", new Object[0]));
        }
        if (iAuthenticationUser.getSuperuser() == 1) {
            employee.setSuperUser(1);
        }
        if ((authorities = (Collection<IUAAGrantedAuthority>)employee.get("_authorities")) == null) {
            authorities = this.getGrantedAuthorities(iAuthenticationUser.getUsername(), iAuthenticationUser.getToken(), employee.getDCSystemId());
        }
        if ((session = (Map<String, Object>)employee.get("_session")) == null) {
            session = this.getEmployeeSession(iAuthenticationUser.getUsername(), iAuthenticationUser.getToken(), employee.getDCSystemId());
        }
        return new EmployeeContext(employee, null, strSystemId, authorities, session);
    }

    @Override
    public IEmployeeContext getEmployeeContext(final IAuthenticationUser iAuthenticationUser, final Employee employee, final String strSystemId) {
        return (IEmployeeContext)this.executeAction("\u83b7\u53d6\u673a\u6784\u7528\u6237\u4e0a\u4e0b\u6587", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                IEmployeeContext iEmployeeContext = SysUAAUtilRuntimeBase.this.onGetEmployeeContext(iAuthenticationUser, employee, strSystemId);
                return iEmployeeContext;
            }
        }, null, IEmployeeContext.class);
    }

    protected IEmployeeContext onGetEmployeeContext(IAuthenticationUser iAuthenticationUser, Employee employee, String strSystemId) throws Throwable {
        Map<String, Object> session;
        Collection<IUAAGrantedAuthority> authorities = (Collection<IUAAGrantedAuthority>)employee.get("_authorities");
        if (authorities == null) {
            authorities = this.getGrantedAuthorities(iAuthenticationUser.getUsername(), iAuthenticationUser.getToken(), employee.getDCSystemId());
        }
        if ((session = (Map<String, Object>)employee.get("_session")) == null) {
            session = this.getEmployeeSession(iAuthenticationUser.getUsername(), iAuthenticationUser.getToken(), employee.getDCSystemId());
        }
        return new EmployeeContext(employee, null, strSystemId, authorities, session);
    }

    @Override
    public IAuthenticationUser getAuthenticationUser(String strToken) {
        return this.getAuthenticationUser(strToken, true);
    }

    @Override
    public IAuthenticationUser getAuthenticationUser(final String strToken, final boolean bValidate) {
        return (IAuthenticationUser)this.executeAction("\u83b7\u53d6\u8ba4\u8bc1\u7528\u6237", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                IAuthenticationUser iAuthenticationUser = SysUAAUtilRuntimeBase.this.onGetAuthenticationUser(strToken, bValidate);
                return iAuthenticationUser;
            }
        }, null, IAuthenticationUser.class);
    }

    protected IAuthenticationUser onGetAuthenticationUser(String strToken, boolean bValidate) throws Throwable {
        String strUserName = this.getUsernameFromToken(strToken);
        if (!StringUtils.hasLength((String)strUserName)) {
            throw new Exception(String.format("Token\u672a\u5305\u542b\u7528\u6237\u6807\u8bc6", new Object[0]));
        }
        IAuthenticationUser iAuthenticationUser = (IAuthenticationUser)this.getSysCacheUtilRuntime().get(CloudCacheTagUtils.getAuthenticationUserTag(strUserName), AuthenticationUser.class);
        if (iAuthenticationUser == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6Token\u76f8\u5173\u7684\u7528\u6237\u8eab\u4efd\u4fe1\u606f", new Object[0]));
        }
        if (bValidate && !this.validateToken(strToken, iAuthenticationUser)) {
            throw new Exception("\u9274\u522b\u7528\u6237\u51ed\u8bc1\u5931\u8d25");
        }
        if (iAuthenticationUser instanceof IAuthenticationUserRuntime) {
            ((IAuthenticationUserRuntime)((Object)iAuthenticationUser)).setToken(strToken);
            ((IAuthenticationUserRuntime)((Object)iAuthenticationUser)).setExpirein(this.getExpireInFromToken(strToken));
        }
        return iAuthenticationUser;
    }

    protected Collection<IUAAGrantedAuthority> getGrantedAuthorities(String strUAAUserName, String strToken, String strDCSystemId) {
        return (Collection)this.getSysCacheUtilRuntime().get(CloudCacheTagUtils.getAuthenticationUserCat(strUAAUserName, strToken), CloudCacheTagUtils.getUserAuthoritiesTag(strDCSystemId), this.UAAGrantedAuthorityListType);
    }

    protected Map<String, Object> getEmployeeSession(String strUAAUserName, String strToken, String strDCSystemId) {
        return (Map)this.getSysCacheUtilRuntime().get(CloudCacheTagUtils.getAuthenticationUserCat(strUAAUserName, strToken), CloudCacheTagUtils.getUserSessionTag(strDCSystemId), Map.class);
    }

    @Override
    public void updateCurrentEmployeeSession(final Map<String, Object> sessions) {
        final IAuthenticationUser iAuthenticationUser = AuthenticationUser.getCurrentMust();
        final IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        this.executeAction("\u8bbe\u7f6e\u673a\u6784\u7528\u6237\u4f1a\u8bdd\u53d8\u91cf", new IAction(){

            public Object execute(Object[] args) throws Throwable {
                SysUAAUtilRuntimeBase.this.onEmployeeSession(iAuthenticationUser, iEmployeeContext, sessions);
                return null;
            }
        }, null);
    }

    protected void onEmployeeSession(IAuthenticationUser iAuthenticationUser, IEmployeeContext iEmployeeContext, Map<String, Object> sessions) throws Throwable {
        this.getSysCacheUtilRuntime().set(CloudCacheTagUtils.getAuthenticationUserCat(iAuthenticationUser.getUsername(), iAuthenticationUser.getToken()), CloudCacheTagUtils.getUserSessionTag(iEmployeeContext.getDcsystemid()), sessions);
        if (iEmployeeContext.getSessionParams() != null) {
            iEmployeeContext.getSessionParams().putAll(sessions);
        }
    }

    protected Employee getEmployee(String strUAAUserName, String strToken, String strSystemId, String strOrgId) {
        String strCacheCat = CloudCacheTagUtils.getAuthenticationUserCat(strUAAUserName, strToken);
        Map map = this.getSysCacheUtilRuntime().getAll(strCacheCat);
        if (ObjectUtils.isEmpty((Object)map)) {
            return null;
        }
        String strEmployeeTag = CloudCacheTagUtils.getUserEmployeeTag(strSystemId, strOrgId);
        String strEmployee = (String)map.get(strEmployeeTag);
        if (ObjectUtils.isEmpty((Object)strEmployee)) {
            return null;
        }
        Employee employee = (Employee)((Object)this.getSystemRuntime().deserialize((Object)strEmployee, Employee.class));
        String strDCSystemId = null;
        if (employee != null) {
            strDCSystemId = employee.getDCSystemId();
        }
        if (StringUtils.hasLength(strDCSystemId)) {
            String strUAAGrantedAuthorityList = (String)map.get(CloudCacheTagUtils.getUserAuthoritiesTag(strDCSystemId));
            if (!ObjectUtils.isEmpty((Object)strUAAGrantedAuthorityList)) {
                Collection authorities = (Collection)this.getSystemRuntime().deserialize((Object)strUAAGrantedAuthorityList, this.UAAGrantedAuthorityListType);
                employee.set("_authorities", authorities);
            } else {
                employee.set("_authorities", new ArrayList());
            }
            String strSession = (String)map.get(CloudCacheTagUtils.getUserSessionTag(strDCSystemId));
            if (!ObjectUtils.isEmpty((Object)strSession)) {
                Map session = (Map)this.getSystemRuntime().deserialize((Object)strSession, Map.class);
                employee.set("_session", session);
            } else {
                employee.set("_session", new LinkedHashMap());
            }
        }
        return employee;
    }

    @Override
    public Employee getEmployee(String strSystemId, String strOrgId, boolean bTryMode) {
        IAuthenticationUser iAuthenticationUser = AuthenticationUser.getCurrentMust();
        Employee employee = this.getEmployee(iAuthenticationUser.getUsername(), iAuthenticationUser.getToken(), strSystemId, strOrgId);
        if (employee != null || bTryMode) {
            return employee;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u65e0\u6cd5\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u6307\u5b9a\u673a\u6784\u4eba\u5458", new Object[0]));
    }
}

