/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.util.Inflector;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.codelist.IPSAppCodeList;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class GatewayUtils {
    private static final Log log = LogFactory.getLog(GatewayUtils.class);

    public static ObjectNode getAppGatewayNode(String strDeploySystemId, String strServiceId, IPSApplication iPSApplication) throws Exception {
        return GatewayUtils.getAppGatewayNode(strDeploySystemId, strServiceId, iPSApplication, false);
    }

    public static ObjectNode getAppGatewayNode(String strDeploySystemId, String strServiceId, IPSApplication iPSApplication, boolean bEnableExtension) throws Exception {
        Map<String, IPSDEServiceAPI> psPSDEServiceAPIMap;
        List psAppCodeLists;
        Object filtersNode;
        ArrayNode predicatesNode;
        ObjectNode objectNode;
        IPSSystem iPSSystem = (IPSSystem)iPSApplication.getParentPSModelObject(IPSSystem.class, false);
        strServiceId = strServiceId.toLowerCase();
        String strAPIPrefix = String.format("%1$s__%2$s", strDeploySystemId, iPSApplication.getCodeName()).toLowerCase();
        ObjectNode gatewayNode = JsonUtils.createObjectNode();
        ArrayNode routesNode = gatewayNode.putArray("routes");
        if (!bEnableExtension || strDeploySystemId.equalsIgnoreCase(strServiceId)) {
            objectNode = routesNode.addObject();
            objectNode.put("id", String.format("%1$s__appdata", strAPIPrefix));
            objectNode.put("uri", String.format("lb://servicehub-%1$s", strServiceId));
            objectNode.put("order", 50);
            predicatesNode = objectNode.putArray("predicates");
            predicatesNode.add(String.format("Path=/%1$s/appdata/**", strAPIPrefix));
            filtersNode = objectNode.putArray("filters");
            filtersNode.add("StripPrefix=1");
            filtersNode.add(String.format("PrefixPath=/%1$s", strServiceId));
        }
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_uaa", strAPIPrefix));
        objectNode.put("uri", String.format("lb://%1$s", "ibizcloud-uaa"));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/v7/**,/%1$s/uaa/**", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=1");
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_oss", strAPIPrefix));
        objectNode.put("uri", String.format("lb://%1$s", "ibizcloud-oss"));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/ibizutil/**", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=1");
        if (bEnableExtension && !ObjectUtils.isEmpty((Object)(psAppCodeLists = iPSApplication.getAllPSAppCodeLists()))) {
            ArrayList<String> list = new ArrayList<String>();
            for (IPSAppCodeList iPSAppCodeList : psAppCodeLists) {
                if (iPSAppCodeList.getDynaSysMode() == PSModelEnums.DynaSysMode.DISABLED.value) continue;
                list.add(String.format("/%1$s/dictionaries/codelist/%2$s/**", strAPIPrefix, iPSAppCodeList.getCodeListTag()));
                list.add(String.format("/%1$s/dictionarys/codelist/%2$s/**", strAPIPrefix, iPSAppCodeList.getCodeListTag()));
            }
            if (!ObjectUtils.isEmpty(list)) {
                ObjectNode objectNode2 = routesNode.addObject();
                objectNode2.put("id", String.format("%1$s__cloud_conf_dynasys", strAPIPrefix));
                objectNode2.put("uri", String.format("lb://servicehub-%1$s", strServiceId));
                objectNode2.put("order", 50);
                ArrayNode predicatesNode2 = objectNode2.putArray("predicates");
                predicatesNode2.add(String.format("Path=%1$s", StringUtils.collectionToDelimitedString(list, (String)",")));
                ArrayNode filtersNode2 = objectNode2.putArray("filters");
                filtersNode2.add("StripPrefix=2");
                filtersNode2.add(String.format("PrefixPath=/%1$s/extension/dictionaries", strServiceId));
            }
        }
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_conf", strAPIPrefix));
        objectNode.put("uri", String.format("lb://%1$s", "ibizcloud-conf"));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/configs/**,/%1$s/dictionaries/**,/%1$s/dictionarys/**", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=1");
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_workflow", strAPIPrefix));
        objectNode.put("uri", String.format("lb://%1$s", "ibizcloud-wf"));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/wfcore/**", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=1");
        if (!bEnableExtension) {
            objectNode = routesNode.addObject();
            objectNode.put("id", String.format("%1$s__cloud_devops", strAPIPrefix));
            objectNode.put("uri", String.format("lb://%1$s", "ibizcloud-devops"));
            objectNode.put("order", 60);
            predicatesNode = objectNode.putArray("predicates");
            predicatesNode.add(String.format("Path=/%1$s/remotemodel/**", strAPIPrefix));
            filtersNode = objectNode.putArray("filters");
            filtersNode.add("StripPrefix=2");
            filtersNode.add(String.format("PrefixPath=/devops/dynamodels/pssysapps/%1$s", iPSApplication.getCodeName()));
        } else {
            objectNode = routesNode.addObject();
            objectNode.put("id", String.format("%1$s__cloud_devops", strAPIPrefix));
            objectNode.put("uri", String.format("lb://servicehub-%1$s", strServiceId));
            objectNode.put("order", 60);
            predicatesNode = objectNode.putArray("predicates");
            predicatesNode.add(String.format("Path=/%1$s/remotemodel/**", strAPIPrefix));
            filtersNode = objectNode.putArray("filters");
            filtersNode.add("StripPrefix=2");
            filtersNode.add(String.format("PrefixPath=/%2$s/extension/dynamodels/pssysapps/%1$s", iPSApplication.getCodeName(), strServiceId));
        }
        if (!bEnableExtension) {
            objectNode = routesNode.addObject();
            objectNode.put("id", String.format("%1$s__cloud_devops_jsonschema", strAPIPrefix));
            objectNode.put("uri", String.format("lb://%1$s", "ibizcloud-devops"));
            objectNode.put("order", 60);
            predicatesNode = objectNode.putArray("predicates");
            predicatesNode.add(String.format("Path=/%1$s/jsonschema/**", strAPIPrefix));
            filtersNode = objectNode.putArray("filters");
            filtersNode.add("StripPrefix=2");
            filtersNode.add(String.format("PrefixPath=/devops/jsonschemas/pssysapps/%1$s", iPSApplication.getCodeName()));
        } else {
            objectNode = routesNode.addObject();
            objectNode.put("id", String.format("%1$s__cloud_devops_jsonschema", strAPIPrefix));
            objectNode.put("uri", String.format("lb://servicehub-%1$s", strServiceId));
            objectNode.put("order", 60);
            predicatesNode = objectNode.putArray("predicates");
            predicatesNode.add(String.format("Path=/%1$s/jsonschema/**", strAPIPrefix));
            filtersNode = objectNode.putArray("filters");
            filtersNode.add("StripPrefix=2");
            filtersNode.add(String.format("PrefixPath=/%2$s/extension/jsonschemas/pssysapps/%1$s", iPSApplication.getCodeName(), strServiceId));
        }
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_portal", strAPIPrefix));
        objectNode.put("uri", String.format("lb://%1$s", "ibizcloud-portal"));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/portal/markopendata/**", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=1");
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_portal_asyncaction", strAPIPrefix));
        objectNode.put("uri", String.format("lb://%1$s", "ibizcloud-portal"));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/portal/asyncaction/**", strAPIPrefix));
        predicatesNode.add(String.format("Method=GET", new Object[0]));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=1");
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_portal_asyncaction_select", strAPIPrefix));
        objectNode.put("uri", String.format("lb://%1$s", "ibizcloud-portal"));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/portal/asyncaction/executing,/%1$s/portal/asyncaction/finished,/%1$s/portal/asyncaction/error,/%1$s/portal/asyncaction/all", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=1");
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_portal_mqtt", strAPIPrefix));
        objectNode.put("uri", String.format("lb:ws://%1$s", "ibizcloud-portal-mqtt"));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/portal/mqtt/**", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=3");
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_saas_extension", strAPIPrefix));
        objectNode.put("uri", String.format("lb://%1$s", "extension-api"));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/extension/**", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=2");
        filtersNode.add("PrefixPath=/extension/api");
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__webhooks", strAPIPrefix));
        objectNode.put("uri", String.format("lb://servicehub-%1$s", strServiceId));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/webhooks/**", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=2");
        filtersNode.add(String.format("PrefixPath=/%1$s/extension/webhooks", strServiceId));
        List psAppDataEntities = iPSApplication.getAllPSAppDataEntities();
        if (!ObjectUtils.isEmpty((Object)psAppDataEntities) && !ObjectUtils.isEmpty(psPSDEServiceAPIMap = GatewayUtils.getPSDEServiceAPIMap(iPSSystem))) {
            for (IPSAppDataEntity iPSAppDataEntity : psAppDataEntities) {
                ObjectNode objectNode3;
                if (!StringUtils.hasLength((String)iPSAppDataEntity.getSysAPITag()) || !StringUtils.hasLength((String)iPSAppDataEntity.getDEAPITag())) continue;
                IPSDEServiceAPI iPSDEServiceAPI = psPSDEServiceAPIMap.get(String.format("%1$s-%2$s", iPSAppDataEntity.getSysAPITag(), iPSAppDataEntity.getDEAPITag()).toLowerCase());
                if (iPSDEServiceAPI == null) {
                    throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u5e94\u7528\u5b9e\u4f53[%1$s]\u7ed1\u5b9a\u7684\u670d\u52a1\u63a5\u53e3[%2$s-%3$s]", iPSAppDataEntity.getName(), iPSAppDataEntity.getSysAPITag(), iPSAppDataEntity.getDEAPITag()));
                }
                if (!iPSDEServiceAPI.isMajor()) continue;
                String strAppDataEntityCodeName = iPSAppDataEntity.getDEAPICodeName2();
                if (!StringUtils.hasLength((String)strAppDataEntityCodeName)) {
                    if (StringUtils.hasLength((String)iPSAppDataEntity.getDEAPICodeName())) {
                        strAppDataEntityCodeName = Inflector.getInstance().pluralize((Object)iPSAppDataEntity.getDEAPICodeName());
                    } else {
                        strAppDataEntityCodeName = iPSAppDataEntity.getCodeName2();
                        if (!StringUtils.hasLength((String)strAppDataEntityCodeName)) {
                            strAppDataEntityCodeName = Inflector.getInstance().pluralize((Object)iPSAppDataEntity.getCodeName());
                        }
                    }
                }
                strAppDataEntityCodeName = strAppDataEntityCodeName.toLowerCase();
                IPSDataEntity iPSDataEntity = iPSDEServiceAPI.getPSDataEntityMust();
                if ((iPSDataEntity.getStorageMode() & 4) == 4 && iPSDataEntity.getPSSubSysServiceAPI() != null && iPSDataEntity.getPSSubSysServiceAPIDE() != null && iPSDataEntity.getExtendMode() == 0 && StringUtils.hasLength((String)iPSDataEntity.getPSSubSysServiceAPI().getServicePath()) && iPSDataEntity.getPSSubSysServiceAPI().getServicePath().indexOf("lb://") == 0) {
                    objectNode3 = routesNode.addObject();
                    objectNode3.put("id", String.format("%1$s__%2$s", strAPIPrefix, iPSAppDataEntity.getCodeName().toLowerCase()));
                    String strServicePath = iPSDataEntity.getPSSubSysServiceAPI().getServicePath();
                    String strPrefixPath = "";
                    int nPos = strServicePath.indexOf("//");
                    if (nPos == -1) {
                        nPos = strServicePath.indexOf("/");
                        if (nPos != -1) {
                            strPrefixPath = strServicePath.substring(nPos);
                            strServicePath = strServicePath.substring(0, nPos);
                        }
                    } else if ((nPos = strServicePath.indexOf("/", nPos + 2)) != -1) {
                        strPrefixPath = strServicePath.substring(nPos);
                        strServicePath = strServicePath.substring(0, nPos);
                    }
                    objectNode3.put("uri", strServicePath);
                    objectNode3.put("order", 100);
                    ArrayNode predicatesNode3 = objectNode3.putArray("predicates");
                    predicatesNode3.add(String.format("Path=/%1$s/%2$s/**", strAPIPrefix, strAppDataEntityCodeName));
                    ArrayNode filtersNode3 = objectNode3.putArray("filters");
                    filtersNode3.add("StripPrefix=1");
                    if (!StringUtils.hasLength((String)strPrefixPath)) continue;
                    filtersNode3.add(String.format("PrefixPath=%1$s", strPrefixPath));
                    continue;
                }
                objectNode3 = routesNode.addObject();
                objectNode3.put("id", String.format("%1$s__%2$s", strAPIPrefix, iPSAppDataEntity.getCodeName().toLowerCase()));
                objectNode3.put("uri", String.format("lb://%1$s-%2$s", strServiceId, iPSAppDataEntity.getSysAPITag().toLowerCase()));
                objectNode3.put("order", 100);
                ArrayNode predicatesNode4 = objectNode3.putArray("predicates");
                predicatesNode4.add(String.format("Path=/%1$s/%2$s/**", strAPIPrefix, strAppDataEntityCodeName));
                ArrayNode filtersNode4 = objectNode3.putArray("filters");
                filtersNode4.add("StripPrefix=1");
                filtersNode4.add(String.format("PrefixPath=/%1$s/%2$s", strServiceId, iPSAppDataEntity.getSysAPITag().toLowerCase()));
            }
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("ibzemployees", "");
        map.put("sysemployees", "");
        map.put("ibzdepartments", "");
        map.put("sysdepartments", "");
        map.put("ibzorganizations", "");
        map.put("sysorganizations", "");
        String strOldOUServiceId = "ebsx-oldou";
        for (Map.Entry entry : map.entrySet()) {
            ObjectNode objectNode4 = routesNode.addObject();
            objectNode4.put("id", String.format("%1$s__oldou__%2$s", strAPIPrefix, entry.getKey()));
            objectNode4.put("uri", String.format("lb://%1$s", strOldOUServiceId));
            objectNode4.put("order", 120);
            ArrayNode predicatesNode5 = objectNode4.putArray("predicates");
            predicatesNode5.add(String.format("Path=/%1$s/%2$s/**", strAPIPrefix, entry.getKey()));
            ArrayNode filtersNode5 = objectNode4.putArray("filters");
            filtersNode5.add("StripPrefix=1");
            filtersNode5.add(String.format("PrefixPath=/ebsx/oldou", new Object[0]));
        }
        return gatewayNode;
    }

    protected static Map<String, IPSDEServiceAPI> getPSDEServiceAPIMap(IPSSystem iPSSystem) {
        List psSysServiceAPIs = iPSSystem.getAllPSSysServiceAPIs();
        if (ObjectUtils.isEmpty((Object)psSysServiceAPIs)) {
            return null;
        }
        HashMap<String, IPSDEServiceAPI> psDEServiceAPIMap = new HashMap<String, IPSDEServiceAPI>();
        for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIs) {
            List psDEServiceAPIs = iPSSysServiceAPI.getPSDEServiceAPIs();
            if (ObjectUtils.isEmpty((Object)psDEServiceAPIs)) continue;
            for (IPSDEServiceAPI iPSDEServiceAPI : psDEServiceAPIs) {
                psDEServiceAPIMap.put(String.format("%1$s-%2$s", iPSSysServiceAPI.getCodeName(), iPSDEServiceAPI.getName()).toLowerCase(), iPSDEServiceAPI);
            }
        }
        return psDEServiceAPIMap;
    }

    public static ObjectNode getPSModelToolAppGatewayNode(String strDeploySystemId, String strServiceId, IPSApplication iPSApplication) throws Exception {
        strServiceId = strServiceId.toLowerCase();
        String strAPIPrefix = String.format("%1$s__%2$s", strDeploySystemId, iPSApplication.getCodeName()).toLowerCase();
        ObjectNode gatewayNode = JsonUtils.createObjectNode();
        ArrayNode routesNode = gatewayNode.putArray("routes");
        ObjectNode objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_devops", strAPIPrefix));
        objectNode.put("uri", String.format("lb://servicehub-%1$s", strServiceId));
        objectNode.put("order", 60);
        ArrayNode predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/remotemodel/**", strAPIPrefix));
        ArrayNode filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=2");
        filtersNode.add(String.format("PrefixPath=/%2$s/extension/dynamodels/pssysapps/%1$s", iPSApplication.getCodeName(), strServiceId));
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_devops_jsonschema", strAPIPrefix));
        objectNode.put("uri", String.format("lb://servicehub-%1$s", strServiceId));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/jsonschema/**", strAPIPrefix));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=2");
        filtersNode.add(String.format("PrefixPath=/%2$s/extension/jsonschemas/pssysapps/%1$s", iPSApplication.getCodeName(), strServiceId));
        objectNode = routesNode.addObject();
        objectNode.put("id", String.format("%1$s__cloud_devops_dynamodelapi", strAPIPrefix));
        objectNode.put("uri", String.format("lb://servicehub-%1$s", strServiceId));
        objectNode.put("order", 60);
        predicatesNode = objectNode.putArray("predicates");
        predicatesNode.add(String.format("Path=/%1$s/**", strAPIPrefix));
        predicatesNode.add(String.format("Header=Srfsystemid,%1$s", strServiceId));
        filtersNode = objectNode.putArray("filters");
        filtersNode.add("StripPrefix=1");
        filtersNode.add(String.format("PrefixPath=/%1$s/extension/dynamodelapi", strServiceId));
        return gatewayNode;
    }

    public static ObjectNode appendAppGatewayNode(ObjectNode gatewayNode, ObjectNode gatewayNode2) throws Exception {
        JsonNode routesNode = gatewayNode.get("routes");
        JsonNode routesNode2 = gatewayNode2.get("routes");
        if (routesNode != null) {
            if (routesNode2 != null) {
                ArrayNode routesArrayNode = (ArrayNode)routesNode;
                ArrayNode routesArrayNode2 = (ArrayNode)routesNode2;
                routesArrayNode.addAll(routesArrayNode2);
            }
            return gatewayNode;
        }
        return gatewayNode2;
    }
}

