/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiOperation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIDocAdapter;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.cloud.core.util.RestUtils;
import net.ibizsys.central.dataentity.service.IDEServiceAPIRSRuntime;
import net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime;
import net.ibizsys.central.service.ISysServiceAPIRuntime;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.action.IPSDEActionInputDTO;
import net.ibizsys.model.dataentity.action.IPSDEActionReturn;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.ds.IPSDEDataSetReturn;
import net.ibizsys.model.dataentity.ds.IPSDEFilterDTO;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTOField;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIMethod;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.service.ParameterType;
import springfox.documentation.spring.web.scanners.ApiDocumentationScanner;

@Primary
@Component
public class DocumentationCache
extends springfox.documentation.spring.web.DocumentationCache
implements ISysServiceAPIDocAdapter,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(DocumentationCache.class);
    @Autowired
    private ApiDocumentationScanner apiDocumentationScanner = null;
    private Map<String, String> schemaMap = new HashMap<String, String>();
    private Map<Object, SysApiCache> sysApiCacheMap = new LinkedHashMap<Object, SysApiCache>();
    private GenericApplicationContext ctx = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof GenericApplicationContext) {
            this.ctx = (GenericApplicationContext)applicationContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMapping(IDEServiceAPIRuntime iDEServiceAPIRuntime, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, IPSDEServiceAPIMethod iPSDEServiceAPIMethod, String ... paths) {
        String description;
        String summary;
        String strSysTag = iDEServiceAPIRuntime.getSystemRuntime().getServiceId();
        String strApiTag = iDEServiceAPIRuntime.getSysServiceAPIRuntime().getPSSysServiceAPI().getServiceCodeName();
        SysApiCache sysApiCache = null;
        Map<Object, SysApiCache> map = this.sysApiCacheMap;
        synchronized (map) {
            sysApiCache = this.sysApiCacheMap.get(iDEServiceAPIRuntime.getSysServiceAPIRuntime());
            if (sysApiCache == null) {
                sysApiCache = new SysApiCache();
                this.sysApiCacheMap.put(iDEServiceAPIRuntime.getSysServiceAPIRuntime(), sysApiCache);
            }
        }
        String strTag = String.format("%1$s-%2$s-%3$s-controller", strSysTag, strApiTag, iDEServiceAPIRuntime.getPSDEServiceAPI().getCodeName()).toLowerCase();
        if (!sysApiCache.tagNodeMap.containsKey(strTag)) {
            String strApiDesc;
            String strSysDesc;
            String strDesc = iDEServiceAPIRuntime.getPSDEServiceAPI().getLogicName();
            if (!StringUtils.hasLength((String)strDesc)) {
                strDesc = iDEServiceAPIRuntime.getPSDEServiceAPI().getPSDataEntityMust().getLogicName();
            }
            if (!StringUtils.hasLength((String)(strSysDesc = iDEServiceAPIRuntime.getSystemRuntime().getPSSystem().getLogicName()))) {
                strSysDesc = strSysTag;
            }
            if (!StringUtils.hasLength((String)(strApiDesc = iDEServiceAPIRuntime.getSysServiceAPIRuntime().getPSSysServiceAPI().getName()))) {
                strApiDesc = strApiTag;
            }
            strDesc = String.format("%1$s[%2$s] - %3$s", strSysDesc, strApiDesc, strDesc);
            ObjectNode tagNode = JsonUtils.createObjectNode();
            tagNode.put("name", strTag);
            tagNode.put("description", strDesc);
            sysApiCache.tagNodeMap.put(strTag, tagNode);
        }
        if (!StringUtils.hasLength((String)(summary = iPSDEServiceAPIMethod.getLogicName()))) {
            if (iPSDEServiceAPIMethod.getPSDEAction() != null) {
                summary = iPSDEServiceAPIMethod.getPSDEAction().getLogicName();
            } else if (iPSDEServiceAPIMethod.getPSDEDataSet() != null) {
                summary = iPSDEServiceAPIMethod.getPSDEDataSet().getLogicName();
            }
        }
        if (!StringUtils.hasLength((String)(description = iPSDEServiceAPIMethod.getMemo()))) {
            if (iPSDEServiceAPIMethod.getPSDEAction() != null) {
                description = iPSDEServiceAPIMethod.getPSDEAction().getMemo();
            } else if (iPSDEServiceAPIMethod.getPSDEDataSet() != null) {
                description = iPSDEServiceAPIMethod.getPSDEDataSet().getMemo();
            }
        }
        for (int i = 0; i < paths.length; ++i) {
            String strType;
            IPSDEMethodDTO iPSDEMethodDTO;
            String path = paths[i];
            ObjectNode pathNode = sysApiCache.pathNodeMap.get(path);
            if (pathNode == null) {
                pathNode = JsonUtils.createObjectNode();
                sysApiCache.pathNodeMap.put(path, pathNode);
            }
            ObjectNode operationNode = pathNode.putObject(iPSDEServiceAPIMethod.getRequestMethod().toLowerCase());
            ArrayNode tagsNode = operationNode.putArray("tags");
            tagsNode.add(strTag);
            String uniqueId = iPSDEServiceAPIMethod.getCodeName();
            if (!StringUtils.hasLength((String)uniqueId) && iPSDEServiceAPIMethod.getPSDEAction() != null) {
                uniqueId = iPSDEServiceAPIMethod.getPSDEAction().getCodeName();
            }
            if (iDEServiceAPIRSRuntime != null) {
                uniqueId = String.format("%1$s__%2$s__%3$s", iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getPSDEServiceAPI().getCodeName(), uniqueId, i);
            }
            operationNode.put("operationId", uniqueId);
            operationNode.put("summary", summary);
            ArrayNode parametersNode = this.getParametersNode(iDEServiceAPIRuntime, iDEServiceAPIRSRuntime, iPSDEServiceAPIMethod);
            operationNode.put("parameters", (JsonNode)parametersNode);
            if (iPSDEServiceAPIMethod.getPSDEServiceAPIMethodInput() != null && (iPSDEMethodDTO = iPSDEServiceAPIMethod.getPSDEServiceAPIMethodInput().getPSDEMethodDTO()) != null) {
                String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, iDEServiceAPIRuntime.getPSDEServiceAPI().getPSDataEntityMust(), iPSDEMethodDTO);
                ObjectNode requestBodyNode = operationNode.putObject("requestBody");
                ObjectNode contentNode = requestBodyNode.putObject("content");
                ObjectNode jsonNode = contentNode.putObject("application/json");
                ObjectNode schemaNode = jsonNode.putObject("schema");
                schemaNode.put("$ref", strRefTag);
            }
            ObjectNode responsesNode = operationNode.putObject("responses");
            ObjectNode okNode = responsesNode.putObject("200");
            okNode.put("description", "OK");
            if (iPSDEServiceAPIMethod.getPSDEServiceAPIMethodReturn() == null || "VOID".equals(strType = iPSDEServiceAPIMethod.getPSDEServiceAPIMethodReturn().getType())) continue;
            ObjectNode schemaNode = okNode.putObject("content").putObject("*/*").putObject("schema");
            IPSDEMethodDTO iPSDEMethodDTO2 = iPSDEServiceAPIMethod.getPSDEServiceAPIMethodReturn().getPSDEMethodDTO();
            if (iPSDEMethodDTO2 != null) {
                String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, iDEServiceAPIRuntime.getPSDEServiceAPI().getPSDataEntityMust(), iPSDEMethodDTO2);
                if ("DTOS".equals(strType) || "PAGE".equals(strType)) {
                    schemaNode.put("type", "array");
                    ObjectNode itemsNode = schemaNode.putObject("items");
                    itemsNode.put("$ref", strRefTag);
                    continue;
                }
                schemaNode.put("$ref", strRefTag);
                continue;
            }
            if ("SIMPLES".equals(strType)) {
                schemaNode.put("type", "array");
                ObjectNode itemsNode = schemaNode.putObject("items");
                itemsNode.put("type", this.getSimpleJSType(iPSDEServiceAPIMethod.getPSDEServiceAPIMethodReturn().getStdDataType()));
                continue;
            }
            schemaNode.put("type", this.getSimpleJSType(iPSDEServiceAPIMethod.getPSDEServiceAPIMethodReturn().getStdDataType()));
        }
    }

    protected ArrayNode getParametersNode(IDEServiceAPIRuntime iDEServiceAPIRuntime, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, IPSDEServiceAPIMethod iPSDEServiceAPIMethod) {
        ObjectNode schemaNode;
        ObjectNode parameterNode;
        ArrayNode parametersNode = JsonUtils.createArrayNode();
        if (iDEServiceAPIRSRuntime != null) {
            parameterNode = parametersNode.addObject();
            parameterNode.put("name", "pkey");
            parameterNode.put("in", ParameterType.PATH.getIn());
            parameterNode.put("description", "\u7236\u952e\u503c");
            parameterNode.put("required", true);
            schemaNode = parameterNode.putObject("schema");
            schemaNode.put("type", "string");
        }
        if (iPSDEServiceAPIMethod.isNeedResourceKey()) {
            parameterNode = parametersNode.addObject();
            parameterNode.put("name", "key");
            parameterNode.put("in", ParameterType.PATH.getIn());
            parameterNode.put("description", "\u952e\u503c");
            parameterNode.put("required", true);
            schemaNode = parameterNode.putObject("schema");
            schemaNode.put("type", "string");
        }
        return parametersNode;
    }

    protected ArrayNode getParametersNode(ISysServiceAPIRuntime iSysServiceAPIRuntime, IPSDataEntity iPSDataEntity, Object model) {
        IPSDEAction iPSDEAction;
        ArrayNode parametersNode = JsonUtils.createArrayNode();
        if (model instanceof IPSDEAction && ("READ".equals((iPSDEAction = (IPSDEAction)model).getActionMode()) || "DELETE".equals(iPSDEAction.getActionMode()))) {
            ObjectNode parameterNode = parametersNode.addObject();
            parameterNode.put("name", "key");
            parameterNode.put("in", ParameterType.PATH.getIn());
            parameterNode.put("description", "\u952e\u503c");
            parameterNode.put("required", true);
            ObjectNode schemaNode = parameterNode.putObject("schema");
            schemaNode.put("type", "string");
        }
        return parametersNode;
    }

    protected ArrayNode getParametersNode(ISysServiceAPIRuntime iSysServiceAPIRuntime, Object handler, Method action) {
        ArrayNode parametersNode = JsonUtils.createArrayNode();
        Annotation[][] annotations = action.getParameterAnnotations();
        int nParamCount = action.getParameterCount();
        for (int i = 0; i < nParamCount; ++i) {
            ObjectNode schemaNode;
            ObjectNode parameterNode;
            if (annotations[i].length == 0) continue;
            Parameter parameter = action.getParameters()[i];
            Annotation annotation = annotations[i][0];
            if (annotation instanceof RequestHeader) {
                RequestHeader requestHeader = (RequestHeader)annotation;
                parameterNode = parametersNode.addObject();
                if (StringUtils.hasLength((String)requestHeader.name())) {
                    parameterNode.put("name", requestHeader.name());
                } else {
                    parameterNode.put("name", requestHeader.value());
                }
                parameterNode.put("in", ParameterType.HEADER.getIn());
                parameterNode.put("required", requestHeader.required());
                schemaNode = parameterNode.putObject("schema");
                this.fillJsonSchemaNode(schemaNode, iSysServiceAPIRuntime, handler, action, parameter);
                continue;
            }
            if (annotation instanceof PathVariable) {
                PathVariable pathVariable = (PathVariable)annotation;
                parameterNode = parametersNode.addObject();
                if (StringUtils.hasLength((String)pathVariable.name())) {
                    parameterNode.put("name", pathVariable.name());
                } else {
                    parameterNode.put("name", pathVariable.value());
                }
                parameterNode.put("in", ParameterType.PATH.getIn());
                parameterNode.put("required", pathVariable.required());
                schemaNode = parameterNode.putObject("schema");
                this.fillJsonSchemaNode(schemaNode, iSysServiceAPIRuntime, handler, action, parameter);
                continue;
            }
            if (annotation instanceof RequestParam) {
                RequestParam requestParam = (RequestParam)annotation;
                parameterNode = parametersNode.addObject();
                if (StringUtils.hasLength((String)requestParam.name())) {
                    parameterNode.put("name", requestParam.name());
                } else {
                    parameterNode.put("name", requestParam.value());
                }
                parameterNode.put("in", ParameterType.QUERY.getIn());
                parameterNode.put("required", requestParam.required());
                schemaNode = parameterNode.putObject("schema");
                this.fillJsonSchemaNode(schemaNode, iSysServiceAPIRuntime, handler, action, parameter);
                continue;
            }
            if (annotation instanceof RequestBody) {
                RequestBody requestBody = (RequestBody)annotation;
                parameterNode = parametersNode.addObject();
                parameterNode.put("in", ParameterType.BODY.getIn());
                parameterNode.put("required", requestBody.required());
                schemaNode = parameterNode.putObject("schema");
                this.fillJsonSchemaNode(schemaNode, iSysServiceAPIRuntime, handler, action, parameter);
                continue;
            }
            log.warn((Object)String.format("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u6ce8\u89e3[%1$s]", annotation));
        }
        return parametersNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillJsonSchemaNode(ObjectNode schemaNode, ISysServiceAPIRuntime iSysServiceAPIRuntime, Object handler, Method action, Parameter parameter) {
        String strSysTag = iSysServiceAPIRuntime.getSystemRuntime().getServiceId();
        String strApiTag = iSysServiceAPIRuntime.getPSSysServiceAPI().getServiceCodeName();
        SysApiCache sysApiCache = null;
        Map<Object, SysApiCache> map = this.sysApiCacheMap;
        synchronized (map) {
            sysApiCache = this.sysApiCacheMap.get(iSysServiceAPIRuntime);
            if (sysApiCache == null) {
                sysApiCache = new SysApiCache();
                this.sysApiCacheMap.put(iSysServiceAPIRuntime, sysApiCache);
            }
        }
        if (parameter.getType().isArray() || List.class.isAssignableFrom(parameter.getType())) {
            schemaNode.put("type", "array");
            ObjectNode itemsNode = schemaNode.putObject("items");
            if (parameter.getType().isArray()) {
                if (this.isSimpleJSType(parameter.getType().getComponentType())) {
                    itemsNode.put("type", this.getSimpleJSType(parameter.getType().getComponentType()));
                } else {
                    String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, parameter.getType().getComponentType());
                    itemsNode.put("$ref", strRefTag);
                }
            } else {
                Type[] actualTypeArguments;
                Class itemCls = null;
                Type genericReturnType = parameter.getParameterizedType();
                if (genericReturnType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments()) != null && actualTypeArguments.length != 0) {
                    Type type = actualTypeArguments[0];
                    if (type instanceof Class) {
                        itemCls = (Class)type;
                    } else if (type instanceof WildcardType) {
                        WildcardType wildcardType = (WildcardType)type;
                        itemCls = (Class)wildcardType.getUpperBounds()[0];
                    }
                }
                if (itemCls == null) {
                    itemsNode.put("type", "object");
                } else if (this.isSimpleJSType(itemCls)) {
                    itemsNode.put("type", this.getSimpleJSType(itemCls));
                } else {
                    String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, itemCls);
                    itemsNode.put("$ref", strRefTag);
                }
            }
        } else if (this.isSimpleJSType(parameter.getType())) {
            schemaNode.put("type", this.getSimpleJSType(parameter.getType()));
        } else {
            String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, parameter.getType());
            schemaNode.put("$ref", strRefTag);
        }
    }

    protected String getJsonSchemaRefId(SysApiCache sysApiCache, String strSysTag, String strApiTag, IPSDataEntity iPSDataEntity, IPSDEMethodDTO iPSDEMethodDTO) {
        if (iPSDataEntity == null || iPSDEMethodDTO == null) {
            return null;
        }
        String strJsonSchemaTag = String.format("%1$s__%2$s__%3$s", strSysTag, iPSDataEntity.getName().toLowerCase(), iPSDEMethodDTO.getName());
        if (!sysApiCache.componentNodeMap.containsKey(strJsonSchemaTag)) {
            Object object;
            ObjectNode schemaNode = JsonUtils.createObjectNode();
            sysApiCache.componentNodeMap.put(strJsonSchemaTag, schemaNode);
            schemaNode.put("type", "object");
            ObjectNode propertiesNode = schemaNode.putObject("properties");
            List psDEMethodDTOFieldList = iPSDEMethodDTO.getPSDEMethodDTOFields();
            if (iPSDEMethodDTO instanceof IPSDEActionInputDTO) {
                object = (IPSDEActionInputDTO)iPSDEMethodDTO;
            } else if (iPSDEMethodDTO instanceof IPSDEFilterDTO) {
                object = (IPSDEFilterDTO)iPSDEMethodDTO;
            }
            if (!ObjectUtils.isEmpty((Object)psDEMethodDTOFieldList)) {
                for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
                    ObjectNode itemsNode;
                    ObjectNode propertyNode = propertiesNode.putObject(iPSDEMethodDTOField.getName().toLowerCase());
                    propertyNode.put("description", iPSDEMethodDTOField.getLogicName());
                    String strFieldType = iPSDEMethodDTOField.getType();
                    if ("DTO".equals(strFieldType)) {
                        String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, iPSDEMethodDTOField.getRefPSDataEntity(), iPSDEMethodDTOField.getRefPSDEMethodDTO());
                        if (StringUtils.hasLength((String)strRefTag)) {
                            propertyNode.put("$ref", strRefTag);
                            continue;
                        }
                        propertyNode.put("type", "object");
                        continue;
                    }
                    if ("DTOS".equals(strFieldType)) {
                        propertyNode.put("type", "array");
                        itemsNode = propertyNode.putObject("items");
                        String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, iPSDEMethodDTOField.getRefPSDataEntity(), iPSDEMethodDTOField.getRefPSDEMethodDTO());
                        if (StringUtils.hasLength((String)strRefTag)) {
                            itemsNode.put("$ref", strRefTag);
                            continue;
                        }
                        itemsNode.put("type", "object");
                        continue;
                    }
                    if ("SIMPLES".equals(strFieldType)) {
                        propertyNode.put("type", "array");
                        itemsNode = propertyNode.putObject("items");
                        itemsNode.put("type", this.getSimpleJSType(iPSDEMethodDTOField.getStdDataType()));
                        continue;
                    }
                    propertyNode.put("type", this.getSimpleJSType(iPSDEMethodDTOField.getStdDataType()));
                }
            }
        }
        return String.format("#/components/schemas/%1$s__%2$s__%3$s", strSysTag, iPSDataEntity.getName().toLowerCase(), iPSDEMethodDTO.getName());
    }

    protected String getJsonSchemaRefId(SysApiCache sysApiCache, String strSysTag, String strApiTag, Class<?> theClass) {
        String strJsonSchemaTag = String.format("%1$s__%2$s", strSysTag, theClass.getName().replace(".", "__").toLowerCase());
        if (!sysApiCache.componentNodeMap.containsKey(strJsonSchemaTag)) {
            ObjectNode schemaNode = JsonUtils.createObjectNode();
            sysApiCache.componentNodeMap.put(strJsonSchemaTag, schemaNode);
            schemaNode.put("type", "object");
            ObjectNode propertiesNode = schemaNode.putObject("properties");
            LinkedHashMap fieldMap = new LinkedHashMap();
            LinkedHashMap<String, Type> fieldMap2 = new LinkedHashMap<String, Type>();
            Field[] fields = theClass.getDeclaredFields();
            for (Field field : fields) {
                if (Modifier.isTransient(field.getModifiers()) || field.getName().indexOf("$") != -1) continue;
                fieldMap.put(field.getName(), field.getType());
                fieldMap2.put(field.getName(), field.getGenericType());
            }
            for (Map.Entry entry : fieldMap.entrySet()) {
                ObjectNode propertyNode = propertiesNode.putObject((String)entry.getKey());
                Class returnType = (Class)entry.getValue();
                if (returnType.isArray() || List.class.isAssignableFrom(returnType)) {
                    Type[] actualTypeArguments;
                    propertyNode.put("type", "array");
                    ObjectNode itemsNode = propertyNode.putObject("items");
                    if (returnType.isArray()) {
                        if (this.isSimpleJSType(returnType.getComponentType())) {
                            itemsNode.put("type", this.getSimpleJSType(returnType.getComponentType()));
                            continue;
                        }
                        String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, returnType.getComponentType());
                        itemsNode.put("$ref", strRefTag);
                        continue;
                    }
                    Class itemCls = null;
                    Type genericReturnType = (Type)fieldMap2.get(entry.getKey());
                    if (genericReturnType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments()) != null && actualTypeArguments.length != 0) {
                        Type type = actualTypeArguments[0];
                        if (type instanceof Class) {
                            itemCls = (Class)type;
                        } else if (type instanceof WildcardType) {
                            WildcardType wildcardType = (WildcardType)type;
                            itemCls = (Class)wildcardType.getUpperBounds()[0];
                        }
                    }
                    if (itemCls == null) {
                        itemsNode.put("type", "object");
                        continue;
                    }
                    if (this.isSimpleJSType(itemCls)) {
                        itemsNode.put("type", this.getSimpleJSType(itemCls));
                        continue;
                    }
                    String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, itemCls);
                    itemsNode.put("$ref", strRefTag);
                    continue;
                }
                if (this.isSimpleJSType(returnType)) {
                    propertyNode.put("type", this.getSimpleJSType(returnType));
                    continue;
                }
                String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, returnType);
                propertyNode.put("$ref", strRefTag);
            }
        }
        return String.format("#/components/schemas/%1$s__%2$s", strSysTag, theClass.getName().replace(".", "__").toLowerCase());
    }

    protected String getSimpleJSType(int nStdDataType) {
        if (DataTypeUtils.isStringDataType((int)nStdDataType)) {
            return "string";
        }
        if (DataTypeUtils.isIntDataType((int)nStdDataType)) {
            return "integer";
        }
        if (DataTypeUtils.isDateTimeDataType((int)nStdDataType)) {
            return "string";
        }
        if (DataTypeUtils.isDoubleDataType((int)nStdDataType)) {
            return "number";
        }
        return "string";
    }

    protected boolean isSimpleJSType(Class<?> type) {
        if (String.class.isAssignableFrom(type)) {
            return true;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return true;
        }
        if (Character.class.isAssignableFrom(type)) {
            return true;
        }
        if (Date.class.isAssignableFrom(type)) {
            return true;
        }
        if (Map.class.isAssignableFrom(type)) {
            return true;
        }
        return Object.class.equals(type);
    }

    protected String getSimpleJSType(Class<?> type) {
        if (String.class.isAssignableFrom(type)) {
            return "string";
        }
        if (Integer.class.isAssignableFrom(type)) {
            return "integer";
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return "integer";
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return "number";
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return "number";
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return "number";
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return "boolean";
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return "boolean";
        }
        if (Date.class.isAssignableFrom(type)) {
            return "string";
        }
        if (Number.class.isAssignableFrom(type)) {
            return "number";
        }
        if (Map.class.equals(type)) {
            return "object";
        }
        if (Object.class.equals(type)) {
            return "object";
        }
        return "string";
    }

    @Override
    public boolean outputOpenAPIDoc(HttpServletRequest request, HttpServletResponse response) {
        Object objGroup;
        String strQueryString = request.getQueryString();
        if (!StringUtils.hasLength((String)strQueryString)) {
            return true;
        }
        Map<String, Object> params = RestUtils.queryString2Map(strQueryString);
        if (!ObjectUtils.isEmpty(params) && (objGroup = params.get("group")) instanceof String && ((String)objGroup).equalsIgnoreCase("auto")) {
            this.outputOpenAPIDoc((String)objGroup, response);
            return false;
        }
        return true;
    }

    protected void outputOpenAPIDoc(String strType, HttpServletResponse response) {
        try {
            String strContent = this.schemaMap.get(strType);
            if (!StringUtils.hasLength((String)strContent)) {
                ObjectNode apiNode = JsonUtils.createObjectNode();
                apiNode.put("openapi", "3.0.3");
                ObjectNode infoNode = apiNode.putObject("info");
                infoNode.put("title", "\u81ea\u52a8\u670d\u52a1\u63a5\u53e3");
                infoNode.put("version", "1.0");
                ArrayNode serversNode = apiNode.putArray("servers");
                ObjectNode serverNode = serversNode.addObject();
                serverNode.put("url", ServiceHub.getInstance().getServiceUrl());
                ArrayNode tagsNode = apiNode.putArray("tags");
                ObjectNode pathsNode = apiNode.putObject("paths");
                ObjectNode componentsNode = apiNode.putObject("components");
                ObjectNode schemasNode = componentsNode.putObject("schemas");
                for (SysApiCache sysApiCache : this.sysApiCacheMap.values()) {
                    for (Map.Entry<String, ObjectNode> entry : sysApiCache.tagNodeMap.entrySet()) {
                        tagsNode.add((JsonNode)entry.getValue());
                    }
                    for (Map.Entry<String, ObjectNode> entry : sysApiCache.pathNodeMap.entrySet()) {
                        pathsNode.put(entry.getKey(), (JsonNode)entry.getValue());
                    }
                    for (Map.Entry<String, ObjectNode> entry : sysApiCache.componentNodeMap.entrySet()) {
                        schemasNode.put(entry.getKey(), (JsonNode)entry.getValue());
                    }
                }
                strContent = apiNode.toString();
                this.schemaMap.put(strType, strContent);
            }
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            response.setHeader("charset", "utf-8");
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(strContent);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void registerMapping(ISysServiceAPIRuntime iSysServiceAPIRuntime, String[] uris, RequestMethod[] methods, IPSDataEntity iPSDataEntity, IPSDEAction iPSDEAction) {
        this.doRegisterMapping(iSysServiceAPIRuntime, uris, methods, iPSDataEntity, iPSDEAction);
    }

    @Override
    public void registerMapping(ISysServiceAPIRuntime iSysServiceAPIRuntime, String[] uris, RequestMethod[] methods, IPSDataEntity iPSDataEntity, IPSDEDataSet iPSDEDataSet) {
        this.doRegisterMapping(iSysServiceAPIRuntime, uris, methods, iPSDataEntity, iPSDEDataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRegisterMapping(ISysServiceAPIRuntime iSysServiceAPIRuntime, String[] uris, RequestMethod[] methods, IPSDataEntity iPSDataEntity, Object model) {
        String strSysTag = iSysServiceAPIRuntime.getSystemRuntime().getServiceId();
        String strApiTag = iSysServiceAPIRuntime.getPSSysServiceAPI().getServiceCodeName();
        SysApiCache sysApiCache = null;
        Map<Object, SysApiCache> map = this.sysApiCacheMap;
        synchronized (map) {
            sysApiCache = this.sysApiCacheMap.get(iSysServiceAPIRuntime);
            if (sysApiCache == null) {
                sysApiCache = new SysApiCache();
                this.sysApiCacheMap.put(iSysServiceAPIRuntime, sysApiCache);
            }
        }
        String strTag = String.format("%1$s-%2$s-%3$s-controller", strSysTag, strApiTag, iPSDataEntity.getName()).toLowerCase();
        if (!sysApiCache.tagNodeMap.containsKey(strTag)) {
            String strApiDesc;
            String strDesc = iPSDataEntity.getLogicName();
            String strSysDesc = iSysServiceAPIRuntime.getSystemRuntime().getPSSystem().getLogicName();
            if (!StringUtils.hasLength((String)strSysDesc)) {
                strSysDesc = strSysTag;
            }
            if (!StringUtils.hasLength((String)(strApiDesc = iSysServiceAPIRuntime.getPSSysServiceAPI().getName()))) {
                strApiDesc = strApiTag;
            }
            strDesc = String.format("%1$s[%2$s] - %3$s", strSysDesc, strApiDesc, strDesc);
            ObjectNode tagNode = JsonUtils.createObjectNode();
            tagNode.put("name", strTag);
            tagNode.put("description", strDesc);
            sysApiCache.tagNodeMap.put(strTag, tagNode);
        }
        IPSDEAction iPSDEAction = null;
        IPSDEDataSet iPSDEDataSet = null;
        if (model instanceof IPSDEAction) {
            iPSDEAction = (IPSDEAction)model;
        } else if (model instanceof IPSDEDataSet) {
            iPSDEDataSet = (IPSDEDataSet)model;
        } else {
            log.error((Object)String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6a21\u578b\u5bf9\u8c61[%1$s]", model));
            return;
        }
        String summary = null;
        if (iPSDEAction != null) {
            summary = iPSDEAction.getLogicName();
        } else if (iPSDEDataSet != null) {
            summary = iPSDEDataSet.getLogicName();
        }
        String description = null;
        if (iPSDEAction != null) {
            description = iPSDEAction.getMemo();
        } else if (iPSDEDataSet != null) {
            description = iPSDEDataSet.getMemo();
        }
        for (int i = 0; i < uris.length; ++i) {
            String path = uris[i];
            ObjectNode pathNode = sysApiCache.pathNodeMap.get(path);
            if (pathNode == null) {
                pathNode = JsonUtils.createObjectNode();
                sysApiCache.pathNodeMap.put(path, pathNode);
            }
            for (RequestMethod method : methods) {
                String codeNameFormat;
                String codeName;
                ObjectNode operationNode = pathNode.putObject(method.name().toLowerCase());
                ArrayNode tagsNode = operationNode.putArray("tags");
                tagsNode.add(strTag);
                String uniqueId = null;
                if (iPSDEAction != null) {
                    codeName = iPSDEAction.getCodeName();
                    codeNameFormat = iSysServiceAPIRuntime.getSystemRuntime().getSystemRuntimeSetting().getDEActionCodeNameFormat();
                    if (StringUtils.hasLength((String)codeNameFormat)) {
                        codeName = String.format(codeNameFormat, codeName);
                    }
                    uniqueId = codeName;
                } else if (iPSDEDataSet != null) {
                    codeName = iPSDEDataSet.getCodeName();
                    codeNameFormat = iSysServiceAPIRuntime.getSystemRuntime().getSystemRuntimeSetting().getDEDataSetCodeNameFormat();
                    if (StringUtils.hasLength((String)codeNameFormat)) {
                        codeName = String.format(codeNameFormat, codeName);
                    }
                    uniqueId = codeName;
                }
                operationNode.put("operationId", uniqueId);
                operationNode.put("summary", summary);
                ArrayNode parametersNode = this.getParametersNode(iSysServiceAPIRuntime, iPSDataEntity, model);
                operationNode.put("parameters", (JsonNode)parametersNode);
                IPSDEMethodDTO iPSDEMethodDTO = null;
                if (iPSDEAction != null) {
                    if (iPSDEAction.getPSDEActionInput() != null) {
                        iPSDEMethodDTO = iPSDEAction.getPSDEActionInput().getPSDEMethodDTO();
                    }
                } else if (iPSDEDataSet != null && iPSDEDataSet.getPSDEDataSetInput() != null) {
                    iPSDEMethodDTO = iPSDEDataSet.getPSDEDataSetInput().getPSDEFilterDTO();
                }
                if (iPSDEMethodDTO != null) {
                    String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, iPSDataEntity, iPSDEMethodDTO);
                    ObjectNode requestBodyNode = operationNode.putObject("requestBody");
                    ObjectNode contentNode = requestBodyNode.putObject("content");
                    ObjectNode jsonNode = contentNode.putObject("application/json");
                    ObjectNode schemaNode = jsonNode.putObject("schema");
                    schemaNode.put("$ref", strRefTag);
                }
                ObjectNode responsesNode = operationNode.putObject("responses");
                ObjectNode okNode = responsesNode.putObject("200");
                okNode.put("description", "OK");
                IPSDEActionReturn iPSDEMethodReturn = null;
                if (iPSDEAction != null) {
                    iPSDEMethodReturn = iPSDEAction.getPSDEActionReturn();
                } else if (iPSDEDataSet != null) {
                    iPSDEMethodReturn = iPSDEDataSet.getPSDEDataSetReturn();
                }
                String strType = iPSDEMethodReturn.getType();
                if ("VOID".equals(strType)) continue;
                ObjectNode schemaNode = okNode.putObject("content").putObject("*/*").putObject("schema");
                IPSDEMethodDTO iPSDEMethodDTO2 = null;
                int nStdDataType = 0;
                if (iPSDEMethodReturn instanceof IPSDEActionReturn) {
                    iPSDEMethodDTO2 = iPSDEMethodReturn.getPSDEMethodDTO();
                    nStdDataType = iPSDEMethodReturn.getStdDataType();
                } else if (iPSDEMethodReturn instanceof IPSDEDataSetReturn) {
                    iPSDEMethodDTO2 = ((IPSDEDataSetReturn)iPSDEMethodReturn).getPSDEMethodDTO();
                }
                if (iPSDEMethodDTO2 != null) {
                    String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, iPSDataEntity, iPSDEMethodDTO2);
                    if ("DTOS".equals(strType) || "PAGE".equals(strType)) {
                        schemaNode.put("type", "array");
                        ObjectNode itemsNode = schemaNode.putObject("items");
                        itemsNode.put("$ref", strRefTag);
                        continue;
                    }
                    schemaNode.put("$ref", strRefTag);
                    continue;
                }
                if ("SIMPLES".equals(strType)) {
                    schemaNode.put("type", "array");
                    ObjectNode itemsNode = schemaNode.putObject("items");
                    itemsNode.put("type", this.getSimpleJSType(nStdDataType));
                    continue;
                }
                schemaNode.put("type", this.getSimpleJSType(nStdDataType));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMapping(ISysServiceAPIRuntime iSysServiceAPIRuntime, String[] uris, RequestMethod[] methods, Object handler, Method action) {
        String strSysTag = iSysServiceAPIRuntime.getSystemRuntime().getServiceId();
        String strApiTag = iSysServiceAPIRuntime.getPSSysServiceAPI().getServiceCodeName();
        SysApiCache sysApiCache = null;
        Map<Object, SysApiCache> map = this.sysApiCacheMap;
        synchronized (map) {
            sysApiCache = this.sysApiCacheMap.get(iSysServiceAPIRuntime);
            if (sysApiCache == null) {
                sysApiCache = new SysApiCache();
                this.sysApiCacheMap.put(iSysServiceAPIRuntime, sysApiCache);
            }
        }
        String strTag = String.format("%1$s-%2$s-controller", strSysTag, strApiTag).toLowerCase();
        if (!sysApiCache.tagNodeMap.containsKey(strTag)) {
            String strApiDesc;
            String strDesc = null;
            String strSysDesc = iSysServiceAPIRuntime.getSystemRuntime().getPSSystem().getLogicName();
            if (!StringUtils.hasLength((String)strSysDesc)) {
                strSysDesc = strSysTag;
            }
            if (!StringUtils.hasLength((String)(strApiDesc = iSysServiceAPIRuntime.getPSSysServiceAPI().getName()))) {
                strApiDesc = strApiTag;
            }
            strDesc = String.format("%1$s[%2$s]", strSysDesc, strApiDesc);
            ObjectNode tagNode = JsonUtils.createObjectNode();
            tagNode.put("name", strTag);
            tagNode.put("description", strDesc);
            sysApiCache.tagNodeMap.put(strTag, tagNode);
        }
        String summary = null;
        ApiOperation apiOperation = action.getAnnotation(ApiOperation.class);
        if (apiOperation != null && !StringUtils.hasLength((String)(summary = apiOperation.notes()))) {
            summary = apiOperation.value();
        }
        for (int i = 0; i < uris.length; ++i) {
            String path = uris[i];
            ObjectNode pathNode = sysApiCache.pathNodeMap.get(path);
            if (pathNode == null) {
                pathNode = JsonUtils.createObjectNode();
                sysApiCache.pathNodeMap.put(path, pathNode);
            }
            for (RequestMethod method : methods) {
                ObjectNode operationNode = pathNode.putObject(method.name().toLowerCase());
                ArrayNode tagsNode = operationNode.putArray("tags");
                tagsNode.add(strTag);
                String uniqueId = action.getName();
                operationNode.put("operationId", uniqueId);
                operationNode.put("summary", summary);
                ArrayNode parametersNode = this.getParametersNode(iSysServiceAPIRuntime, handler, action);
                operationNode.put("parameters", (JsonNode)parametersNode);
                ObjectNode responsesNode = operationNode.putObject("responses");
                ObjectNode okNode = responsesNode.putObject("200");
                okNode.put("description", "OK");
                Class<?> returnType = action.getReturnType();
                if (returnType == null || returnType.getName().equals("void")) continue;
                ObjectNode schemaNode = okNode.putObject("content").putObject("*/*").putObject("schema");
                if (returnType.isArray() || List.class.isAssignableFrom(returnType) || Page.class.isAssignableFrom(returnType)) {
                    Type[] actualTypeArguments;
                    schemaNode.put("type", "array");
                    ObjectNode itemsNode = schemaNode.putObject("items");
                    if (returnType.isArray()) {
                        if (this.isSimpleJSType(returnType.getComponentType())) {
                            itemsNode.put("type", this.getSimpleJSType(returnType.getComponentType()));
                            continue;
                        }
                        String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, returnType.getComponentType());
                        itemsNode.put("$ref", strRefTag);
                        continue;
                    }
                    Class itemCls = null;
                    Type genericReturnType = action.getGenericReturnType();
                    if (genericReturnType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments()) != null && actualTypeArguments.length != 0) {
                        Type type = actualTypeArguments[0];
                        if (type instanceof Class) {
                            itemCls = (Class)type;
                        } else if (type instanceof WildcardType) {
                            WildcardType wildcardType = (WildcardType)type;
                            itemCls = (Class)wildcardType.getUpperBounds()[0];
                        }
                    }
                    if (itemCls == null) {
                        itemsNode.put("type", "object");
                        continue;
                    }
                    if (this.isSimpleJSType(itemCls)) {
                        itemsNode.put("type", this.getSimpleJSType(itemCls));
                        continue;
                    }
                    String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, itemCls);
                    itemsNode.put("$ref", strRefTag);
                    continue;
                }
                if (this.isSimpleJSType(returnType)) {
                    schemaNode.put("type", this.getSimpleJSType(returnType));
                    continue;
                }
                String strRefTag = this.getJsonSchemaRefId(sysApiCache, strSysTag, strApiTag, returnType);
                schemaNode.put("$ref", strRefTag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMapping(ISysServiceAPIRuntime iSysServiceAPIRuntime) {
        Map<Object, SysApiCache> map = this.sysApiCacheMap;
        synchronized (map) {
            this.sysApiCacheMap.remove(iSysServiceAPIRuntime);
            this.schemaMap.clear();
        }
    }

    private class SysApiCache {
        public Map<String, ObjectNode> tagNodeMap = new TreeMap<String, ObjectNode>();
        public Map<String, ObjectNode> componentNodeMap = new LinkedHashMap<String, ObjectNode>();
        public Map<String, ObjectNode> pathNodeMap = new LinkedHashMap<String, ObjectNode>();

        private SysApiCache() {
        }
    }
}

