/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.rt.util;

import javax.annotation.PostConstruct;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.ITransactionalUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
public class TransactionalUtil
implements ITransactionalUtil {
    @Autowired
    PlatformTransactionManager platformTransactionManager;
    private static final DefaultTransactionDefinition TRANSACTIONDEFINITION_MANDATORY = new DefaultTransactionDefinition(2);
    private static final DefaultTransactionDefinition TRANSACTIONDEFINITION_NESTED = new DefaultTransactionDefinition(6);
    private static final DefaultTransactionDefinition TRANSACTIONDEFINITION_NEVER = new DefaultTransactionDefinition(5);
    private static final DefaultTransactionDefinition TRANSACTIONDEFINITION_NOT_SUPPORTED = new DefaultTransactionDefinition(4);
    private static final DefaultTransactionDefinition TRANSACTIONDEFINITION_REQUIRED = new DefaultTransactionDefinition(0);
    private static final DefaultTransactionDefinition TRANSACTIONDEFINITION_REQUIRED_NEW = new DefaultTransactionDefinition(3);
    private static final DefaultTransactionDefinition TRANSACTIONDEFINITION_SUPPORTS = new DefaultTransactionDefinition(1);

    @PostConstruct
    public void postConstruct() {
        ActionSessionManager.setTransactionalUtil((ITransactionalUtil)this);
    }

    public Object mandatory(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.platformTransactionManager.getTransaction((TransactionDefinition)TRANSACTIONDEFINITION_MANDATORY);
            Object obj = iAction.execute(args);
            this.platformTransactionManager.commit(transactionStatus);
            return obj;
        }
        catch (Throwable e) {
            if (transactionStatus != null) {
                this.platformTransactionManager.rollback(transactionStatus);
            }
            throw e;
        }
    }

    public Object nested(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.platformTransactionManager.getTransaction((TransactionDefinition)TRANSACTIONDEFINITION_NESTED);
            Object obj = iAction.execute(args);
            this.platformTransactionManager.commit(transactionStatus);
            return obj;
        }
        catch (Throwable e) {
            if (transactionStatus != null) {
                this.platformTransactionManager.rollback(transactionStatus);
            }
            throw e;
        }
    }

    public Object never(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.platformTransactionManager.getTransaction((TransactionDefinition)TRANSACTIONDEFINITION_NEVER);
            Object obj = iAction.execute(args);
            this.platformTransactionManager.commit(transactionStatus);
            return obj;
        }
        catch (Throwable e) {
            if (transactionStatus != null) {
                this.platformTransactionManager.rollback(transactionStatus);
            }
            throw e;
        }
    }

    public Object not_supported(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.platformTransactionManager.getTransaction((TransactionDefinition)TRANSACTIONDEFINITION_NOT_SUPPORTED);
            Object obj = iAction.execute(args);
            this.platformTransactionManager.commit(transactionStatus);
            return obj;
        }
        catch (Throwable e) {
            if (transactionStatus != null) {
                this.platformTransactionManager.rollback(transactionStatus);
            }
            throw e;
        }
    }

    public Object required(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.platformTransactionManager.getTransaction((TransactionDefinition)TRANSACTIONDEFINITION_REQUIRED);
            Object obj = iAction.execute(args);
            this.platformTransactionManager.commit(transactionStatus);
            return obj;
        }
        catch (Throwable e) {
            if (transactionStatus != null) {
                this.platformTransactionManager.rollback(transactionStatus);
            }
            throw e;
        }
    }

    public Object required_new(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.platformTransactionManager.getTransaction((TransactionDefinition)TRANSACTIONDEFINITION_REQUIRED_NEW);
            Object obj = iAction.execute(args);
            this.platformTransactionManager.commit(transactionStatus);
            return obj;
        }
        catch (Throwable e) {
            if (transactionStatus != null) {
                this.platformTransactionManager.rollback(transactionStatus);
            }
            throw e;
        }
    }

    public Object supports(IAction iAction, Object[] args) throws Throwable {
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.platformTransactionManager.getTransaction((TransactionDefinition)TRANSACTIONDEFINITION_SUPPORTS);
            Object obj = iAction.execute(args);
            this.platformTransactionManager.commit(transactionStatus);
            return obj;
        }
        catch (Throwable e) {
            if (transactionStatus != null) {
                this.platformTransactionManager.rollback(transactionStatus);
            }
            throw e;
        }
    }

    public void commit() throws Throwable {
    }

    public void rollback() throws Throwable {
    }
}

