/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.rt;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import javax.annotation.PostConstruct;
import net.ibizsys.central.cloud.core.IServiceHubSetting;
import net.ibizsys.central.cloud.core.ServiceHubBase;
import net.ibizsys.central.cloud.core.database.ISysDBSchemeSyncAdapter;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIDocAdapter;
import net.ibizsys.central.cloud.core.util.domain.DataSource;
import net.ibizsys.runtime.util.DBTypes;
import net.ibizsys.runtime.util.EntityUtils;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component(value="ServiceHub")
public class ServiceHub
extends ServiceHubBase
implements ApplicationContextAware,
ApplicationRunner {
    private static final Log log = LogFactory.getLog(ServiceHub.class);
    @Autowired
    IServiceHubSetting iServiceHubSetting;
    @Autowired
    RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired(required=false)
    ISysServiceAPIDocAdapter sysServiceAPIDocAdapter = null;
    @Autowired(required=false)
    ISysDBSchemeSyncAdapter sysDBSchemeSyncAdapter = null;
    @Autowired
    NacosDiscoveryProperties nacosDiscoveryProperties;
    @Autowired
    ServerProperties serverProperties;
    @Autowired(required=false)
    javax.sql.DataSource dataSource = null;
    private ConfigurableApplicationContext ctx;

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = (ConfigurableApplicationContext)ctx;
    }

    @PostConstruct
    public void postConstruct() {
        this.setServiceHubSetting(this.iServiceHubSetting);
        this.setDefaultDataSource(this.dataSource);
        this.setRequestMappingHandlerMapping(this.requestMappingHandlerMapping);
        this.setSysServiceAPIDocAdapter(this.sysServiceAPIDocAdapter);
        this.setSysDBSchemeSyncAdapter(this.sysDBSchemeSyncAdapter);
        this.onPostConstruct();
    }

    @Override
    protected javax.sql.DataSource registerDataSource(DataSource ds) throws Exception {
        String strDriverClassName;
        HikariDataSource dataSource = new HikariDataSource();
        EntityUtils.copyTo((IEntity)ds, (Object)dataSource);
        if (!StringUtils.hasLength((String)dataSource.getPoolName())) {
            dataSource.setPoolName(ds.getDataSourceId());
        }
        if (StringUtils.hasLength((String)ds.getDriverClassName())) {
            dataSource.setDriverClassName(ds.getDriverClassName());
        } else if (StringUtils.hasLength((String)ds.getDBType()) && StringUtils.hasLength((String)(strDriverClassName = DBTypes.getDriverClassName((String)ds.getDBType())))) {
            log.debug((Object)String.format("\u6570\u636e\u6e90[%1$s]\u7c7b\u578b[%2$s]\u5339\u914d\u9a71\u52a8[%3$s]", ds.getDataSourceId(), ds.getDBType(), strDriverClassName));
            dataSource.setDriverClassName(strDriverClassName);
        }
        dataSource.setJdbcUrl(ds.getJdbcUrl());
        dataSource.setUsername(ds.getUsername());
        dataSource.setPassword(ds.getPassword());
        Connection connection = dataSource.getConnection();
        this.ctx.getBeanFactory().registerSingleton("dynadatasource_" + ds.getDataSourceId(), (Object)dataSource);
        try {
            connection.close();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        this.setDataSource(ds.getDataSourceId(), (javax.sql.DataSource)dataSource);
        return dataSource;
    }

    public void run(ApplicationArguments args) throws Exception {
        this.install();
    }
}

