/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.controller;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.sysutil.IHubSysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysUtilContainerOnly;
import net.ibizsys.central.cloud.core.util.RestUtils;
import net.ibizsys.central.cloud.core.util.domain.CodeList;
import net.ibizsys.runtime.util.SystemRuntimeHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.filters.StringInputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={""})
@ConditionalOnProperty(prefix="ibiz.servicehub", name={"extensiongateway"}, havingValue="true", matchIfMissing=true)
public class ExtensionGatewayRestController {
    private static final Log log = LogFactory.getLog(ExtensionGatewayRestController.class);
    @Autowired
    IServiceHub iServiceHub;

    @PostConstruct
    protected void postConstruct() {
        this.iServiceHub.registerIgnoreAuthPattern("/*/extension/dynamodels/pssysapps/*/simple/**");
        this.iServiceHub.registerIgnoreAuthPattern("/*/extension/webhooks/**");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/extension/webhooks/{key}"})
    public ResponseEntity<Object> invokeWebHook(@PathVariable(value="id") String id, @PathVariable(name="key") String key, HttpServletRequest req, HttpServletResponse response) {
        try {
            ISystemRuntime iSystemRuntime = this.iServiceHub.getLoadedSystemRuntime(id);
            SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
            ISysExtensionUtilRuntime iSysExtensionUtilRuntime = (ISysExtensionUtilRuntime)iSystemRuntime.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
            Map<String, Object> param = RestUtils.queryString2Map(req.getQueryString());
            Object ret = null;
            ret = iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly) ? ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).invokeWebHook(iSystemRuntime, key, param) : iSysExtensionUtilRuntime.invokeWebHook(key, param);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)ret);
            return responseEntity;
        }
        finally {
            SystemRuntimeHolder.poll();
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/extension/dynamodelapi/{model}", "/{id}/extension/dynamodelapi/{model}/{key}", "/{id}/extension/dynamodelapi/{model}/{key}/{method}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}/{method}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}/{method}"})
    public ResponseEntity<Object> invokeDynaModelAPIGetMethod(@PathVariable(value="id") String id, @PathVariable(name="model", required=true) String model, @PathVariable(name="key", required=false) String key, @PathVariable(name="method", required=false) String method, HttpServletRequest req, HttpServletResponse response) {
        return ResponseEntity.ok((Object)this.invokeDynaModelAPI(id, null, null, model, key, StringUtils.hasLength((String)method) ? method : "GET", null, req, response));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/extension/dynamodelapi/{model}/fetch{method}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/fetch{method}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/fetch{method}"})
    public ResponseEntity<?> invokeDynaModelAPIFetchMethod(@PathVariable(value="id") String id, @PathVariable(name="pmodel", required=false) String pmodel, @PathVariable(name="pkey", required=false) String pkey, @PathVariable(name="model", required=true) String model, @PathVariable(name="method", required=true) String method, HttpServletRequest req, HttpServletResponse response) {
        Object ret = this.invokeDynaModelAPI(id, pmodel, pkey, model, null, "fetch" + method, null, req, response);
        if (ret instanceof Page) {
            return RestUtils.sendBackPage((Page)ret);
        }
        return ResponseEntity.ok((Object)ret);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{id}/extension/dynamodelapi/{model}/fetch{method}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/fetch{method}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/fetch{method}"})
    public ResponseEntity<?> invokeDynaModelAPIFetchMethod(@PathVariable(value="id") String id, @PathVariable(name="pmodel", required=false) String pmodel, @PathVariable(name="pkey", required=false) String pkey, @PathVariable(name="model", required=true) String model, @PathVariable(name="method", required=true) String method, @RequestBody(required=false) Object body, HttpServletRequest req, HttpServletResponse response) {
        Object ret = this.invokeDynaModelAPI(id, pmodel, pkey, model, null, "fetch" + method, body, req, response);
        if (ret instanceof Page) {
            return RestUtils.sendBackPage((Page)ret);
        }
        return ResponseEntity.ok((Object)ret);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{id}/extension/dynamodelapi/{model}", "/{id}/extension/dynamodelapi/{model}/{key}", "/{id}/extension/dynamodelapi/{model}/{key}/{method}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}/{method}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}/{method}"})
    public ResponseEntity<Object> invokeDynaModelAPIPostMethod(@PathVariable(value="id") String id, @PathVariable(name="model", required=true) String model, @PathVariable(name="key", required=false) String key, @PathVariable(name="method", required=false) String method, @RequestBody(required=false) Object body, HttpServletRequest req, HttpServletResponse response) {
        return ResponseEntity.ok((Object)this.invokeDynaModelAPI(id, null, null, model, key, StringUtils.hasLength((String)method) ? method : "CREATE", body, req, response));
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}/extension/dynamodelapi/{model}/{key}", "/{id}/extension/dynamodelapi/{model}/{key}/{method}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}/{method}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}/{method}"})
    public ResponseEntity<Object> invokeDynaModelAPIPutMethod(@PathVariable(value="id") String id, @PathVariable(name="model", required=true) String model, @PathVariable(name="key", required=false) String key, @PathVariable(name="method", required=false) String method, @RequestBody(required=false) Object body, HttpServletRequest req, HttpServletResponse response) {
        return ResponseEntity.ok((Object)this.invokeDynaModelAPI(id, null, null, model, key, StringUtils.hasLength((String)method) ? method : "UPDATE", body, req, response));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}/extension/dynamodelapi/{model}/{key}", "/{id}/extension/dynamodelapi/{model}/{key}/{method}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{pmodel}/{pkey}/{model}/{key}/{method}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}", "/{id}/extension/dynamodelapi/{ppmodel}/{ppkey}/{pmodel}/{pkey}/{model}/{key}/{method}"})
    public ResponseEntity<Object> invokeDynaModelAPIDeleteMethod(@PathVariable(value="id") String id, @PathVariable(name="model", required=true) String model, @PathVariable(name="key", required=false) String key, @PathVariable(name="method", required=false) String method, HttpServletRequest req, HttpServletResponse response) {
        return ResponseEntity.ok((Object)this.invokeDynaModelAPI(id, null, null, model, key, StringUtils.hasLength((String)method) ? method : "REMOVE", null, req, response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeDynaModelAPI(String id, String pmodel, String pkey, String model, String key, String method, Object body, HttpServletRequest req, HttpServletResponse response) {
        try {
            ISystemRuntime iSystemRuntime = this.iServiceHub.getLoadedSystemRuntime(id);
            SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
            ISysExtensionUtilRuntime iSysExtensionUtilRuntime = (ISysExtensionUtilRuntime)iSystemRuntime.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
            if (body == null) {
                body = RestUtils.queryString2Map(req.getQueryString());
            }
            if (iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly)) {
                Object object = ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).invokeDynaModelAPI(iSystemRuntime, pmodel, pkey, model, method, key, body);
                return object;
            }
            Object object = iSysExtensionUtilRuntime.invokeDynaModelAPI(pmodel, pkey, model, method, key, body);
            return object;
        }
        finally {
            SystemRuntimeHolder.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/{id}/extension/jsonschemas/pssysapps/{app}/{appde}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadAppDataEntityJsonSchema(@PathVariable(value="id") String id, @PathVariable(value="app") String app, @PathVariable(value="appde") String appde, HttpServletRequest req, HttpServletResponse response) throws IOException {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        try {
            ISystemRuntime iSystemRuntime = this.iServiceHub.getLoadedSystemRuntime(id);
            SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
            ISysExtensionUtilRuntime iSysExtensionUtilRuntime = (ISysExtensionUtilRuntime)iSystemRuntime.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
            Map<String, Object> param = RestUtils.queryString2Map(req.getQueryString());
            File configFile = null;
            configFile = iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly) ? ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).getAppDataEntityJsonSchema(iSystemRuntime, app, appde, param, true) : iSysExtensionUtilRuntime.getAppDataEntityJsonSchema(app, appde, param, true);
            if (configFile == null || !configFile.exists()) {
                response.sendError(HttpStatus.NOT_FOUND.value());
                return;
            }
            String strCacheTag = req.getQueryString();
            if (StringUtils.hasLength((String)strCacheTag)) {
                strCacheTag = null;
                if (param instanceof Map) {
                    strCacheTag = (String)param.get("dynamodeltag");
                }
            }
            if (!StringUtils.hasLength((String)strCacheTag)) {
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Expires", "0");
            } else {
                response.setHeader("Cache-Control", "max-age=2592000");
            }
            String strAcceptEncoding = req.getHeader("Accept-Encoding");
            boolean bGZip = false;
            if (StringUtils.hasLength((String)strAcceptEncoding)) {
                bGZip = strAcceptEncoding.indexOf("gzip") != -1;
            }
            response.setHeader("charset", "utf-8");
            response.setHeader("Content-Disposition", String.format("attachment;filename=%s;filename*=utf-8''%s", configFile.getName(), this.getFileName(configFile.getName())));
            response.setContentType("application/json;charset=UTF-8");
            if (bGZip) {
                response.setHeader("Content-Encoding", "gzip");
            }
            this.sendRespose(response, configFile, bGZip);
        }
        finally {
            SystemRuntimeHolder.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/{id}/extension/dynamodels/pssysapps/{app}/**"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadAppDynaModel(@PathVariable(value="id") String id, @PathVariable(value="app") String app, HttpServletRequest req, HttpServletResponse response) throws IOException {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        String strUri = req.getRequestURI();
        strUri = strUri.substring(32 + id.length());
        Map<String, Object> param = RestUtils.queryString2Map(req.getQueryString());
        try {
            ISystemRuntime iSystemRuntime = this.iServiceHub.getLoadedSystemRuntime(id);
            SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
            ISysExtensionUtilRuntime iSysExtensionUtilRuntime = (ISysExtensionUtilRuntime)iSystemRuntime.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
            File configFile = null;
            String strCacheTag = req.getQueryString();
            if (iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly)) {
                if (strUri.indexOf("PSSYSAPP.hub.json") != -1) {
                    configFile = ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).getHubAppDynaModelFile(iSystemRuntime, app, param, true);
                    strCacheTag = null;
                } else {
                    configFile = ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).getAppDynaModelFile(iSystemRuntime, app, strUri, param, true);
                }
            } else if (strUri.indexOf("PSSYSAPP.hub.json") != -1) {
                configFile = iSysExtensionUtilRuntime.getHubAppDynaModelFile(app, param, true);
                strCacheTag = null;
            } else {
                configFile = iSysExtensionUtilRuntime.getAppDynaModelFile(app, strUri, param, true);
            }
            if (configFile == null || !configFile.exists()) {
                response.sendError(HttpStatus.NOT_FOUND.value());
                return;
            }
            if (StringUtils.hasLength((String)strCacheTag)) {
                strCacheTag = null;
                if (param instanceof Map) {
                    strCacheTag = (String)param.get("dynamodeltag");
                }
            }
            if (!StringUtils.hasLength((String)strCacheTag)) {
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Expires", "0");
            } else {
                response.setHeader("Cache-Control", "max-age=2592000");
            }
            String strAcceptEncoding = req.getHeader("Accept-Encoding");
            boolean bGZip = false;
            if (StringUtils.hasLength((String)strAcceptEncoding)) {
                bGZip = strAcceptEncoding.indexOf("gzip") != -1;
            }
            response.setHeader("charset", "utf-8");
            response.setHeader("Content-Disposition", String.format("attachment;filename=%s;filename*=utf-8''%s", configFile.getName(), this.getFileName(configFile.getName())));
            response.setContentType("application/json;charset=UTF-8");
            if (bGZip) {
                response.setHeader("Content-Encoding", "gzip");
            }
            this.sendRespose(response, configFile, bGZip);
        }
        finally {
            SystemRuntimeHolder.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/{id}/extension/dynamodels/pssysapps/{app}/simple/**"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadAppSimpleModel(@PathVariable(value="id") String id, @PathVariable(value="app") String app, HttpServletRequest req, HttpServletResponse response) throws IOException {
        String strUri = req.getRequestURI();
        strUri = strUri.substring(32 + id.length());
        strUri = strUri.substring(app.length() + 8);
        strUri = "/" + app + strUri;
        if (strUri.indexOf(".simple.json") == -1) {
            response.sendError(HttpStatus.FORBIDDEN.value());
            return;
        }
        String strCacheTag = req.getQueryString();
        try {
            ISystemRuntime iSystemRuntime = this.iServiceHub.getLoadedSystemRuntime(id);
            SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
            String strConfigPath = iSystemRuntime.getPSSystemService().getPSModelFolderPath();
            File configFile = new File(strConfigPath + "/PSSYSAPPS" + strUri);
            if (!configFile.exists()) {
                response.sendError(HttpStatus.NOT_FOUND.value());
                return;
            }
            if (!StringUtils.hasLength((String)strCacheTag)) {
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Expires", "0");
            } else {
                response.setHeader("Cache-Control", "max-age=2592000");
            }
            String strAcceptEncoding = req.getHeader("Accept-Encoding");
            boolean bGZip = false;
            if (StringUtils.hasLength((String)strAcceptEncoding)) {
                bGZip = strAcceptEncoding.indexOf("gzip") != -1;
            }
            response.setHeader("charset", "utf-8");
            response.setHeader("Content-Disposition", String.format("attachment;filename=%s;filename*=utf-8''%s", configFile.getName(), this.getFileName(configFile.getName())));
            response.setContentType("application/json;charset=UTF-8");
            if (bGZip) {
                response.setHeader("Content-Encoding", "gzip");
            }
            this.sendRespose(response, configFile, bGZip);
        }
        finally {
            SystemRuntimeHolder.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/{id}/extension/dynamodels/pssysapps/{app}/subapps/{subapp}/**"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadHubSubAppModel(@PathVariable(value="id") String id, @PathVariable(value="app") String app, @PathVariable(value="subapp") String subapp, HttpServletRequest req, HttpServletResponse response) throws IOException {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        String strUri = req.getRequestURI();
        strUri = strUri.substring(32 + id.length());
        strUri = strUri.substring(app.length() + 9);
        strUri = strUri.substring(subapp.length() + 1);
        String strCacheTag = req.getQueryString();
        Map<String, Object> param = RestUtils.queryString2Map(req.getQueryString());
        try {
            ISystemRuntime iSystemRuntime = this.iServiceHub.getLoadedSystemRuntime(id);
            SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
            ISysExtensionUtilRuntime iSysExtensionUtilRuntime = (ISysExtensionUtilRuntime)iSystemRuntime.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
            File configFile = null;
            configFile = iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly) ? ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).getHubSubAppDynaModelFile(iSystemRuntime, app, subapp, strUri, param, true) : iSysExtensionUtilRuntime.getHubSubAppDynaModelFile(app, subapp, strUri, param, true);
            if (configFile == null || !configFile.exists()) {
                response.sendError(HttpStatus.NOT_FOUND.value());
                return;
            }
            if (StringUtils.hasLength((String)strCacheTag)) {
                strCacheTag = null;
                if (param instanceof Map) {
                    strCacheTag = (String)param.get("dynamodeltag");
                }
            }
            if (!StringUtils.hasLength((String)strCacheTag)) {
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Expires", "0");
            } else {
                response.setHeader("Cache-Control", "max-age=2592000");
            }
            String strAcceptEncoding = req.getHeader("Accept-Encoding");
            boolean bGZip = false;
            if (StringUtils.hasLength((String)strAcceptEncoding)) {
                bGZip = strAcceptEncoding.indexOf("gzip") != -1;
            }
            response.setHeader("charset", "utf-8");
            response.setHeader("Content-Disposition", String.format("attachment;filename=%s;filename*=utf-8''%s", configFile.getName(), this.getFileName(configFile.getName())));
            response.setContentType("application/json;charset=UTF-8");
            if (bGZip) {
                response.setHeader("Content-Encoding", "gzip");
            }
            this.sendRespose(response, configFile, bGZip);
        }
        finally {
            SystemRuntimeHolder.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/{id}/extension/jsonschemas/pssysapps/{app}/subapps/{subapp}/{appde}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadHubSubAppDataEntityJsonSchema(@PathVariable(value="id") String id, @PathVariable(value="app") String app, @PathVariable(value="subapp") String subapp, @PathVariable(value="appde") String appde, HttpServletRequest req, HttpServletResponse response) throws IOException {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        try {
            ISystemRuntime iSystemRuntime = this.iServiceHub.getLoadedSystemRuntime(id);
            SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
            ISysExtensionUtilRuntime iSysExtensionUtilRuntime = (ISysExtensionUtilRuntime)iSystemRuntime.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
            Map<String, Object> param = RestUtils.queryString2Map(req.getQueryString());
            File configFile = null;
            configFile = iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly) ? ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).getHubSubAppDataEntityJsonSchema(iSystemRuntime, app, subapp, appde, param, true) : iSysExtensionUtilRuntime.getHubSubAppDataEntityJsonSchema(app, subapp, appde, param, true);
            if (configFile == null || !configFile.exists()) {
                response.sendError(HttpStatus.NOT_FOUND.value());
                return;
            }
            String strCacheTag = req.getQueryString();
            if (StringUtils.hasLength((String)strCacheTag)) {
                strCacheTag = null;
                if (param instanceof Map) {
                    strCacheTag = (String)param.get("dynamodeltag");
                }
            }
            if (!StringUtils.hasLength((String)strCacheTag)) {
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Expires", "0");
            } else {
                response.setHeader("Cache-Control", "max-age=2592000");
            }
            String strAcceptEncoding = req.getHeader("Accept-Encoding");
            boolean bGZip = false;
            if (StringUtils.hasLength((String)strAcceptEncoding)) {
                bGZip = strAcceptEncoding.indexOf("gzip") != -1;
            }
            response.setHeader("charset", "utf-8");
            response.setHeader("Content-Disposition", String.format("attachment;filename=%s;filename*=utf-8''%s", configFile.getName(), this.getFileName(configFile.getName())));
            response.setContentType("application/json;charset=UTF-8");
            if (bGZip) {
                response.setHeader("Content-Encoding", "gzip");
            }
            this.sendRespose(response, configFile, bGZip);
        }
        finally {
            SystemRuntimeHolder.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/extension/dictionaries/codelist/{code}"})
    public ResponseEntity<CodeList> getCodeList(@PathVariable(value="id") String id, @PathVariable(value="code") String code, @RequestParam(name="trymode", required=false, defaultValue="false") String trymode, @RequestParam(name="size", required=false) Integer maxSize, HttpServletRequest req, HttpServletResponse response) throws IOException {
        Map<String, Object> param = RestUtils.queryString2Map(req.getQueryString());
        boolean bTryMode = trymode.equalsIgnoreCase("true");
        if (maxSize == null || maxSize <= 0) {
            maxSize = Integer.MAX_VALUE;
        }
        try {
            ISystemRuntime iSystemRuntime = this.iServiceHub.getLoadedSystemRuntime(id);
            SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
            ISysExtensionUtilRuntime iSysExtensionUtilRuntime = (ISysExtensionUtilRuntime)iSystemRuntime.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
            CodeList codeList = iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly) ? ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).getCodeList(iSystemRuntime, code, maxSize, param, bTryMode) : iSysExtensionUtilRuntime.getCodeList(code, maxSize, param, bTryMode);
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)codeList);
            return responseEntity;
        }
        finally {
            SystemRuntimeHolder.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRespose(HttpServletResponse response, File file, boolean bGZip) {
        BufferedInputStream bis = null;
        OutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(new FileInputStream(file));
            bos = bGZip ? new GZIPOutputStream((OutputStream)response.getOutputStream()) : new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            if (bGZip && bos instanceof GZIPOutputStream) {
                ((GZIPOutputStream)bos).finish();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRespose(HttpServletResponse response, String strContent, boolean bGZip) {
        BufferedInputStream bis = null;
        OutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream((InputStream)new StringInputStream(strContent, "UTF-8"));
            bos = bGZip ? new GZIPOutputStream((OutputStream)response.getOutputStream()) : new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            if (bGZip && bos instanceof GZIPOutputStream) {
                ((GZIPOutputStream)bos).finish();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String getFileName(String fileName) {
        try {
            return new String(fileName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)ex);
            return fileName;
        }
    }
}

