/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.configuration;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.config.ConfigService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.ServiceHubSettingBase;
import net.ibizsys.central.cloud.core.util.ConfigEntity;
import net.ibizsys.central.cloud.core.util.NacosConfigUtils;
import net.ibizsys.central.cloud.core.util.domain.DataSource;
import net.ibizsys.central.cloud.core.util.domain.DeploySystem;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public abstract class NacosServiceHubSettingBase
extends ServiceHubSettingBase {
    private static final Log log = LogFactory.getLog(NacosServiceHubSettingBase.class);
    public static final String DATAID_SERVICEHUB_PREFIX = "servicehub-";
    public static final String DATAID_APPHUB_PREFIX = "apphub-";
    public static final String DATAID_DEPLOYSYSTEM_PREFIX = "deploysystem-";
    public static final String DATAID_DEPLOYAPP_PREFIX = "deployapp-";
    public static final String DATAID_DBINST_PREFIX = "dbinst-";
    public static final String DATAID_BDINST_PREFIX = "bdinst-";
    public static final String DATAID_SYSTEMHUB_PREFIX = "systemhub-";
    public static final String DATAID_SYSTEMEXTENSION_PREFIX = "systemextension-";
    public static final String DATAID_SYSTEMMERGENCES_PREFIX = "systemmergences-";
    @Autowired
    private NacosConfigManager nacosConfigManager;
    @Autowired
    private NacosConfigProperties nacosConfigProperties;
    private boolean bLoadConfig = false;
    public static final String DEFAULT_TEMPFOLDER = "/app/file/tempfile";
    public static final String DEFAULT_FILEFOLDER = "/app/file/datafile";
    public static final String DEFAULT_FONTFOLDER = "/usr/share/fonts";
    public static final String DEFAULT_REPORTFOLDER = "/app/file/datafile/report";

    @Override
    public synchronized void loadConfig() {
        if (this.bLoadConfig) {
            return;
        }
        try {
            this.onLoadConfig();
            this.bLoadConfig = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void onLoadConfig() throws Exception {
        ConfigService configService = this.nacosConfigManager.getConfigService();
        boolean bLocal = false;
        String content = configService.getConfig(DATAID_SERVICEHUB_PREFIX + this.getId(), this.nacosConfigProperties.getGroup(), 5000L);
        if (!StringUtils.hasLength((String)content)) {
            log.warn((Object)String.format("\u65e0\u6cd5\u83b7\u53d6\u8fdc\u7a0b\u914d\u7f6e[%1$s]\uff0c\u4f7f\u7528\u672c\u5730\u914d\u7f6e\u6587\u4ef6", DATAID_SERVICEHUB_PREFIX + this.getId()));
            content = this.getLocalConfig();
            if (!StringUtils.hasLength((String)content)) {
                throw new Exception("\u672a\u5b9a\u4e49\u914d\u7f6e");
            }
            bLocal = true;
        }
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.loadAs(content, Map.class);
        this.onLoadConfig(config, bLocal);
    }

    @Override
    public synchronized void reloadConfig() {
        if (!this.bLoadConfig) {
            this.loadConfig();
            return;
        }
        try {
            this.onReloadConfig();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void onLoadConfig(Map config, boolean bLocal) throws Exception {
        Object objDeploySystems;
        Object value = config.get("enableappgateway");
        if (value != null) {
            this.setEnableAppGateway(value.toString().equalsIgnoreCase("true"));
        }
        if (!StringUtils.hasLength((String)this.getTempFolder()) && (value = config.get("tempfolder")) != null) {
            this.setTempFolder(value.toString());
        }
        if (!StringUtils.hasLength((String)this.getFileFolder()) && (value = config.get("filefolder")) != null) {
            this.setFileFolder(value.toString());
        }
        if (!StringUtils.hasLength((String)this.getFontFolder()) && (value = config.get("fontfolder")) != null) {
            this.setFontFolder(value.toString());
        }
        if (!StringUtils.hasLength((String)this.getReportFolder()) && (value = config.get("reportfolder")) != null) {
            this.setReportFolder(value.toString());
        }
        if (!StringUtils.hasLength((String)this.getTempFolder())) {
            this.setTempFolder(DEFAULT_TEMPFOLDER);
        }
        if (!StringUtils.hasLength((String)this.getFileFolder())) {
            this.setFileFolder(DEFAULT_FILEFOLDER);
        }
        if (!StringUtils.hasLength((String)this.getFontFolder())) {
            this.setFontFolder(DEFAULT_FONTFOLDER);
        }
        if (!StringUtils.hasLength((String)this.getReportFolder())) {
            this.setReportFolder(DEFAULT_REPORTFOLDER);
        }
        if (!StringUtils.hasLength((String)this.getCloudPluginServiceId()) && (value = config.get("cloudpluginserviceid")) != null) {
            this.setCloudPluginServiceId(value.toString());
        }
        if ((value = config.get("enablereloadsystem")) != null) {
            this.setEnableReloadSystem(DataTypeUtils.getBooleanValue(value, (Boolean)this.isEnableReloadSystem()));
        }
        if (this.getNode() == null && (value = config.get("node")) != null) {
            this.setNode(Long.valueOf(value.toString()));
        }
        Map systemSettings = null;
        if (config.get("systemsettings") instanceof Map) {
            systemSettings = (Map)config.get("systemsettings");
        }
        ConfigService configService = this.nacosConfigManager.getConfigService();
        Yaml yaml = new Yaml();
        Object objDataSources = config.get("datasources");
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        if (objDataSources instanceof Map) {
            ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
            Map map = (Map)objDataSources;
            for (Map.Entry entry : map.entrySet()) {
                DataSource dataSource = new DataSource();
                Object objDataSource = entry.getValue();
                if (objDataSource instanceof Map) {
                    Map source = (Map)objDataSource;
                    dataSource.putAll(source);
                    for (Map.Entry item : source.entrySet()) {
                        String strKey = ((String)item.getKey()).replace("-", "");
                        if (strKey.equals(item.getKey())) continue;
                        dataSource.set(strKey, item.getValue());
                    }
                    if (ObjectUtils.isEmpty((Object)dataSource.getDriverClassName())) {
                        dataSource.setDriverClassName((String)dataSource.get("driver-class-name"));
                    }
                } else {
                    String strDBInstConfig;
                    String strDBInstConfigKey = String.format("%1$s%2$s", DATAID_DBINST_PREFIX, objDataSource);
                    String strBackupConfigId = strDBInstConfigKey;
                    if (!strBackupConfigId.equals(strDBInstConfigKey = NacosConfigUtils.getDataId(strBackupConfigId))) {
                        log.warn((Object)String.format("\u952e\u540d[%1$s]\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff0c\u8f6c\u6362\u81f3[%2$s]\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u952e\u540d\u51b2\u7a81", strBackupConfigId, strDBInstConfigKey));
                    }
                    if (!StringUtils.hasLength((String)(strDBInstConfig = configService.getConfig(strDBInstConfigKey, this.nacosConfigProperties.getGroup(), 5000L)))) {
                        log.warn((Object)String.format("\u672a\u5b9a\u4e49\u6570\u636e\u5e93\u5b9e\u4f8b[%1$s]\u914d\u7f6e\uff0c\u8bbf\u95ee\u53ef\u80fd\u4f1a\u51fa\u73b0\u95ee\u9898", strDBInstConfigKey));
                        continue;
                    }
                    ConfigEntity configEntity = new ConfigEntity(strDBInstConfig);
                    String strDBInstConfigExKey = String.format("%1$s%2$s-ex", DATAID_DBINST_PREFIX, objDataSource);
                    strDBInstConfigExKey = NacosConfigUtils.getDataId(strDBInstConfigExKey);
                    String strDBInstConfigEx = configService.getConfig(strDBInstConfigExKey, this.nacosConfigProperties.getGroup(), 5000L);
                    if (StringUtils.hasLength((String)strDBInstConfigExKey)) {
                        ConfigEntity configexEntity = new ConfigEntity(strDBInstConfigEx);
                        configexEntity.copyTo(configEntity);
                    }
                    configEntity.copyTo((IEntity)dataSource);
                }
                if (ObjectUtils.isEmpty((Object)dataSource.getJdbcUrl())) {
                    dataSource.setJdbcUrl((String)dataSource.get("url"));
                }
                dataSource.setDataSourceId((String)entry.getKey());
                dataSourceList.add(dataSource);
                dataSourceMap.put(dataSource.getDataSourceId(), dataSource);
            }
            this.setDataSources(dataSourceList);
        }
        if ((objDeploySystems = config.get("deploysystems")) instanceof List) {
            ArrayList<DeploySystem> deploySystemList = new ArrayList<DeploySystem>();
            List list = (List)objDeploySystems;
            for (Object item : list) {
                String strDefaultDBInstTag;
                String strSystemRuntimeClass;
                String deploySystemConfig;
                if (ObjectUtils.isEmpty(item)) continue;
                String strEnableAPIs = "";
                String strItem = item.toString();
                int nPos = strItem.indexOf(":");
                if (nPos != -1) {
                    item = strItem.substring(0, nPos);
                    strEnableAPIs = strItem.substring(nPos + 1);
                }
                if (!StringUtils.hasLength((String)(deploySystemConfig = configService.getConfig(DATAID_DEPLOYSYSTEM_PREFIX + item.toString(), this.nacosConfigProperties.getGroup(), 5000L)))) {
                    throw new Exception(String.format("\u90e8\u7f72\u7cfb\u7edf[%1$s]\u914d\u7f6e\u65e0\u6548", item.toString()));
                }
                Map map2 = (Map)yaml.loadAs(deploySystemConfig, Map.class);
                DeploySystem deploySystem = new DeploySystem();
                deploySystem.putAll(map2);
                deploySystem.setDeploySystemId(item.toString());
                if (this.getSystemRuntimeClass() != null && StringUtils.hasLength((String)(strSystemRuntimeClass = this.getSystemRuntimeClass().get(item)))) {
                    deploySystem.setRuntimeClassName(strSystemRuntimeClass);
                }
                if (systemSettings != null) {
                    HashMap<String, Object> settings = new HashMap<String, Object>();
                    settings.putAll(systemSettings);
                    if (deploySystem.getSettings() != null) {
                        settings.putAll(deploySystem.getSettings());
                    }
                    deploySystem.setSettings(settings);
                }
                if (StringUtils.hasLength((String)strEnableAPIs)) {
                    if (deploySystem.getSettings() == null) {
                        deploySystem.setSettings(new HashMap<String, Object>());
                    }
                    deploySystem.getSettings().put("enableapis", strEnableAPIs);
                }
                if (dataSourceMap.containsKey(strDefaultDBInstTag = String.format("%1$s__default", deploySystem.getDeploySystemId()))) {
                    if (deploySystem.getSettings() == null) {
                        deploySystem.setSettings(new HashMap<String, Object>());
                    }
                    deploySystem.getSettings().put("defaultdbinsttag", strDefaultDBInstTag);
                }
                deploySystemList.add(deploySystem);
            }
            this.setDeploySystems(deploySystemList);
        }
    }

    protected void onReloadConfig() throws Exception {
        ConfigService configService = this.nacosConfigManager.getConfigService();
        String content = configService.getConfig(DATAID_SERVICEHUB_PREFIX + this.getId(), this.nacosConfigProperties.getGroup(), 5000L);
        if (!StringUtils.hasLength((String)content)) {
            throw new Exception("\u672a\u5b9a\u4e49\u914d\u7f6e");
        }
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.loadAs(content, Map.class);
        this.onReloadConfig(config);
    }

    protected void onReloadConfig(Map config) throws Exception {
        Map systemSettings = null;
        if (config.get("systemsettings") instanceof Map) {
            systemSettings = (Map)config.get("systemsettings");
        }
        ConfigService configService = this.nacosConfigManager.getConfigService();
        Yaml yaml = new Yaml();
        Object objDataSources = config.get("datasources");
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        if (objDataSources instanceof Map) {
            ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
            Map map = (Map)objDataSources;
            for (Map.Entry entry : map.entrySet()) {
                DataSource dataSource = new DataSource();
                Object objDataSource = entry.getValue();
                if (objDataSource instanceof Map) {
                    Map source = (Map)objDataSource;
                    dataSource.putAll(source);
                    for (Map.Entry item : source.entrySet()) {
                        String strKey = ((String)item.getKey()).replace("-", "");
                        if (strKey.equals(item.getKey())) continue;
                        dataSource.set(strKey, item.getValue());
                    }
                    if (ObjectUtils.isEmpty((Object)dataSource.getDriverClassName())) {
                        dataSource.setDriverClassName((String)dataSource.get("driver-class-name"));
                    }
                } else {
                    String strDBInstConfig;
                    String strDBInstConfigKey = String.format("%1$s%2$s", DATAID_DBINST_PREFIX, objDataSource);
                    String strBackupConfigId = strDBInstConfigKey;
                    if (!strBackupConfigId.equals(strDBInstConfigKey = NacosConfigUtils.getDataId(strBackupConfigId))) {
                        log.warn((Object)String.format("\u952e\u540d[%1$s]\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff0c\u8f6c\u6362\u81f3[%2$s]\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u952e\u540d\u51b2\u7a81", strBackupConfigId, strDBInstConfigKey));
                    }
                    if (!StringUtils.hasLength((String)(strDBInstConfig = configService.getConfig(strDBInstConfigKey, this.nacosConfigProperties.getGroup(), 5000L)))) {
                        log.warn((Object)String.format("\u672a\u5b9a\u4e49\u6570\u636e\u5e93\u5b9e\u4f8b[%1$s]\u914d\u7f6e\uff0c\u8bbf\u95ee\u53ef\u80fd\u4f1a\u51fa\u73b0\u95ee\u9898", strDBInstConfigKey));
                        continue;
                    }
                    ConfigEntity configEntity = new ConfigEntity(strDBInstConfig);
                    String strDBInstConfigExKey = String.format("%1$s%2$s-ex", DATAID_DBINST_PREFIX, objDataSource);
                    strDBInstConfigExKey = NacosConfigUtils.getDataId(strDBInstConfigExKey);
                    String strDBInstConfigEx = configService.getConfig(strDBInstConfigExKey, this.nacosConfigProperties.getGroup(), 5000L);
                    if (StringUtils.hasLength((String)strDBInstConfigExKey)) {
                        ConfigEntity configexEntity = new ConfigEntity(strDBInstConfigEx);
                        configexEntity.copyTo(configEntity);
                    }
                    configEntity.copyTo((IEntity)dataSource);
                }
                if (ObjectUtils.isEmpty((Object)dataSource.getJdbcUrl())) {
                    dataSource.setJdbcUrl((String)dataSource.get("url"));
                }
                dataSource.setDataSourceId((String)entry.getKey());
                dataSourceList.add(dataSource);
                dataSourceMap.put(dataSource.getDataSourceId(), dataSource);
            }
            this.setDataSources(dataSourceList);
        } else {
            this.setDataSources(new ArrayList<DataSource>());
        }
        Object objDeploySystems = config.get("deploysystems");
        if (objDeploySystems instanceof List) {
            ArrayList<DeploySystem> deploySystemList = new ArrayList<DeploySystem>();
            List list = (List)objDeploySystems;
            for (Object item : list) {
                String strDefaultDBInstTag;
                String deploySystemConfig;
                if (ObjectUtils.isEmpty(item)) continue;
                String strEnableAPIs = "";
                String strItem = item.toString();
                int nPos = strItem.indexOf(":");
                if (nPos != -1) {
                    item = strItem.substring(0, nPos);
                    strEnableAPIs = strItem.substring(nPos + 1);
                }
                if (!StringUtils.hasLength((String)(deploySystemConfig = configService.getConfig(DATAID_DEPLOYSYSTEM_PREFIX + item.toString(), this.nacosConfigProperties.getGroup(), 5000L)))) {
                    throw new Exception(String.format("\u90e8\u7f72\u7cfb\u7edf[%1$s]\u914d\u7f6e\u65e0\u6548", item.toString()));
                }
                Map map2 = (Map)yaml.loadAs(deploySystemConfig, Map.class);
                DeploySystem deploySystem = new DeploySystem();
                deploySystem.putAll(map2);
                deploySystem.setDeploySystemId(item.toString());
                if (systemSettings != null) {
                    HashMap<String, Object> settings = new HashMap<String, Object>();
                    settings.putAll(systemSettings);
                    if (deploySystem.getSettings() != null) {
                        settings.putAll(deploySystem.getSettings());
                    }
                    deploySystem.setSettings(settings);
                }
                if (StringUtils.hasLength((String)strEnableAPIs)) {
                    if (deploySystem.getSettings() == null) {
                        deploySystem.setSettings(new HashMap<String, Object>());
                    }
                    deploySystem.getSettings().put("enableapis", strEnableAPIs);
                }
                if (dataSourceMap.containsKey(strDefaultDBInstTag = String.format("%1$s__default", deploySystem.getDeploySystemId()))) {
                    if (deploySystem.getSettings() == null) {
                        deploySystem.setSettings(new HashMap<String, Object>());
                    }
                    deploySystem.getSettings().put("defaultdbinsttag", strDefaultDBInstTag);
                }
                deploySystemList.add(deploySystem);
            }
            this.setDeploySystems(deploySystemList);
        } else {
            this.setDeploySystems(new ArrayList<DeploySystem>());
        }
    }

    protected String getLocalConfig() throws Exception {
        try (InputStream is = this.getClass().getResourceAsStream("/servicehub.yml");){
            if (is != null) {
                String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                return string;
            }
        }
        return null;
    }
}

