/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.service.util;

import java.util.List;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIDocAdapter;
import net.ibizsys.central.service.ISysServiceAPIRuntime;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class SysServiceAPIDocUtils {
    private static final Log log = LogFactory.getLog(SysServiceAPIDocUtils.class);

    public static void registerR8DEMethodMapping(ISysServiceAPIRuntime iSysServiceAPIRuntime, ISysServiceAPIDocAdapter iSysServiceAPIDocAdapter) {
        List psDataEntityList = iSysServiceAPIRuntime.getSystemRuntime().getPSSystem().getAllPSDataEntities();
        if (ObjectUtils.isEmpty((Object)psDataEntityList)) {
            return;
        }
        String baseUrl = String.format("/%1$s/%2$s", iSysServiceAPIRuntime.getSystemRuntime().getServiceId(), iSysServiceAPIRuntime.getPSSysServiceAPI().getServiceCodeName()).toLowerCase();
        for (IPSDataEntity iPSDataEntity : psDataEntityList) {
            List psDEDataSetList;
            if (iPSDataEntity.getPSSystemModuleMust().getPSSysModelGroup() != null) continue;
            List psDEActionList = iPSDataEntity.getAllPSDEActions();
            if (!ObjectUtils.isEmpty((Object)psDEActionList)) {
                for (IPSDEAction iPSDEAction : psDEActionList) {
                    String codeName = iPSDEAction.getCodeName();
                    String codeNameFormat = iSysServiceAPIRuntime.getSystemRuntime().getSystemRuntimeSetting().getDEActionCodeNameFormat();
                    if (StringUtils.hasLength((String)codeNameFormat)) {
                        codeName = String.format(codeNameFormat, codeName);
                    }
                    String uri = String.format("%1$s/%2$s/%3$s", baseUrl, iPSDataEntity.getName(), codeName).toLowerCase();
                    if ("READ".equals(iPSDEAction.getActionMode()) || "DELETE".equals(iPSDEAction.getActionMode())) {
                        uri = uri + "/{key}";
                    }
                    iSysServiceAPIDocAdapter.registerMapping(iSysServiceAPIRuntime, new String[]{uri}, new RequestMethod[]{RequestMethod.POST}, iPSDataEntity, iPSDEAction);
                }
            }
            if (ObjectUtils.isEmpty((Object)(psDEDataSetList = iPSDataEntity.getAllPSDEDataSets()))) continue;
            for (IPSDEDataSet iPSDEDataSet : psDEDataSetList) {
                String codeName = iPSDEDataSet.getCodeName();
                String codeNameFormat = iSysServiceAPIRuntime.getSystemRuntime().getSystemRuntimeSetting().getDEDataSetCodeNameFormat();
                if (StringUtils.hasLength((String)codeNameFormat)) {
                    codeName = String.format(codeNameFormat, codeName);
                }
                String uri = String.format("%1$s/%2$s/%3$s", baseUrl, iPSDataEntity.getName(), codeName).toLowerCase();
                iSysServiceAPIDocAdapter.registerMapping(iSysServiceAPIRuntime, new String[]{uri}, new RequestMethod[]{RequestMethod.POST}, iPSDataEntity, iPSDEDataSet);
            }
        }
    }
}

