/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.service.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ibizsys.central.SystemGatewayException;
import net.ibizsys.central.cloud.core.service.util.IResponseExceptionHandler;
import net.ibizsys.central.dataentity.service.DEServiceAPIRuntimeException;
import net.ibizsys.central.service.SubSysServiceAPIDERuntimeException;
import net.ibizsys.central.service.SubSysServiceAPIRuntimeException;
import net.ibizsys.central.service.SysServiceAPIRuntimeException;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.util.EntityException;
import net.ibizsys.runtime.util.EntityFieldError;
import net.ibizsys.runtime.util.ErrorException;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.UserConfirmException;
import net.ibizsys.runtime.util.UserConfirmOption;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;

public class ResponseExceptionHandler
implements IResponseExceptionHandler {
    @Override
    public ResponseEntity<?> getResponseEntity(Throwable ex) {
        if (ex instanceof EntityException) {
            return this.getResponseEntity((EntityException)ex);
        }
        if (ex instanceof UserConfirmException) {
            return this.getResponseEntity((UserConfirmException)ex);
        }
        if (ex instanceof ErrorException) {
            return this.getResponseEntity((ErrorException)ex);
        }
        if (ex instanceof DataEntityRuntimeException) {
            return this.getResponseEntity((DataEntityRuntimeException)ex);
        }
        if (ex instanceof SysServiceAPIRuntimeException) {
            return this.getResponseEntity((SysServiceAPIRuntimeException)ex);
        }
        if (ex instanceof DEServiceAPIRuntimeException) {
            return this.getResponseEntity((DEServiceAPIRuntimeException)ex);
        }
        if (ex instanceof SubSysServiceAPIRuntimeException) {
            return this.getResponseEntity((SubSysServiceAPIRuntimeException)ex);
        }
        if (ex instanceof SubSysServiceAPIDERuntimeException) {
            return this.getResponseEntity((SubSysServiceAPIDERuntimeException)ex);
        }
        if (ex instanceof SystemRuntimeException) {
            return this.getResponseEntity((SystemRuntimeException)ex);
        }
        if (ex instanceof SystemGatewayException) {
            return this.getResponseEntity((SystemGatewayException)ex);
        }
        if (ex instanceof RuntimeException) {
            ObjectNode out = JsonUtils.createObjectNode();
            out.put("type", "RuntimeException");
            out.put("code", 1);
            out.put("message", ex.getMessage());
            return this.getResponseEntity(out);
        }
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", ex.getClass().getSimpleName());
        out.put("code", 1);
        out.put("message", ex.getMessage());
        return this.getResponseEntity(out);
    }

    protected boolean isGetCauseResponseEntity(Throwable ex) {
        if (!(ex instanceof RuntimeException)) {
            return false;
        }
        if (ex instanceof EntityException) {
            return true;
        }
        if (ex instanceof UserConfirmException) {
            return true;
        }
        if (ex instanceof ErrorException) {
            return true;
        }
        if (ex instanceof DataEntityRuntimeException) {
            return true;
        }
        if (ex instanceof DEServiceAPIRuntimeException) {
            return true;
        }
        if (ex instanceof SubSysServiceAPIRuntimeException) {
            return true;
        }
        if (ex instanceof SubSysServiceAPIDERuntimeException) {
            return true;
        }
        if (ex instanceof SystemRuntimeException) {
            return true;
        }
        return ex instanceof SystemGatewayException;
    }

    public ResponseEntity<?> getResponseEntity(SystemGatewayException systemGatewayException) {
        if (this.isGetCauseResponseEntity(systemGatewayException.getCause())) {
            return this.getResponseEntity((RuntimeException)systemGatewayException.getCause());
        }
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "SystemGatewayException");
        out.put("code", 1);
        out.put("message", systemGatewayException.getMessage());
        return this.getResponseEntity(out);
    }

    public ResponseEntity<?> getResponseEntity(UserConfirmException userConfirmException) {
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "UserConfirmException");
        out.put("code", 19);
        out.put("message", userConfirmException.getMessage());
        out.put("messagetype", userConfirmException.getMessageType());
        ArrayNode arrayNode = out.putArray("options");
        if (!ObjectUtils.isEmpty((Object[])userConfirmException.getOptions())) {
            for (UserConfirmOption userConfirmOption : userConfirmException.getOptions()) {
                arrayNode.add(JsonUtils.toJsonNode((Object)userConfirmOption));
            }
        }
        return this.getResponseEntity(out);
    }

    public ResponseEntity<?> getResponseEntity(EntityException entityException) {
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "EntityException");
        out.put("code", entityException.getErrorCode());
        out.put("message", entityException.getMessage());
        ArrayNode arrayNode = out.putArray("details");
        if (entityException.getEntityError() != null) {
            for (EntityFieldError entityFieldError : entityException.getEntityError().getEntityFieldErrorList()) {
                ObjectNode fieldError = arrayNode.addObject();
                fieldError.put("fieldname", entityFieldError.getFieldName());
                fieldError.put("fieldlogicname", entityFieldError.getFieldLogicName());
                fieldError.put("fielderrortype", entityFieldError.getErrorType());
                if (entityFieldError.getPSDEFValueRule() != null) {
                    fieldError.put("fielderrorinfo", entityFieldError.getPSDEFValueRule().getRuleInfo());
                    continue;
                }
                fieldError.put("fielderrorinfo", entityFieldError.getErrorInfo());
            }
        }
        return this.getResponseEntity(out);
    }

    public ResponseEntity<?> getResponseEntity(ErrorException errorException) {
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "ErrorException");
        out.put("code", errorException.getErrorCode());
        out.put("message", errorException.getMessage());
        return this.getResponseEntity(out);
    }

    public ResponseEntity<?> getResponseEntity(DataEntityRuntimeException dataEntityRuntimeException) {
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "DataEntityRuntimeException");
        out.put("code", dataEntityRuntimeException.getErrorCode());
        out.put("message", dataEntityRuntimeException.getMessage());
        return this.getResponseEntity(out);
    }

    public ResponseEntity<?> getResponseEntity(SystemRuntimeException systemRuntimeException) {
        if (this.isGetCauseResponseEntity(systemRuntimeException.getCause())) {
            return this.getResponseEntity(systemRuntimeException.getCause());
        }
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "SystemRuntimeException");
        out.put("code", systemRuntimeException.getErrorCode());
        out.put("message", systemRuntimeException.getMessage());
        return this.getResponseEntity(out);
    }

    public ResponseEntity<?> getResponseEntity(SubSysServiceAPIRuntimeException subSysServiceAPIRuntimeException) {
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "SubSysServiceAPIRuntimeException");
        out.put("code", subSysServiceAPIRuntimeException.getErrorCode());
        out.put("message", subSysServiceAPIRuntimeException.getMessage());
        return this.getResponseEntity(out);
    }

    public ResponseEntity<?> getResponseEntity(SubSysServiceAPIDERuntimeException subSysServiceAPIDERuntimeException) {
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "SubSysServiceAPIDERuntimeException");
        out.put("code", subSysServiceAPIDERuntimeException.getErrorCode());
        out.put("message", subSysServiceAPIDERuntimeException.getMessage());
        return this.getResponseEntity(out);
    }

    public ResponseEntity<?> getResponseEntity(DEServiceAPIRuntimeException deServiceAPIRuntimeException) {
        if (this.isGetCauseResponseEntity(deServiceAPIRuntimeException.getCause())) {
            return this.getResponseEntity((RuntimeException)deServiceAPIRuntimeException.getCause());
        }
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "DEServiceAPIRuntimeException");
        out.put("code", deServiceAPIRuntimeException.getErrorCode());
        out.put("message", deServiceAPIRuntimeException.getMessage());
        return this.getResponseEntity(out);
    }

    public ResponseEntity<?> getResponseEntity(SysServiceAPIRuntimeException sysServiceAPIRuntimeException) {
        if (this.isGetCauseResponseEntity(sysServiceAPIRuntimeException.getCause())) {
            return this.getResponseEntity((RuntimeException)sysServiceAPIRuntimeException.getCause());
        }
        ObjectNode out = JsonUtils.createObjectNode();
        out.put("type", "SysServiceAPIRuntimeException");
        out.put("code", sysServiceAPIRuntimeException.getErrorCode());
        out.put("message", sysServiceAPIRuntimeException.getMessage());
        return this.getResponseEntity(out);
    }

    protected ResponseEntity<?> getResponseEntity(ObjectNode objectNode) {
        JsonNode codeNode = objectNode.get("code");
        int nCode = 1;
        if (codeNode != null && codeNode.isNumber()) {
            nCode = codeNode.asInt();
        }
        if (2 == nCode) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body((Object)objectNode);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)objectNode);
    }
}

