/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.service;

import java.util.List;
import net.ibizsys.central.cloud.core.dataentity.service.DEServiceAPIRuntime;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIRequestMappingAdapter;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIRuntime;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.dataentity.service.IDEServiceAPIRSRuntime;
import net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime;
import net.ibizsys.central.service.SysServiceAPIRuntimeException;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.domain.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class SysServiceAPIRuntime
extends net.ibizsys.central.service.SysServiceAPIRuntime
implements ISysServiceAPIRuntime {
    private static final Log log = LogFactory.getLog(SysServiceAPIRuntime.class);
    private int nAPILevel = 3;
    private String strBaseUrl = null;
    private boolean bEnableAnonymousUser = false;

    protected void onInit() throws Exception {
        this.setAPILevel(this.getPSSysServiceAPI().getAPILevel());
        if (this.getAPILevel() < 0 || this.getAPILevel() > 4) {
            log.warn((Object)String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u63a5\u53e3\u8bbf\u95ee\u7ea7\u522b[%1$s]", this.getAPILevel()));
        }
        if (!StringUtils.hasLength((String)this.getBaseUrl())) {
            this.prepareBaseUrl();
        }
        if (this.getAPILevel() == 4 || !ObjectUtils.isEmpty((Object)this.getPSSysServiceAPI().getIgnoreAuthPatterns())) {
            this.setEnableAnonymousUser(true);
        }
        super.onInit();
        this.registerIgnoreAuthPatterns();
    }

    protected void registerIgnoreAuthPatterns() {
        String serviceUrl = this.getBaseUrl();
        if (!StringUtils.hasLength((String)serviceUrl)) {
            log.warn((Object)String.format("\u670d\u52a1\u63a5\u53e3[%1$s]\u57fa\u7840\u8def\u5f84\u65e0\u6548", new Object[0]));
            return;
        }
        if (this.getAPILevel() == 4) {
            serviceUrl = serviceUrl + "/**";
            ServiceHub.getInstance().registerIgnoreAuthPattern(serviceUrl);
            log.debug((Object)String.format("\u5ffd\u7565\u8ba4\u8bc1\u8def\u5f84[%s]", serviceUrl));
        } else {
            List list = this.getPSSysServiceAPI().getIgnoreAuthPatterns();
            if (!ObjectUtils.isEmpty((Object)list)) {
                for (String strPattern : list) {
                    String strFullPattern = serviceUrl + strPattern;
                    ServiceHub.getInstance().registerIgnoreAuthPattern(strFullPattern);
                    log.debug((Object)String.format("\u5ffd\u7565\u8ba4\u8bc1\u8def\u5f84[%s]", strFullPattern));
                }
            }
        }
    }

    protected IDEServiceAPIRuntime createDefaultDEServiceAPIRuntime() {
        return new DEServiceAPIRuntime();
    }

    public int getAPILevel() {
        return this.nAPILevel;
    }

    protected void setAPILevel(int nAPILevel) {
        this.nAPILevel = nAPILevel;
    }

    protected void prepareBaseUrl() throws Exception {
        this.setBaseUrl(String.format("/%1$s/%2$s", this.getSystemRuntime().getServiceId(), this.getPSSysServiceAPI().getServiceCodeName()).toLowerCase());
    }

    @Override
    public void registerMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        this.onRegisterMapping(iSysServiceAPIRequestMappingAdapter);
    }

    protected void onRegisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        iSysServiceAPIRequestMappingAdapter.registerMapping(this);
    }

    @Override
    public void unregisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        this.onUnregisterMapping(iSysServiceAPIRequestMappingAdapter);
    }

    protected void onUnregisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        iSysServiceAPIRequestMappingAdapter.unregisterMapping(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEMethod(String strScope, String strDataEntityName, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEMethod(strScope, strDataEntityName, strMethodName, objBody, strKey, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEMethod(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEMethod(strScope, strParentDEName, strParentKey, strDataEntityName, strMethodName, objBody, strKey, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEImportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEImportData(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEImportData2(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEImportData2(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEAsyncImportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEAsyncImportData(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEAsyncImportData2(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEAsyncImportData2(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objBody, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEGetImportTemplate(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEGetImportTemplate(strScope, strParentDEName, strParentKey, strDataEntityName, strImportTag, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, Object objBody, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, objBody, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, strMethodName, objBody, strKey, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEAsyncExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEAsyncExportData(strScope, strParentDEName, strParentKey, strDataEntityName, strExportTag, strMethodName, objBody, strKey, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEPrintData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strPrintTag, String strPrintType, Object objBody, String strKey, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEPrintData(strScope, strParentDEName, strParentKey, strDataEntityName, strPrintTag, strPrintType, objBody, strKey, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEReport(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strReportTag, String strReportType, Object objBody, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEReport(strScope, strParentDEName, strParentKey, strDataEntityName, strReportTag, strReportType, objBody, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEWFStart(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEWFStart(strScope, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEWFCancel(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEWFCancel(strScope, strParentDEName, strParentKey, strDataEntityName, strWFTag, objBody, strKey, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEDownloadFile(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEDownloadFile(strScope, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEUploadFile(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEUploadFile(strScope, strParentDEName, strParentKey, strDataEntityName, strKey, strStorageField, file, objBody, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeDEAutoComplete(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strACTag, String strMethodName, Object objBody, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            this.testAccessUser();
            Object object = super.invokeDEAutoComplete(strScope, strParentDEName, strParentKey, strDataEntityName, strACTag, strMethodName, objBody, objTag);
            return object;
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    @Override
    public Object invokeDEChatCompletion(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strACTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            IDEServiceAPIRuntime iDEServiceAPIRuntime;
            String strMinorDEServiceAPIName;
            this.testAccessUser();
            IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
            if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
                log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
                strDataEntityName = strMinorDEServiceAPIName;
            }
            if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
                throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
            }
            if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
                throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
            }
            if (iDEServiceAPIRuntime instanceof net.ibizsys.central.cloud.core.dataentity.service.IDEServiceAPIRuntime) {
                Object object = ((net.ibizsys.central.cloud.core.dataentity.service.IDEServiceAPIRuntime)iDEServiceAPIRuntime).chatCompletion(strScope, iDEServiceAPIRSRuntime, strParentKey, strACTag, strMethodName, objBody, strKey, objTag);
                return object;
            }
            throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", iDEServiceAPIRuntime.getName()));
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    @Override
    public Object invokeDEAsyncImportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, String strOSSFileId, String strImportSchemaId, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            IDEServiceAPIRuntime iDEServiceAPIRuntime;
            String strMinorDEServiceAPIName;
            this.testAccessUser();
            IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
            if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
                log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
                strDataEntityName = strMinorDEServiceAPIName;
            }
            if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
                throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
            }
            if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
                throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
            }
            if (iDEServiceAPIRuntime instanceof net.ibizsys.central.cloud.core.dataentity.service.IDEServiceAPIRuntime) {
                Object object = ((net.ibizsys.central.cloud.core.dataentity.service.IDEServiceAPIRuntime)iDEServiceAPIRuntime).asyncImportData(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, strOSSFileId, strImportSchemaId, objTag);
                return object;
            }
            throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", iDEServiceAPIRuntime.getName()));
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    @Override
    public Object invokeDEAsyncImportData2(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, String strOSSFileId, String strImportSchemaId, Object objTag) throws Throwable {
        IUserContext lastUserContext = this.prepareAccessUser();
        try {
            IDEServiceAPIRuntime iDEServiceAPIRuntime;
            String strMinorDEServiceAPIName;
            this.testAccessUser();
            IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
            if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
                log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
                strDataEntityName = strMinorDEServiceAPIName;
            }
            if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
                throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
            }
            if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
                throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
            }
            if (iDEServiceAPIRuntime instanceof net.ibizsys.central.cloud.core.dataentity.service.IDEServiceAPIRuntime) {
                Object object = ((net.ibizsys.central.cloud.core.dataentity.service.IDEServiceAPIRuntime)iDEServiceAPIRuntime).asyncImportData2(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, strOSSFileId, strImportSchemaId, objTag);
                return object;
            }
            throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", iDEServiceAPIRuntime.getName()));
        }
        finally {
            UserContext.setCurrent((IUserContext)lastUserContext);
        }
    }

    protected IUserContext prepareAccessUser() throws Throwable {
        Object pattern;
        RequestAttributes requestAttributes;
        IUserContext iUserContext = UserContext.getCurrent();
        if (this.isEnableAnonymousUser() && (requestAttributes = RequestContextHolder.getRequestAttributes()) != null && (pattern = requestAttributes.getAttribute("__IGNOREAUTHPATTERN__", 0)) != null) {
            UserContext.setCurrent((IUserContext)this.getSystemRuntime().createAnonymousUserContext());
        }
        return iUserContext;
    }

    protected void testAccessUser() throws Throwable {
        if (this.getAPILevel() == 0) {
            if (DataTypeUtils.getIntegerValue((Object)AuthenticationUser.getCurrentMust().getSuperuser(), (Integer)0) == 1 || DataTypeUtils.getIntegerValue((Object)AuthenticationUser.getCurrentMust().getApiuser(), (Integer)0) == 1) {
                return;
            }
            throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u4ec5\u5141\u8bb8\u6838\u5fc3\u7528\u6237\u8bbf\u95ee", new Object[0]), 2);
        }
        if (this.getAPILevel() == 1) {
            if (AuthenticationUser.getCurrentMust().getSuperuser() != 1) {
                throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u4ec5\u5141\u8bb8\u5e73\u53f0\u7ba1\u7406\u5458\u8bbf\u95ee", new Object[0]), 2);
            }
            return;
        }
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrentMust();
        if (this.getAPILevel() == 2) {
            if (!iEmployeeContext.isSuperuser()) {
                throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u4ec5\u5141\u8bb8\u673a\u6784\u7ba1\u7406\u5458\u8bbf\u95ee", new Object[0]), 2);
            }
            return;
        }
        if (this.getAPILevel() == 4) {
            if (!iEmployeeContext.isAnonymoususer()) {
                throw new SysServiceAPIRuntimeException((net.ibizsys.central.service.ISysServiceAPIRuntime)this, String.format("\u4ec5\u5141\u8bb8\u533f\u540d\u7528\u6237\u8bbf\u95ee", new Object[0]), 2);
            }
            return;
        }
    }

    @Override
    public String getBaseUrl() {
        return this.strBaseUrl;
    }

    protected void setBaseUrl(String strBaseUrl) {
        this.strBaseUrl = strBaseUrl;
    }

    @Override
    public boolean isEnableAnonymousUser() {
        return this.bEnableAnonymousUser;
    }

    protected void setEnableAnonymousUser(boolean bEnableAnonymousUser) {
        this.bEnableAnonymousUser = bEnableAnonymousUser;
    }
}

