/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.service;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIRequestMappingAdapter;
import net.ibizsys.central.cloud.core.service.SysServiceAPIRuntime;
import net.ibizsys.central.service.ISysServiceAPIRuntime;
import net.ibizsys.central.service.SysServiceAPIRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

@RestController
public class SysRestServiceAPIRuntimeBase
extends SysServiceAPIRuntime {
    private static final Log log = LogFactory.getLog(SysRestServiceAPIRuntimeBase.class);
    private Map<String, RequestMappingInfo> requestMappingInfoMap = new HashMap<String, RequestMappingInfo>();
    private SysRestServiceAPIRuntimeBase proxyObject = null;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    protected void prepareBaseUrl() throws Exception {
        RequestMapping requestMapping = this.getClass().getAnnotation(RequestMapping.class);
        if (requestMapping != null) {
            if (!ObjectUtils.isEmpty((Object[])requestMapping.path())) {
                this.setBaseUrl(requestMapping.path()[0]);
                return;
            }
            if (!ObjectUtils.isEmpty((Object[])requestMapping.value())) {
                this.setBaseUrl(requestMapping.value()[0]);
                return;
            }
        }
        super.prepareBaseUrl();
    }

    private SysRestServiceAPIRuntimeBase getSelf() {
        return this;
    }

    protected SysRestServiceAPIRuntimeBase getProxyObject() {
        return this.getProxyObject(false);
    }

    protected SysRestServiceAPIRuntimeBase getProxyObject(boolean bTryMode) {
        if (this.proxyObject != null || bTryMode) {
            return this.proxyObject;
        }
        throw new SysServiceAPIRuntimeException((ISysServiceAPIRuntime)this, String.format("\u4ee3\u7406\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setProxyObject(SysRestServiceAPIRuntimeBase proxyObject) {
        this.proxyObject = proxyObject;
    }

    protected void prepareProxyObject() throws Exception {
        MethodInterceptor methodInterceptor = new MethodInterceptor(){

            public Object intercept(Object o, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
                RequestMappingInfo requestMappingInfo = (RequestMappingInfo)SysRestServiceAPIRuntimeBase.this.requestMappingInfoMap.get(method.getName());
                if (requestMappingInfo == null) {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method.invoke((Object)SysRestServiceAPIRuntimeBase.this.getSelf(), args);
                }
                SysRestServiceAPIRuntimeBase.this.testAccessUser();
                try {
                    return method.invoke((Object)SysRestServiceAPIRuntimeBase.this.getSelf(), args);
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u6267\u884c\u65b9\u6cd5[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", method.getName(), ex.getMessage()), ex);
                    throw ex;
                }
            }
        };
        this.setProxyObject((SysRestServiceAPIRuntimeBase)Enhancer.create(this.getClass(), (Callback)methodInterceptor));
    }

    @Override
    protected void onRegisterMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter) throws Exception {
        super.onRegisterMapping(iSysServiceAPIRequestMappingAdapter);
        if (this.getProxyObject(true) == null) {
            this.prepareProxyObject();
        }
        this.registerMapping(iSysServiceAPIRequestMappingAdapter, this.getClass());
    }

    protected void registerMapping(ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter, Class<?> cls) throws Exception {
        Object[] methods = cls.getMethods();
        if (ObjectUtils.isEmpty((Object[])methods)) {
            return;
        }
        for (Object method : methods) {
            RequestMappingInfo requestMappingInfo = iSysServiceAPIRequestMappingAdapter.registerMapping(this, this.getProxyObject(), (Method)method);
            if (requestMappingInfo == null) continue;
            this.requestMappingInfoMap.put(((Method)method).getName(), requestMappingInfo);
        }
    }
}

