/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.service.SubSysServiceAPIDERuntime;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.service.IPSSubSysServiceAPIDEMethod;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;

public abstract class SubSysRestServiceAPIDERuntimeBase
extends SubSysServiceAPIDERuntime {
    private static final Log log = LogFactory.getLog(SubSysRestServiceAPIDERuntimeBase.class);
    public static final String PAGE_TOTAL = "total";
    public static final String PAGE_CONTENT = "content";

    protected Object onInvokeMethod(IPSSubSysServiceAPIDEMethod iPSSubSysServiceAPIDEMethod, Map<String, Object> context, IDataEntityRuntime iDataEntityRuntime, IPSDEAction iPSDEAction, Object[] args) throws Throwable {
        Object ret = super.onInvokeMethod(iPSSubSysServiceAPIDEMethod, context, iDataEntityRuntime, iPSDEAction, args);
        if (ret instanceof IWebClientRep) {
            Object body = ((IWebClientRep)ret).getBody();
            if (ObjectUtils.isEmpty((Object)body) || iDataEntityRuntime == null || iPSDEAction == null) {
                return body;
            }
            String strRetType = iPSDEAction.getPSDEActionReturnMust().getType();
            if (PSModelEnums.DEMethodReturnType.VOID.value.equals(strRetType)) {
                IPSDEMethodDTO iPSDEMethodDTO = iDataEntityRuntime.getDefaultPSDEMethodDTO();
                if (iPSDEMethodDTO != null) {
                    Map map = JsonUtils.asMap((Object)body);
                    return iDataEntityRuntime.getDEMethodDTO(iPSDEMethodDTO, (Object)map, this.isDTOData());
                }
                return null;
            }
            if (PSModelEnums.DEMethodReturnType.DTO.value.equals(strRetType)) {
                IPSDEMethodDTO iPSDEMethodDTO = iPSDEAction.getPSDEActionReturnMust().getPSDEMethodDTOMust();
                Map map = JsonUtils.asMap((Object)body);
                return iDataEntityRuntime.getDEMethodDTO(iPSDEMethodDTO, (Object)map, this.isDTOData());
            }
            if (PSModelEnums.DEMethodReturnType.DTOS.value.equals(strRetType)) {
                ArrayList<IEntityDTO> entityList = new ArrayList<IEntityDTO>();
                List list = JsonUtils.asList((Object)body);
                if (!ObjectUtils.isEmpty((Object)list)) {
                    IPSDEMethodDTO iPSDEMethodDTO = iPSDEAction.getPSDEActionReturnMust().getPSDEMethodDTOMust();
                    for (Object map : list) {
                        IEntityDTO iEntityDTO = (IEntityDTO)iDataEntityRuntime.getDEMethodDTO(iPSDEMethodDTO, map, this.isDTOData());
                        entityList.add(iEntityDTO);
                    }
                }
                return entityList;
            }
            if (PSModelEnums.DEMethodReturnType.SIMPLE.value.equals(strRetType)) {
                return DataTypeUtils.parse((int)iPSDEAction.getPSDEActionReturnMust().getStdDataType(), (String)body.toString());
            }
            if (PSModelEnums.DEMethodReturnType.SIMPLES.value.equals(strRetType)) {
                ArrayList<Object> valueList = new ArrayList<Object>();
                List list = JsonUtils.asList((Object)body);
                if (!ObjectUtils.isEmpty((Object)list)) {
                    for (Object item : list) {
                        if (item != null) {
                            Object value = DataTypeUtils.parse((int)iPSDEAction.getPSDEActionReturnMust().getStdDataType(), (String)item.toString());
                            valueList.add(value);
                            continue;
                        }
                        valueList.add(null);
                    }
                }
                return valueList;
            }
            return body;
        }
        return ret;
    }

    protected Object onInvokeMethod(IPSSubSysServiceAPIDEMethod iPSSubSysServiceAPIDEMethod, Map<String, Object> context, IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, Object[] args) throws Throwable {
        Object ret = super.onInvokeMethod(iPSSubSysServiceAPIDEMethod, context, iDataEntityRuntime, iPSDEDataSet, args);
        if (ret instanceof IWebClientRep) {
            IWebClientRep rep = (IWebClientRep)ret;
            Object body = rep.getBody();
            if (ObjectUtils.isEmpty((Object)body) || iDataEntityRuntime == null || iPSDEDataSet == null) {
                return body;
            }
            String strRetType = iPSDEDataSet.getPSDEDataSetReturnMust().getType();
            if (PSModelEnums.DEMethodReturnType.PAGE.value.equals(strRetType) || PSModelEnums.DEMethodReturnType.DTOS.value.equals(strRetType)) {
                long total = -1L;
                ArrayNode listNode = null;
                JsonNode jsonNode = JsonUtils.toJsonNode((Object)body);
                if (jsonNode instanceof ArrayNode) {
                    listNode = (ArrayNode)jsonNode;
                    total = DataTypeUtils.getIntegerValue((Object)rep.getHeader("x-total"), (Integer)0).intValue();
                } else if (jsonNode instanceof ObjectNode) {
                    JsonNode node;
                    ObjectNode objectNode = (ObjectNode)jsonNode;
                    if (objectNode.has(PAGE_TOTAL)) {
                        total = objectNode.get(PAGE_TOTAL).asLong(-1L);
                    }
                    if (objectNode.has(PAGE_CONTENT) && (node = objectNode.get(PAGE_CONTENT)) instanceof ArrayNode) {
                        listNode = (ArrayNode)node;
                    }
                }
                if (listNode != null) {
                    ArrayList<IEntityDTO> entityDTOList = new ArrayList<IEntityDTO>();
                    IPSDEMethodDTO iPSDEMethodDTO = iPSDEDataSet.getPSDEDataSetReturnMust().getPSDEMethodDTOMust();
                    for (JsonNode node : listNode) {
                        IEntityDTO iEntityDTO = (IEntityDTO)iDataEntityRuntime.getDEMethodDTO(iPSDEMethodDTO, (Object)JsonUtils.asMap((Object)node), this.isDTOData());
                        entityDTOList.add(iEntityDTO);
                    }
                    if (PSModelEnums.DEMethodReturnType.PAGE.value.equals(strRetType)) {
                        if (total <= 0L) {
                            total = entityDTOList.size();
                        }
                        if (args.length > 0 && args[0] instanceof ISearchContext) {
                            return new PageImpl(entityDTOList, ((ISearchContext)args[0]).getPageable(), total);
                        }
                        return new PageImpl(entityDTOList, Pageable.unpaged(), total);
                    }
                    if (PSModelEnums.DEMethodReturnType.DTOS.value.equals(strRetType)) {
                        return entityDTOList;
                    }
                }
                return body;
            }
            return body;
        }
        return ret;
    }

    protected boolean isDTOData() {
        return true;
    }
}

