/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.Version;
import net.ibizsys.central.cloud.core.IServiceSystemRuntime;
import net.ibizsys.central.cloud.core.dataentity.security.DataEntityAccessManager;
import net.ibizsys.central.cloud.core.dataentity.security.IDataEntityAccessManager;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.security.ISystemAccessManager;
import net.ibizsys.central.cloud.core.security.SysUserRoleRuntime;
import net.ibizsys.central.cloud.core.security.UAARoleAuthority;
import net.ibizsys.central.cloud.core.security.UAAUniResAuthority;
import net.ibizsys.central.cloud.core.sysutil.ISysUAAUtilRuntime;
import net.ibizsys.central.cloud.core.util.CloudCacheTagUtils;
import net.ibizsys.central.cloud.core.util.domain.AppData;
import net.ibizsys.central.cloud.core.util.domain.V2DeploySystem;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.security.ISysUserRoleRuntime;
import net.ibizsys.model.res.IPSSysLogic;
import net.ibizsys.model.security.IPSSysUserRole;
import net.ibizsys.model.security.IPSSysUserRoleRes;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.res.ISysLogicRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.script.IScriptEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SystemAccessManager
extends net.ibizsys.central.security.SystemAccessManager
implements ISystemAccessManager {
    private static final Log log = LogFactory.getLog(SystemAccessManager.class);
    private ISysUAAUtilRuntime iSysUAAUtilRuntime = null;
    private ISysLogicRuntime fillAppDataSysLogicRuntime = null;
    private boolean bCalcFillAppDataSysLogicRuntime = false;
    private Map<String, Object> appDataCtxMap = null;
    private Map<String, Object> appDataMap = null;
    private IServiceSystemRuntime iServiceSystemRuntime = null;

    protected void onInit() throws Exception {
        if (this.getSystemRuntime() instanceof IServiceSystemRuntime) {
            this.iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
        }
        super.onInit();
        this.prepareSysCacheUtilRuntime();
        this.appDataCtxMap = this.getSystemRuntime().getSystemRuntimeSetting().getParams("appdatactx", null);
        this.appDataMap = this.getSystemRuntime().getSystemRuntimeSetting().getParams("appdata", null);
    }

    protected Map<String, Object> getAppDataCtxMap() {
        return this.appDataCtxMap;
    }

    protected Map<String, Object> getAppDataMap() {
        return this.appDataMap;
    }

    protected ISysUAAUtilRuntime getSysUAAUtilRuntime() {
        if (this.iSysUAAUtilRuntime == null) {
            this.iSysUAAUtilRuntime = (ISysUAAUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysUAAUtilRuntime.class, false);
        }
        return this.iSysUAAUtilRuntime;
    }

    protected IServiceSystemRuntime getServiceSystemRuntime(boolean bTryMode) throws Exception {
        if (this.iServiceSystemRuntime != null || bTryMode) {
            return this.iServiceSystemRuntime;
        }
        throw new Exception("\u672a\u6307\u5b9a\u670d\u52a1\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61");
    }

    protected ISysUserRoleRuntime createSysUserRoleRuntime(IPSSysUserRole iPSSysUserRole) {
        if (iPSSysUserRole.getPSSysSFPlugin() != null) {
            return (ISysUserRoleRuntime)this.getSystemRuntime().getRuntimeObject(iPSSysUserRole.getPSSysSFPlugin(), ISysUserRoleRuntime.class, true);
        }
        return this.createDefaultSysUserRoleRuntime();
    }

    protected ISysUserRoleRuntime createDefaultSysUserRoleRuntime() {
        return new SysUserRoleRuntime();
    }

    public IDataEntityAccessManager createDataEntityAccessManager(IDataEntityRuntime iDataEntityRuntime) {
        return new DataEntityAccessManager();
    }

    @Override
    public AppData getAppData(String strSystemTag, String strOrgId) {
        try {
            return this.onGetAppData(strSystemTag, strOrgId);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5e94\u7528\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public AppData getAppData(String strDCSystemTag) {
        try {
            return this.onGetAppData(strDCSystemTag);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5e94\u7528\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected AppData onGetAppData(String strDCSystemTag) throws Throwable {
        AppData appData = this.getSysUAAUtilRuntime().getAppData(strDCSystemTag);
        String strSystemTag = null;
        String strOrgId = null;
        if (appData.getContext() != null) {
            strSystemTag = (String)appData.getContext().get("srfsystemid");
            strOrgId = (String)appData.getContext().get("srforgid");
        }
        return this.onGetAppData(appData, strSystemTag, strOrgId);
    }

    protected AppData onGetAppData(String strSystemTag, String strOrgId) throws Throwable {
        return this.onGetAppData(null, strSystemTag, strOrgId);
    }

    protected AppData onGetAppData(AppData appData, String strSystemTag, String strOrgId) throws Throwable {
        V2DeploySystem v2DeploySystem;
        IServiceSystemRuntime iServiceSystemRuntime;
        Map<String, Object> ctx;
        if (appData == null) {
            appData = this.getSysUAAUtilRuntime().getAppData(strSystemTag, strOrgId);
        }
        appData.set("version", Version.toVersionString());
        IEmployeeContext iEmployeeContext = this.getSysUAAUtilRuntime().getEmployeeContext(strSystemTag, strOrgId, true);
        Collection<? extends GrantedAuthority> grantedAuthorities = iEmployeeContext.getAuthorities();
        if (AuthenticationUser.getCurrentMust().getSuperuser() == 1 || iEmployeeContext.isSuperuser()) {
            appData.set("enablepermissionvalid", false);
        } else {
            List<ISysUserRoleRuntime> iSysUserRoleRuntimes;
            appData.set("enablepermissionvalid", true);
            HashSet<String> uniRes = new HashSet<String>();
            appData.set("unires", uniRes);
            if (!ObjectUtils.isEmpty(grantedAuthorities)) {
                for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                    if (!(grantedAuthority instanceof UAAUniResAuthority)) continue;
                    uniRes.add(grantedAuthority.getAuthority());
                }
            }
            if (!ObjectUtils.isEmpty(iSysUserRoleRuntimes = this.getSysUserRoleRuntimes(iEmployeeContext))) {
                for (ISysUserRoleRuntime iSysUserRoleRuntime : iSysUserRoleRuntimes) {
                    if (iSysUserRoleRuntime.getPSSysUserRole() == null || iSysUserRoleRuntime.getPSSysUserRole().getPSSysUserRoleReses() == null) continue;
                    for (IPSSysUserRoleRes iPSSysUserRoleRes : iSysUserRoleRuntime.getPSSysUserRole().getPSSysUserRoleReses()) {
                        uniRes.add(iPSSysUserRoleRes.getSysUniResCode());
                    }
                }
            }
        }
        Map<String, Object> data = this.getAppDataMap();
        if (data != null) {
            appData.putAll(data);
        }
        if ((ctx = this.getAppDataCtxMap()) != null) {
            if (appData.getContext() == null) {
                appData.setContext(new Entity());
            }
            appData.getContext().putAll(ctx);
        }
        if ((iServiceSystemRuntime = this.getServiceSystemRuntime(true)) != null && (v2DeploySystem = iServiceSystemRuntime.getV2DeploySystem()) != null) {
            if (StringUtils.hasLength((String)v2DeploySystem.getProductId())) {
                appData.getContext().set("srfv2productid", (Object)v2DeploySystem.getProductId());
            }
            if (StringUtils.hasLength((String)v2DeploySystem.getSystemId())) {
                appData.getContext().set("srfv2systemid", (Object)v2DeploySystem.getSystemId());
            }
        }
        this.onFillAppData(appData);
        return appData;
    }

    protected void onFillAppData(AppData appData) throws Throwable {
        ISysLogicRuntime iSysLogicRuntime = this.getFillAppDataSysLogicRuntime();
        if (iSysLogicRuntime != null) {
            try {
                IScriptEntity appScriptEntity = this.getSystemRuntime().createScriptEntity((IEntity)appData);
                IScriptEntity ctxScriptEntity = this.getSystemRuntime().createScriptEntity((IEntity)appData.getContext());
                Entity session = new Entity();
                IScriptEntity sessionScriptEntity = this.getSystemRuntime().createScriptEntity((IEntity)session);
                iSysLogicRuntime.execute(new Object[]{appScriptEntity, ctxScriptEntity, sessionScriptEntity});
                Map sessionParams = session.any();
                if (!ObjectUtils.isEmpty((Object)sessionParams)) {
                    this.getSysUAAUtilRuntime().updateCurrentEmployeeSession(sessionParams);
                }
            }
            catch (Throwable ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u9644\u52a0\u586b\u5145\u4e0a\u4e0b\u6587\u903b\u8f91\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
    }

    protected ISysLogicRuntime getFillAppDataSysLogicRuntime() {
        if (!this.bCalcFillAppDataSysLogicRuntime) {
            this.fillAppDataSysLogicRuntime = this.onGetFillAppDataSysLogicRuntime();
            this.bCalcFillAppDataSysLogicRuntime = true;
        }
        return this.fillAppDataSysLogicRuntime;
    }

    protected ISysLogicRuntime onGetFillAppDataSysLogicRuntime() {
        IPSSysLogic iPSSysLogic = this.getSystemRuntimeContext().getSystemRuntime().getPSSysLogic("SRFFILLAPPDATA");
        if (iPSSysLogic != null) {
            return this.getSystemRuntimeContext().getSystemRuntime().getSysLogicRuntime(iPSSysLogic);
        }
        return null;
    }

    public List<ISysUserRoleRuntime> getSysUserRoleRuntimes(IUserContext iUserContext) {
        IEmployeeContext iEmployeeContext = (IEmployeeContext)iUserContext;
        ArrayList<ISysUserRoleRuntime> assignSysUserRoleRuntimeList = new ArrayList<ISysUserRoleRuntime>();
        if (!ObjectUtils.isEmpty(iEmployeeContext.getAuthorities())) {
            for (GrantedAuthority grantedAuthority : iEmployeeContext.getAuthorities()) {
                ISysUserRoleRuntime iSysUserRoleRuntime;
                if (!(grantedAuthority instanceof UAARoleAuthority) || (iSysUserRoleRuntime = this.getSysUserRoleRuntime(grantedAuthority.getAuthority(), true)) == null) continue;
                assignSysUserRoleRuntimeList.add(iSysUserRoleRuntime);
            }
        }
        IAuthenticationUser iAuthenticationUser = AuthenticationUser.getCurrent();
        List list = this.getTestSysUserRoleRuntimes();
        if (!ObjectUtils.isEmpty((Object)list) && iAuthenticationUser != null) {
            LinkedHashMap<String, String> map = (LinkedHashMap<String, String>)this.getSysCacheUtilRuntime().get(CloudCacheTagUtils.getAuthenticationUserCat(iAuthenticationUser.getUsername(), iAuthenticationUser.getToken()), CloudCacheTagUtils.getUserDynaRolesTag(iEmployeeContext.getDcsystemid()), Map.class);
            if (map == null) {
                map = new LinkedHashMap<String, String>();
                for (ISysUserRoleRuntime iSysUserRoleRuntime : this.getTestSysUserRoleRuntimes()) {
                    if (!iSysUserRoleRuntime.testUser(iUserContext)) continue;
                    map.put(iSysUserRoleRuntime.getRoleTag(), "");
                }
                this.getSysCacheUtilRuntime().set(CloudCacheTagUtils.getAuthenticationUserCat(iAuthenticationUser.getUsername(), iAuthenticationUser.getToken()), CloudCacheTagUtils.getUserDynaRolesTag(iEmployeeContext.getDcsystemid()), map);
            }
            for (Object roleTag : map.keySet()) {
                ISysUserRoleRuntime iSysUserRoleRuntime = this.getSysUserRoleRuntime((String)roleTag, true);
                if (iSysUserRoleRuntime == null || assignSysUserRoleRuntimeList.contains(iSysUserRoleRuntime)) continue;
                assignSysUserRoleRuntimeList.add(iSysUserRoleRuntime);
            }
        }
        return assignSysUserRoleRuntimeList;
    }

    public boolean testSysUniRes(IUserContext iUserContext, String strSysUniRes, IEntity iEntity) throws Exception {
        IEmployeeContext iEmployeeContext;
        Collection<? extends GrantedAuthority> grantedAuthorities;
        if (this.testSuperuser(iUserContext)) {
            return true;
        }
        if (iUserContext instanceof IEmployeeContext && !ObjectUtils.isEmpty(grantedAuthorities = (iEmployeeContext = (IEmployeeContext)iUserContext).getAuthorities())) {
            for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                if (!(grantedAuthority instanceof UAAUniResAuthority) || grantedAuthority.getAuthority() == null || !grantedAuthority.getAuthority().equals(strSysUniRes)) continue;
                return true;
            }
        }
        return super.testSysUniRes(iUserContext, strSysUniRes, iEntity);
    }

    protected boolean testSuperuser(IUserContext iUserContext) {
        return iUserContext.isSuperuser();
    }
}

