/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.eai;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.eai.SysEAIAgentRuntimeBase;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.sysutil.ISysAIUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysPortalUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionRequest;
import net.ibizsys.central.cloud.core.util.domain.ChatCompletionResult;
import net.ibizsys.central.cloud.core.util.domain.ChatMessage;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncAction;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncActionState;
import net.ibizsys.runtime.dataentity.datasync.IDEDataSyncInRuntime;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.domain.DataSyncIn;
import net.ibizsys.runtime.util.domain.DataSyncOut;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SysAIAgentRuntime
extends SysEAIAgentRuntimeBase {
    private static final Log log = LogFactory.getLog(SysAIAgentRuntime.class);
    public static final String AITYPE_DEFAULT = "DEFAULT";
    private ISysAIUtilRuntime iSysAIUtilRuntime = null;
    private ISysPortalUtilRuntime iSysPortalUtilRuntime = null;
    public static final String PARAM_REQUEST = "_request";
    public static final String PARAM_ACTION = "_action";
    public static final String PARAM_RESULT = "_result";

    protected ISysAIUtilRuntime getSysAIUtilRuntime() {
        if (this.iSysAIUtilRuntime == null) {
            this.iSysAIUtilRuntime = (ISysAIUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysAIUtilRuntime.class, false);
        }
        return this.iSysAIUtilRuntime;
    }

    protected ISysPortalUtilRuntime getSysPortalUtilRuntime() {
        if (this.iSysPortalUtilRuntime == null) {
            this.iSysPortalUtilRuntime = (ISysPortalUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysPortalUtilRuntime.class, false);
        }
        return this.iSysPortalUtilRuntime;
    }

    public boolean isRawDataMode() {
        return true;
    }

    protected void onSend(String strSendData, DataSyncOut[] dataSyncOuts) throws Throwable {
        Map data = this.getRecvDataMap(strSendData);
        Object request = data.get(PARAM_REQUEST);
        Map requestMap = null;
        if (!(request instanceof Map)) {
            throw new Exception("\u672a\u4f20\u5165\u8bf7\u6c42\u53c2\u6570");
        }
        requestMap = (Map)request;
        ArrayList<ChatMessage> messageList = new ArrayList<ChatMessage>();
        Object list = requestMap.get("messages");
        if (list instanceof List) {
            for (Object item : (List)list) {
                messageList.add(this.getChatMessage(item));
            }
        }
        if (ObjectUtils.isEmpty(messageList)) {
            throw new Exception(String.format("\u672a\u6307\u5b9a\u6d88\u606f\u5217\u8868", new Object[0]));
        }
        Object sessionId = requestMap.get("sessionid");
        String strSessionId = null;
        if (sessionId instanceof String) {
            strSessionId = (String)sessionId;
        }
        if (!StringUtils.hasLength(strSessionId)) {
            strSessionId = EmployeeContext.getCurrent() != null ? String.format("%1$s_%2$s_%3$s", EmployeeContext.getCurrent().getTenant(), EmployeeContext.getCurrent().getSystemid(), EmployeeContext.getCurrent().getUaausername()) : (AuthenticationUser.getCurrent() != null ? String.format("%1$s", AuthenticationUser.getCurrent().getUsername()) : KeyValueUtils.genGuidEx());
        }
        ChatCompletionRequest chatCompletionRequest = new ChatCompletionRequest();
        chatCompletionRequest.setMessages(messageList);
        chatCompletionRequest.setSessionId(strSessionId);
        this.getSystemRuntime().log(10000, this.getLogCat(), String.format("AI\u4ea4\u4e92\u8865\u5168\u8bf7\u6c42\uff1a\r\n\r\n%1$s", this.getSystemRuntime().serialize((Object)chatCompletionRequest)), null);
        PortalAsyncAction portalAsyncAction = this.getSysAIUtilRuntime().asyncChatCompletion(AITYPE_DEFAULT, chatCompletionRequest);
        this.threadMonitor(portalAsyncAction, data, true);
    }

    protected void threadMonitor(final PortalAsyncAction portalAsyncAction, final Map<String, Object> data, boolean bTimerOnly) {
        if (!bTimerOnly) {
            PortalAsyncAction action = null;
            try {
                action = this.getSysPortalUtilRuntime().getAsyncAction(portalAsyncAction.getAsyncAcitonId());
            }
            catch (Throwable ex) {
                this.getSystemRuntime().log(40000, this.getLogCat(), String.format("\u68c0\u67e5\u5f02\u6b65\u64cd\u4f5c\u72b6\u6001[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", portalAsyncAction.getAsyncAcitonId(), ex.getMessage()), null);
                action = new PortalAsyncAction();
                action.setActionState(PortalAsyncActionState.FAILED.getValue());
                action.setActionResult(ex.getMessage());
            }
            int nActionState = DataTypeUtils.asInteger((Object)action.getActionState(), (Integer)PortalAsyncActionState.EXECUTING.getValue());
            if (nActionState == PortalAsyncActionState.FAILED.getValue() || nActionState == PortalAsyncActionState.FINISHED.getValue()) {
                data.put(PARAM_ACTION, (Object)action);
                if (nActionState == PortalAsyncActionState.FINISHED.getValue()) {
                    String strResult = action.getActionResult();
                    if (StringUtils.hasLength((String)strResult)) {
                        ChatCompletionResult chatCompletionResult = (ChatCompletionResult)((Object)this.getSystemRuntime().deserialize((Object)strResult, ChatCompletionResult.class));
                        data.put(PARAM_RESULT, (Object)chatCompletionResult);
                    }
                    this.getSystemRuntime().log(10000, this.getLogCat(), String.format("AI\u4ea4\u4e92\u8865\u5168\u8fd4\u56de\uff1a\r\n\r\n%1$s", action.getActionResult()), null);
                } else {
                    this.getSystemRuntime().log(40000, this.getLogCat(), String.format("AI\u4ea4\u4e92\u8865\u5168\u53d1\u751f\u9519\u8bef\uff1a\r\n\r\n%1$s", action.getActionResult()), null);
                }
                List list = this.getDEDataSyncInRuntimeList();
                if (list == null || list.size() == 0) {
                    return;
                }
                for (IDEDataSyncInRuntime iDEDataSyncInRuntime : list) {
                    try {
                        String strData = this.serializeSendData(data);
                        DataSyncIn dataSyncIn = new DataSyncIn();
                        dataSyncIn.setData(strData);
                        dataSyncIn.setEventType(Integer.valueOf(iDEDataSyncInRuntime.getPSDEDataSync().getEventType()));
                        iDEDataSyncInRuntime.recv(new DataSyncIn[]{dataSyncIn});
                    }
                    catch (Throwable ex) {
                        this.getSystemRuntime().log(40000, this.getLogCat(), String.format("\u5904\u7406\u6570\u636e\u63a5\u6536[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDEDataSyncInRuntime.getName(), portalAsyncAction.getAsyncAcitonId(), ex.getMessage()), null);
                    }
                }
                return;
            }
        }
        this.getSystemRuntime().threadRun(new Runnable(){

            @Override
            public void run() {
                SysAIAgentRuntime.this.threadMonitor(portalAsyncAction, data, false);
            }
        }, 2000L);
    }

    protected ChatMessage getChatMessage(Object item) throws Throwable {
        if (item instanceof ChatMessage) {
            return (ChatMessage)((Object)item);
        }
        if (item instanceof IEntity) {
            ChatMessage chatMessage = new ChatMessage();
            ((IEntity)item).copyTo((IEntity)chatMessage);
            return chatMessage;
        }
        if (item instanceof Map) {
            ChatMessage chatMessage = new ChatMessage();
            Map map = (Map)item;
            for (Object key : map.keySet()) {
                if (ObjectUtils.isEmpty(key)) continue;
                chatMessage.set(key.toString(), map.get(key));
            }
            return chatMessage;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u5c06\u5bf9\u8c61[%1$s]\u8f6c\u6362\u81f3ChatMessage", item));
    }

    protected String getLogCat() {
        return "SYSAIAGENT";
    }
}

