/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity.security.dr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.security.dr.DataEntityDRProviderBase;
import net.ibizsys.central.util.SearchGroupCond;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQFieldCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQGroupCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeCond;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.SearchCustomCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DataSetDRProvider
extends DataEntityDRProviderBase {
    private static final Log log = LogFactory.getLog(DataSetDRProvider.class);

    public boolean support(IPSDEUserRole iPSDEUserRole) {
        return iPSDEUserRole.getPSDEDataSet() != null;
    }

    public List<ISearchCond> getDRSearchConds(IDataEntityRuntime iDataEntityRuntime, IPSDEUserRole iPSDEUserRole, String action) {
        try {
            return this.onGetDRSearchConds(iDataEntityRuntime, iPSDEUserRole, action);
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u83b7\u53d6\u5b9e\u4f53[%1$s]\u89d2\u8272[%2$s]\u6570\u636e\u8303\u56f4\u6761\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%3$s", iDataEntityRuntime.getName(), iPSDEUserRole.getName(), ex.getMessage()), ex);
        }
    }

    protected List<ISearchCond> onGetDRSearchConds(IDataEntityRuntime iDataEntityRuntime, IPSDEUserRole iPSDEUserRole, String action) throws Throwable {
        ArrayList<ISearchCond> searchConds = new ArrayList<ISearchCond>();
        IPSDEDataSet iPSDEDataSet = iPSDEUserRole.getPSDEDataSetMust();
        if (ObjectUtils.isEmpty((Object)iPSDEDataSet.getPSDEDataQueries())) {
            throw new Exception(String.format("\u6570\u636e\u96c6[%1$s]\u672a\u5305\u542b\u67e5\u8be2\u6a21\u578b", iPSDEDataSet.getName()));
        }
        List psDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
        SearchGroupCond orSearchGroupCond = null;
        if (iPSDEDataSet.getPSDEDataQueries().size() > 1) {
            orSearchGroupCond = new SearchGroupCond();
            orSearchGroupCond.setCondOp("OR");
        }
        block0: for (IPSDEDataQuery iPSDEDataQuery : psDEDataQueryList) {
            if (this.isEnableCustomCondMode(iDataEntityRuntime, iPSDEDataQuery)) {
                String strDBType = iDataEntityRuntime.getSysDBSchemeRuntimeMust().getDBType();
                List iPSDEDataQueryCodes = iPSDEDataQuery.getAllPSDEDataQueryCodes();
                if (iPSDEDataQueryCodes == null) continue;
                for (IPSDEDataQueryCode iPSDEDataQueryCode : iPSDEDataQueryCodes) {
                    if (!strDBType.equals(iPSDEDataQueryCode.getDBType())) continue;
                    List iPSDEDataQueryCodeConds = iPSDEDataQueryCode.getPSDEDataQueryCodeConds();
                    if (ObjectUtils.isEmpty((Object)iPSDEDataQueryCodeConds)) continue block0;
                    String strCustomCond = "";
                    for (int i = 0; i < iPSDEDataQueryCodeConds.size(); ++i) {
                        IPSDEDataQueryCodeCond psdeDataQueryCodeCond = (IPSDEDataQueryCodeCond)iPSDEDataQueryCodeConds.get(i);
                        if (i > 0) {
                            strCustomCond = strCustomCond + " AND ";
                        }
                        strCustomCond = strCustomCond + psdeDataQueryCodeCond.getCustomCond();
                    }
                    SearchCustomCond customCond = new SearchCustomCond();
                    customCond.setCustomCond(strCustomCond);
                    if (orSearchGroupCond != null) {
                        orSearchGroupCond.getSearchCondsIf().add(customCond);
                        continue block0;
                    }
                    searchConds.add((ISearchCond)customCond);
                    continue block0;
                }
                continue;
            }
            IPSDEDQGroupCondition iPSDEDQGroupCondition = iPSDEDataQuery.getPSDEDQMainMust().getPSDEDQGroupCondition();
            if (iPSDEDQGroupCondition == null) {
                throw new Exception(String.format("\u6570\u636e\u67e5\u8be2[%1$s]\u672a\u5305\u542b\u8fc7\u6ee4\u6761\u4ef6", iPSDEDataQuery.getName()));
            }
            ISearchCond iSearchCond = this.getSearchCond(iDataEntityRuntime, (IPSDEDQCondition)iPSDEDQGroupCondition, null);
            if (iSearchCond == null) continue;
            if (orSearchGroupCond != null) {
                orSearchGroupCond.getSearchCondsIf().add(iSearchCond);
                continue;
            }
            searchConds.add(iSearchCond);
        }
        if (orSearchGroupCond != null && !ObjectUtils.isEmpty((Object)orSearchGroupCond.getSearchConds())) {
            searchConds.add((ISearchCond)orSearchGroupCond);
        }
        return searchConds;
    }

    protected boolean isEnableCustomCondMode(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery) {
        if (iPSDEDataQuery.isCustomCode()) {
            return true;
        }
        return iDataEntityRuntime.getSysDBSchemeRuntime() != null && !iDataEntityRuntime.isEnableDEMapping();
    }

    protected ISearchCond getSearchCond(IDataEntityRuntime iDataEntityRuntime, IPSDEDQCondition iPSDEDQCondition, Map<String, Object> params) throws Exception {
        if (iPSDEDQCondition instanceof IPSDEDQGroupCondition) {
            ArrayList<ISearchCond> list = new ArrayList<ISearchCond>();
            IPSDEDQGroupCondition iPSDEDQGroupCondition = (IPSDEDQGroupCondition)iPSDEDQCondition;
            List psDEDQConditions = iPSDEDQGroupCondition.getPSDEDQConditions();
            if (psDEDQConditions != null) {
                for (IPSDEDQCondition item : psDEDQConditions) {
                    ISearchCond iSearchCond = this.getSearchCond(iDataEntityRuntime, item, params);
                    if (iSearchCond == null) continue;
                    list.add(iSearchCond);
                }
            }
            if (list.size() > 0) {
                SearchGroupCond searchGroupCond = new SearchGroupCond();
                if (iPSDEDQGroupCondition.isNotMode()) {
                    searchGroupCond.setNotMode(true);
                }
                searchGroupCond.setCondOp(iPSDEDQGroupCondition.getCondOp());
                searchGroupCond.getSearchCondsIf().addAll(list);
                return searchGroupCond;
            }
            return null;
        }
        if (iPSDEDQCondition instanceof IPSDEDQFieldCondition) {
            IPSDEDQFieldCondition iPSDEDQFieldCondition = (IPSDEDQFieldCondition)iPSDEDQCondition;
            String strVarType = iPSDEDQFieldCondition.getPSVARTypeId();
            if (StringUtils.hasLength((String)strVarType)) {
                if ("SESSIONCONTEXT".equalsIgnoreCase(strVarType)) {
                    Object objValue = null;
                    if (StringUtils.hasLength((String)iPSDEDQFieldCondition.getCondValue())) {
                        objValue = EmployeeContext.getCurrentMust().getSessionParam(iPSDEDQFieldCondition.getCondValue().toLowerCase());
                    }
                    return this.getSearchCond(iDataEntityRuntime, iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue);
                }
                throw new Exception(String.format("\u672a\u652f\u6301\u7684\u6761\u4ef6\u503c\u7c7b\u578b[%1$s]", strVarType));
            }
            Object objValue = iPSDEDQFieldCondition.getCondValue();
            IPSDEField iPSDEField = iDataEntityRuntime.getPSDEField(iPSDEDQFieldCondition.getFieldName(), true);
            if (iPSDEField != null) {
                objValue = iDataEntityRuntime.convertValue(iPSDEField.getStdDataType(), (String)objValue);
            }
            return this.getSearchCond(iDataEntityRuntime, iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u641c\u7d22\u6761\u4ef6\u7c7b\u578b[%1$s]", iPSDEDQCondition.getCondType()));
    }

    protected ISearchCond getSearchCond(IDataEntityRuntime iDataEntityRuntime, String strFieldName, String strCondition, Object objValue) throws Exception {
        if (!StringUtils.hasLength((String)strFieldName)) {
            throw new Exception("\u672a\u6307\u5b9a\u5c5e\u6027\u6807\u8bc6");
        }
        strFieldName = strFieldName.toLowerCase();
        SearchFieldCond searchFieldCond = new SearchFieldCond();
        searchFieldCond.setFieldName(strFieldName);
        searchFieldCond.setParamMode(false);
        searchFieldCond.setCondOp(strCondition);
        searchFieldCond.setValue(objValue);
        return searchFieldCond;
    }
}

