/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ibizsys.central.cloud.core.dataentity.IDataEntityRuntime;
import net.ibizsys.central.cloud.core.dataentity.security.DEUserRoleRuntime;
import net.ibizsys.central.cloud.core.dataentity.security.IDataEntityAccessManager;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.security.UAADEAuthority;
import net.ibizsys.central.cloud.core.util.domain.WFEditableFields;
import net.ibizsys.central.dataentity.security.IDEUserRoleRuntime;
import net.ibizsys.central.dataentity.security.dr.IDataEntityDRProvider;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.central.util.SearchGroupCond;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.der.IPSDER1NBase;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.priv.IPSDEOPPriv;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.SearchCustomCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DataEntityAccessManager
extends net.ibizsys.central.dataentity.security.DataEntityAccessManager
implements IDataEntityAccessManager {
    private static final Log log = LogFactory.getLog(DataEntityAccessManager.class);
    private Map<String, Integer> allOPPrivs = new HashMap<String, Integer>();
    private Map<String, IDataEntityDRProvider> dataEntityDRProviderMap = null;

    protected void onInit() throws Exception {
        super.onInit();
        this.loadAllOPPrivs();
        this.dataEntityDRProviderMap = this.getSystemRuntime().getRuntimeObjects(IDataEntityDRProvider.class);
    }

    protected Map<String, IDataEntityDRProvider> getDataEntityDRProviderMap() {
        return this.dataEntityDRProviderMap;
    }

    public IDataEntityRuntime getDataEntityRuntime() {
        return (IDataEntityRuntime)super.getDataEntityRuntime();
    }

    protected boolean testSuperuser(IUserContext iUserContext) {
        return iUserContext.isSuperuser();
    }

    protected void loadAllOPPrivs() throws Exception {
        List iPSDEOPPrivs = this.getDataEntityRuntime().getPSDataEntity().getAllPSDEOPPrivs();
        if (iPSDEOPPrivs != null) {
            for (IPSDEOPPriv psDEUserRoleOPPriv : iPSDEOPPrivs) {
                if (this.allOPPrivs.containsKey(psDEUserRoleOPPriv.getName())) continue;
                this.allOPPrivs.put(psDEUserRoleOPPriv.getName(), 0);
            }
        }
    }

    protected IDEUserRoleRuntime createDEUserRoleRuntime(IPSDEUserRole iPSDEUserRole) {
        return new DEUserRoleRuntime();
    }

    protected boolean onTestDataAccessAction(IUserContext iUserContext, Object objKey, IEntityDTO inputEntityDTO, String strAccessAction) throws Exception {
        if (this.testSuperuser(iUserContext)) {
            return true;
        }
        try {
            if (!ObjectUtils.isEmpty((Object)objKey) && this.getDataEntityRuntime().isEnableWF()) {
                if ("READ".equals(strAccessAction)) {
                    int nAccessMode = this.getDataEntityRuntime().getDefaultDEWFRuntime().getAccessMode(objKey, null);
                    if ((nAccessMode & 1) > 0) {
                        return true;
                    }
                } else if ("UPDATE".equals(strAccessAction) && this.getDataEntityRuntime().testDataInWF((IEntityBase)this.getDataEntityRuntime().getSimpleEntity(objKey))) {
                    boolean bRet;
                    int nAccessMode = this.getDataEntityRuntime().getDefaultDEWFRuntime().getAccessMode(objKey, null);
                    boolean bl = bRet = (nAccessMode & 2) > 0;
                    if (bRet && inputEntityDTO != null) {
                        WFEditableFields wfEditableFields = this.getDataEntityRuntime().getDefaultDEWFRuntime().getEditableFields(objKey, null);
                        if (wfEditableFields != null && ("2".equalsIgnoreCase(wfEditableFields.getEditMode()) || "1".equalsIgnoreCase(wfEditableFields.getEditMode()))) {
                            List<String> fieldList = wfEditableFields.getFieldMap();
                            HashMap<String, String> fieldMap = new HashMap<String, String>();
                            if (!ObjectUtils.isEmpty(fieldList)) {
                                for (String strField : fieldList) {
                                    if (!StringUtils.hasLength((String)strField)) continue;
                                    fieldMap.put(strField.trim().toLowerCase(), "");
                                }
                            }
                            boolean bIncludeMode = "2".equalsIgnoreCase(wfEditableFields.getEditMode());
                            List psDEFields = this.getDataEntityRuntime().getPSDataEntity().getAllPSDEFields();
                            if (!ObjectUtils.isEmpty((Object)psDEFields)) {
                                for (IPSDEField iPSDEField : psDEFields) {
                                    if (iPSDEField.isKeyDEField()) continue;
                                    if (bIncludeMode) {
                                        if (fieldMap.containsKey(iPSDEField.getLowerCaseName())) continue;
                                        inputEntityDTO.reset(iPSDEField.getLowerCaseName());
                                        continue;
                                    }
                                    if (!fieldMap.containsKey(iPSDEField.getLowerCaseName())) continue;
                                    inputEntityDTO.reset(iPSDEField.getLowerCaseName());
                                }
                            }
                            return true;
                        }
                        return false;
                    }
                    return bRet;
                }
            }
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u5224\u65ad\u5de5\u4f5c\u6d41\u6570\u636e\u6743\u9650\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        if (!this.onTestDataAccessAction(iUserContext, inputEntityDTO, strAccessAction)) {
            return false;
        }
        if ("CREATE".equals(strAccessAction)) {
            return true;
        }
        if (objKey == null) {
            return true;
        }
        return this.existsData(iUserContext, objKey, strAccessAction);
    }

    protected boolean existsData(IUserContext iUserContext, Object objKey, String strAccessAction) {
        ISearchContextDTO context = this.getDataEntityRuntime().createSearchContext();
        SearchContextDTO.addSearchFieldCond((ISearchContextDTO)context, (String)this.getDataEntityRuntime().getKeyPSDEField().getName(), (String)"EQ", (Object)objKey, null);
        this.addAuthorityConditions(context, (IEmployeeContext)iUserContext, strAccessAction);
        return this.getDataEntityRuntime().existsData((ISearchContextBase)context);
    }

    protected boolean onTestDataAccessAction(IUserContext iUserContext, net.ibizsys.central.dataentity.IDataEntityRuntime parentDataEntityRuntime, String strParentKey, ISearchContextDTO iSearchContextDTO, String strAccessAction) throws Exception {
        if (this.testSuperuser(iUserContext)) {
            return true;
        }
        if (!this.onTestDataAccessAction(iUserContext, null, strAccessAction)) {
            return false;
        }
        this.addAuthorityConditions(iSearchContextDTO, (IEmployeeContext)iUserContext, strAccessAction);
        return true;
    }

    protected boolean onTestDataAccessAction(IUserContext iUserContext, IEntityDTO inputEntityDTO, String strAccessAction) throws Exception {
        if (this.testSuperuser(iUserContext)) {
            return true;
        }
        if (!StringUtils.hasLength((String)strAccessAction)) {
            return false;
        }
        if ("DENY".equals(strAccessAction)) {
            return false;
        }
        if ("NONE".equals(strAccessAction)) {
            return true;
        }
        List<IPSDEUserRole> list = this.getPSDEUserRoles((IEmployeeContext)iUserContext, strAccessAction);
        if (ObjectUtils.isEmpty(list)) {
            return false;
        }
        if ("CREATE".equals(strAccessAction)) {
            IPSDEField deptIdPSDEField;
            for (IPSDEUserRole iPSDEUserRole : list) {
                if (!iPSDEUserRole.isAllData()) continue;
                return true;
            }
            IEmployeeContext iEmployeeContext = (IEmployeeContext)iUserContext;
            IPSDEField orgIdPSDEField = this.getDataEntityRuntime().getOrgIdPSDEField();
            if (orgIdPSDEField != null) {
                String strOrgId = null;
                if (inputEntityDTO != null) {
                    strOrgId = DataTypeUtils.getStringValue((Object)this.getDataEntityRuntime().getFieldValue((IEntityBase)inputEntityDTO, orgIdPSDEField), null);
                }
                if (!StringUtils.hasLength(strOrgId)) {
                    strOrgId = iEmployeeContext.getOrgid();
                }
                if (StringUtils.hasLength((String)iEmployeeContext.getOrgid())) {
                    for (IPSDEUserRole iPSDEUserRole : list) {
                        if (!iPSDEUserRole.isEnableOrgDR() || (iPSDEUserRole.getOrgDR() & 1L) != 1L || !iEmployeeContext.getOrgid().equals(strOrgId)) continue;
                        return true;
                    }
                }
            }
            if ((deptIdPSDEField = this.getDataEntityRuntime().getDeptIdPSDEField()) != null) {
                String strDeptId = null;
                if (inputEntityDTO != null) {
                    strDeptId = DataTypeUtils.getStringValue((Object)this.getDataEntityRuntime().getFieldValue((IEntityBase)inputEntityDTO, deptIdPSDEField), null);
                }
                if (!StringUtils.hasLength(strDeptId)) {
                    strDeptId = iEmployeeContext.getDeptid();
                }
                if (StringUtils.hasLength((String)iEmployeeContext.getDeptid())) {
                    for (IPSDEUserRole iPSDEUserRole : list) {
                        if (!iPSDEUserRole.isEnableSecDR() || (iPSDEUserRole.getSecDR() & 1L) != 1L || !iEmployeeContext.getDeptid().equals(strDeptId)) continue;
                        return true;
                    }
                }
            }
            return orgIdPSDEField == null && deptIdPSDEField == null;
        }
        return true;
    }

    protected List<IPSDEUserRole> getPSDEUserRoles(IEmployeeContext iEmployeeContext, String strAccessAction) {
        List adminSysUserRoleRuntimes;
        List userSysUserRoleRuntimes;
        ArrayList<IPSDEUserRole> authorities = new ArrayList<IPSDEUserRole>();
        ArrayList iPSDEUserRoles = new ArrayList();
        List iDEUserRoleRuntimes = this.getDefaultDEUserRoleRuntimes();
        if (iDEUserRoleRuntimes != null) {
            iDEUserRoleRuntimes.stream().forEach(iDEUserRoleRuntime -> iPSDEUserRoles.add(iDEUserRoleRuntime.getPSDEUserRole()));
        }
        if (iPSDEUserRoles != null) {
            iPSDEUserRoles.stream().forEach(iPSDEUserRole -> {
                List iPSDEUserRoleOPPrivs = iPSDEUserRole.getPSDEUserRoleOPPrivs();
                if (iPSDEUserRoleOPPrivs != null && iPSDEUserRoleOPPrivs.stream().anyMatch(iPSDEUserRoleOPPriv -> iPSDEUserRoleOPPriv.getDataAccessAction().equals(strAccessAction))) {
                    authorities.add((IPSDEUserRole)iPSDEUserRole);
                }
            });
        }
        if ((userSysUserRoleRuntimes = this.getSystemAccessManager().getUserSysUserRoleRuntimes()) != null) {
            userSysUserRoleRuntimes.stream().forEach(userSysUserRoleRuntime -> {
                List userIPSDEUserRoles = userSysUserRoleRuntime.getPSDEUserRoles(this.getDataEntityRuntime().getId());
                if (userIPSDEUserRoles != null) {
                    userIPSDEUserRoles.forEach(userIPSDEUserRole -> {
                        List iPSDEUserRoleOPPrivs = userIPSDEUserRole.getPSDEUserRoleOPPrivs();
                        if (iPSDEUserRoleOPPrivs != null && iPSDEUserRoleOPPrivs.stream().anyMatch(iPSDEUserRoleOPPriv -> iPSDEUserRoleOPPriv.getDataAccessAction().equals(strAccessAction))) {
                            authorities.add((IPSDEUserRole)userIPSDEUserRole);
                        }
                    });
                }
            });
        }
        if (iEmployeeContext.isSystemadmin() && (adminSysUserRoleRuntimes = this.getSystemAccessManager().getAdminSysUserRoleRuntimes()) != null) {
            adminSysUserRoleRuntimes.stream().forEach(adminSysUserRoleRuntime -> {
                List adminIPSDEUserRoles = adminSysUserRoleRuntime.getPSDEUserRoles(this.getDataEntityRuntime().getId());
                if (adminIPSDEUserRoles != null) {
                    adminIPSDEUserRoles.stream().forEach(adminIPSDEUserRole -> {
                        List iPSDEUserRoleOPPrivs = adminIPSDEUserRole.getPSDEUserRoleOPPrivs();
                        if (iPSDEUserRoleOPPrivs != null && iPSDEUserRoleOPPrivs.stream().anyMatch(iPSDEUserRoleOPPriv -> iPSDEUserRoleOPPriv.getDataAccessAction().equals(strAccessAction))) {
                            authorities.add((IPSDEUserRole)adminIPSDEUserRole);
                        }
                    });
                }
            });
        }
        List iSysUserRoleRuntimes = this.getSystemAccessManager().getSysUserRoleRuntimes((IUserContext)iEmployeeContext);
        iSysUserRoleRuntimes.stream().forEach(iSysUserRoleRuntime -> {
            List followPSDEUserRoles = iSysUserRoleRuntime.getPSDEUserRoles(this.getDataEntityRuntime().getId());
            if (followPSDEUserRoles != null) {
                for (IPSDEUserRole followIPSDEUserRole : followPSDEUserRoles) {
                    List iPSDEUserRoleOPPrivs;
                    if (!"CAT1".equals(followIPSDEUserRole.getUserCat()) && !followIPSDEUserRole.isSystemReserved() || (iPSDEUserRoleOPPrivs = followIPSDEUserRole.getPSDEUserRoleOPPrivs()) == null || !iPSDEUserRoleOPPrivs.stream().anyMatch(iPSDEUserRoleOPPriv -> iPSDEUserRoleOPPriv.getDataAccessAction().equals(strAccessAction))) continue;
                    authorities.add(followIPSDEUserRole);
                }
            }
        });
        for (IPSDEUserRole rtIPSDEUserRole : this.getPSDEUserRoleByRT(iEmployeeContext)) {
            List iPSDEUserRoleOPPrivs = rtIPSDEUserRole.getPSDEUserRoleOPPrivs();
            if (iPSDEUserRoleOPPrivs == null || !iPSDEUserRoleOPPrivs.stream().anyMatch(iPSDEUserRoleOPPriv -> iPSDEUserRoleOPPriv.getDataAccessAction().equals(strAccessAction))) continue;
            authorities.add(rtIPSDEUserRole);
        }
        return authorities;
    }

    protected List<IPSDEUserRole> getPSDEUserRoleByRT(IEmployeeContext iEmployeeContext) {
        ArrayList<IPSDEUserRole> iPSDEUserRoles = new ArrayList<IPSDEUserRole>();
        if (iEmployeeContext.getAuthorities() != null) {
            iEmployeeContext.getAuthorities().stream().filter(grantedAuthority -> grantedAuthority instanceof UAADEAuthority).forEach(grantedAuthority -> {
                UAADEAuthority uaadeAuthority = (UAADEAuthority)grantedAuthority;
                if (uaadeAuthority.getEntity().equals(this.getDataEntityRuntime().getName())) {
                    ObjectNode userRoleNode = JsonUtils.createObjectNode();
                    userRoleNode.put("name", uaadeAuthority.getName());
                    if (uaadeAuthority.getIsAllData() != null) {
                        userRoleNode.put("allData", uaadeAuthority.getIsAllData());
                    }
                    if (uaadeAuthority.getEnableorgdr() != null) {
                        userRoleNode.put("enableOrgDR", uaadeAuthority.getEnableorgdr());
                    }
                    if (uaadeAuthority.getOrgdr() != null) {
                        userRoleNode.put("orgDR", uaadeAuthority.getOrgdr());
                    }
                    if (uaadeAuthority.getEnabledeptdr() != null) {
                        userRoleNode.put("enableSecDR", uaadeAuthority.getEnabledeptdr());
                    }
                    if (uaadeAuthority.getDeptdr() != null) {
                        userRoleNode.put("secDR", uaadeAuthority.getDeptdr());
                    }
                    if (uaadeAuthority.getDeptbc() != null) {
                        userRoleNode.put("secBC", uaadeAuthority.getDeptbc());
                    }
                    if (uaadeAuthority.getBscope() != null) {
                        userRoleNode.put("customCond", uaadeAuthority.getBscope());
                    }
                    if (!ObjectUtils.isEmpty(uaadeAuthority.getDeAction())) {
                        ArrayNode userRoleDataActionsNode = JsonUtils.createArrayNode();
                        for (Map<String, String> deAction : uaadeAuthority.getDeAction()) {
                            ObjectNode userRoleDataActionNode = JsonUtils.createObjectNode();
                            for (String key : deAction.keySet()) {
                                userRoleDataActionNode.put("dataAccessAction", key);
                                userRoleDataActionsNode.add((JsonNode)userRoleDataActionNode);
                            }
                        }
                        userRoleNode.put("getPSDEUserRoleOPPrivs", (JsonNode)userRoleDataActionsNode);
                    }
                    try {
                        IPSDEUserRole iPSDEUserRole = (IPSDEUserRole)this.getDataEntityRuntime().getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getDataEntityRuntime().getPSDataEntity(), IPSDEUserRole.class, userRoleNode);
                        iPSDEUserRoles.add(iPSDEUserRole);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                    }
                }
            });
        }
        return iPSDEUserRoles;
    }

    public void addAuthorityConditions(ISearchContextDTO searchContext, IEmployeeContext iEmployeeContext, String action) {
        if (this.testSuperuser(iEmployeeContext)) {
            return;
        }
        List items = searchContext.getSearchCondsIf();
        List<IPSDEUserRole> authorities = this.getPSDEUserRoles(iEmployeeContext, action);
        if (authorities.stream().anyMatch(authority -> authority.isAllData())) {
            return;
        }
        SearchGroupCond authorityCond = new SearchGroupCond(searchContext);
        authorityCond.setCondOp("AND");
        authorityCond.setCat("AUTHORITY");
        SearchGroupCond authorityConds = new SearchGroupCond(searchContext);
        authorityConds.setCondOp("OR");
        authorityCond.getSearchCondsIf().add(authorityConds);
        if (authorities.size() == 0) {
            SearchCustomCond customCond = new SearchCustomCond();
            customCond.setCustomCond("1 <> 1");
            authorityConds.getSearchCondsIf().add(customCond);
            items.add(authorityCond);
        } else {
            List<ISearchCond> conds = this.genAuthorityConditions(authorities, action);
            if (!ObjectUtils.isEmpty(conds)) {
                authorityConds.getSearchCondsIf().addAll(conds);
                items.add(authorityCond);
            } else {
                SearchCustomCond customCond = new SearchCustomCond();
                customCond.setCustomCond("1 <> 1");
                authorityConds.getSearchCondsIf().add(customCond);
                items.add(authorityCond);
            }
        }
    }

    protected List<ISearchCond> genAuthorityConditions(Collection<IPSDEUserRole> iPSDEUserRoles, String action) {
        ArrayList<ISearchCond> searchConds = new ArrayList<ISearchCond>();
        Map<String, IDataEntityDRProvider> providerMap = this.getDataEntityDRProviderMap();
        if (!ObjectUtils.isEmpty(providerMap)) {
            providerMap.values().forEach(provider -> {
                List drSearchConds = provider.getDRSearchConds((net.ibizsys.central.dataentity.IDataEntityRuntime)this.getDataEntityRuntime(), iPSDEUserRoles, action);
                if (!ObjectUtils.isEmpty((Object)drSearchConds)) {
                    searchConds.addAll(drSearchConds);
                }
            });
        }
        return searchConds;
    }

    protected Map<String, Integer> getDataOPPrivs(IEmployeeContext iEmployeeContext, Serializable key) {
        List adminSysUserRoleRuntimes;
        List userSysUserRoleRuntimes;
        HashMap<String, Integer> opprivsMap = new HashMap<String, Integer>();
        if (this.testSuperuser(iEmployeeContext)) {
            return opprivsMap;
        }
        ArrayList iPSDEUserRoles = new ArrayList();
        List iDEUserRoleRuntimes = this.getDefaultDEUserRoleRuntimes();
        if (iDEUserRoleRuntimes != null) {
            iDEUserRoleRuntimes.stream().forEach(iDEUserRoleRuntime -> iPSDEUserRoles.add(iDEUserRoleRuntime.getPSDEUserRole()));
        }
        if (iPSDEUserRoles != null) {
            iPSDEUserRoles.stream().forEach(iPSDEUserRole -> {
                List iPSDEUserRoleOPPrivs = iPSDEUserRole.getPSDEUserRoleOPPrivs();
                if (iPSDEUserRoleOPPrivs != null) {
                    iPSDEUserRoleOPPrivs.stream().forEach(iPSDEUserRoleOPPriv -> {
                        if (!opprivsMap.containsKey(iPSDEUserRoleOPPriv.getDataAccessAction())) {
                            opprivsMap.put(iPSDEUserRoleOPPriv.getDataAccessAction(), 0);
                        }
                    });
                }
            });
        }
        if ((userSysUserRoleRuntimes = this.getSystemAccessManager().getUserSysUserRoleRuntimes()) != null) {
            userSysUserRoleRuntimes.stream().forEach(userSysUserRoleRuntime -> {
                List userIPSDEUserRoles = userSysUserRoleRuntime.getPSDEUserRoles(this.getDataEntityRuntime().getId());
                if (userIPSDEUserRoles != null) {
                    userIPSDEUserRoles.forEach(userIPSDEUserRole -> {
                        List iPSDEUserRoleOPPrivs = userIPSDEUserRole.getPSDEUserRoleOPPrivs();
                        if (iPSDEUserRoleOPPrivs != null) {
                            iPSDEUserRoleOPPrivs.stream().forEach(iPSDEUserRoleOPPriv -> {
                                if (!opprivsMap.containsKey(iPSDEUserRoleOPPriv.getDataAccessAction())) {
                                    opprivsMap.put(iPSDEUserRoleOPPriv.getDataAccessAction(), 0);
                                }
                            });
                        }
                    });
                }
            });
        }
        if (iEmployeeContext.isSystemadmin() && (adminSysUserRoleRuntimes = this.getSystemAccessManager().getAdminSysUserRoleRuntimes()) != null) {
            adminSysUserRoleRuntimes.stream().forEach(adminSysUserRoleRuntime -> {
                List adminIPSDEUserRoles = adminSysUserRoleRuntime.getPSDEUserRoles(this.getDataEntityRuntime().getId());
                if (adminIPSDEUserRoles != null) {
                    adminIPSDEUserRoles.stream().forEach(adminIPSDEUserRole -> {
                        List iPSDEUserRoleOPPrivs = adminIPSDEUserRole.getPSDEUserRoleOPPrivs();
                        if (iPSDEUserRoleOPPrivs != null) {
                            iPSDEUserRoleOPPrivs.stream().forEach(iPSDEUserRoleOPPriv -> {
                                if (!opprivsMap.containsKey(iPSDEUserRoleOPPriv.getDataAccessAction())) {
                                    opprivsMap.put(iPSDEUserRoleOPPriv.getDataAccessAction(), 0);
                                }
                            });
                        }
                    });
                }
            });
        }
        List iSysUserRoleRuntimes = this.getSystemAccessManager().getSysUserRoleRuntimes((IUserContext)iEmployeeContext);
        iSysUserRoleRuntimes.stream().forEach(iSysUserRoleRuntime -> {
            List followPSDEUserRoles = iSysUserRoleRuntime.getPSDEUserRoles(this.getDataEntityRuntime().getId());
            if (followPSDEUserRoles != null) {
                for (IPSDEUserRole followIPSDEUserRole : followPSDEUserRoles) {
                    List iPSDEUserRoleOPPrivs;
                    if (!"CAT1".equals(followIPSDEUserRole.getUserCat()) && !followIPSDEUserRole.isSystemReserved() || (iPSDEUserRoleOPPrivs = followIPSDEUserRole.getPSDEUserRoleOPPrivs()) == null) continue;
                    iPSDEUserRoleOPPrivs.stream().forEach(iPSDEUserRoleOPPriv -> {
                        if (!opprivsMap.containsKey(iPSDEUserRoleOPPriv.getDataAccessAction())) {
                            opprivsMap.put(iPSDEUserRoleOPPriv.getDataAccessAction(), 0);
                        }
                    });
                }
            }
        });
        for (IPSDEUserRole rtIPSDEUserRole : this.getPSDEUserRoleByRT(iEmployeeContext)) {
            List iPSDEUserRoleOPPrivs = rtIPSDEUserRole.getPSDEUserRoleOPPrivs();
            if (iPSDEUserRoleOPPrivs == null) continue;
            iPSDEUserRoleOPPrivs.stream().forEach(iPSDEUserRoleOPPriv -> {
                if (!opprivsMap.containsKey(iPSDEUserRoleOPPriv.getDataAccessAction())) {
                    opprivsMap.put(iPSDEUserRoleOPPriv.getDataAccessAction(), 0);
                }
            });
        }
        opprivsMap.entrySet().stream().forEach(opprivsrEntry -> {
            try {
                if (this.onTestDataAccessAction(iEmployeeContext, key, null, (String)opprivsrEntry.getKey())) {
                    opprivsrEntry.setValue(1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.allOPPrivs.entrySet().stream().forEach(opprivEntry -> {
            if (!opprivsMap.containsKey(opprivEntry.getKey())) {
                opprivsMap.put((String)opprivEntry.getKey(), 0);
            }
        });
        return opprivsMap;
    }

    @Override
    public void fillDataAccessActions(IEmployeeContext iEmployeeContext, List<IEntityDTO> iEntityDTOList, String strDataAccessActions, String strFieldName) throws Exception {
        if (ObjectUtils.isEmpty(iEntityDTOList)) {
            return;
        }
        HashSet<String> dataAccessActionList = new HashSet<String>();
        if (StringUtils.hasLength((String)strDataAccessActions)) {
            String[] items = strDataAccessActions.toUpperCase().replace(",", ";").split("[;]");
            dataAccessActionList.addAll(Arrays.asList(items));
        } else {
            dataAccessActionList.addAll(this.allOPPrivs.keySet());
        }
        dataAccessActionList.remove("CREATE");
        dataAccessActionList.remove("READ");
        this.fillDataAccessActions(iEmployeeContext, iEntityDTOList, dataAccessActionList, strFieldName);
    }

    protected void fillDataAccessActions(IEmployeeContext iEmployeeContext, List<IEntityDTO> iEntityDTOList, Set<String> dataAccessActionList, String strFieldName) throws Exception {
        if (ObjectUtils.isEmpty(dataAccessActionList)) {
            return;
        }
        if (!StringUtils.hasLength((String)strFieldName)) {
            strFieldName = "srfdataaccaction";
        }
        LinkedHashMap entityAccessActionMap = new LinkedHashMap();
        for (IEntityDTO iEntityDTO : iEntityDTOList) {
            Object key = this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)iEntityDTO);
            if (ObjectUtils.isEmpty((Object)key) || iEntityDTO.contains(strFieldName)) continue;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String string : dataAccessActionList) {
                map.put(string, null);
            }
            entityAccessActionMap.put(key, map);
        }
        if (ObjectUtils.isEmpty(entityAccessActionMap)) {
            return;
        }
        int nDataAccCtrlMode = this.getDataAccCtrlMode();
        if (nDataAccCtrlMode != 0) {
            boolean bTestMaster = false;
            boolean bTestSelf = false;
            switch (nDataAccCtrlMode) {
                case 1: {
                    bTestSelf = true;
                    break;
                }
                case 2: {
                    bTestMaster = true;
                    break;
                }
                case 3: {
                    bTestSelf = true;
                    bTestMaster = true;
                    break;
                }
                default: {
                    throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u8bbf\u95ee\u63a7\u5236\u6a21\u5f0f[%1$s]", nDataAccCtrlMode));
                }
            }
            if (bTestMaster) {
                LinkedHashMap<String, LinkedHashMap<String, Boolean>> masterActionsMap = new LinkedHashMap<String, LinkedHashMap<String, Boolean>>();
                for (IEntityDTO iEntityDTO : iEntityDTOList) {
                    IPSDERBase iPSDERBase = this.getDataEntityRuntime().getMasterPSDER((IEntityBase)iEntityDTO, true);
                    if (!(iPSDERBase instanceof IPSDER1NBase)) continue;
                    IPSDER1NBase iPSDER1NBase = (IPSDER1NBase)iPSDERBase;
                    for (String string : dataAccessActionList) {
                        Object key;
                        Map<String, Boolean> map;
                        Object parentKey;
                        IPSDEOPPriv iPSDEOPPriv = this.getPSDEOPPriv(this.getSystemRuntime().getDataEntityRuntime(iPSDER1NBase.getMajorPSDataEntityMust().getId()), string, true);
                        if (iPSDEOPPriv != null && (parentKey = this.getDataEntityRuntime().getFieldValue((IEntityBase)iEntityDTO, iPSDER1NBase.getPickupPSDEFieldMust())) != null) {
                            ArrayList<String> list;
                            map = (Map)masterActionsMap.get(iPSDER1NBase.getMajorPSDataEntityMust().getId());
                            if (map == null) {
                                map = new LinkedHashMap<String, Boolean>();
                                masterActionsMap.put(iPSDER1NBase.getMajorPSDataEntityMust().getId(), (LinkedHashMap<String, Boolean>)map);
                            }
                            if ((list = (ArrayList<String>)map.get(parentKey)) == null) {
                                list = new ArrayList<String>();
                                map.put((String)parentKey, (Boolean)((Object)list));
                            }
                            if (list.contains(iPSDEOPPriv.getMapPSDEOPPrivName())) continue;
                            list.add(iPSDEOPPriv.getMapPSDEOPPrivName());
                            continue;
                        }
                        if (bTestSelf || ObjectUtils.isEmpty((Object)(key = this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)iEntityDTO))) || (map = (LinkedHashMap<String, Boolean>)entityAccessActionMap.get(key)) == null) continue;
                        map.put(string, false);
                    }
                }
                for (Map.Entry entry : masterActionsMap.entrySet()) {
                    net.ibizsys.central.dataentity.IDataEntityRuntime masterDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime((String)entry.getKey());
                    ISearchContextDTO iSearchContextDTO = masterDataEntityRuntime.createSearchContext();
                    iSearchContextDTO.all().count(false);
                    iSearchContextDTO.in(masterDataEntityRuntime.getKeyPSDEField().getLowerCaseName(), ((Map)entry.getValue()).keySet());
                    List masterEntityDTOList = masterDataEntityRuntime.selectDataQuery(masterDataEntityRuntime.getSimplePSDEDataQuery(), iSearchContextDTO);
                    LinkedHashSet linkedHashSet = new LinkedHashSet();
                    for (List list : ((Map)entry.getValue()).values()) {
                        linkedHashSet.addAll(list);
                    }
                    ((IDataEntityAccessManager)masterDataEntityRuntime.getDataEntityAccessManager()).fillDataAccessActions(iEmployeeContext, masterEntityDTOList, StringUtils.collectionToDelimitedString(linkedHashSet, (String)","), strFieldName);
                    for (IEntityDTO masterEntityDTO : masterEntityDTOList) {
                        HashMap<String, Boolean> masterOPPrivMap = new HashMap<String, Boolean>();
                        String strMasterDataAccessActions = masterEntityDTO.getString(strFieldName, null);
                        if (StringUtils.hasLength((String)strMasterDataAccessActions)) {
                            String[] items = strMasterDataAccessActions.split("[,]");
                            for (String item : items) {
                                String[] items2 = item.split("[:]");
                                if (items2.length != 2) continue;
                                masterOPPrivMap.put(items2[0], "1".equals(items2[1]));
                            }
                        }
                        Object parentKey = masterEntityDTO.get(masterDataEntityRuntime.getKeyPSDEField().getLowerCaseName());
                        for (IEntityDTO iEntityDTO : iEntityDTOList) {
                            Object parentKey2;
                            IPSDER1NBase iPSDER1NBase;
                            IPSDERBase iPSDERBase = this.getDataEntityRuntime().getMasterPSDER((IEntityBase)iEntityDTO, true);
                            if (!(iPSDERBase instanceof IPSDER1NBase) || !(iPSDER1NBase = (IPSDER1NBase)iPSDERBase).getMajorPSDataEntityMust().getId().equals(entry.getKey()) || !parentKey.equals(parentKey2 = this.getDataEntityRuntime().getFieldValue((IEntityBase)iEntityDTO, iPSDER1NBase.getPickupPSDEFieldMust()))) continue;
                            for (String strAccessAction : dataAccessActionList) {
                                Map map;
                                Object key;
                                Boolean bRet;
                                IPSDEOPPriv iPSDEOPPriv = this.getPSDEOPPriv(masterDataEntityRuntime, strAccessAction, true);
                                if (iPSDEOPPriv == null || (bRet = (Boolean)masterOPPrivMap.get(iPSDEOPPriv.getMapPSDEOPPrivName())) == null || ObjectUtils.isEmpty((Object)(key = this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)iEntityDTO))) || (map = (Map)entityAccessActionMap.get(key)) == null) continue;
                                map.put(strAccessAction, bRet);
                            }
                        }
                    }
                }
            }
            if (bTestSelf) {
                for (IEntityDTO iEntityDTO : iEntityDTOList) {
                    for (String strAccessAction : dataAccessActionList) {
                        Map map;
                        Iterator<Object> key;
                        IPSDEOPPriv iPSDEOPPriv = this.getPSDEOPPriv(null, strAccessAction);
                        if (iPSDEOPPriv == null || !StringUtils.hasLength((String)iPSDEOPPriv.getMapSysUniResCode()) || ObjectUtils.isEmpty((Object)(key = this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)iEntityDTO))) || (map = (Map)entityAccessActionMap.get(key)) == null || map.get(strAccessAction) != null) continue;
                        map.put(strAccessAction, this.getSystemAccessManager().testSysUniRes((IUserContext)iEmployeeContext, iPSDEOPPriv.getMapSysUniResCode(), (IEntity)iEntityDTO));
                    }
                }
                for (String strAccessAction : dataAccessActionList) {
                    List<IPSDEUserRole> list = this.getPSDEUserRoles(iEmployeeContext, strAccessAction);
                    if (!ObjectUtils.isEmpty(list)) {
                        ISearchContextDTO context = this.getDataEntityRuntime().createSearchContext();
                        context.all();
                        context.count(false);
                        this.getDataEntityRuntime().setSearchCondition((ISearchContextBase)context, this.getDataEntityRuntime().getKeyPSDEField(), "IN", entityAccessActionMap.keySet());
                        this.addAuthorityConditions(context, iEmployeeContext, strAccessAction);
                        List list2 = this.getDataEntityRuntime().selectDataQuery(this.getDataEntityRuntime().getDefaultPSDEDataQuery(), context);
                        for (Object k : entityAccessActionMap.keySet()) {
                            Map map = (Map)entityAccessActionMap.get(k);
                            if (map == null || map.get(strAccessAction) != null) continue;
                            map.put(strAccessAction, false);
                        }
                        if (ObjectUtils.isEmpty((Object)list2)) continue;
                        for (IEntityDTO iEntityDTO : list2) {
                            Map map;
                            Object key = this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)iEntityDTO);
                            if (ObjectUtils.isEmpty((Object)key) || (map = (Map)entityAccessActionMap.get(key)) == null) continue;
                            map.put(strAccessAction, true);
                        }
                        continue;
                    }
                    for (Object key : entityAccessActionMap.keySet()) {
                        Map map = (Map)entityAccessActionMap.get(key);
                        if (map == null || map.get(strAccessAction) != null) continue;
                        map.put(strAccessAction, null);
                    }
                }
            }
            for (IEntityDTO iEntityDTO : iEntityDTOList) {
                Object object = this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)iEntityDTO);
                if (ObjectUtils.isEmpty((Object)object) || iEntityDTO.contains(strFieldName)) continue;
                Map map = (Map)entityAccessActionMap.get(object);
                LinkedHashMap map2 = new LinkedHashMap();
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() != null && !((Boolean)entry.getValue()).booleanValue()) continue;
                    map2.put(entry.getKey(), true);
                }
                if (map2.size() > 0) {
                    this.getDataEntityRuntime().fillDataAccessActions(iEntityDTO, map2);
                    for (Map.Entry entry : map2.entrySet()) {
                        boolean bRet = false;
                        if (entry.getValue() instanceof Boolean) {
                            bRet = (Boolean)entry.getValue();
                        }
                        map.put(entry.getKey(), bRet);
                    }
                }
                StringBuilder sb = new StringBuilder();
                boolean bl = true;
                for (Map.Entry entry : map.entrySet()) {
                    boolean bl2;
                    if (bl2) {
                        bl2 = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(String.format("%1$s:%2$s", entry.getKey(), entry.getValue() != null && (Boolean)entry.getValue() != false ? 1 : 0));
                }
                iEntityDTO.set(strFieldName, sb.toString());
            }
        }
    }
}

