/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ibizsys.central.cloud.core.IServiceSystemRuntime;
import net.ibizsys.central.cloud.core.dataentity.IDataEntityRuntime;
import net.ibizsys.central.cloud.core.dataentity.dataflow.DEDataFlowRuntime;
import net.ibizsys.central.cloud.core.dataentity.dataimport.IDEDataImportRuntime;
import net.ibizsys.central.cloud.core.dataentity.logic.DELogicRuntime;
import net.ibizsys.central.cloud.core.dataentity.service.DEServiceInvocationHandler;
import net.ibizsys.central.cloud.core.dataentity.util.IDEExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.dataentity.wf.IDEWFRuntime;
import net.ibizsys.central.cloud.core.sysutil.IHubSysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysUtilContainerOnly;
import net.ibizsys.central.cloud.core.util.domain.V2ImportSchema;
import net.ibizsys.central.cloud.core.util.domain.V2SystemExtensionLogic;
import net.ibizsys.central.cloud.core.util.domain.V2SystemExtensionSuite;
import net.ibizsys.central.dataentity.dataflow.IDEDataFlowRuntime;
import net.ibizsys.central.dataentity.logic.IDELogicRuntime;
import net.ibizsys.central.dataentity.logic.IDEMSLogicRuntime;
import net.ibizsys.central.dataentity.security.IDataEntityAccessManager;
import net.ibizsys.central.dataentity.service.IDEMethodDTO;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.central.util.domain.ImportDataResult;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.dataflow.IPSDEDataFlow;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRCondition;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRQueryCountCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogic;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.util.IPSDEUtil;
import net.ibizsys.model.dataentity.wf.IPSDEWF;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeContext;
import net.ibizsys.runtime.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.runtime.dataentity.util.IDEUtilRuntime;
import net.ibizsys.runtime.plugin.RuntimeObjectFactory;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.EntityBase;
import net.ibizsys.runtime.util.EntityError;
import net.ibizsys.runtime.util.IActionSessionLog;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DataEntityRuntime
extends net.ibizsys.central.dataentity.DataEntityRuntime
implements IDataEntityRuntime {
    private static final Log log = LogFactory.getLog(DataEntityRuntime.class);
    private boolean bEnableRTCodeMode = false;
    private Map<Class<?>, Object> proxyDEServiceMap = null;
    private Map<Class<?>, Map<String, String>> rtObjectNameMap = null;
    private IDEService proxyDEService = null;
    private boolean bEnableExtension = false;
    private IDEExtensionUtilRuntime iDEExtensionUtilRuntime = null;

    protected void onInit() throws Exception {
        IServiceSystemRuntime iServiceSystemRuntime = null;
        if (this.getSystemRuntime() instanceof IServiceSystemRuntime) {
            iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
        }
        if (iServiceSystemRuntime != null) {
            this.bEnableRTCodeMode = iServiceSystemRuntime.isEnableRTCodeMode();
        }
        if (this.isEnableRTCodeMode()) {
            this.registerRTObjects();
        }
        if (DataTypeUtils.getIntegerValue((Object)this.getPSDataEntity().getDynaSysMode(), (Integer)0) > 0) {
            this.prepareDEExtensionUtilRuntime();
        }
        super.onInit();
    }

    protected void registerRTObjects() throws Exception {
        IPSDataEntity iPSDataEntity = this.getPSDataEntity();
        if (this.getSystemRuntime() instanceof IServiceSystemRuntime) {
            List psDEMethodDTOList;
            IServiceSystemRuntime iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
            String strDEServiceObjectName = iServiceSystemRuntime.getRTCodeUtils().getDEServiceObjectName(iPSDataEntity);
            if (StringUtils.hasLength((String)strDEServiceObjectName)) {
                Object objService;
                this.registerRTObjectName(IDEService.class, iPSDataEntity.getId(), strDEServiceObjectName);
                Class deServiceCls = RuntimeObjectFactory.getInstance().getObjectClass(IDEService.class, strDEServiceObjectName);
                IDEService proxyDEService = null;
                if (deServiceCls != null && (objService = this.getProxyDEService(deServiceCls)) instanceof IDEService) {
                    proxyDEService = (IDEService)objService;
                }
                if (proxyDEService == null) {
                    proxyDEService = (IDEService)this.getProxyDEService(IDEService.class);
                }
                this.proxyDEService = proxyDEService;
            }
            if (!ObjectUtils.isEmpty((Object)(psDEMethodDTOList = iPSDataEntity.getAllPSDEMethodDTOs()))) {
                for (IPSDEMethodDTO iPSDEMethodDTO : psDEMethodDTOList) {
                    String strRTObjectName = iServiceSystemRuntime.getRTCodeUtils().getRTObjectName(iPSDEMethodDTO);
                    if (!StringUtils.hasLength((String)strRTObjectName)) continue;
                    this.registerRTObjectName(IDEMethodDTO.class, iPSDEMethodDTO.getId(), strRTObjectName);
                }
            }
        }
    }

    protected boolean registerRTObjectName(Class<?> cls, String strId, String strRTObjectName) {
        Map<String, String> map;
        if (!StringUtils.hasLength((String)strId) || !StringUtils.hasLength((String)strRTObjectName)) {
            return false;
        }
        if (!RuntimeObjectFactory.getInstance().containsObject(cls, strRTObjectName) && !RuntimeObjectFactory.getInstance().registerObjectIf(cls, strRTObjectName, (Object)strRTObjectName)) {
            return false;
        }
        if (this.rtObjectNameMap == null) {
            this.rtObjectNameMap = new ConcurrentHashMap();
        }
        if ((map = this.rtObjectNameMap.get(cls)) == null) {
            map = new HashMap<String, String>();
            this.rtObjectNameMap.put(cls, map);
        }
        map.put(strId, strRTObjectName);
        return true;
    }

    protected String getRTObjectName(Class<?> cls, String strId) {
        if (this.rtObjectNameMap == null) {
            return null;
        }
        Map<String, String> map = this.rtObjectNameMap.get(cls);
        if (map == null) {
            return null;
        }
        return map.get(strId);
    }

    protected <T> T getRTObject(Class<T> cls, String strId) {
        return this.getRTObject(cls, strId, true);
    }

    protected <T> T getRTObject(Class<T> cls, String strId, boolean bAutowire) {
        String strRTObjectName = this.getRTObjectName(cls, strId);
        if (!StringUtils.hasLength((String)strRTObjectName)) {
            return null;
        }
        Object t = RuntimeObjectFactory.getInstance().getObject(cls, strRTObjectName);
        if (t != null && bAutowire) {
            this.getSystemRuntime().autowareObject(t);
        }
        return (T)t;
    }

    protected boolean isEnableRuntimeServiceMode() {
        return this.isEnableRTCodeMode();
    }

    protected IEntityDTO createEntityDTO(IPSDEMethodDTO iPSDEMethodDTO) {
        IDEMethodDTO object = this.getRTObject(IDEMethodDTO.class, iPSDEMethodDTO.getId(), false);
        if (object != null) {
            return (IEntityDTO)object;
        }
        return super.createEntityDTO(iPSDEMethodDTO);
    }

    protected ISearchContextDTO createSearchContextDTO(IPSDEMethodDTO iPSDEMethodDTO) {
        IDEMethodDTO object = this.getRTObject(IDEMethodDTO.class, iPSDEMethodDTO.getId(), false);
        if (object != null) {
            return (ISearchContextDTO)object;
        }
        return super.createSearchContextDTO(iPSDEMethodDTO);
    }

    public boolean fillEntityKeyValue(IEntityBase objEntity) {
        if (DataTypeUtils.isNumberDataType((int)this.getKeyPSDEField().getStdDataType())) {
            String strDEFType = this.getKeyPSDEField().getDataType();
            if ("ACID".equals(strDEFType)) {
                this.resetFieldValue(objEntity, this.getKeyPSDEField());
            } else {
                this.setFieldValue(objEntity, this.getKeyPSDEField(), this.getNumberId());
            }
            return false;
        }
        return super.fillEntityKeyValue(objEntity);
    }

    protected Object getNumberId() {
        String strTableName = this.getTableName();
        return KeyValueUtils.genNumberId((String)String.format("%1$s|%2$s", this.getSystemRuntime().getDeploySystemId(), StringUtils.hasLength((String)strTableName) ? strTableName : this.getId()));
    }

    public void setSearchCustomCondition(ISearchContextBase iSearchContextBase, String strCustomCondition) {
        Pattern bracketPattern = Pattern.compile("\\[(.*?)]");
        Matcher matcher = bracketPattern.matcher(strCustomCondition);
        if (matcher.find()) {
            ISearchContextDTO iSearchContextDTO = this.getSearchContextDTO(iSearchContextBase);
            SearchContextDTO.addSearchPredefinedCond((ISearchContextDTO)iSearchContextDTO, (String)strCustomCondition, null);
            return;
        }
        super.setSearchCustomCondition(iSearchContextBase, strCustomCondition);
    }

    protected boolean checkFieldQueryCountCondition(Object objValue, IEntityBase arg0, IPSDEFVRQueryCountCondition iPSDEFVRQueryCountCondition, IPSDEField iPSDEField) throws Throwable {
        String strRuleInfo = iPSDEFVRQueryCountCondition.getRuleInfo();
        IPSDEDataQuery iPSDEDataQuery = iPSDEFVRQueryCountCondition.getPSDEDataQuery();
        ISearchContextDTO searchContext = this.createSearchContext();
        searchContext.setCount(true);
        EntityBase datacontext = (EntityBase)arg0;
        if (datacontext != null) {
            searchContext.putAll(datacontext.any());
            searchContext.set("datacontext", (Object)datacontext.any());
        }
        searchContext.set("sessioncontext", (Object)ActionSessionManager.getUserContextMust().getSessionParams());
        List result = this.selectDataQuery(iPSDEDataQuery, searchContext);
        Integer nMinValue = iPSDEFVRQueryCountCondition.getMinValue();
        Integer nMaxValue = iPSDEFVRQueryCountCondition.getMaxValue();
        boolean bIncMinValue = iPSDEFVRQueryCountCondition.isIncludeMinValue();
        boolean bIncMaxValue = iPSDEFVRQueryCountCondition.isIncludeMaxValue();
        boolean bTryMode = !iPSDEFVRQueryCountCondition.isKeyCond();
        int nSize = result.size();
        if (nMinValue != null) {
            if (bIncMinValue) {
                if (nSize < nMinValue) {
                    if (bTryMode) {
                        return false;
                    }
                    throw this.createDEFVRConditionException((IPSDEFVRCondition)iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            } else if (nSize <= nMinValue) {
                if (bTryMode) {
                    return false;
                }
                throw this.createDEFVRConditionException((IPSDEFVRCondition)iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
            }
        }
        if (nMaxValue != null) {
            if (bIncMaxValue) {
                if (nSize > nMaxValue) {
                    if (bTryMode) {
                        return false;
                    }
                    throw this.createDEFVRConditionException((IPSDEFVRCondition)iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
                }
            } else if (nSize >= nMaxValue) {
                if (bTryMode) {
                    return false;
                }
                throw this.createDEFVRConditionException((IPSDEFVRCondition)iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
            }
        }
        return true;
    }

    @Override
    public IDEWFRuntime getDefaultDEWFRuntime() {
        return (IDEWFRuntime)super.getDefaultDEWFRuntime();
    }

    @Override
    public IDEWFRuntime getDEWFRuntime(IPSDEWF iPSDEWF) {
        return (IDEWFRuntime)super.getDEWFRuntime(iPSDEWF);
    }

    public net.ibizsys.runtime.dataentity.logic.IDELogicRuntime createDELogicRuntime(IPSDELogic iPSDELogic) {
        if (this.isEnableRTCodeMode() && iPSDELogic.getPSSysSFPlugin() == null && this.getSystemRuntime() instanceof IServiceSystemRuntime) {
            IServiceSystemRuntime iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
            try {
                String strRTObjectName = iServiceSystemRuntime.getRTCodeUtils().getRTObjectName(iPSDELogic);
                this.registerRTObjectName(net.ibizsys.runtime.dataentity.logic.IDELogicRuntime.class, iPSDELogic.getId(), strRTObjectName);
                net.ibizsys.runtime.dataentity.logic.IDELogicRuntime iDELogicRuntime = this.getRTObject(net.ibizsys.runtime.dataentity.logic.IDELogicRuntime.class, iPSDELogic.getId(), true);
                if (iDELogicRuntime != null) {
                    return iDELogicRuntime;
                }
            }
            catch (Exception ex) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this, String.format("\u83b7\u53d6\u5b9e\u4f53\u903b\u8f91[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDELogic.getName(), ex.getMessage()), (Throwable)ex);
            }
        }
        return super.createDELogicRuntime(iPSDELogic);
    }

    protected net.ibizsys.runtime.dataentity.logic.IDELogicRuntime createDefaultDELogicRuntime(IPSDELogic iPSDELogic) {
        return new DELogicRuntime();
    }

    protected IDEDataFlowRuntime createDefaultDEDataFlowRuntime(IPSDEDataFlow iPSDEDataFlow) {
        return new DEDataFlowRuntime();
    }

    public boolean isEnableRTCodeMode() {
        this.prepare();
        return this.bEnableRTCodeMode;
    }

    public IDEService getDEService() {
        if (this.isEnableRTCodeMode()) {
            if (this.proxyDEService == null) {
                this.prepare();
            }
            return this.proxyDEService;
        }
        return super.getDEService();
    }

    @Override
    public <T> T getProxyDEService(Class<?> cls) {
        try {
            Object serviceObject;
            if (this.proxyDEServiceMap == null) {
                this.proxyDEServiceMap = new ConcurrentHashMap();
            }
            if ((serviceObject = this.proxyDEServiceMap.get(cls)) == null) {
                serviceObject = this.createProxyDEService(cls);
                this.proxyDEServiceMap.put(cls, serviceObject);
            }
            return (T)serviceObject;
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this, String.format("\u83b7\u53d6\u5b9e\u4f53\u4ee3\u7406\u670d\u52a1\u5bf9\u8c61[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", cls.getName(), ex.getMessage()), ex);
        }
    }

    protected <T> T createProxyDEService(Class<?> cls) throws Exception {
        DEServiceInvocationHandler deServiceInvocationHandler = new DEServiceInvocationHandler(this.getDataEntityRuntimeContext(), cls);
        return (T)deServiceInvocationHandler.getProxyDEService();
    }

    protected IDataEntityAccessManager createDataEntityAccessManager() {
        if (this.isEnableRTCodeMode() && this.getSystemRuntime() instanceof IServiceSystemRuntime) {
            IServiceSystemRuntime iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
            try {
                String strRTObjectName = iServiceSystemRuntime.getRTCodeUtils().getDEAccessManagerObjectName(this.getPSDataEntity());
                this.registerRTObjectName(IDataEntityAccessManager.class, this.getPSDataEntity().getId(), strRTObjectName);
                IDataEntityAccessManager iDataEntityAccessManager = this.getRTObject(IDataEntityAccessManager.class, this.getPSDataEntity().getId(), true);
                if (iDataEntityAccessManager != null) {
                    return iDataEntityAccessManager;
                }
            }
            catch (Exception ex) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this, String.format("\u83b7\u53d6\u5b9e\u4f53\u8bbf\u95ee\u63a7\u5236\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            }
        }
        return super.createDataEntityAccessManager();
    }

    @Override
    public ImportDataResult importData2(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        boolean bOpenActionSession;
        this.prepare();
        boolean bl = bOpenActionSession = ActionSessionManager.getCurrentSession() == null;
        if (bOpenActionSession) {
            ActionSessionManager.openSession().setName(this.getName());
            ActionSessionManager.getCurrentSession().setUserContext(this.getUserContext());
        }
        try {
            this.pushDataSource();
            IDynaInstRuntime lastDynaInstRuntime = ActionSessionManager.getCurrentSession().getDynaInstRuntime();
            IDynaInstRuntime lastChildDynaInstRuntime = ActionSessionManager.getCurrentSession().getChildDynaInstRuntime();
            String strLastSessionId = ActionSessionManager.getCurrentSession().getSessionId();
            ActionSessionManager.getCurrentSession().setSessionId(KeyValueUtils.genGuidEx());
            ActionSessionManager.getCurrentSession().beginLog(this.getName(), String.format("\u5bfc\u5165\u6570\u636e[%1$s]", strImportTag));
            ImportDataResult ret = this.onImportData2(strImportTag, baseEntity, inputStream, v2ImportSchema, bTestPriv, parentDataEntityRuntime, strParentKey);
            ActionSessionManager.getCurrentSession().setSessionId(strLastSessionId);
            ActionSessionManager.getCurrentSession().setDynaInstRuntime(lastDynaInstRuntime);
            ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(lastChildDynaInstRuntime);
            IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null);
            if (bOpenActionSession) {
                if (iActionSessionLog != null && iActionSessionLog.getTime() >= (long)ActionSessionManager.getImportDataLogPOTime()) {
                    this.getSystemRuntime().logPO(30000, "DEDATAIMP", iActionSessionLog.toString(true), this.getName(), String.format("\u5bfc\u5165\u6570\u636e[%1$s]", strImportTag), iActionSessionLog.getTime(), (Object)iActionSessionLog);
                }
                ActionSessionManager.closeSession((boolean)true);
            }
            ImportDataResult importDataResult = ret;
            return importDataResult;
        }
        catch (Throwable ex) {
            ActionSessionManager.getCurrentSession().setDynaInstRuntime(null);
            ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(null);
            if (bOpenActionSession) {
                IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(ex.getMessage(), true, ex);
                if (iActionSessionLog != null) {
                    String strInfo = String.format("\u5b9e\u4f53[%1$s]\u6570\u636e\u5bfc\u5165[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s\r\n%4$s", this.getName(), strImportTag, ex.getMessage(), iActionSessionLog.toObjectNode().toString());
                    this.getSystemRuntime().log(40000, "DEDATAIMP", strInfo, (Object)ex);
                }
                ActionSessionManager.closeSession((boolean)false);
            }
            throw ex;
        }
        finally {
            this.pollDataSource();
        }
    }

    protected ImportDataResult onImportData2(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        net.ibizsys.runtime.dataentity.dataimport.IDEDataImportRuntime iDEDataImportRuntime = this.getDEDataImportRuntime(strImportTag);
        if (iDEDataImportRuntime instanceof IDEDataImportRuntime) {
            return ((IDEDataImportRuntime)iDEDataImportRuntime).importStream2(baseEntity, inputStream, v2ImportSchema, bTestPriv, parentDataEntityRuntime, strParentKey);
        }
        throw new Exception(String.format("\u5bf9\u8c61[%1$s]\u672a\u652f\u6301\u589e\u5f3a\u5bfc\u5165\u6570\u636e", iDEDataImportRuntime));
    }

    @Override
    public Map<Integer, EntityError> importData(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        boolean bOpenActionSession;
        this.prepare();
        boolean bl = bOpenActionSession = ActionSessionManager.getCurrentSession() == null;
        if (bOpenActionSession) {
            ActionSessionManager.openSession().setName(this.getName());
            ActionSessionManager.getCurrentSession().setUserContext(this.getUserContext());
        }
        try {
            this.pushDataSource();
            IDynaInstRuntime lastDynaInstRuntime = ActionSessionManager.getCurrentSession().getDynaInstRuntime();
            IDynaInstRuntime lastChildDynaInstRuntime = ActionSessionManager.getCurrentSession().getChildDynaInstRuntime();
            String strLastSessionId = ActionSessionManager.getCurrentSession().getSessionId();
            ActionSessionManager.getCurrentSession().setSessionId(KeyValueUtils.genGuidEx());
            ActionSessionManager.getCurrentSession().beginLog(this.getName(), String.format("\u5bfc\u5165\u6570\u636e[%1$s]", strImportTag));
            Map<Integer, EntityError> ret = this.onImportData(strImportTag, baseEntity, inputStream, v2ImportSchema, bTestPriv, parentDataEntityRuntime, strParentKey);
            ActionSessionManager.getCurrentSession().setSessionId(strLastSessionId);
            ActionSessionManager.getCurrentSession().setDynaInstRuntime(lastDynaInstRuntime);
            ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(lastChildDynaInstRuntime);
            IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null);
            if (bOpenActionSession) {
                if (iActionSessionLog != null && iActionSessionLog.getTime() >= (long)ActionSessionManager.getImportDataLogPOTime()) {
                    this.getSystemRuntime().logPO(30000, "DEDATAIMP", iActionSessionLog.toString(true), this.getName(), String.format("\u5bfc\u5165\u6570\u636e[%1$s]", strImportTag), iActionSessionLog.getTime(), (Object)iActionSessionLog);
                }
                ActionSessionManager.closeSession((boolean)true);
            }
            Map<Integer, EntityError> map = ret;
            return map;
        }
        catch (Throwable ex) {
            ActionSessionManager.getCurrentSession().setDynaInstRuntime(null);
            ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(null);
            if (bOpenActionSession) {
                IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(ex.getMessage(), true, ex);
                if (iActionSessionLog != null) {
                    String strInfo = String.format("\u5b9e\u4f53[%1$s]\u6570\u636e\u5bfc\u5165[%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s\r\n%4$s", this.getName(), strImportTag, ex.getMessage(), iActionSessionLog.toObjectNode().toString());
                    this.getSystemRuntime().log(40000, "DEDATAIMP", strInfo, (Object)ex);
                }
                ActionSessionManager.closeSession((boolean)false);
            }
            throw ex;
        }
        finally {
            this.pollDataSource();
        }
    }

    protected Map<Integer, EntityError> onImportData(String strImportTag, IEntity baseEntity, InputStream inputStream, V2ImportSchema v2ImportSchema, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        net.ibizsys.runtime.dataentity.dataimport.IDEDataImportRuntime iDEDataImportRuntime = this.getDEDataImportRuntime(strImportTag);
        if (iDEDataImportRuntime instanceof IDEDataImportRuntime) {
            return ((IDEDataImportRuntime)iDEDataImportRuntime).importStream(baseEntity, inputStream, v2ImportSchema, bTestPriv, parentDataEntityRuntime, strParentKey);
        }
        throw new Exception(String.format("\u5bf9\u8c61[%1$s]\u672a\u652f\u6301\u589e\u5f3a\u5bfc\u5165\u6570\u636e", iDEDataImportRuntime));
    }

    @Override
    public boolean isEnableExtension() {
        this.prepare();
        return this.bEnableExtension;
    }

    protected void prepareDEExtensionUtilRuntime() throws Exception {
        if (this.iDEExtensionUtilRuntime != null) {
            return;
        }
        List psDEUtils = this.getPSDataEntity().getAllPSDEUtils();
        if (!ObjectUtils.isEmpty((Object)psDEUtils)) {
            for (IPSDEUtil iPSDEUtil : psDEUtils) {
                IDEUtilRuntime iDEUtilRuntime;
                if (!PSModelEnums.DEUtilType.EXTENSION.value.equals(iPSDEUtil.getUtilType()) || !((iDEUtilRuntime = this.registerPSDEUtil(iPSDEUtil)) instanceof IDEExtensionUtilRuntime)) continue;
                this.iDEExtensionUtilRuntime = (IDEExtensionUtilRuntime)iDEUtilRuntime;
                break;
            }
        }
        if (this.iDEExtensionUtilRuntime == null) {
            IDEExtensionUtilRuntime iDEExtensionUtilRuntime = null;
            ISysExtensionUtilRuntime iSysExtensionUtilRuntime = (ISysExtensionUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
            iDEExtensionUtilRuntime = iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly) ? ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).createDEExtensionUtilRuntime(this) : iSysExtensionUtilRuntime.createDEExtensionUtilRuntime(this);
            if (iDEExtensionUtilRuntime != null) {
                ObjectNode objectNode = JsonUtils.createObjectNode();
                objectNode.put("utilType", PSModelEnums.DEUtilType.EXTENSION.value);
                objectNode.put("id", PSModelEnums.DEUtilType.EXTENSION.value);
                objectNode.put("name", PSModelEnums.DEUtilType.EXTENSION.value);
                IPSDEUtil iPSDEUtil = (IPSDEUtil)this.getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSDataEntity(), IPSDEUtil.class, objectNode);
                iDEExtensionUtilRuntime.init((IDataEntityRuntimeContext)this.getDataEntityRuntimeContext(), iPSDEUtil);
                this.iDEExtensionUtilRuntime = iDEExtensionUtilRuntime;
            }
        }
        this.bEnableExtension = this.iDEExtensionUtilRuntime != null;
    }

    @Override
    public IDEExtensionUtilRuntime getDEExtensionUtilRuntime() {
        if (this.isEnableExtension()) {
            if (this.iDEExtensionUtilRuntime == null) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this, String.format("\u542f\u7528\u5b9e\u4f53\u6269\u5c55\u4f46\u672a\u6307\u5b9a\u6269\u5c55\u7ec4\u4ef6\u5bf9\u8c61", new Object[0]));
            }
            return this.iDEExtensionUtilRuntime;
        }
        return null;
    }

    @Override
    public void reloadExtension(V2SystemExtensionSuite v2SystemExtensionSuite) {
        this.prepare();
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null) {
            iDEExtensionUtilRuntime.reloadExtension(v2SystemExtensionSuite);
        }
    }

    protected net.ibizsys.runtime.dataentity.logic.IDELogicRuntime getDELogicRuntime(IPSDELogic iPSDELogic, boolean bTryMode) {
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime;
        net.ibizsys.runtime.dataentity.logic.IDELogicRuntime iDELogicRuntime = super.getDELogicRuntime(iPSDELogic, bTryMode);
        if (iDELogicRuntime != null && (iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime()) != null) {
            return iDEExtensionUtilRuntime.getDELogicRuntime((IDELogicRuntime)iDELogicRuntime);
        }
        return iDELogicRuntime;
    }

    protected net.ibizsys.runtime.dataentity.logic.IDEMSLogicRuntime getDEMSLogicRuntime(IPSDEMSLogic iPSDEMSLogic, boolean bTryMode) {
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime;
        net.ibizsys.runtime.dataentity.logic.IDEMSLogicRuntime iDEMSLogicRuntime = super.getDEMSLogicRuntime(iPSDEMSLogic, bTryMode);
        if (iDEMSLogicRuntime != null && (iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime()) != null) {
            return iDEExtensionUtilRuntime.getDEMSLogicRuntime((IDEMSLogicRuntime)iDEMSLogicRuntime);
        }
        return iDEMSLogicRuntime;
    }

    protected boolean isEnableActionLogic(IPSDEAction iPSDEAction, String strAttachMode) {
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null && iDEExtensionUtilRuntime.isEnableActionLogic(iPSDEAction, strAttachMode)) {
            return true;
        }
        return super.isEnableActionLogic(iPSDEAction, strAttachMode);
    }

    protected void executeActionLogics(IEntityBase arg0, IPSDEAction iPSDEAction, String strAttachMode, IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
        super.executeActionLogics(arg0, iPSDEAction, strAttachMode, iDynaInstDataEntityRuntime, iDynaInstRuntime, actionData);
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null) {
            iDEExtensionUtilRuntime.executeActionLogics(arg0, iPSDEAction, strAttachMode);
        }
    }

    @Override
    public V2SystemExtensionLogic[] getExtensionLogics(String strLogicType) {
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null) {
            return iDEExtensionUtilRuntime.getExtensionLogics(strLogicType);
        }
        return null;
    }

    @Override
    public Object executeExtensionLogic(V2SystemExtensionLogic v2SystemExtensionLogic, Object objData) throws Throwable {
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null) {
            return iDEExtensionUtilRuntime.executeExtensionLogic(v2SystemExtensionLogic, objData);
        }
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this, String.format("\u672a\u652f\u6301\u5b9e\u4f53\u6269\u5c55", new Object[0]));
    }

    public void notify(Object key, String strEvent, Object eventData, Object eventData2, Object eventData3, Object eventData4) throws Throwable {
        super.notify(key, strEvent, eventData, eventData2, eventData3, eventData4);
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null) {
            iDEExtensionUtilRuntime.notify(key, strEvent, eventData, eventData2, eventData3, eventData4);
        }
    }

    public IDEMSLogicRuntime getDEMSLogicRuntime(IEntity iEntity, boolean bTryMode) {
        IDEMSLogicRuntime iDEMSLogicRuntime;
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null && (iDEMSLogicRuntime = iDEExtensionUtilRuntime.getDEMSLogicRuntime(iEntity, true)) != null) {
            return iDEMSLogicRuntime;
        }
        return super.getDEMSLogicRuntime(iEntity, bTryMode);
    }

    protected void checkDEMainState(Object arg, IPSDEAction iPSDEAction) throws Exception {
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null) {
            iDEExtensionUtilRuntime.checkDEMainState(arg, iPSDEAction);
        }
        super.checkDEMainState(arg, iPSDEAction);
    }

    protected boolean onTestDataAccessAction(Object dataOrKey, String strAccessAction) throws Exception {
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null && !iDEExtensionUtilRuntime.testDataAccessAction(dataOrKey, strAccessAction)) {
            return false;
        }
        return super.onTestDataAccessAction(dataOrKey, strAccessAction);
    }

    @Override
    public String getExtensionSessionId() {
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime();
        if (iDEExtensionUtilRuntime != null) {
            return iDEExtensionUtilRuntime.getExtensionSessionId();
        }
        return null;
    }

    public List<IPSDEField> getPSDEFields(boolean bExtension) {
        List<IPSDEField> extendPSDEFields;
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime;
        if (bExtension && (iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime()) != null && !ObjectUtils.isEmpty(extendPSDEFields = iDEExtensionUtilRuntime.getPSDEFields(null))) {
            ArrayList<IPSDEField> allList = new ArrayList<IPSDEField>();
            List orginList = super.getPSDEFields(bExtension);
            if (!ObjectUtils.isEmpty((Object)orginList)) {
                allList.addAll(orginList);
            }
            allList.addAll(extendPSDEFields);
            return allList;
        }
        return super.getPSDEFields(bExtension);
    }

    public IPSDEField getPSDEField(boolean bExtension, String strName, boolean bTryMode) {
        IDEExtensionUtilRuntime iDEExtensionUtilRuntime;
        if (bExtension && (iDEExtensionUtilRuntime = this.getDEExtensionUtilRuntime()) != null) {
            IPSDEField iPSDEField = super.getPSDEField(bExtension, strName, true);
            if (iPSDEField != null) {
                return iPSDEField;
            }
            List<IPSDEField> extendPSDEFields = iDEExtensionUtilRuntime.getPSDEFields(null);
            if (!ObjectUtils.isEmpty(extendPSDEFields)) {
                for (IPSDEField item : extendPSDEFields) {
                    if (!strName.equalsIgnoreCase(item.getName())) continue;
                    return item;
                }
            }
            if (!bTryMode) {
                return super.getPSDEField(bExtension, strName, bTryMode);
            }
            return null;
        }
        return super.getPSDEField(bExtension, strName, bTryMode);
    }
}

