/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.codelist;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.central.cloud.core.sysutil.ISysConfUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.CodeItem;
import net.ibizsys.central.cloud.core.util.domain.CodeList;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.runtime.codelist.PredefinedCodeListRuntime;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CloudCodeListRuntime
extends PredefinedCodeListRuntime {
    private List<IPSCodeItem> psCodeItemList = null;

    public List<IPSCodeItem> getPSCodeItems() {
        return this.onGetPSCodeItems();
    }

    protected synchronized List<IPSCodeItem> onGetPSCodeItems() {
        if (this.psCodeItemList != null) {
            return this.psCodeItemList;
        }
        ArrayList<IPSCodeItem> psCodeItemList = new ArrayList<IPSCodeItem>();
        ISysConfUtilRuntime iSysConfUtilRuntime = (ISysConfUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysConfUtilRuntime.class, false);
        CodeList codeList = iSysConfUtilRuntime.getCodeList(this.getPSCodeList().getCodeName(), false);
        if (!ObjectUtils.isEmpty(codeList.getItems())) {
            for (CodeItem codeItem : codeList.getItems()) {
                ObjectNode itemNode = this.getPSCodeItemNode(codeItem);
                IPSCodeItem iPSCodeItem = (IPSCodeItem)this.getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSCodeList(), IPSCodeItem.class, itemNode);
                psCodeItemList.add(iPSCodeItem);
            }
        }
        if (this.psCodeItemList == null) {
            this.psCodeItemList = psCodeItemList;
        }
        return this.psCodeItemList;
    }

    public ObjectNode getPSCodeItemNode(CodeItem codeItem) {
        ObjectNode objNode = JsonUtils.createObjectNode();
        objNode.put("id", String.valueOf(codeItem.getValue()));
        objNode.put("name", String.valueOf(codeItem.getText()));
        objNode.put("value", String.valueOf(codeItem.getValue()));
        objNode.put("text", String.valueOf(codeItem.getText()));
        if (StringUtils.hasLength((String)codeItem.getColor())) {
            objNode.put("color", String.valueOf(codeItem.getColor()));
        }
        if (StringUtils.hasLength((String)codeItem.getBKColor())) {
            objNode.put("bKColor", String.valueOf(codeItem.getBKColor()));
        }
        if (StringUtils.hasLength((String)codeItem.getCls())) {
            objNode.put("textCls", String.valueOf(codeItem.getCls()));
        }
        if (StringUtils.hasLength((String)codeItem.getIconClass())) {
            objNode.put("iconCls", String.valueOf(codeItem.getIconClass()));
        }
        if (DataTypeUtils.getBooleanValue((Object)codeItem.getDisabled(), (Boolean)false).booleanValue()) {
            objNode.put("disableSelect", true);
        }
        return objNode;
    }

    public IPSCodeItem getPSCodeItem(String strItemValue, boolean bTryMode) {
        if (!bTryMode) {
            IPSCodeItem iPSCodeItem = super.getPSCodeItem(strItemValue, true);
            if (iPSCodeItem != null) {
                return iPSCodeItem;
            }
            this.reset();
        }
        return super.getPSCodeItem(strItemValue, bTryMode);
    }

    protected void onReset() {
        this.psCodeItemList = null;
        super.onReset();
    }
}

