/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.bi;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.bi.SysBISchemeRuntimeException;
import net.ibizsys.central.bi.util.IBISearchContext;
import net.ibizsys.central.cloud.core.IServiceSystemRuntime;
import net.ibizsys.central.cloud.core.bi.ISysBICubeRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.V2SystemExtensionBICube;
import net.ibizsys.central.cloud.core.util.domain.V2SystemExtensionBICubeItemType;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.bi.IPSSysBICubeDimension;
import net.ibizsys.model.bi.IPSSysBICubeMeasure;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysBICubeRuntimeBase
extends net.ibizsys.central.bi.SysBICubeRuntimeBase
implements ISysBICubeRuntime {
    private static final Log log = LogFactory.getLog(SysBICubeRuntimeBase.class);
    private String strLastExtensionBICubeCacheData = null;
    private ISysCloudExtensionUtilRuntime iSysCloudExtensionUtilRuntime = null;
    private IServiceSystemRuntime iServiceSystemRuntime = null;
    private Map<String, IPSSysBICubeMeasure> psSysBICubeMeasureMap = new LinkedHashMap<String, IPSSysBICubeMeasure>();
    private Map<String, IPSSysBICubeDimension> psSysBICubeDimensionMap = new LinkedHashMap<String, IPSSysBICubeDimension>();

    protected void onInit() throws Exception {
        if (this.getSystemRuntime() instanceof IServiceSystemRuntime) {
            this.iServiceSystemRuntime = (IServiceSystemRuntime)this.getSystemRuntime();
        }
        super.onInit();
    }

    protected ISysCloudExtensionUtilRuntime getSysCloudExtensionUtilRuntime() {
        if (this.iSysCloudExtensionUtilRuntime == null) {
            this.iSysCloudExtensionUtilRuntime = (ISysCloudExtensionUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudExtensionUtilRuntime.class, false);
        }
        return this.iSysCloudExtensionUtilRuntime;
    }

    protected List onFetch(IBISearchContext iBISearchContext) throws Throwable {
        this.prepareExtensionBICubes();
        return super.onFetch(iBISearchContext);
    }

    protected void prepareExtensionBICubes() throws Exception {
        if (this.getServiceSystemRuntime(true) == null || !this.getServiceSystemRuntime(false).isEnableExtension()) {
            return;
        }
        this.onPrepareExtensionBICubes();
    }

    protected synchronized void onPrepareExtensionBICubes() throws Exception {
        String strCurrentExtensionCacheData = this.getCurrentExtensionBICubeCacheData();
        if (this.strLastExtensionBICubeCacheData == null || !this.strLastExtensionBICubeCacheData.equals(strCurrentExtensionCacheData)) {
            List<V2SystemExtensionBICube> v2SystemExtensionBICubeList = this.getSysCloudExtensionUtilRuntime().getSystemExtensionBICubes(this.getServiceSystemRuntime(false).getExtensionId(), this.getFullUniqueTag());
            for (IPSSysBICubeDimension iPSysBICubeDimension : this.psSysBICubeDimensionMap.values()) {
                this.resetDimensionFormulaCache(iPSysBICubeDimension);
            }
            for (IPSSysBICubeMeasure iPSysBICubeMeasure : this.psSysBICubeMeasureMap.values()) {
                this.resetMeasureFormulaCache(iPSysBICubeMeasure);
            }
            this.psSysBICubeMeasureMap.clear();
            this.psSysBICubeDimensionMap.clear();
            if (!ObjectUtils.isEmpty(v2SystemExtensionBICubeList)) {
                for (V2SystemExtensionBICube v2SystemExtensionBICube : v2SystemExtensionBICubeList) {
                    IPSSysBICubeMeasure iPSSysBICubeMeasure;
                    if (!StringUtils.hasLength((String)v2SystemExtensionBICube.getRuntimeModel())) continue;
                    ObjectNode objectNode = JsonUtils.toObjectNode((Object)v2SystemExtensionBICube.getRuntimeModel());
                    if (V2SystemExtensionBICubeItemType.DIMENSION.value.equals(v2SystemExtensionBICube.getType())) {
                        IPSSysBICubeDimension iPSSysBICubeDimension = (IPSSysBICubeDimension)this.getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSSysBICube(), IPSSysBICubeDimension.class, objectNode);
                        if (!StringUtils.hasLength((String)iPSSysBICubeDimension.getCodeName())) continue;
                        this.psSysBICubeDimensionMap.put(iPSSysBICubeDimension.getCodeName().toLowerCase(), iPSSysBICubeDimension);
                        continue;
                    }
                    if (!V2SystemExtensionBICubeItemType.MEASURE.value.equals(v2SystemExtensionBICube.getType()) || !StringUtils.hasLength((String)(iPSSysBICubeMeasure = (IPSSysBICubeMeasure)this.getSystemRuntime().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSSysBICube(), IPSSysBICubeMeasure.class, objectNode)).getCodeName())) continue;
                    this.psSysBICubeMeasureMap.put(iPSSysBICubeMeasure.getCodeName().toLowerCase(), iPSSysBICubeMeasure);
                }
            }
            this.strLastExtensionBICubeCacheData = strCurrentExtensionCacheData;
        }
    }

    protected String getCurrentExtensionBICubeCacheData() throws Exception {
        return this.getSysCloudExtensionUtilRuntime().getSystemExtensionBICubeCacheData(this.getServiceSystemRuntime(false).getExtensionId(), this.getFullUniqueTag());
    }

    protected String getLastExtensionBICubeCacheData() {
        return this.strLastExtensionBICubeCacheData;
    }

    public IPSSysBICubeMeasure getPSSysBICubeMeasure(String strName, boolean bTryMode) {
        IPSSysBICubeMeasure iPSSysBICubeMeasure = super.getPSSysBICubeMeasure(strName, true);
        if (iPSSysBICubeMeasure != null) {
            return iPSSysBICubeMeasure;
        }
        iPSSysBICubeMeasure = this.psSysBICubeMeasureMap.get(strName.toLowerCase());
        if (iPSSysBICubeMeasure != null || bTryMode) {
            return iPSSysBICubeMeasure;
        }
        throw new SysBISchemeRuntimeException(this.getSysBISchemeRuntime(), (IModelRuntime)this, String.format("\u6307\u5b9a\u7acb\u65b9\u4f53\u7ef4\u5ea6[%1$s]\u4e0d\u5b58\u5728", strName));
    }

    public IPSSysBICubeDimension getPSSysBICubeDimension(String strName, boolean bTryMode) {
        IPSSysBICubeDimension iPSSysBICubeDimension = super.getPSSysBICubeDimension(strName, true);
        if (iPSSysBICubeDimension != null) {
            return iPSSysBICubeDimension;
        }
        iPSSysBICubeDimension = this.psSysBICubeDimensionMap.get(strName.toLowerCase());
        if (iPSSysBICubeDimension != null || bTryMode) {
            return iPSSysBICubeDimension;
        }
        throw new SysBISchemeRuntimeException(this.getSysBISchemeRuntime(), (IModelRuntime)this, String.format("\u6307\u5b9a\u7acb\u65b9\u4f53\u7ef4\u5ea6[%1$s]\u4e0d\u5b58\u5728", strName));
    }

    protected IServiceSystemRuntime getServiceSystemRuntime(boolean bTryMode) throws Exception {
        if (this.iServiceSystemRuntime != null || bTryMode) {
            return this.iServiceSystemRuntime;
        }
        throw new Exception(String.format("\u670d\u52a1\u7cfb\u7edf\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }
}

