/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.ba;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntimeException;
import net.ibizsys.central.cloud.core.sysutil.ISysOSSUtilRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQFieldCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQGroupCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.SearchFieldCond;
import net.ibizsys.runtime.util.SearchGroupCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class CloudOSSBDSchemeRuntime
extends SysBDSchemeRuntime {
    private static final Log log = LogFactory.getLog(CloudOSSBDSchemeRuntime.class);
    public static final String BDTYPE_CLOUDOSS = "CLOUDOSS";
    private ISysOSSUtilRuntime iSysOSSUtilRuntime = null;

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getSysOSSUtilRuntime(true) == null) {
            this.prepareSysOSSUtilRuntime();
        }
    }

    public ISysOSSUtilRuntime getSysOSSUtilRuntime() {
        return this.getSysOSSUtilRuntime(false);
    }

    public ISysOSSUtilRuntime getSysOSSUtilRuntime(boolean bTryMode) {
        if (this.iSysOSSUtilRuntime != null || bTryMode) {
            return this.iSysOSSUtilRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("Mongo\u7cfb\u7edfOSS\u529f\u80fd\u5bf9\u8c61\u5bf9\u8c61\u65e0\u6548", new Object[0]));
    }

    protected void setSysOSSUtilRuntime(ISysOSSUtilRuntime iSysOSSUtilRuntime) {
        this.iSysOSSUtilRuntime = iSysOSSUtilRuntime;
    }

    protected void prepareSysOSSUtilRuntime() throws Exception {
        ISysOSSUtilRuntime iSysOSSUtilRuntime = (ISysOSSUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysOSSUtilRuntime.class, false);
        this.setSysOSSUtilRuntime(iSysOSSUtilRuntime);
    }

    protected void closeSysOSSUtilRuntime() throws Exception {
    }

    public String getDBName() {
        return this.getSystemRuntime().getServiceId();
    }

    protected Object onInsert(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        String strId = null;
        Object objId = arg.get("_id");
        if (objId instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength(strId) && (objId = arg.get("srfkey")) instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength((String)strId)) {
            strId = this.getAutoId();
        }
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.putAll(arg);
        if (extParamMap != null) {
            data.putAll(extParamMap);
        }
        data.put("_id", strId);
        String _id2 = null;
        try {
            _id2 = this.getSysOSSUtilRuntime().createObject(this.getDBName(), strTableName, data);
        }
        catch (Throwable ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u5efa\u7acb\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        if (!strId.equals(_id2)) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u5efa\u7acb\u6570\u636e\u5931\u8d25");
        }
        return _id2;
    }

    protected Object onUpdate(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        String strId = null;
        Object objId = arg.get("_id");
        if (objId instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength(strId) && (objId = arg.get("srfkey")) instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength((String)strId)) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u66f4\u65b0\u6570\u636e\u672a\u6307\u5b9a\u952e\u503c");
        }
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.putAll(arg);
        if (extParamMap != null) {
            data.putAll(extParamMap);
        }
        data.put("_id", strId);
        try {
            if (this.getSysOSSUtilRuntime().updateObject(this.getDBName(), strTableName, data, bAppendMode) != 1) {
                throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6570\u636e\u4e0d\u5b58\u5728");
            }
            return 1;
        }
        catch (Exception ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u66f4\u65b0\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
    }

    protected Object onDelete(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        String strId = null;
        Object objId = arg.get("_id");
        if (objId instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength(strId) && (objId = arg.get("srfkey")) instanceof String) {
            strId = (String)objId;
        }
        if (!StringUtils.hasLength((String)strId)) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u5220\u9664\u6570\u636e\u672a\u6307\u5b9a\u952e\u503c");
        }
        try {
            if (this.getSysOSSUtilRuntime().deleteObject(this.getDBName(), strTableName, strId) != 1) {
                throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6570\u636e\u4e0d\u5b58\u5728");
            }
            return 1;
        }
        catch (Exception ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
    }

    protected Page onFetchDataSet(IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        String strTableName = iDataEntityRuntime.getTableName();
        if (ObjectUtils.isEmpty((Object)strTableName)) {
            throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u672a\u6307\u5b9a\u6570\u636e\u8868\u6807\u8bc6", iDataEntityRuntime.getName()));
        }
        if (iDataEntityRuntime.isEnableLogicValid()) {
            SearchFieldCond searchFieldCond = new SearchFieldCond();
            searchFieldCond.setParamMode(false);
            searchFieldCond.setFieldName(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName());
            searchFieldCond.setCondOp("EQ");
            searchFieldCond.setValue(iDataEntityRuntime.getValidLogicValue());
            iSearchContext.getSearchCondsIf().add(searchFieldCond);
        }
        List selectedPSDEFieldList = null;
        List psDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
        if (!ObjectUtils.isEmpty((Object)psDEDataQueryList)) {
            ArrayList<ISearchCond> orlist = new ArrayList<ISearchCond>();
            for (IPSDEDataQuery iPSDEDataQuery : psDEDataQueryList) {
                ISearchCond iSearchCond;
                if (selectedPSDEFieldList == null) {
                    selectedPSDEFieldList = iDataEntityRuntime.getPSDEFields(iPSDEDataQuery);
                }
                if (iPSDEDataQuery.getPSDEDQMain() == null || iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition() == null || (iSearchCond = this.getSearchCond((IPSDEDQCondition)iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition(), iSearchContext == null ? null : iSearchContext.any(), iDataEntityRuntime)) == null) continue;
                orlist.add(iSearchCond);
            }
            if (!ObjectUtils.isEmpty(orlist)) {
                SearchGroupCond searchGroupCond = new SearchGroupCond();
                searchGroupCond.setCondOp("AND");
                searchGroupCond.getSearchCondsIf().addAll(orlist);
            }
        }
        if (selectedPSDEFieldList == null) {
            selectedPSDEFieldList = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("_id");
        if (selectedPSDEFieldList != null) {
            selectedPSDEFieldList.forEach(t -> fieldList.add(t.getLowerCaseName()));
        }
        iSearchContext.set("fields", fieldList);
        try {
            return this.getSysOSSUtilRuntime().fetchObjects(this.getDBName(), strTableName, iSearchContext);
        }
        catch (Throwable ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u83b7\u53d6\u7ed3\u679c\u96c6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected List onQuery(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        ISearchCond iSearchCond;
        List selectedPSDEFieldList;
        String strTableName = iDataEntityRuntime.getTableName();
        if (ObjectUtils.isEmpty((Object)strTableName)) {
            throw new Exception(String.format("\u5b9e\u4f53[%1$s]\u672a\u6307\u5b9a\u6570\u636e\u8868\u6807\u8bc6", iDataEntityRuntime.getName()));
        }
        if (iDataEntityRuntime.isEnableLogicValid()) {
            SearchFieldCond searchFieldCond = new SearchFieldCond();
            searchFieldCond.setParamMode(false);
            searchFieldCond.setFieldName(iDataEntityRuntime.getLogicValidPSDEField().getLowerCaseName());
            searchFieldCond.setCondOp("EQ");
            searchFieldCond.setValue(iDataEntityRuntime.getValidLogicValue());
            iSearchContext.getSearchCondsIf().add(searchFieldCond);
        }
        if ((selectedPSDEFieldList = null) == null) {
            selectedPSDEFieldList = iDataEntityRuntime.getPSDEFields(iPSDEDataQuery);
        }
        if (iPSDEDataQuery.getPSDEDQMain() != null && iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition() != null && (iSearchCond = this.getSearchCond((IPSDEDQCondition)iPSDEDataQuery.getPSDEDQMain().getPSDEDQGroupCondition(), iSearchContext == null ? null : iSearchContext.any(), iDataEntityRuntime)) != null) {
            iSearchContext.getSearchCondsIf().add(iSearchCond);
        }
        if (selectedPSDEFieldList == null) {
            selectedPSDEFieldList = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("_id");
        if (selectedPSDEFieldList != null) {
            selectedPSDEFieldList.forEach(t -> fieldList.add(t.getLowerCaseName()));
        }
        iSearchContext.set("fields", fieldList);
        try {
            Page page = this.getSysOSSUtilRuntime().fetchObjects(this.getDBName(), strTableName, iSearchContext);
            return page.getContent();
        }
        catch (Throwable ex) {
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u83b7\u53d6\u6570\u636e\u67e5\u8be2\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected ISearchCond getSearchCond(IPSDEDQCondition iPSDEDQCondition, Map<String, Object> params, IDataEntityRuntime iDataEntityRuntime) throws Throwable {
        if (iPSDEDQCondition instanceof IPSDEDQGroupCondition) {
            ArrayList<ISearchCond> list = new ArrayList<ISearchCond>();
            IPSDEDQGroupCondition iPSDEDQGroupCondition = (IPSDEDQGroupCondition)iPSDEDQCondition;
            List psDEDQConditions = iPSDEDQGroupCondition.getPSDEDQConditions();
            if (psDEDQConditions != null) {
                for (IPSDEDQCondition item : psDEDQConditions) {
                    ISearchCond iSearchCond = this.getSearchCond(item, params, iDataEntityRuntime);
                    if (iSearchCond == null) continue;
                    list.add(iSearchCond);
                }
            }
            if (list.size() > 0) {
                SearchGroupCond searchGroupCond = new SearchGroupCond();
                if (iPSDEDQGroupCondition.isNotMode()) {
                    searchGroupCond.setNotMode(true);
                }
                searchGroupCond.setCondOp(iPSDEDQGroupCondition.getCondOp());
                searchGroupCond.getSearchCondsIf().addAll(list);
            } else {
                return null;
            }
        }
        if (iPSDEDQCondition instanceof IPSDEDQFieldCondition) {
            Object objValue;
            IPSDEDQFieldCondition iPSDEDQFieldCondition = (IPSDEDQFieldCondition)iPSDEDQCondition;
            String strVarType = iPSDEDQFieldCondition.getPSVARTypeId();
            if (StringUtils.hasLength((String)strVarType)) {
                objValue = null;
                if (StringUtils.hasLength((String)iPSDEDQFieldCondition.getCondValue())) {
                    objValue = params == null ? null : params.get(iPSDEDQFieldCondition.getCondValue().toLowerCase());
                }
                return this.getSearchCond(iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue, iDataEntityRuntime);
            }
            objValue = iPSDEDQFieldCondition.getCondValue();
            IPSDEField iPSDEField = iDataEntityRuntime.getPSDEField(iPSDEDQFieldCondition.getFieldName(), true);
            if (iPSDEField != null) {
                objValue = iDataEntityRuntime.convertValue(iPSDEField.getStdDataType(), (String)objValue);
            }
            return this.getSearchCond(iPSDEDQFieldCondition.getFieldName(), iPSDEDQFieldCondition.getCondOp(), objValue, iDataEntityRuntime);
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u641c\u7d22\u6761\u4ef6\u7c7b\u578b[%1$s]", iPSDEDQCondition.getCondType()));
    }

    protected ISearchCond getSearchCond(String strFieldName, String strCondition, Object objValue, IDataEntityRuntime iDataEntityRuntime) throws Throwable {
        if (StringUtils.hasLength((String)strFieldName)) {
            IPSDEField iPSDEField;
            strFieldName = strFieldName.toLowerCase();
            if (iDataEntityRuntime != null && (iPSDEField = iDataEntityRuntime.getPSDEField(strFieldName, true)) != null && iPSDEField.isKeyDEField()) {
                strFieldName = "_id";
            }
        } else {
            throw new Exception("\u672a\u6307\u5b9a\u5c5e\u6027\u6807\u8bc6");
        }
        SearchFieldCond searchFieldCond = new SearchFieldCond();
        searchFieldCond.setFieldName(strFieldName);
        searchFieldCond.setParamMode(false);
        searchFieldCond.setCondOp(strCondition);
        searchFieldCond.setValue(objValue);
        return searchFieldCond;
    }

    protected String getAutoId() {
        return String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS%2$s", new Date(), KeyValueUtils.genUniqueId());
    }

    protected void onShutdown() throws Exception {
        try {
            this.closeSysOSSUtilRuntime();
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u5173\u95ed\u7cfb\u7edfOSS\u529f\u80fd\u5bf9\u8c61\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        super.onShutdown();
    }
}

