/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.app;

import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import net.ibizsys.central.app.ApplicationRuntimeException;
import net.ibizsys.central.app.IApplicationRuntime;
import net.ibizsys.central.cloud.core.app.ServletAppRuntimeBase;
import net.ibizsys.central.cloud.core.app.util.AppTemplateUtils;
import net.ibizsys.central.cloud.core.util.RestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class GroovyServletAppRuntime
extends ServletAppRuntimeBase {
    private static final Log log = LogFactory.getLog(GroovyServletAppRuntime.class);
    private GStringTemplateEngine engine = new GStringTemplateEngine();
    private Map<String, Template> templateCacheMap = new ConcurrentHashMap<String, Template>();
    private Map<String, String> templatePathMap = new HashMap<String, String>();
    private boolean enableTemplateCache = true;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Object templateUtils = new AppTemplateUtils();

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        try {
            this.prepareTemplates();
        }
        catch (Exception ex) {
            throw new Exception(String.format("\u51c6\u5907\u6a21\u677f\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected boolean isEnableTemplateCache() {
        return this.enableTemplateCache;
    }

    protected void setEnableTemplateCache(boolean enableTemplateCache) {
        this.enableTemplateCache = enableTemplateCache;
    }

    protected void resetTemplates() {
        this.templateCacheMap.clear();
        this.templatePathMap.clear();
    }

    protected void prepareTemplates() throws Exception {
    }

    protected void reloadTemplates() throws Exception {
        this.resetTemplates();
        this.prepareTemplates();
    }

    protected Template registerTemplate(String pattern, String path) throws Exception {
        Resource resource = this.getResource(path);
        if (resource == null) {
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6a21\u677f\u8d44\u6e90[%1$s]", path));
        }
        if (!this.isEnableTemplateCache()) {
            this.templatePathMap.put(pattern, path);
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader(resource.getInputStream());){
            Template template = this.registerTemplate(pattern, inputStreamReader);
            return template;
        }
    }

    protected Template registerTemplate(String pattern, Reader reader) throws Exception {
        try {
            Template template = this.engine.createTemplate(reader);
            this.templateCacheMap.put(pattern, template);
            return template;
        }
        catch (Exception ex) {
            throw new Exception(String.format("\u7f16\u8bd1\u6a21\u677f[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", pattern, ex.getMessage()), ex);
        }
    }

    protected Template unregisterTemplate(String pattern) {
        return this.templateCacheMap.remove(pattern);
    }

    protected Object getTemplateUtils() {
        return this.templateUtils;
    }

    protected void setTemplateUtils(Object templateUtils) {
        this.templateUtils = templateUtils;
    }

    @Override
    protected Resource onResolveResource(HttpServletRequest request, final String requestPath) {
        for (Map.Entry<String, Template> entry : this.templateCacheMap.entrySet()) {
            if (!this.pathMatcher.match(entry.getKey(), requestPath)) continue;
            Map pathVariables = this.pathMatcher.extractUriTemplateVariables(entry.getKey(), requestPath);
            Map<String, Object> queryParams = RestUtils.queryString2Map(request.getQueryString());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("app", this);
            params.put("sys", this.getSystemRuntime());
            params.put("req", request);
            params.put("path", pathVariables);
            params.put("query", queryParams);
            params.put("utils", this.getTemplateUtils());
            try {
                String content = this.getContent(request, requestPath, entry.getKey(), entry.getValue(), params);
                return new ByteArrayResource(content.getBytes("UTF-8")){

                    public String getFilename() {
                        return requestPath;
                    }

                    public long lastModified() throws IOException {
                        return System.currentTimeMillis();
                    }
                };
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException((IApplicationRuntime)this, String.format("\u8f93\u51fa[%1$s]\u6a21\u677f\u53d1\u751f\u5f02\u5e38\uff0c%2$s", requestPath, ex.getMessage()), (Throwable)ex);
            }
        }
        return super.onResolveResource(request, requestPath);
    }

    protected String getContent(HttpServletRequest request, String requestPath, String pattern, Template template, Map<String, Object> params) throws Exception {
        if (!this.isEnableTemplateCache()) {
            template = this.registerTemplate(pattern, this.templatePathMap.get(pattern));
        }
        StringWriter sw = new StringWriter();
        template.make(params).writeTo((Writer)sw);
        return sw.toString();
    }
}

