/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core;

import com.fasterxml.jackson.databind.node.ObjectNode;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import net.ibizsys.central.ISystemLogAdapter;
import net.ibizsys.central.ISystemPersistentAdapter;
import net.ibizsys.central.SystemRuntime;
import net.ibizsys.central.app.IApplicationRuntime;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.backend.ISysBackendTaskRuntime;
import net.ibizsys.central.cloud.core.SystemLogAdapter;
import net.ibizsys.central.cloud.core.SystemPersistentAdapter;
import net.ibizsys.central.cloud.core.app.IServiceAppRuntime;
import net.ibizsys.central.cloud.core.app.IServletAppRuntime;
import net.ibizsys.central.cloud.core.ba.CloudOSSBDSchemeRuntime;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudPortalClient;
import net.ibizsys.central.cloud.core.dataentity.ac.DEChatCompletionRuntime;
import net.ibizsys.central.cloud.core.dataentity.dataflow.DEDataFlowRuntime;
import net.ibizsys.central.cloud.core.dataentity.security.dr.DataSetDRProvider;
import net.ibizsys.central.cloud.core.dataentity.security.dr.DeptDRProvider;
import net.ibizsys.central.cloud.core.dataentity.security.dr.OrgDRProvider;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.SystemAccessManager;
import net.ibizsys.central.cloud.core.service.SysServiceAPIRuntime;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudLogUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncAction;
import net.ibizsys.central.cloud.core.util.domain.PortalAsyncActionState;
import net.ibizsys.central.cloud.core.util.groovy.MetaClassCreationHandle;
import net.ibizsys.central.cloud.core.util.groovy.SystemRTGroovyContext;
import net.ibizsys.central.dataentity.ac.IDEAutoCompleteRuntime;
import net.ibizsys.central.dataentity.dataflow.IDEDataFlowRuntime;
import net.ibizsys.central.dataentity.security.dr.IDataEntityDRProvider;
import net.ibizsys.central.dataentity.wf.IDEWFRuntime;
import net.ibizsys.central.security.ISystemAccessManager;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.service.ISysServiceAPIRuntime;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.service.client.WebClientBase;
import net.ibizsys.central.system.ISysRefRuntime;
import net.ibizsys.central.system.ISystemModuleUtilRuntime;
import net.ibizsys.central.sysutil.ISysCacheUtilRuntime;
import net.ibizsys.central.util.groovy.ISystemRTGroovyContext;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.res.IPSSysUtil;
import net.ibizsys.model.wf.IPSWFRole;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.dataexport.IDEDataExportRuntime;
import net.ibizsys.runtime.dataentity.dataimport.IDEDataImportRuntime;
import net.ibizsys.runtime.dataentity.util.IDEUtilRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.res.ISysUtilRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.INamedAction;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.wf.IWFRoleRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public abstract class ServiceSystemRuntimeBase
extends SystemRuntime {
    private static final Log log = LogFactory.getLog(ServiceSystemRuntimeBase.class);
    static ThreadPoolExecutor globalWorkThreadPoolExecutor;
    private ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = null;

    protected static void setGlobalWorkThreadPoolExecutor(ThreadPoolExecutor globalWorkThreadPoolExecutor) {
        ServiceSystemRuntimeBase.globalWorkThreadPoolExecutor = globalWorkThreadPoolExecutor;
    }

    protected static ThreadPoolExecutor getGlobalWorkThreadPoolExecutor() {
        return globalWorkThreadPoolExecutor;
    }

    public IWebClient createWebClient(Object data) {
        IWebClient iWebClient = (IWebClient)this.getRuntimeObject("GLOBAL_WEBCLIENT", IWebClient.class, true, true);
        if (iWebClient != null) {
            return iWebClient;
        }
        iWebClient = (IWebClient)this.getRuntimeObject(IWebClient.class, null);
        if (iWebClient != null) {
            return iWebClient;
        }
        throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u65e0\u6cd5\u5efa\u7acbWebClient\u5bf9\u8c61", new Object[0]));
    }

    public IWFRoleRuntime createWFRoleRuntime(IPSWFRole iPSWFRole) {
        return super.createWFRoleRuntime(iPSWFRole);
    }

    protected ISysServiceAPIRuntime createDefaultSysServiceAPIRuntime() {
        return new SysServiceAPIRuntime();
    }

    protected ISystemAccessManager createDefaultSystemAccessManager() {
        return new SystemAccessManager();
    }

    protected void onStart() throws Exception {
        super.onStart();
        ISysCloudLogUtilRuntime iSysCloudLogUtilRuntime = (ISysCloudLogUtilRuntime)this.getSysUtilRuntime(ISysCloudLogUtilRuntime.class, true);
        if (iSysCloudLogUtilRuntime == null) {
            this.prepareSysCloudLogUtilRuntime();
        }
    }

    public ISysCacheUtilRuntime getSysCacheUtilRuntime(boolean bTryMode) {
        ISysCacheUtilRuntime iSysCacheUtilRuntime = super.getSysCacheUtilRuntime(true);
        if (iSysCacheUtilRuntime != null) {
            return iSysCacheUtilRuntime;
        }
        return (ISysCacheUtilRuntime)this.getSysUtilRuntime(ISysCacheUtilRuntime.class, bTryMode);
    }

    protected void prepareSysCloudLogUtilRuntime() throws Exception {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("id", "CLOUDLOG");
        objectNode.put("name", "Cloud\u65e5\u5fd7\u6a21\u5757");
        objectNode.put("utilType", "USER");
        objectNode.put("utilTag", "CLOUDLOG");
        objectNode.put("codeName", "CLOUDLOG");
        IPSSysUtil iPSSysUtil = (IPSSysUtil)this.getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSSystem(), IPSSysUtil.class, objectNode);
        ISysCloudLogUtilRuntime iSysCloudLogUtilRuntime = (ISysCloudLogUtilRuntime)this.registerPSSysUtil(iPSSysUtil);
        if (!iSysCloudLogUtilRuntime.isInstalled()) {
            iSysCloudLogUtilRuntime.install();
        }
    }

    protected ISystemLogAdapter createDefaultSystemLogAdapter() {
        return new SystemLogAdapter();
    }

    public void logAudit(int nLogLevel, String strCat, String strInfo, String strPersonId, String strAddress, Object objData) {
        HttpServletRequest httpServletRequest;
        RequestAttributes requestAttributes;
        if (!StringUtils.hasLength((String)strAddress) && (requestAttributes = RequestContextHolder.getRequestAttributes()) instanceof ServletRequestAttributes && !StringUtils.hasLength((String)(strAddress = (httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest()).getHeader("X-Real-IP")))) {
            strAddress = httpServletRequest.getRemoteAddr();
        }
        super.logAudit(nLogLevel, strCat, strInfo, strPersonId, strAddress, objData);
    }

    protected ThreadPoolExecutor createWorkThreadPoolExecutor() {
        ThreadPoolExecutor threadPoolExecutor = ServiceSystemRuntimeBase.getGlobalWorkThreadPoolExecutor();
        if (threadPoolExecutor != null) {
            return threadPoolExecutor;
        }
        return super.createWorkThreadPoolExecutor();
    }

    protected void shutdownWorkThreadPoolExecutor() {
        ThreadPoolExecutor threadPoolExecutor = ServiceSystemRuntimeBase.getGlobalWorkThreadPoolExecutor();
        if (threadPoolExecutor == null) {
            super.shutdownWorkThreadPoolExecutor();
        }
    }

    public IUserContext createDefaultUserContext() {
        return super.createDefaultUserContext();
    }

    public IUserContext createAnonymousUserContext() {
        IUserContext iUserContext = super.createAnonymousUserContext();
        Employee employee = new Employee();
        employee.setUserId(iUserContext.getUserid());
        employee.setUserName(iUserContext.getUsername());
        employee.setPersonName(iUserContext.getUsername());
        EmployeeContext iEmployeeContext = new EmployeeContext(employee, null, this.getDeploySystemId());
        iEmployeeContext.setAnonymoususer(true);
        return iEmployeeContext;
    }

    protected void onInit() throws Exception {
        super.onInit();
    }

    protected boolean isEnableServletApp() {
        return ServiceHub.getInstance().isEnableServletApp();
    }

    protected boolean isEnableServiceApp() {
        return ServiceHub.getInstance().isEnableServiceApp();
    }

    protected boolean isEnableAppGateway() {
        if (!super.isEnableAppGateway()) {
            return this.isEnableServletApp() || this.isEnableServiceApp();
        }
        return true;
    }

    protected IApplicationRuntime createApplicationRuntime(IPSApplication iPSApplication) {
        if (!super.isEnableAppGateway()) {
            if (iPSApplication.getPSSysSFPlugin() == null) {
                return null;
            }
            IApplicationRuntime iApplicationRuntime = super.createApplicationRuntime(iPSApplication);
            if (this.isEnableServletApp() && iApplicationRuntime instanceof IServletAppRuntime) {
                return iApplicationRuntime;
            }
            if (this.isEnableServiceApp() && iApplicationRuntime instanceof IServiceAppRuntime) {
                return iApplicationRuntime;
            }
            return null;
        }
        return super.createApplicationRuntime(iPSApplication);
    }

    public PortalAsyncAction asyncExecute(final IAction iAction, final Object[] args, Object actionTag) throws Throwable {
        String strName = "\u5f02\u6b65\u4f5c\u4e1a";
        if (iAction instanceof INamedAction) {
            strName = ((INamedAction)iAction).getName();
        }
        ICloudPortalClient iCloudPortalClient = (ICloudPortalClient)this.getSysCloudClientUtilRuntime().getServiceClient("ibizcloud-portal", ICloudPortalClient.class);
        PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
        portalAsyncAction.setAsyncAcitonName(strName);
        if (actionTag != null) {
            if (actionTag instanceof Map) {
                portalAsyncAction.putAll((Map)actionTag);
            } else if (actionTag instanceof IEntity) {
                IEntity iEntity = (IEntity)actionTag;
                iEntity.copyTo((IEntity)portalAsyncAction);
            }
        }
        try {
            portalAsyncAction = iCloudPortalClient.createAsyncAction(portalAsyncAction);
        }
        catch (Throwable ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5efa\u7acb\u95e8\u6237\u5f02\u6b65\u4f5c\u4e1a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        final String strAsyncActionId = portalAsyncAction.getAsyncAcitonId();
        this.threadRun(new Runnable(){

            @Override
            public void run() {
                try {
                    ServiceSystemRuntimeBase.this.onAsyncExecute(iAction, args, strAsyncActionId);
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                }
            }
        });
        return portalAsyncAction;
    }

    protected void onAsyncExecute(IAction iAction, Object[] args, final String strAsyncActionId) throws Throwable {
        boolean bOpenActionSession;
        final ICloudPortalClient iCloudPortalClient = (ICloudPortalClient)this.getSysCloudClientUtilRuntime().getServiceClient("ibizcloud-portal", ICloudPortalClient.class);
        boolean bl = bOpenActionSession = ActionSessionManager.getCurrentSession() == null;
        if (bOpenActionSession) {
            ActionSessionManager.openSession().setName(this.getName());
            ActionSessionManager.getCurrentSession().setUserContext((IUserContext)EmployeeContext.getCurrent());
        }
        final ActionSession actionSession = ActionSessionManager.getCurrentSession();
        final String strWorkTag = KeyValueUtils.genUniqueId();
        actionSession.setActionParam(strWorkTag, (Object)"1");
        this.threadRun(new Runnable(){

            @Override
            public void run() {
                Object objValue;
                String strLastActionStep = actionSession.getActionStep();
                double fLastCompletionRate = actionSession.getCompletionRate();
                String strLastActionResult = actionSession.getActionResult();
                while (!ObjectUtils.isEmpty((Object)(objValue = actionSession.getActionParam(strWorkTag)))) {
                    String strActionResult = actionSession.getActionResult();
                    String strActionStep = actionSession.getActionStep();
                    double fCompletionRate = actionSession.getCompletionRate();
                    if (DataTypeUtils.compare((String)strLastActionStep, (String)strActionStep) != 0L || fLastCompletionRate != fCompletionRate || DataTypeUtils.compare((String)strLastActionResult, (String)strActionResult) != 0L) {
                        strLastActionStep = strActionStep;
                        fLastCompletionRate = fCompletionRate;
                        strLastActionResult = strActionResult;
                        PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
                        portalAsyncAction.setAsyncAcitonId(strAsyncActionId);
                        portalAsyncAction.setActionResult(strLastActionResult);
                        portalAsyncAction.setStepInfo(strLastActionStep);
                        portalAsyncAction.set("completionrate", fLastCompletionRate);
                        try {
                            portalAsyncAction = iCloudPortalClient.executeAsyncAction(strAsyncActionId, portalAsyncAction);
                        }
                        catch (Throwable ex) {
                            log.error((Object)String.format("\u6267\u884c\u95e8\u6237\u5f02\u6b65\u4f5c\u4e1a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                        }
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        log.error((Object)ex);
                    }
                }
            }
        });
        try {
            PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
            portalAsyncAction.setAsyncAcitonId(strAsyncActionId);
            try {
                iCloudPortalClient.executeAsyncAction(strAsyncActionId, portalAsyncAction);
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u6267\u884c\u95e8\u6237\u5f02\u6b65\u4f5c\u4e1a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            Object objRet = iAction.execute(args);
            actionSession.removeActionParam(strWorkTag);
            if (objRet != null) {
                if (objRet instanceof String) {
                    portalAsyncAction.setActionResult((String)objRet);
                } else {
                    String strResult = WebClientBase.OUTMAPPER.writeValueAsString(objRet);
                    portalAsyncAction.setActionResult(strResult);
                }
            } else {
                portalAsyncAction.setActionResult(null);
            }
            Object objDownloadRUrl = actionSession.getActionParam("__ASYNCACTION_DOWNLOADURL__");
            if (objDownloadRUrl != null) {
                if (objDownloadRUrl instanceof String) {
                    portalAsyncAction.setAsyncResultDownloadUrl((String)objDownloadRUrl);
                } else {
                    String strResult = WebClientBase.OUTMAPPER.writeValueAsString(objDownloadRUrl);
                    portalAsyncAction.setAsyncResultDownloadUrl(strResult);
                }
            }
            try {
                iCloudPortalClient.finishAsyncAction(strAsyncActionId, portalAsyncAction);
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u5b8c\u6210\u95e8\u6237\u5f02\u6b65\u4f5c\u4e1a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            if (bOpenActionSession) {
                ActionSessionManager.closeSession((boolean)true);
            }
        }
        catch (Throwable ex) {
            actionSession.removeActionParam(strWorkTag);
            if (bOpenActionSession) {
                ActionSessionManager.closeSession((boolean)false);
            }
            PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
            portalAsyncAction.setAsyncAcitonId(strAsyncActionId);
            portalAsyncAction.setActionResult(ex.getMessage());
            try {
                iCloudPortalClient.errorAsyncAction(strAsyncActionId, portalAsyncAction);
            }
            catch (Throwable ex2) {
                log.error((Object)String.format("\u6267\u884c\u95e8\u6237\u5f02\u6b65\u4f5c\u4e1a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex2.getMessage()), ex2);
            }
            throw ex;
        }
    }

    public SseEmitter sseExecute(final IAction iAction, final Object[] args, Object actionTag, long nTimeout) throws Throwable {
        final SseEmitter sseEmitter = nTimeout == -1L ? new SseEmitter() : new SseEmitter(Long.valueOf(nTimeout));
        this.threadRun(new Runnable(){

            @Override
            public void run() {
                try {
                    ServiceSystemRuntimeBase.this.onSseExecute(iAction, args, sseEmitter);
                }
                catch (Throwable ex) {
                    log.error((Object)ex);
                }
            }
        });
        return sseEmitter;
    }

    protected void onSseExecute(IAction iAction, Object[] args, final SseEmitter sseEmitter) throws Throwable {
        boolean bOpenActionSession;
        boolean bl = bOpenActionSession = ActionSessionManager.getCurrentSession() == null;
        if (bOpenActionSession) {
            ActionSessionManager.openSession().setName(this.getName());
            ActionSessionManager.getCurrentSession().setUserContext((IUserContext)EmployeeContext.getCurrent());
        }
        final ActionSession actionSession = ActionSessionManager.getCurrentSession();
        final String strWorkTag = KeyValueUtils.genUniqueId();
        final String strLastResultTag = KeyValueUtils.genUniqueId();
        final PortalAsyncAction portalAsyncAction = new PortalAsyncAction();
        portalAsyncAction.setActionState(PortalAsyncActionState.NOTSTARTED.getValue());
        try {
            sseEmitter.send((Object)portalAsyncAction);
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
        actionSession.setActionParam(strWorkTag, (Object)"1");
        this.threadRun(new Runnable(){

            @Override
            public void run() {
                Object objValue;
                String strLastActionStep = actionSession.getActionStep();
                double fLastCompletionRate = actionSession.getCompletionRate();
                String strLastActionResult = actionSession.getActionResult();
                while (!ObjectUtils.isEmpty((Object)(objValue = actionSession.getActionParam(strWorkTag)))) {
                    String strActionResult = actionSession.getActionResult();
                    String strActionStep = actionSession.getActionStep();
                    double fCompletionRate = actionSession.getCompletionRate();
                    if (DataTypeUtils.compare((String)strLastActionStep, (String)strActionStep) != 0L || DataTypeUtils.compare((String)strLastActionResult, (String)strActionResult) != 0L || fLastCompletionRate != fCompletionRate) {
                        String strTemp = strLastActionResult;
                        strLastActionResult = strActionResult;
                        actionSession.setActionParam(strLastResultTag, (Object)strLastActionResult);
                        strLastActionStep = strActionStep;
                        fLastCompletionRate = fCompletionRate;
                        portalAsyncAction.setStepInfo(strLastActionStep);
                        if (StringUtils.hasLength((String)strLastActionResult) && StringUtils.hasLength((String)strTemp) && strLastActionResult.length() > strTemp.length()) {
                            portalAsyncAction.setActionResult(strLastActionResult.substring(strTemp.length()));
                        } else {
                            portalAsyncAction.setActionResult(strLastActionResult);
                        }
                        portalAsyncAction.set("completionrate", fLastCompletionRate);
                        try {
                            sseEmitter.send((Object)portalAsyncAction);
                        }
                        catch (IOException ex) {
                            log.error((Object)ex);
                        }
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        log.error((Object)ex);
                    }
                }
            }
        });
        try {
            Object objDownloadRUrl;
            portalAsyncAction.setActionState(PortalAsyncActionState.EXECUTING.getValue());
            portalAsyncAction.setBeginTime(new Timestamp(System.currentTimeMillis()));
            try {
                sseEmitter.send((Object)portalAsyncAction);
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
            Object objRet = iAction.execute(args);
            actionSession.removeActionParam(strWorkTag);
            String strActionResult = actionSession.getActionResult();
            String strLastActionResult = (String)actionSession.getActionParam(strLastResultTag);
            if (StringUtils.hasLength((String)strActionResult) && StringUtils.hasLength((String)strLastActionResult) && strActionResult.length() > strLastActionResult.length()) {
                portalAsyncAction.setActionResult(strActionResult.substring(strLastActionResult.length()));
                portalAsyncAction.setStepInfo(actionSession.getActionStep());
                portalAsyncAction.set("completionrate", actionSession.getCompletionRate());
                try {
                    sseEmitter.send((Object)portalAsyncAction);
                }
                catch (IOException ex) {
                    log.error((Object)ex);
                }
            }
            portalAsyncAction.set("completionrate", 100.0);
            portalAsyncAction.setStepInfo(null);
            if (objRet != null) {
                if (objRet instanceof String) {
                    portalAsyncAction.setActionResult((String)objRet);
                } else {
                    String strResult = WebClientBase.OUTMAPPER.writeValueAsString(objRet);
                    portalAsyncAction.setActionResult(strResult);
                }
            }
            if ((objDownloadRUrl = actionSession.getActionParam("__ASYNCACTION_DOWNLOADURL__")) != null) {
                if (objDownloadRUrl instanceof String) {
                    portalAsyncAction.setAsyncResultDownloadUrl((String)objDownloadRUrl);
                } else {
                    String strResult = WebClientBase.OUTMAPPER.writeValueAsString(objDownloadRUrl);
                    portalAsyncAction.setAsyncResultDownloadUrl(strResult);
                }
            }
            portalAsyncAction.setActionState(PortalAsyncActionState.FINISHED.getValue());
            portalAsyncAction.setEndTime(new Timestamp(System.currentTimeMillis()));
            try {
                sseEmitter.send((Object)portalAsyncAction);
            }
            catch (IOException ex) {
                log.error((Object)ex);
            }
            sseEmitter.complete();
            if (bOpenActionSession) {
                ActionSessionManager.closeSession((boolean)true);
            }
        }
        catch (Throwable ex) {
            actionSession.removeActionParam(strWorkTag);
            if (bOpenActionSession) {
                ActionSessionManager.closeSession((boolean)false);
            }
            portalAsyncAction.setActionState(PortalAsyncActionState.FAILED.getValue());
            portalAsyncAction.setEndTime(new Timestamp(System.currentTimeMillis()));
            portalAsyncAction.setActionResult(ex.getMessage());
            try {
                sseEmitter.send((Object)portalAsyncAction);
            }
            catch (IOException ex2) {
                log.error((Object)ex2);
            }
            sseEmitter.completeWithError(ex);
            throw ex;
        }
    }

    public ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime() {
        if (this.iSysCloudClientUtilRuntime == null) {
            this.iSysCloudClientUtilRuntime = (ISysCloudClientUtilRuntime)this.getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
        }
        return this.iSysCloudClientUtilRuntime;
    }

    protected ISystemRTGroovyContext createSystemRTGroovyContext() {
        return new SystemRTGroovyContext(this.getSystemRuntimeContext());
    }

    static {
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISystemModuleUtilRuntime.class, (String)PSModelEnums.ModuleUtilType.EXTENSION.value, (Object)"net.ibizsys.central.plugin.extension.system.ExtensionSystemModuleUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysRefRuntime.class, (String)PSModelEnums.SysRefType.EXTENSION_DEVSYS.value, (Object)"net.ibizsys.central.plugin.extension.system.ExtensionSysRefRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysRefRuntime.class, (String)PSModelEnums.SysRefType.EXTENSION_DEVSYS_PSMODELTOOL.value, (Object)"net.ibizsys.central.plugin.extension.system.ExtensionSysRefRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysRefRuntime.class, (String)PSModelEnums.SysRefType.EXTENSION_DEVSYS_WORKFLOW.value, (Object)"net.ibizsys.central.plugin.extension.system.ExtensionSysRefRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysDataSyncAgentRuntime.class, (String)"KAFKA", (Object)"net.ibizsys.central.plugin.kafka.eai.KafkaEAIAgentRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysDataSyncAgentRuntime.class, (String)"RABBITMQ", (Object)"net.ibizsys.central.plugin.rabbitmq.eai.RabbitMQEAIAgentRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysDataSyncAgentRuntime.class, (String)"ACTIVEMQ", (Object)"net.ibizsys.central.plugin.activemq.eai.ActiveMQEAIAgentRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysDataSyncAgentRuntime.class, (String)"MQTT", (Object)"net.ibizsys.central.plugin.eai.MqttEAIAgentRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISubSysServiceAPIRuntime.class, null, (Object)"net.ibizsys.central.plugin.cloud.service.CloudServiceClientRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IWebClient.class, null, (Object)"net.ibizsys.central.plugin.spring.service.client.WebFluxClient");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:CACHE", (Object)"net.ibizsys.central.plugin.redis.sysutil.SysRedisUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:UAA", (Object)"net.ibizsys.central.cloud.core.sysutil.JWTSysUAAUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:CLOUDCLIENT", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysCloudClientUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:OSS", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysOSSUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:WF", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysWFUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:CLOUDLOG", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysCloudLogUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:CONF", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysConfUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:UNISTATE", (Object)"net.ibizsys.central.plugin.zk.sysutil.SysZooKeeperUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:NOTIFY", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysNotifyUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:DEVOPS", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysDevOpsUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:AI", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysAIUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:PORTAL", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysPortalUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:AIFACTORY", (Object)"net.ibizsys.central.plugin.ai.sysutil.SysAIFactoryUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysUtilRuntime.class, (String)"USER:DATAFLOW", (Object)"net.ibizsys.central.plugin.cloud.sysutil.SysDataFlowUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ICodeListRuntime.class, (String)"DYNAMIC:RUNTIME", (Object)"net.ibizsys.central.cloud.core.codelist.CloudCodeListRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ICodeListRuntime.class, (String)"DYNAMIC:OPERATOR", (Object)"net.ibizsys.central.cloud.core.codelist.OperatorCodeListRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ICodeListRuntime.class, (String)"DYNAMIC:DEMAINSTATE", (Object)"net.ibizsys.central.codelist.DEMainStateCodeListRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysBackendTaskRuntime.class, (String)"PREDEFINED:WFCALLBACK", (Object)"net.ibizsys.central.cloud.core.backend.SysWFCallbackBackendTaskRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDataEntityDRProvider.class, (String)"DATASET", (Object)((Object)new DataSetDRProvider()));
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDataEntityDRProvider.class, (String)"DEPT", (Object)((Object)new DeptDRProvider()));
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDataEntityDRProvider.class, (String)"ORG", (Object)((Object)new OrgDRProvider()));
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISystemPersistentAdapter.class, null, (Object)SystemPersistentAdapter.class.getCanonicalName());
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDEWFRuntime.class, null, (Object)"net.ibizsys.central.cloud.core.dataentity.wf.DEWFRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDEDataImportRuntime.class, null, (Object)"net.ibizsys.central.plugin.poi.dataentity.dataimport.POIDEDataImportRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDEDataExportRuntime.class, null, (Object)"net.ibizsys.central.plugin.poi.dataentity.dataexport.POIDEDataExportRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(ISysBDSchemeRuntime.class, (String)"CLOUDOSS", (Object)CloudOSSBDSchemeRuntime.class.getCanonicalName());
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDEAutoCompleteRuntime.class, (String)"CHATCOMPLETION", (Object)DEChatCompletionRuntime.class.getCanonicalName());
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDEDataFlowRuntime.class, null, (Object)DEDataFlowRuntime.class.getCanonicalName());
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDEUtilRuntime.class, (String)PSModelEnums.DEUtilType.EXTENSION.value, (Object)"net.ibizsys.central.plugin.extension.dataentity.util.DEExtensionUtilRuntime");
        ServiceSystemRuntimeBase.registerRuntimeObjectIf(IDEUtilRuntime.class, (String)PSModelEnums.DEUtilType.DYNASTORAGE.value, (Object)"net.ibizsys.central.plugin.extension.dataentity.util.DEDynaStorageUtilRuntime");
        GroovySystem.getMetaClassRegistry().setMetaClassCreationHandle((MetaClassRegistry.MetaClassCreationHandle)new MetaClassCreationHandle());
        globalWorkThreadPoolExecutor = null;
    }
}

