/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.SysBDSchemeRuntime;
import net.ibizsys.central.bi.ISysBISchemeRuntime;
import net.ibizsys.central.cloud.core.IServiceSystemRuntime;
import net.ibizsys.central.cloud.core.ServiceSystemRuntimeBase;
import net.ibizsys.central.cloud.core.bi.SysBISchemeRuntime;
import net.ibizsys.central.cloud.core.dataentity.DataEntityRuntime;
import net.ibizsys.central.cloud.core.eai.SysAIAgentRuntime;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.security.ISystemAccessManager;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.cloud.core.system.IExtensionSysRefRuntime;
import net.ibizsys.central.cloud.core.sysutil.IHubSysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysUtilContainerOnly;
import net.ibizsys.central.cloud.core.util.IConfigListener;
import net.ibizsys.central.cloud.core.util.IRTCodeUtils;
import net.ibizsys.central.cloud.core.util.RTCodeUtils;
import net.ibizsys.central.cloud.core.util.domain.AppData;
import net.ibizsys.central.cloud.core.util.domain.V2DeploySystem;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.system.ISysRefRuntime;
import net.ibizsys.central.sysutil.ISysOSSUtilRuntime;
import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.model.system.IPSSysRef;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.plugin.ModelRTScriptBase;
import net.ibizsys.runtime.plugin.RuntimeObjectFactory;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.sysutil.ISysFileUtilRuntime;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ServiceSystemRuntime
extends ServiceSystemRuntimeBase
implements IServiceSystemRuntime {
    private static final Log log = LogFactory.getLog(ServiceSystemRuntime.class);
    private static final Object EMPTY = new Object();
    private Map<Class<?>, Object> sysUtilRuntimeCacheMap = new HashMap();
    private boolean bEnableServiceHubAPI = true;
    private String strDataFlowSystemId = null;
    private Collection<IExtensionSysRefRuntime> extensionSysRefRuntimeList = null;
    private Collection<IExtensionSysRefRuntime> allExtensionSysRefRuntimeList = null;
    private Map<String, IExtensionSysRefRuntime> extensionSysRefRuntimeMap = new LinkedHashMap<String, IExtensionSysRefRuntime>();
    private IRTCodeUtils iRTCodeUtils = null;
    private V2DeploySystem v2DeploySystem = null;
    private String strSystemExtensionConfigId = null;
    private String strExtensionSessionId = null;
    private String strSystemMergencesConfigId = null;
    private String strSystemMergeSessionId = null;
    private IConfigListener systemExtensionConfigListener = new IConfigListener(){

        @Override
        public Executor getExecutor() {
            return null;
        }

        @Override
        public void receiveConfigInfo(String configInfo) {
            try {
                ServiceSystemRuntime.this.reloadSystemExtension(configInfo);
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
    };
    private IConfigListener systemMergencesConfigListener = new IConfigListener(){

        @Override
        public Executor getExecutor() {
            return null;
        }

        @Override
        public void receiveConfigInfo(String configInfo) {
            try {
                ServiceSystemRuntime.this.reloadSystemMergences(configInfo);
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
    };

    @Override
    public boolean isEnableRTCodeMode() {
        return ServiceHub.getInstance().isEnableRTCodeMode();
    }

    @Override
    public boolean isEnableProdMode() {
        return ServiceHub.getInstance().isEnableProdMode();
    }

    protected void prepareSysSFPluginRuntimes() throws Exception {
        if (this.getRTCodeUtils(true) == null) {
            this.prepareRTCodeUtils();
            this.getRTCodeUtils(false);
        }
        super.prepareSysSFPluginRuntimes();
        if (this.isEnableRTCodeMode()) {
            // empty if block
        }
    }

    protected IDataEntityRuntime createDataEntityRuntime(IPSDataEntity iPSDataEntity) {
        if (this.isEnableRTCodeMode() && iPSDataEntity.getPSSysSFPlugin() == null) {
            String strRTObjectName = null;
            try {
                strRTObjectName = this.getRTCodeUtils(false).getRTObjectName(iPSDataEntity);
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u8ba1\u7b97\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u540d\u79f0\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDataEntity.getName(), ex.getMessage()), (Throwable)ex);
            }
            if (StringUtils.hasLength((String)strRTObjectName)) {
                RuntimeObjectFactory.getInstance().registerObjectIf(IDataEntityRuntime.class, strRTObjectName, (Object)strRTObjectName);
                IDataEntityRuntime iDataEntityRuntime = (IDataEntityRuntime)RuntimeObjectFactory.getInstance().getObject(IDataEntityRuntime.class, strRTObjectName);
                if (iDataEntityRuntime != null) {
                    log.info((Object)String.format("\u5b9e\u4f53[%1$s]\u4f7f\u7528\u8fd0\u884c\u65f6\u5bf9\u8c61[%2$s]", iPSDataEntity.getName(), iDataEntityRuntime.getClass().getName()));
                    this.autowareObject(iDataEntityRuntime);
                    return iDataEntityRuntime;
                }
            }
        }
        return super.createDataEntityRuntime(iPSDataEntity);
    }

    @Override
    protected void onInit() throws Exception {
        Object value = this.getSystemRuntimeSetting().getParam("v2deploysystem");
        if (value instanceof V2DeploySystem) {
            this.v2DeploySystem = (V2DeploySystem)((Object)value);
        }
        super.onInit();
        String strEnableAPIs = this.getSystemRuntimeSetting().getEnableAPIs();
        if (StringUtils.hasLength((String)strEnableAPIs)) {
            String[] apis;
            HashMap<String, String> enableAPIMap = new HashMap<String, String>();
            for (String api : apis = strEnableAPIs.toLowerCase().split("[;]")) {
                enableAPIMap.put(api, "");
            }
            if (enableAPIMap.containsKey("-noservicehub")) {
                this.setEnableServiceHubAPI(false);
            }
        }
        this.strDataFlowSystemId = this.getSystemRuntimeSetting().getParam("dataflowsystemid", this.getServiceId());
    }

    @Override
    protected void onStart() throws Exception {
        super.onStart();
        this.reloadSystemMergences(null);
        this.reloadSystemExtension(null);
    }

    protected IDataEntityRuntime createDefaultDataEntityRuntime() {
        return new DataEntityRuntime();
    }

    public <T> T getSysUtilRuntime(Class<T> cls, boolean bTryMode) {
        return this.getSysUtilRuntime(cls, bTryMode, false);
    }

    @Override
    public <T> T getSysUtilRuntime(Class<T> cls, boolean bTryMode, boolean bSystemOnly) {
        Object t = this.sysUtilRuntimeCacheMap.get(cls);
        if (t != null) {
            if (t != EMPTY) {
                return (T)t;
            }
            if (bTryMode) {
                return null;
            }
        }
        if ((t = this.onGetSysUtilRuntime(cls, bTryMode, bSystemOnly)) != null) {
            this.sysUtilRuntimeCacheMap.put(cls, t);
        } else {
            this.sysUtilRuntimeCacheMap.put(cls, EMPTY);
        }
        return (T)t;
    }

    protected <T> T onGetSysUtilRuntime(Class<T> cls, boolean bTryMode, boolean bSystemOnly) {
        if (bSystemOnly) {
            return (T)super.getSysUtilRuntime(cls, bTryMode);
        }
        Object t = super.getSysUtilRuntime(cls, true);
        if (t != null) {
            return (T)t;
        }
        return (T)ServiceHub.getInstance().getSysUtilRuntime(null, cls, bTryMode);
    }

    @Override
    public AppData invokeGetAppData(String strSystemTag, String strOrgId, IAuthenticationUser iAuthenticationUser, Object objTag) throws Throwable {
        return this.onInvokeGetAppData(strSystemTag, strOrgId, objTag);
    }

    protected AppData onInvokeGetAppData(String strSystemTag, String strOrgId, Object objTag) {
        return this.getSystemAccessManager().getAppData(strSystemTag, strOrgId);
    }

    @Override
    public AppData invokeGetAppData(String strDCSystemTag, IAuthenticationUser iAuthenticationUser, Object objTag) throws Throwable {
        return this.onInvokeGetAppData(strDCSystemTag, objTag);
    }

    protected AppData onInvokeGetAppData(String strDCSystemTag, Object objTag) {
        return this.getSystemAccessManager().getAppData(strDCSystemTag);
    }

    @Override
    public ISystemAccessManager getSystemAccessManager() {
        return (ISystemAccessManager)super.getSystemAccessManager();
    }

    @Override
    public boolean isEnableServiceHubAPI() {
        return this.bEnableServiceHubAPI;
    }

    protected void setEnableServiceHubAPI(boolean bEnableServiceHubAPI) {
        this.bEnableServiceHubAPI = bEnableServiceHubAPI;
    }

    protected ISysFileUtilRuntime registerDefaultSysFileUtilRuntime() throws Exception {
        return this.getSysUtilRuntime(ISysOSSUtilRuntime.class, false);
    }

    @Override
    public void shutdown() {
        try {
            this.fireSystemEvent("SHUTDOWN", null);
            this.onBeforeShutdown();
            this.onShutdown();
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u5173\u95ed\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
    }

    protected void onBeforeShutdown() throws Exception {
        try {
            String strSystemExtensionConfigId = this.strSystemExtensionConfigId;
            this.strSystemExtensionConfigId = null;
            this.strExtensionSessionId = null;
            if (StringUtils.hasLength((String)strSystemExtensionConfigId)) {
                ServiceHub.getInstance().removeConfigListener(strSystemExtensionConfigId, this.systemExtensionConfigListener);
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u79fb\u9664\u7cfb\u7edf\u6269\u5c55\u914d\u7f6e\u76d1\u63a7\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        try {
            String strSystemMergencesConfigId = this.strSystemMergencesConfigId;
            this.strSystemMergencesConfigId = null;
            this.strSystemMergeSessionId = null;
            if (StringUtils.hasLength((String)strSystemMergencesConfigId)) {
                ServiceHub.getInstance().removeConfigListener(strSystemMergencesConfigId, this.systemMergencesConfigListener);
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u79fb\u9664\u7cfb\u7edf\u5408\u5e76\u914d\u7f6e\u76d1\u63a7\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        if (this.getV2DeploySystem() != null) {
            ISysExtensionUtilRuntime iSysExtensionUtilRuntime;
            if (StringUtils.hasLength((String)this.getV2DeploySystem().getSystemExtensionId())) {
                try {
                    iSysExtensionUtilRuntime = this.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
                    if (iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly)) {
                        ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).reloadExtension(this, null);
                    } else {
                        iSysExtensionUtilRuntime.reloadExtension(null);
                    }
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u91cd\u7f6e\u7cfb\u7edf\u6269\u5c55\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                }
            }
            if (!StringUtils.hasLength((String)this.getV2DeploySystem().getSystemVersionId())) {
                try {
                    iSysExtensionUtilRuntime = this.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
                    if (iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly)) {
                        ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).reloadSystemMergences(this, null);
                    } else {
                        iSysExtensionUtilRuntime.reloadSystemMergences(null);
                    }
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u91cd\u7f6e\u7cfb\u7edf\u5408\u5e76\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                }
            }
        }
    }

    protected void onShutdown() throws Exception {
        super.onShutdown();
    }

    protected void prepareDefaultSysBDSchemeRuntime() throws Exception {
        super.prepareDefaultSysBDSchemeRuntime();
        if (this.getDefaultSysBDSchemeRuntime() != null) {
            return;
        }
        IPSSysBDScheme iPSSysBDScheme = SysBDSchemeRuntime.getDefaultPSSysBDScheme((ISystemRuntimeContext)this.getSystemRuntimeContext());
        ISysBDSchemeRuntime iSysBDSchemeRuntime = (ISysBDSchemeRuntime)this.getRuntimeObject(ISysBDSchemeRuntime.class, "CLOUDOSS");
        if (iSysBDSchemeRuntime == null) {
            return;
        }
        try {
            iSysBDSchemeRuntime.init(this.getSystemRuntimeContext(), iPSSysBDScheme);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u521d\u59cb\u5316\u5927\u6570\u636e\u4f53\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysBDScheme.getName(), ex.getMessage()), (Throwable)ex);
        }
        this.setDefaultSysBDSchemeRuntime(iSysBDSchemeRuntime);
    }

    public ISysDataSyncAgentRuntime createSysDataSyncAgentRuntime(IPSSysDataSyncAgent iPSSysDataSyncAgent) {
        if (iPSSysDataSyncAgent.getPSSysSFPlugin() == null && "CloudAIAgent".equalsIgnoreCase(iPSSysDataSyncAgent.getCodeName()) && "USER".equalsIgnoreCase(iPSSysDataSyncAgent.getAgentType())) {
            return new SysAIAgentRuntime();
        }
        return super.createSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
    }

    public <T> T createModelRTScript(Object owner, String strScriptCode, Class<? extends ModelRTScriptBase> cls) {
        return (T)super.createModelRTScript(owner, strScriptCode, cls);
    }

    @Override
    public String getDataFlowSystemId() {
        return this.strDataFlowSystemId;
    }

    @Override
    public V2DeploySystem getV2DeploySystem() {
        return this.v2DeploySystem;
    }

    @Override
    public boolean isEnableExtension() {
        return this.getV2DeploySystem() != null;
    }

    @Override
    public String getExtensionId() {
        return this.getV2DeploySystem() != null ? this.getV2DeploySystem().getSystemExtensionId() : null;
    }

    @Override
    public String getExtensionSessionId() {
        return this.strExtensionSessionId;
    }

    @Override
    public IRTCodeUtils getRTCodeUtils() {
        try {
            return this.getRTCodeUtils(false);
        }
        catch (Exception ex) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this, ex.getMessage(), (Throwable)ex);
        }
    }

    protected IRTCodeUtils getRTCodeUtils(boolean bTryMode) throws Exception {
        if (this.iRTCodeUtils != null || bTryMode) {
            return this.iRTCodeUtils;
        }
        throw new Exception("RT\u4ee3\u7801\u8f85\u52a9\u529f\u80fd\u5bf9\u8c61\u65e0\u6548");
    }

    protected void setRTCodeUtils(IRTCodeUtils iRTCodeUtils) {
        this.iRTCodeUtils = iRTCodeUtils;
    }

    protected void prepareRTCodeUtils() throws Exception {
        this.setRTCodeUtils(new RTCodeUtils(this.getSystemRuntimeContext()));
    }

    protected void reloadSystemExtension(String configInfo) throws Exception {
        ISysExtensionUtilRuntime iSysExtensionUtilRuntime;
        if (this.getV2DeploySystem() == null) {
            return;
        }
        try {
            String strSystemExtensionConfigId = this.strSystemExtensionConfigId;
            this.strSystemExtensionConfigId = null;
            this.strExtensionSessionId = null;
            if (StringUtils.hasLength((String)strSystemExtensionConfigId)) {
                ServiceHub.getInstance().removeConfigListener(strSystemExtensionConfigId, this.systemExtensionConfigListener);
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u79fb\u9664\u7cfb\u7edf\u6269\u5c55\u914d\u7f6e\u76d1\u63a7\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        String strSystemExtensionId = this.getV2DeploySystem().getSystemExtensionId();
        if (StringUtils.hasLength((String)strSystemExtensionId)) {
            String strSystemExtensionConfigId = String.format("%1$s%2$s", "systemextension-", strSystemExtensionId);
            if (!StringUtils.hasLength((String)configInfo)) {
                configInfo = ServiceHub.getInstance().getConfig(strSystemExtensionConfigId);
            }
            ServiceHub.getInstance().addConfigListener(strSystemExtensionConfigId, this.systemExtensionConfigListener);
            this.strSystemExtensionConfigId = strSystemExtensionConfigId;
            this.strExtensionSessionId = KeyValueUtils.genUniqueId((Object)this.getDeploySystemId(), (Object)strSystemExtensionId, (Object)configInfo);
        }
        if ((iSysExtensionUtilRuntime = this.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false)) instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly)) {
            ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).reloadExtension(this, this.getV2DeploySystem().getSystemExtensionId());
        } else {
            iSysExtensionUtilRuntime.reloadExtension(this.getV2DeploySystem().getSystemExtensionId());
        }
    }

    protected void reloadSystemMergences(String configInfo) throws Exception {
        String strSystemMergencesConfigId;
        if (this.getV2DeploySystem() == null || StringUtils.hasLength((String)this.getV2DeploySystem().getSystemVersionId())) {
            return;
        }
        String strSystemId = this.getV2DeploySystem().getSystemId();
        if (!StringUtils.hasLength((String)strSystemId)) {
            return;
        }
        try {
            strSystemMergencesConfigId = this.strSystemMergencesConfigId;
            this.strSystemMergencesConfigId = null;
            this.strSystemMergeSessionId = null;
            if (StringUtils.hasLength((String)strSystemMergencesConfigId)) {
                ServiceHub.getInstance().removeConfigListener(strSystemMergencesConfigId, this.systemMergencesConfigListener);
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u79fb\u9664\u7cfb\u7edf\u5408\u5e76\u914d\u7f6e\u76d1\u63a7\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        strSystemMergencesConfigId = String.format("%1$s%2$s", "systemmergences-", strSystemId);
        if (!StringUtils.hasLength((String)configInfo)) {
            configInfo = ServiceHub.getInstance().getConfig(strSystemMergencesConfigId);
        }
        ServiceHub.getInstance().addConfigListener(strSystemMergencesConfigId, this.systemMergencesConfigListener);
        this.strSystemMergencesConfigId = strSystemMergencesConfigId;
        this.strSystemMergeSessionId = KeyValueUtils.genUniqueId((Object)this.getDeploySystemId(), (Object)strSystemId, (Object)configInfo);
        ISysExtensionUtilRuntime iSysExtensionUtilRuntime = this.getSysUtilRuntime(ISysExtensionUtilRuntime.class, false);
        if (iSysExtensionUtilRuntime instanceof IHubSysExtensionUtilRuntime && !(iSysExtensionUtilRuntime instanceof ISysUtilContainerOnly)) {
            ((IHubSysExtensionUtilRuntime)((Object)iSysExtensionUtilRuntime)).reloadSystemMergences(this, this.getV2DeploySystem().getSystemId());
        } else {
            iSysExtensionUtilRuntime.reloadSystemMergences(this.getV2DeploySystem().getSystemId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IExtensionSysRefRuntime> getExtensionSysRefRuntimes(boolean bIncludeOrigin) {
        Collection<IExtensionSysRefRuntime> ret;
        Collection<IExtensionSysRefRuntime> collection = ret = bIncludeOrigin ? this.allExtensionSysRefRuntimeList : this.extensionSysRefRuntimeList;
        if (ret == null) {
            List psSysRefList;
            ArrayList<IExtensionSysRefRuntime> list = new ArrayList<IExtensionSysRefRuntime>();
            if (bIncludeOrigin && !ObjectUtils.isEmpty((Object)(psSysRefList = this.getPSSystem().getAllPSSysRefs()))) {
                for (IPSSysRef iPSSysRef : psSysRefList) {
                    ISysRefRuntime iSysRefRuntime = this.getSysRefRuntime(iPSSysRef);
                    if (!(iSysRefRuntime instanceof IExtensionSysRefRuntime)) continue;
                    list.add((IExtensionSysRefRuntime)iSysRefRuntime);
                }
            }
            Map<String, IExtensionSysRefRuntime> map = this.extensionSysRefRuntimeMap;
            synchronized (map) {
                list.addAll(this.extensionSysRefRuntimeMap.values());
                ret = Collections.unmodifiableCollection(list);
                if (bIncludeOrigin) {
                    this.allExtensionSysRefRuntimeList = ret;
                } else {
                    this.extensionSysRefRuntimeList = ret;
                }
            }
        }
        return ret;
    }

    @Override
    public IExtensionSysRefRuntime registerExtensionSysRefRuntime(IPSSysRef iPSSysRef) {
        Assert.notNull((Object)iPSSysRef, (String)"\u4f20\u5165\u7cfb\u7edf\u5f15\u7528\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        Map<String, IExtensionSysRefRuntime> map = this.extensionSysRefRuntimeMap;
        synchronized (map) {
            if (this.extensionSysRefRuntimeMap.containsKey(iPSSysRef.getId())) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u6ce8\u518c\u6269\u5c55\u7cfb\u7edf\u5f15\u7528[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c\u91cd\u590d\u7684\u5f15\u7528\u6807\u8bc6[%2$s]", iPSSysRef.getName(), iPSSysRef.getId()));
            }
            try {
                ISysRefRuntime iSysRefRuntime = this.createSysRefRuntime(iPSSysRef);
                if (!(iSysRefRuntime instanceof IExtensionSysRefRuntime)) {
                    throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u6ce8\u518c\u6269\u5c55\u7cfb\u7edf\u5f15\u7528[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c\u7c7b\u578b\u4e0d\u6b63\u786e[%2$s]", iPSSysRef.getName(), iSysRefRuntime.getClass()));
                }
                iSysRefRuntime.init(this.getSystemRuntimeContext(), iPSSysRef);
                IExtensionSysRefRuntime iExtensionSysRefRuntime = (IExtensionSysRefRuntime)iSysRefRuntime;
                iExtensionSysRefRuntime.install();
                this.extensionSysRefRuntimeMap.put(iPSSysRef.getId(), iExtensionSysRefRuntime);
                this.allExtensionSysRefRuntimeList = null;
                this.extensionSysRefRuntimeList = null;
                return iExtensionSysRefRuntime;
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this, String.format("\u6ce8\u518c\u6269\u5c55\u7cfb\u7edf\u5f15\u7528[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysRef.getName(), ex.getMessage()), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterExtensionSysRefRuntime(IPSSysRef iPSSysRef) {
        Assert.notNull((Object)iPSSysRef, (String)"\u4f20\u5165\u7cfb\u7edf\u5f15\u7528\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        Map<String, IExtensionSysRefRuntime> map = this.extensionSysRefRuntimeMap;
        synchronized (map) {
            IExtensionSysRefRuntime iExtensionSysRefRuntime = this.extensionSysRefRuntimeMap.remove(iPSSysRef.getId());
            if (iExtensionSysRefRuntime == null) {
                return;
            }
            this.allExtensionSysRefRuntimeList = null;
            this.extensionSysRefRuntimeList = null;
            try {
                iExtensionSysRefRuntime.uninstall();
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u5378\u8f7d\u6269\u5c55\u7cfb\u7edf\u5f15\u7528[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iExtensionSysRefRuntime.getName(), ex.getMessage()), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterExtensionSysRefRuntimes() {
        Map<String, IExtensionSysRefRuntime> map = this.extensionSysRefRuntimeMap;
        synchronized (map) {
            for (IExtensionSysRefRuntime iExtensionSysRefRuntime : this.extensionSysRefRuntimeMap.values()) {
                try {
                    iExtensionSysRefRuntime.uninstall();
                }
                catch (Exception ex) {
                    log.error((Object)String.format("\u5378\u8f7d\u6269\u5c55\u7cfb\u7edf\u5f15\u7528[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iExtensionSysRefRuntime.getName(), ex.getMessage()), (Throwable)ex);
                }
            }
            this.extensionSysRefRuntimeMap.clear();
            this.allExtensionSysRefRuntimeList = null;
            this.extensionSysRefRuntimeList = null;
        }
    }

    @Override
    public String getSystemMergeSessionId() {
        return this.strSystemMergeSessionId;
    }

    protected ISysBISchemeRuntime createDefaultSysBISchemeRuntime() {
        return new SysBISchemeRuntime();
    }
}

