/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ibizsys.central.ISystemGateway;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.SystemGateway;
import net.ibizsys.central.SystemGatewayException;
import net.ibizsys.central.Version;
import net.ibizsys.central.app.IApplicationRuntime;
import net.ibizsys.central.cloud.core.CloudPluginService;
import net.ibizsys.central.cloud.core.HubSystemRuntime;
import net.ibizsys.central.cloud.core.ICloudPluginService;
import net.ibizsys.central.cloud.core.IHubSystemRuntime;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.IServiceHubSetting;
import net.ibizsys.central.cloud.core.IServiceSystemRuntime;
import net.ibizsys.central.cloud.core.ServiceSystemRuntime;
import net.ibizsys.central.cloud.core.app.IServiceAppRuntime;
import net.ibizsys.central.cloud.core.app.IServletAppRuntime;
import net.ibizsys.central.cloud.core.cloudutil.ICloudUtilRuntime;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudDevOpsClient;
import net.ibizsys.central.cloud.core.cloudutil.client.ICloudExtensionClient;
import net.ibizsys.central.cloud.core.database.ISysDBSchemeSyncAdapter;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIDocAdapter;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIRequestMappingAdapter;
import net.ibizsys.central.cloud.core.service.ISysServiceAPIRuntime;
import net.ibizsys.central.cloud.core.service.StandardSysServiceAPIRequestMappingAdapter;
import net.ibizsys.central.cloud.core.servlet.IServiceHubFilter;
import net.ibizsys.central.cloud.core.spring.util.GatewayUtils;
import net.ibizsys.central.cloud.core.system.IExtensionSysRefRuntime;
import net.ibizsys.central.cloud.core.sysutil.IHubSysDevOpsUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.IHubSysExtensionUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysDevOpsUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysUtilContainerOnly;
import net.ibizsys.central.cloud.core.util.ConfigEntity;
import net.ibizsys.central.cloud.core.util.IConfigListener;
import net.ibizsys.central.cloud.core.util.NacosConfigUtils;
import net.ibizsys.central.cloud.core.util.domain.AppData;
import net.ibizsys.central.cloud.core.util.domain.DataSource;
import net.ibizsys.central.cloud.core.util.domain.DeploySystem;
import net.ibizsys.central.cloud.core.util.domain.ServiceInstance;
import net.ibizsys.central.cloud.core.util.domain.V2DataSource;
import net.ibizsys.central.cloud.core.util.domain.V2DeploySystem;
import net.ibizsys.central.cloud.core.util.domain.V2DeploySystemDataSource;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.plugin.spring.service.client.WebFluxClient;
import net.ibizsys.central.system.ISysRefRuntime;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelServiceImpl;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.database.IPSSysDBScheme;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.model.system.IPSSysRef;
import net.ibizsys.runtime.res.SysSFPluginRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.sysutil.ISysFileUtilRuntime;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.ZipUtils;
import net.ibizsys.runtime.util.domain.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.core.io.Resource;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.yaml.snakeyaml.Yaml;

public abstract class ServiceHubBase
extends SystemGateway
implements IServiceHub,
IServiceHubFilter {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ServiceHubBase.class);
    public static final String LOGCAT = "SERVICEHUB";
    private IServiceHubSetting iServiceHubSetting;
    private IServiceHubFilter realServiceHubFilter = null;
    private Set<String> ignoreAuthPatternSet = null;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Map<String, IServletAppRuntime> servletAppRuntimeMap = new ConcurrentHashMap<String, IServletAppRuntime>();
    private IHubSystemRuntime hubSystemRuntime = null;
    private RequestMappingHandlerMapping requestMappingHandlerMapping = null;
    private ISysServiceAPIDocAdapter sysServiceAPIDocAdapter = null;
    private ISysDBSchemeSyncAdapter sysDBSchemeSyncAdapter = null;
    @Autowired
    private NacosServiceManager nacosServiceManager;
    @Autowired
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    @Autowired
    private NacosConfigManager nacosConfigManager;
    @Autowired
    private NacosConfigProperties nacosConfigProperties;
    @Autowired
    private ReactorLoadBalancerExchangeFilterFunction reactorLoadBalancerExchangeFilterFunction;
    private NamingService namingService = null;
    private String strIPAddress = null;
    private Map<Class<? extends ICloudUtilRuntime>, Class<?>> requiredCloudUtilRuntimeMap = new LinkedHashMap();
    private Map<IConfigListener, Listener> configListenerMap = new ConcurrentHashMap<IConfigListener, Listener>();
    private String strDeploySystemModelPath = null;
    private boolean bInstalled = false;
    private ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter = null;
    private ICloudPluginService cloudPluginService = null;
    private Map<String, String> deploySystemVerMap = new ConcurrentHashMap<String, String>();
    private Map<String, IConfigListener> deploySystemVerListenerMap = new ConcurrentHashMap<String, IConfigListener>();
    private Map<String, ConfigEntity> dbInstConfigMap = new HashMap<String, ConfigEntity>();
    private Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    private String strServiceHubVerConfig = "";
    private ICloudExtensionClient iCloudExtensionClient = null;
    @Value(value="${server.port}")
    private int port;

    public static IServiceHub getInstance() {
        return (IServiceHub)ServiceHubBase.getInstance((boolean)false);
    }

    public ServiceHubBase() {
        if (ServiceHubBase.getInstance((boolean)true) == null) {
            ServiceHubBase.setInstance((ISystemGateway)this);
        }
    }

    protected void onPostConstruct() {
        WebFluxClient.setExchangeFilterFunction((ExchangeFilterFunction)this.reactorLoadBalancerExchangeFilterFunction);
        this.namingService = this.nacosServiceManager.getNamingService(this.nacosDiscoveryProperties.getNacosProperties());
        this.strIPAddress = this.nacosDiscoveryProperties.getIp();
        if (!StringUtils.hasLength((String)this.strIPAddress)) {
            try {
                this.strIPAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.debug((Object)e);
            }
        }
        log.info((Object)String.format("\u670d\u52a1\u7f51\u5173\u7248\u672c[%1$s]", Version.toVersionString()));
        log.debug((Object)String.format("\u670d\u52a1\u7f51\u5173\u5f00\u59cb\u521d\u59cb\u5316[%1$s:%2$s]", this.strIPAddress, this.port));
    }

    public IServiceHubSetting getServiceHubSetting() {
        return this.iServiceHubSetting;
    }

    public void setServiceHubSetting(IServiceHubSetting iServiceHubSetting) {
        this.iServiceHubSetting = iServiceHubSetting;
    }

    protected RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return this.requestMappingHandlerMapping;
    }

    protected void setRequestMappingHandlerMapping(RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    protected ISysServiceAPIDocAdapter getSysServiceAPIDocAdapter() {
        return this.sysServiceAPIDocAdapter;
    }

    protected void setSysServiceAPIDocAdapter(ISysServiceAPIDocAdapter sysServiceAPIDocAdapter) {
        this.sysServiceAPIDocAdapter = sysServiceAPIDocAdapter;
    }

    protected ISysDBSchemeSyncAdapter getSysDBSchemeSyncAdapter() {
        return this.sysDBSchemeSyncAdapter;
    }

    protected void setSysDBSchemeSyncAdapter(ISysDBSchemeSyncAdapter sysDBSchemeSyncAdapter) {
        this.sysDBSchemeSyncAdapter = sysDBSchemeSyncAdapter;
    }

    public void install() {
        try {
            if (this.getServiceHubSetting() == null) {
                throw new Exception("\u65e0\u6548\u7684\u914d\u7f6e\u5bf9\u8c61");
            }
            log.debug((Object)String.format("\u670d\u52a1\u603b\u7ebf[%1$s]\u5f00\u59cb\u5b89\u88c5\u90e8\u7f72", this.getServiceHubSetting().getId()));
            this.onInstall();
            this.bInstalled = true;
        }
        catch (Exception ex) {
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u5b89\u88c5\u670d\u52a1\u7f51\u5173\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
    }

    protected void onInstall() throws Exception {
        List<DeploySystem> deploySystemList;
        List<DataSource> dataSourceList;
        this.registerIgnoreAuthPatterns();
        this.setEnableAppGateway(this.getServiceHubSetting().isEnableAppGateway());
        this.setTempFolder(this.getServiceHubSetting().getTempFolder());
        this.setFileFolder(this.getServiceHubSetting().getFileFolder());
        this.setReportFolder(this.getServiceHubSetting().getReportFolder());
        this.setFontFolder(this.getServiceHubSetting().getFontFolder());
        this.prepareCloudPluginService();
        this.strServiceHubVerConfig = this.getConfig(String.format("%1$s%2$s", "servicehub-", this.getId()));
        if (this.strServiceHubVerConfig == null) {
            this.strServiceHubVerConfig = "";
        }
        if ((dataSourceList = this.getServiceHubSetting().getDataSources()) != null) {
            for (DataSource dataSource : dataSourceList) {
                try {
                    this.dataSourceMap.put(dataSource.getDataSourceId(), dataSource);
                    this.registerDataSource(dataSource);
                }
                catch (Exception exception) {
                    throw new Exception(String.format("\u6ce8\u518c\u6570\u636e\u6e90[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", dataSource.getDataSourceId(), exception.getMessage()), exception);
                }
            }
        }
        if (this.getSysDBSchemeSyncAdapter() == null) {
            log.warn((Object)String.format("\u672a\u914d\u7f6e\u6570\u636e\u5e93\u6a21\u578b\u540c\u6b65\u9002\u914d\u5668\uff0c\u65e0\u6cd5\u540c\u6b65\u6570\u636e\u5e93\u6a21\u578b", new Object[0]));
        }
        if ((deploySystemList = this.getServiceHubSetting().getDeploySystems()) != null) {
            for (DeploySystem deploySystem : deploySystemList) {
                try {
                    this.registerDeploySystem(deploySystem);
                }
                catch (Exception ex) {
                    throw new Exception(String.format("\u6ce8\u518c\u7cfb\u7edf[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", deploySystem.getDeploySystemId(), ex.getMessage()), ex);
                }
            }
            if (this.getServiceHubSetting().isEnableReloadSystem() && !this.isEnableDebug()) {
                for (final DeploySystem deploySystem : deploySystemList) {
                    if ("gateway".equalsIgnoreCase(deploySystem.getDeploySystemId()) || !DataTypeUtils.getBooleanValue((Object)deploySystem.getEnableReload(), (Boolean)true).booleanValue()) continue;
                    final String strConfigId = String.format("%1$s%2$s-ver", "deploysystem-", deploySystem.getDeploySystemId());
                    String strConfig = this.getConfig(strConfigId);
                    if (strConfig == null) {
                        strConfig = "";
                    }
                    this.deploySystemVerMap.put(strConfigId, strConfig);
                    IConfigListener iConfigListener = new IConfigListener(){

                        @Override
                        public Executor getExecutor() {
                            return null;
                        }

                        @Override
                        public void receiveConfigInfo(String configInfo) {
                            String strConfig = (String)ServiceHubBase.this.deploySystemVerMap.get(strConfigId);
                            if (configInfo == null) {
                                configInfo = "";
                            }
                            if (configInfo.equals(strConfig)) {
                                log.debug((Object)String.format("\u90e8\u7f72\u7cfb\u7edf[%1$s]\u63a5\u6536\u5230\u7248\u672c\u53d8\u5316\uff0c\u4f46\u914d\u7f6e\u5185\u5bb9\u4e00\u81f4\uff0c\u5ffd\u7565", deploySystem.getDeploySystemId()));
                                ServiceHubBase.this.logEvent(20000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u63a5\u6536\u5230\u7248\u672c\u53d8\u5316\uff0c\u4f46\u914d\u7f6e\u5185\u5bb9\u4e00\u81f4\uff0c\u5ffd\u7565\u91cd\u65b0\u90e8\u7f72", ServiceHubBase.this.getId(), deploySystem.getDeploySystemId()), (Object)deploySystem);
                                return;
                            }
                            ServiceHubBase.this.deploySystemVerMap.put(strConfigId, configInfo);
                            log.debug((Object)String.format("\u90e8\u7f72\u7cfb\u7edf[%1$s]\u7248\u672c\u53d1\u751f\u53d8\u5316", deploySystem.getDeploySystemId()));
                            ServiceHubBase.this.logEvent(20000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u63a5\u6536\u5230\u7248\u672c\u53d8\u5316\uff0c\u91cd\u65b0\u90e8\u7f72", ServiceHubBase.this.getId(), deploySystem.getDeploySystemId()), (Object)deploySystem);
                            if (ServiceHubBase.this.isInstalled()) {
                                ServiceHubBase.this.reloadDeploySystem(deploySystem, configInfo);
                            } else {
                                log.warn((Object)String.format("\u670d\u52a1\u603b\u7ebf\u672a\u5b89\u88c5\u5b8c\u6210\uff0c\u5ffd\u7565\u90e8\u7f72\u7cfb\u7edf\u7248\u672c\u53d8\u5316", new Object[0]));
                            }
                        }
                    };
                    this.addConfigListener(strConfigId, iConfigListener);
                    this.deploySystemVerListenerMap.put(strConfigId, iConfigListener);
                }
            }
        }
        if (!ObjectUtils.isEmpty(this.requiredCloudUtilRuntimeMap)) {
            for (Map.Entry<Class<ICloudUtilRuntime>, Class<?>> entry : this.requiredCloudUtilRuntimeMap.entrySet()) {
                this.getSysUtilRuntime(entry.getValue(), entry.getKey(), false);
            }
        }
        if (this.isEnableDebug() && this.getServiceHubSetting().isStartDebugger()) {
            this.startCloudDebugger();
        }
        if (this.getServiceHubSetting().isEnableReloadSystem() && !this.isEnableDebug()) {
            String string = String.format("%1$s%2$s-ver", "servicehub-", this.getId());
            this.addConfigListener(string, new IConfigListener(){

                @Override
                public Executor getExecutor() {
                    return null;
                }

                @Override
                public void receiveConfigInfo(String configInfo) {
                    if (configInfo == null) {
                        configInfo = "";
                    }
                    if (configInfo.equals(ServiceHubBase.this.strServiceHubVerConfig)) {
                        log.debug((Object)String.format("\u670d\u52a1\u603b\u7ebf[%1$s]\u63a5\u6536\u5230\u7248\u672c\u53d8\u5316\uff0c\u4f46\u914d\u7f6e\u5185\u5bb9\u4e00\u81f4\uff0c\u5ffd\u7565", ServiceHubBase.this.getId()));
                        ServiceHubBase.this.logEvent(20000, String.format("\u670d\u52a1\u603b\u7ebf[%1$s]\u63a5\u6536\u5230\u7248\u672c\u53d8\u5316\uff0c\u4f46\u914d\u7f6e\u5185\u5bb9\u4e00\u81f4\uff0c\u5ffd\u7565\u91cd\u65b0\u90e8\u7f72", ServiceHubBase.this.getId()));
                        return;
                    }
                    ServiceHubBase.this.strServiceHubVerConfig = configInfo;
                    log.debug((Object)String.format("\u670d\u52a1\u603b\u7ebf[%1$s]\u7248\u672c\u53d1\u751f\u53d8\u5316", ServiceHubBase.this.getId()));
                    ServiceHubBase.this.logEvent(20000, String.format("\u670d\u52a1\u603b\u7ebf[%1$s]\u63a5\u6536\u5230\u7248\u672c\u53d8\u5316\uff0c\u91cd\u65b0\u90e8\u7f72", ServiceHubBase.this.getId()));
                    if (ServiceHubBase.this.isInstalled()) {
                        ServiceHubBase.this.reloadServiceHub(configInfo);
                    } else {
                        log.warn((Object)String.format("\u670d\u52a1\u603b\u7ebf\u672a\u5b89\u88c5\u5b8c\u6210\uff0c\u5ffd\u7565\u914d\u7f6e\u7248\u672c\u53d8\u5316", new Object[0]));
                    }
                }
            });
        }
    }

    protected void prepareCloudPluginService() throws Exception {
        String cloudPluginServiceId = this.getServiceHubSetting().getCloudPluginServiceId();
        if (!StringUtils.hasLength((String)cloudPluginServiceId)) {
            log.warn((Object)String.format("\u672a\u6307\u5b9aCloud\u63d2\u4ef6\u670d\u52a1\u6807\u8bc6\uff0c\u672a\u542f\u7528\u63d2\u4ef6\u670d\u52a1", new Object[0]));
            return;
        }
        DeploySystem deploySystem = new DeploySystem();
        deploySystem.setDeploySystemId(cloudPluginServiceId);
        deploySystem.setModelPath("__REMOTE__");
        IPSSystemService iPSSystemService = null;
        try {
            iPSSystemService = this.getPSSystemService(deploySystem, true);
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u83b7\u53d6Cloud\u63d2\u4ef6\u670d\u52a1\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
        }
        if (iPSSystemService == null) {
            log.warn((Object)String.format("Cloud\u63d2\u4ef6\u670d\u52a1[%1$s]\u65e0\u6548\uff0c\u672a\u542f\u7528\u63d2\u4ef6\u670d\u52a1", cloudPluginServiceId));
            return;
        }
        ICloudPluginService cloudPluginService = this.createCloudPluginService();
        cloudPluginService.init(iPSSystemService);
        this.setCloudPluginService(cloudPluginService);
    }

    protected ICloudPluginService createCloudPluginService() {
        return new CloudPluginService();
    }

    protected void startCloudDebugger() throws Exception {
        String strDebuggerCmd = this.getServiceHubSetting().getDebuggerCmd();
        if (!StringUtils.hasLength((String)strDebuggerCmd)) {
            String strDebugTag = String.format("%1$s_%2$s", this.strIPAddress, this.port).replace(".", "_");
            strDebuggerCmd = String.format("java -Dibiz.debug.config.debugIpAddr=127.0.0.1:12345 -Dibiz.debug.mqttmessenger.serviceUrl=tcp://mqtt.ibizcloud.cn:31883 -Dibiz.debug.mqttmessenger.debugSystemTag=%1$s -jar /ibiztools/clouddebugger.jar", strDebugTag);
            log.debug((Object)String.format("CloudDebugger command: %1$s", strDebuggerCmd));
        }
        Runtime.getRuntime().exec(strDebuggerCmd);
        log.info((Object)"CloudDebugger\u542f\u52a8\u6210\u529f");
    }

    @Override
    public boolean isInstalled() {
        return this.bInstalled;
    }

    @Override
    public boolean isEnableServiceApp() {
        return this.getServiceHubSetting().isEnableServiceApp();
    }

    @Override
    public boolean isEnableServletApp() {
        return this.getServiceHubSetting().isEnableServletApp();
    }

    @Override
    public boolean isEnableDebug() {
        if (this.isEnableProdMode()) {
            return false;
        }
        return this.getServiceHubSetting().isEnableDebug();
    }

    @Override
    public boolean isEnableRTCodeMode() {
        return this.getServiceHubSetting().isEnableRTCodeMode();
    }

    @Override
    public boolean isEnableProdMode() {
        return this.getServiceHubSetting().isEnableProdMode();
    }

    @Override
    public int getWorkThreadCorePoolSize() {
        return this.getServiceHubSetting().getWorkThreadCorePoolSize();
    }

    @Override
    public int getWorkThreadMaximumPoolSize() {
        return this.getServiceHubSetting().getWorkThreadMaximumPoolSize();
    }

    @Override
    public int getWorkThreadBlockingQueueSize() {
        return this.getServiceHubSetting().getWorkThreadBlockingQueueSize();
    }

    @Override
    public String getServletAppBaseUrl() {
        return "web";
    }

    @Override
    public ICloudPluginService getCloudPluginService() {
        return this.cloudPluginService;
    }

    protected void setCloudPluginService(ICloudPluginService cloudPluginService) {
        this.cloudPluginService = cloudPluginService;
    }

    protected void registerIgnoreAuthPatterns() throws Exception {
        this.registerIgnoreAuthPattern("/swagger-ui/**");
        this.registerIgnoreAuthPattern("/swagger**/**");
        this.registerIgnoreAuthPattern("/webjars/**");
        this.registerIgnoreAuthPattern("/v3/**");
        if (this.isEnableServletApp()) {
            this.registerIgnoreAuthPattern(String.format("/%1$s/**", this.getServletAppBaseUrl()));
        }
    }

    protected javax.sql.DataSource registerDataSource(DataSource ds) throws Exception {
        throw new Exception("\u672a\u63d0\u4f9b\u6ce8\u518c\u52a8\u6001\u6570\u636e\u6e90\u80fd\u529b");
    }

    protected ISystemRuntime registerDeploySystem(DeploySystem deploySystem) throws Exception {
        Object iSystemRuntime;
        IPSSystemService iPSSystemService;
        block16: {
            String strModelPath;
            iPSSystemService = null;
            V2DeploySystem v2DeploySystem = null;
            if (!"gateway".equalsIgnoreCase(deploySystem.getDeploySystemId()) && (v2DeploySystem = this.getV2DeploySystem(deploySystem)) != null) {
                if (deploySystem.getSettings() == null) {
                    deploySystem.setSettings(new LinkedHashMap<String, Object>());
                }
                deploySystem.getSettings().put("v2deploysystem", (Object)v2DeploySystem);
                List<V2DeploySystemDataSource> v2DeploySystemDataSourceList = v2DeploySystem.getDataSources();
                if (!ObjectUtils.isEmpty(v2DeploySystemDataSourceList)) {
                    for (V2DeploySystemDataSource v2DeploySystemDataSource : v2DeploySystemDataSourceList) {
                        String strName;
                        if (!StringUtils.hasLength((String)v2DeploySystemDataSource.getDataSourceId()) || !StringUtils.hasLength((String)(strName = v2DeploySystemDataSource.getName()))) continue;
                        DataSource dataSource = this.dataSourceMap.get(v2DeploySystemDataSource.getDataSourceId());
                        if (dataSource == null) {
                            V2DataSource v2DataSource = this.getV2DataSource(v2DeploySystemDataSource.getDataSourceId());
                            dataSource = new DataSource();
                            dataSource.setDataSourceId(v2DataSource.getId());
                            dataSource.setDBType(v2DataSource.getType());
                            dataSource.setJdbcUrl(v2DataSource.getUrl());
                            dataSource.setUsername(v2DataSource.getUsername());
                            dataSource.setPassword(v2DataSource.getPassword());
                        }
                        if (strName.indexOf("db.") == 0) {
                            String strModelTag = strName.substring(3);
                            deploySystem.getSettings().put(String.format("sysdbscheme.%1$s.datasourcetag", strModelTag), dataSource.getDataSourceId());
                            if (StringUtils.hasLength((String)dataSource.getDBType())) {
                                deploySystem.getSettings().put(String.format("sysdbscheme.%1$s.dbtype", strModelTag), dataSource.getDBType());
                            }
                            deploySystem.getSettings().put(String.format("sysdbscheme.%1$s.updateschema", strModelTag), DataTypeUtils.getBooleanValue((Object)v2DeploySystemDataSource.getUpdateSchema(), (Boolean)true));
                        }
                        try {
                            if (this.dataSourceMap.containsKey(v2DeploySystemDataSource.getDataSourceId())) continue;
                            this.dataSourceMap.put(dataSource.getDataSourceId(), dataSource);
                            this.registerDataSource(dataSource);
                        }
                        catch (Exception ex) {
                            throw new Exception(String.format("\u6ce8\u518c\u6570\u636e\u6e90[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", v2DeploySystemDataSource.getDataSourceId(), ex.getMessage()), ex);
                        }
                    }
                }
                iPSSystemService = this.getPSSystemService(v2DeploySystem);
            }
            if (iPSSystemService == null) {
                iPSSystemService = this.getPSSystemService(deploySystem);
            }
            if (iPSSystemService == null && StringUtils.hasLength((String)(strModelPath = deploySystem.getModelPath()))) {
                PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
                psModelServiceImpl.setPSModelFolderPath(strModelPath);
                iPSSystemService = psModelServiceImpl;
            }
            boolean bMustRuntimeClass = v2DeploySystem == null;
            String strRuntimeClassName = deploySystem.getRuntimeClassName();
            if (!StringUtils.hasLength((String)strRuntimeClassName) && iPSSystemService != null && StringUtils.hasLength((String)(strRuntimeClassName = iPSSystemService.getPSSystem().getRTObjectName()))) {
                bMustRuntimeClass = true;
            }
            iSystemRuntime = null;
            if (StringUtils.hasLength((String)strRuntimeClassName)) {
                try {
                    iSystemRuntime = (ISystemRuntime)SysSFPluginRuntime.createObject((String)strRuntimeClassName);
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u65e0\u6cd5\u5efa\u7acb\u7cfb\u7edf[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61[%2$s]", deploySystem.getDeploySystemId(), strRuntimeClassName));
                    if (!bMustRuntimeClass) break block16;
                    throw ex;
                }
            }
        }
        if (iSystemRuntime == null) {
            iSystemRuntime = "gateway".equalsIgnoreCase(deploySystem.getDeploySystemId()) ? new HubSystemRuntime() : new ServiceSystemRuntime();
        }
        iSystemRuntime.init(this.getSystemGatewayContext(), iPSSystemService, deploySystem.getDeploySystemId(), deploySystem.getSettings());
        this.registerSystemRuntime(deploySystem, (ISystemRuntime)iSystemRuntime);
        return iSystemRuntime;
    }

    protected String getDeploySystemModelPath() {
        if (!StringUtils.hasLength((String)this.strDeploySystemModelPath)) {
            String strPath = String.format("%1$s%2$sdeploysystem", this.getFileFolder(), File.separator);
            File folder = new File(strPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            this.strDeploySystemModelPath = strPath;
        }
        return this.strDeploySystemModelPath;
    }

    protected IPSSystemService getPSSystemService(DeploySystem deploySystem) throws Exception {
        return this.getPSSystemService(deploySystem, false);
    }

    protected IPSSystemService getPSSystemService(DeploySystem deploySystem, boolean tryMode) throws Exception {
        File systemModelFile;
        if ("gateway".equalsIgnoreCase(deploySystem.getDeploySystemId())) {
            return null;
        }
        String strModelPath = deploySystem.getModelPath();
        if (!"__REMOTE__".equals(strModelPath)) {
            return null;
        }
        ISysCloudClientUtilRuntime iSysCloudClientRuntime = (ISysCloudClientUtilRuntime)this.getHubSystemRuntime(false).getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
        ICloudDevOpsClient iCloudDevOpsClient = (ICloudDevOpsClient)iSysCloudClientRuntime.getServiceClient("DEVOPS").getProxyClient(ICloudDevOpsClient.class);
        String strModelDigest = iCloudDevOpsClient.getSystemModelDigest(deploySystem.getDeploySystemId());
        if (!StringUtils.hasLength((String)strModelDigest)) {
            if (tryMode) {
                return null;
            }
            throw new Exception(String.format("\u672a\u5b9a\u4e49\u8fdc\u7a0b\u6a21\u578b\u914d\u7f6e", new Object[0]));
        }
        String[] items = strModelDigest.split("[|]");
        if (items.length < 2) {
            throw new Exception(String.format("\u8fdc\u7a0b\u6a21\u578b\u914d\u7f6e\u4e0d\u6b63\u786e", new Object[0]));
        }
        String strFileId = items[1];
        String strDynaModelPath = String.format("%1$s%2$s%3$s", this.getDeploySystemModelPath(), File.separator, strFileId);
        if (this.getServiceHubSetting().isEnableModelSnapshot()) {
            strDynaModelPath = String.format("%1$s%2$s%3$s", strDynaModelPath, File.separator, KeyValueUtils.genUniqueId());
        }
        if (!(systemModelFile = new File(strDynaModelPath + File.separator + "PSSYSTEM.json")).exists()) {
            ISysFileUtilRuntime iSysFileUtilRuntime = (ISysFileUtilRuntime)this.getHubSystemRuntime(false).getSysUtilRuntime(ISysFileUtilRuntime.class, false);
            Object ossFile = iSysFileUtilRuntime.getOSSFile(strFileId, "devops-dynamodel", true);
            if (ossFile == null && (ossFile = iSysFileUtilRuntime.getOSSFile(strFileId, null, true)) == null) {
                throw new Exception(String.format("\u6307\u5b9a\u6a21\u578b\u6587\u4ef6[%1$s]\u4e0d\u5b58\u5728", strFileId));
            }
            File dynaModelFolder = new File(strDynaModelPath);
            if (!systemModelFile.exists()) {
                ZipUtils.unzip((File)new File(ossFile.getLocalPath()), (File)dynaModelFolder);
            }
        }
        log.debug((Object)String.format("\u7cfb\u7edf[%1$s]\u4f7f\u7528\u8fdc\u7a0b\u6a21\u578b[%2$s][%3$s]", deploySystem.getDeploySystemId(), strModelDigest, strDynaModelPath));
        if (this.getServiceHubSetting().isEnableMergeSystem() && !ObjectUtils.isEmpty(deploySystem.getMergeSystems())) {
            ArrayList<DeploySystem> list = new ArrayList<DeploySystem>();
            for (String strMergeSystemId : deploySystem.getMergeSystems()) {
                DeploySystem mergeDeploySystem = new DeploySystem();
                mergeDeploySystem.setDeploySystemId(strMergeSystemId);
                mergeDeploySystem.setModelPath("__REMOTE__");
                File file = this.getDeploySystemRemoteModel(mergeDeploySystem, false);
                mergeDeploySystem.setModelPath(file.getCanonicalPath());
                list.add(mergeDeploySystem);
                log.debug((Object)String.format("\u5408\u5165\u7cfb\u7edf[%1$s]\u6a21\u578b[%2$s]", mergeDeploySystem.getDeploySystemId(), mergeDeploySystem.getModelPath()));
            }
            IHubSysExtensionUtilRuntime iHubSysExtensionUtilRuntime = (IHubSysExtensionUtilRuntime)this.getHubSystemRuntime(false).getSysUtilRuntime(IHubSysExtensionUtilRuntime.class, false);
            File mergeFile = iHubSysExtensionUtilRuntime.mergeDeploySystems(new File(strDynaModelPath), list, true);
            strDynaModelPath = mergeFile.getCanonicalPath();
            log.debug((Object)String.format("\u7cfb\u7edf[%1$s]\u4f7f\u7528\u5408\u5e76\u6a21\u578b[%2$s]", deploySystem.getDeploySystemId(), strDynaModelPath));
        }
        PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
        psModelServiceImpl.setPSModelFolderPath(strDynaModelPath);
        psModelServiceImpl.setModelDigest(items[0]);
        return psModelServiceImpl;
    }

    protected File getDeploySystemRemoteModel(DeploySystem deploySystem, boolean tryMode) throws Exception {
        ISysCloudClientUtilRuntime iSysCloudClientRuntime = (ISysCloudClientUtilRuntime)this.getHubSystemRuntime(false).getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
        ICloudDevOpsClient iCloudDevOpsClient = (ICloudDevOpsClient)iSysCloudClientRuntime.getServiceClient("DEVOPS").getProxyClient(ICloudDevOpsClient.class);
        String strModelDigest = iCloudDevOpsClient.getSystemModelDigest(deploySystem.getDeploySystemId());
        if (!StringUtils.hasLength((String)strModelDigest)) {
            if (tryMode) {
                return null;
            }
            throw new Exception(String.format("\u672a\u5b9a\u4e49\u8fdc\u7a0b\u6a21\u578b\u914d\u7f6e", new Object[0]));
        }
        String[] items = strModelDigest.split("[|]");
        if (items.length < 2) {
            throw new Exception(String.format("\u8fdc\u7a0b\u6a21\u578b\u914d\u7f6e\u4e0d\u6b63\u786e", new Object[0]));
        }
        String strFileId = items[1];
        String strDynaModelPath = String.format("%1$s%2$s%3$s", this.getDeploySystemModelPath(), File.separator, strFileId);
        if (this.getServiceHubSetting().isEnableModelSnapshot()) {
            strDynaModelPath = String.format("%1$s%2$s%3$s", strDynaModelPath, File.separator, KeyValueUtils.genUniqueId());
        }
        File dynaModelFolder = new File(strDynaModelPath);
        File systemModelFile = new File(strDynaModelPath + File.separator + "PSSYSTEM.json");
        if (!systemModelFile.exists()) {
            ISysFileUtilRuntime iSysFileUtilRuntime = (ISysFileUtilRuntime)this.getHubSystemRuntime(false).getSysUtilRuntime(ISysFileUtilRuntime.class, false);
            net.ibizsys.runtime.util.domain.File ossFile = iSysFileUtilRuntime.getOSSFile(strFileId, "devops-dynamodel", true);
            if (ossFile == null && (ossFile = iSysFileUtilRuntime.getOSSFile(strFileId, null, true)) == null) {
                throw new Exception(String.format("\u6307\u5b9a\u6a21\u578b\u6587\u4ef6[%1$s]\u4e0d\u5b58\u5728", strFileId));
            }
            if (!systemModelFile.exists()) {
                ZipUtils.unzip((File)new File(ossFile.getLocalPath()), (File)dynaModelFolder);
            }
        }
        return dynaModelFolder;
    }

    protected IPSSystemService getPSSystemService(V2DeploySystem v2DeploySystem) throws Exception {
        File systemModelFile;
        if (!StringUtils.hasLength((String)v2DeploySystem.getOssFile())) {
            return null;
        }
        String strFileId = v2DeploySystem.getOssFile();
        String strDynaModelPath = String.format("%1$s%2$s%3$s", this.getDeploySystemModelPath(), File.separator, strFileId);
        if (this.getServiceHubSetting().isEnableModelSnapshot()) {
            strDynaModelPath = String.format("%1$s%2$s%3$s", strDynaModelPath, File.separator, KeyValueUtils.genUniqueId());
        }
        if (!(systemModelFile = new File(strDynaModelPath + File.separator + "PSSYSTEM.json")).exists()) {
            ISysFileUtilRuntime iSysFileUtilRuntime = (ISysFileUtilRuntime)this.getHubSystemRuntime(false).getSysUtilRuntime(ISysFileUtilRuntime.class, false);
            net.ibizsys.runtime.util.domain.File ossFile = iSysFileUtilRuntime.getOSSFile(strFileId, "devops-dynamodel", true);
            if (ossFile == null && (ossFile = iSysFileUtilRuntime.getOSSFile(strFileId, null, true)) == null) {
                throw new Exception(String.format("\u6307\u5b9a\u6a21\u578b\u6587\u4ef6[%1$s]\u4e0d\u5b58\u5728", strFileId));
            }
            File dynaModelFolder = new File(strDynaModelPath);
            if (!systemModelFile.exists()) {
                ZipUtils.unzip((File)new File(ossFile.getLocalPath()), (File)dynaModelFolder);
            }
        }
        log.debug((Object)String.format("\u7cfb\u7edf[%1$s]\u4f7f\u7528\u8fdc\u7a0b\u6a21\u578b[%2$s][%3$s]", v2DeploySystem.getId(), v2DeploySystem.getOssFileDigest(), strDynaModelPath));
        PSModelServiceImpl psModelServiceImpl = new PSModelServiceImpl();
        psModelServiceImpl.setPSModelFolderPath(strDynaModelPath);
        psModelServiceImpl.setModelDigest(v2DeploySystem.getOssFileDigest());
        return psModelServiceImpl;
    }

    protected void registerSystemRuntime(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        String strDeploySystemId = deploySystem.getDeploySystemId();
        this.registerSystemRuntime(strDeploySystemId, iSystemRuntime);
        if (!"gateway".equalsIgnoreCase(strDeploySystemId)) {
            boolean bEnableServiceHubAPI = true;
            if (iSystemRuntime instanceof IServiceSystemRuntime) {
                bEnableServiceHubAPI = ((IServiceSystemRuntime)iSystemRuntime).isEnableServiceHubAPI();
            }
            if (bEnableServiceHubAPI) {
                String strServiceName = String.format("%1$s-%2$s", "servicehub", iSystemRuntime.getDeploySystemId());
                this.registerNamingService(strServiceName);
            }
        }
        this.registerDataSources(deploySystem, iSystemRuntime);
        String strInstallData = DataTypeUtils.getStringValue((Object)deploySystem.getInstallData(), (String)"DEFAULT");
        if (StringUtils.hasLength((String)strInstallData) && !strInstallData.equalsIgnoreCase("FALSE")) {
            iSystemRuntime.installData(strInstallData);
        }
        this.registerServiceAPIRequestMapping(deploySystem, iSystemRuntime);
        if (this.isEnableServletApp()) {
            this.registerServletAppRequestMapping(deploySystem, iSystemRuntime);
        }
        if (this.isEnableServiceApp()) {
            this.registerServiceAppRequestMapping(deploySystem, iSystemRuntime);
        }
        this.registerAppGatewayRoutes(deploySystem, iSystemRuntime);
    }

    public void registerSystemRuntime(String strDeploySystemId, ISystemRuntime iSystemRuntime) throws Exception {
        super.registerSystemRuntime(strDeploySystemId, iSystemRuntime);
        if (this.getServiceHubFilter() == null) {
            this.setServiceHubFilter((IServiceHubFilter)iSystemRuntime.getSysUtilRuntime(IServiceHubFilter.class, true));
        }
        if ("gateway".equalsIgnoreCase(strDeploySystemId) && iSystemRuntime instanceof IHubSystemRuntime) {
            this.setHubSystemRuntime((IHubSystemRuntime)iSystemRuntime);
        }
    }

    protected void registerServiceAPIRequestMapping(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        if (this.getRequestMappingHandlerMapping() == null) {
            log.warn((Object)String.format("\u63a5\u53e3\u8bf7\u6c42\u6620\u5c04\u5904\u7406\u5bf9\u8c61\u65e0\u6548", new Object[0]));
            return;
        }
        List psSysServiceAPIs = iSystemRuntime.getPSSystem().getAllPSSysServiceAPIs();
        if (psSysServiceAPIs != null) {
            for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIs) {
                net.ibizsys.central.service.ISysServiceAPIRuntime iSysServiceAPIRuntime = iSystemRuntime.getSysServiceAPIRuntime(iPSSysServiceAPI.getCodeName(), true);
                if (iSysServiceAPIRuntime == null) {
                    log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u670d\u52a1\u63a5\u53e3[%2$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548\uff0c\u5ffd\u7565\u8bf7\u6c42\u5904\u7406\u6620\u5c04", deploySystem.getDeploySystemId(), iPSSysServiceAPI.getName()));
                    continue;
                }
                ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter = this.getSysServiceAPIRequestMappingAdapter(iSysServiceAPIRuntime);
                if (iSysServiceAPIRequestMappingAdapter == null) continue;
                if (iSysServiceAPIRuntime instanceof ISysServiceAPIRuntime) {
                    ((ISysServiceAPIRuntime)iSysServiceAPIRuntime).registerMapping(iSysServiceAPIRequestMappingAdapter);
                } else {
                    iSysServiceAPIRequestMappingAdapter.registerMapping(iSysServiceAPIRuntime);
                }
                String strServiceName = String.format("%1$s-%2$s", iSystemRuntime.getDeploySystemId(), iPSSysServiceAPI.getCodeName()).toLowerCase();
                this.registerNamingService(strServiceName);
            }
        }
    }

    protected void registerServletAppRequestMapping(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        String prefix = String.format("/%1$s/", this.getServletAppBaseUrl());
        List psApplications = iSystemRuntime.getPSSystem().getAllPSApps();
        if (psApplications != null) {
            for (IPSApplication iPSApplication : psApplications) {
                IApplicationRuntime iApplicationRuntime = iSystemRuntime.getApplicationRuntime(iPSApplication.getCodeName(), true);
                if (iApplicationRuntime == null) {
                    log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u524d\u7aef\u5e94\u7528[%2$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548\uff0c\u5ffd\u7565\u8bf7\u6c42\u5904\u7406\u6620\u5c04", deploySystem.getDeploySystemId(), iPSApplication.getName()));
                    continue;
                }
                if (!(iApplicationRuntime instanceof IServletAppRuntime)) continue;
                IServletAppRuntime iServletAppRuntime = (IServletAppRuntime)iApplicationRuntime;
                String url = iServletAppRuntime.getBaseUrl();
                if (url.indexOf(prefix) != 0) {
                    log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u524d\u7aef\u5e94\u7528[%2$s]\u670d\u52a1\u524d\u7f00[%3$s]\u4e0d\u4e00\u81f4\uff0c\u5ffd\u7565\u6ce8\u518c", deploySystem.getDeploySystemId(), iApplicationRuntime.getName(), url));
                    continue;
                }
                url = url.substring(prefix.length());
                this.servletAppRuntimeMap.put(url + "/**", iServletAppRuntime);
                String strServiceName = String.format("%1$s-app-%2$s", iSystemRuntime.getDeploySystemId(), iPSApplication.getCodeName()).toLowerCase();
                this.registerNamingService(strServiceName);
            }
        }
    }

    protected void registerServiceAppRequestMapping(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        if (this.getRequestMappingHandlerMapping() == null) {
            log.warn((Object)String.format("\u63a5\u53e3\u8bf7\u6c42\u6620\u5c04\u5904\u7406\u5bf9\u8c61\u65e0\u6548", new Object[0]));
            return;
        }
        List psApplications = iSystemRuntime.getPSSystem().getAllPSApps();
        if (psApplications != null) {
            for (IPSApplication iPSApplication : psApplications) {
                IApplicationRuntime iApplicationRuntime = iSystemRuntime.getApplicationRuntime(iPSApplication.getCodeName(), true);
                if (iApplicationRuntime == null || !(iApplicationRuntime instanceof IServiceAppRuntime)) continue;
                IServiceAppRuntime iServiceAppRuntime = (IServiceAppRuntime)iApplicationRuntime;
                ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter = this.getApplicationRequestMappingAdapter(iServiceAppRuntime);
                iServiceAppRuntime.registerMapping(iSysServiceAPIRequestMappingAdapter);
                String strServiceName = String.format("%1$s-app-%2$s", iSystemRuntime.getDeploySystemId(), iPSApplication.getCodeName()).toLowerCase();
                this.registerNamingService(strServiceName);
            }
        }
    }

    protected void unregisterSystemRuntime(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        String strDeploySystemId = deploySystem.getDeploySystemId();
        if ("gateway".equalsIgnoreCase(strDeploySystemId)) {
            throw new Exception(String.format("\u65e0\u6cd5\u6ce8\u9500[%1$s]\u7cfb\u7edf\u8fd0\u884c\u65f6", strDeploySystemId));
        }
        try {
            this.unregisterServiceAPIRequestMapping(deploySystem, iSystemRuntime);
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u6ce8\u9500\u670d\u52a1\u63a5\u53e3\u8def\u5f84\u6620\u5c04\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        try {
            if (this.isEnableServletApp()) {
                this.unregisterServletAppRequestMapping(deploySystem, iSystemRuntime);
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u6ce8\u9500\u524d\u7aef\u5e94\u7528\u8def\u5f84\u6620\u5c04\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        try {
            if (this.isEnableServiceApp()) {
                this.unregisterServiceAppRequestMapping(deploySystem, iSystemRuntime);
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u6ce8\u9500\u524d\u7aef\u5e94\u7528\u8def\u5f84\u6620\u5c04\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        try {
            boolean bEnableServiceHubAPI = true;
            if (iSystemRuntime instanceof IServiceSystemRuntime) {
                bEnableServiceHubAPI = ((IServiceSystemRuntime)iSystemRuntime).isEnableServiceHubAPI();
            }
            if (bEnableServiceHubAPI) {
                String strServiceName = String.format("%1$s-%2$s", "servicehub", iSystemRuntime.getDeploySystemId());
                this.unregisterNamingService(strServiceName);
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u6ce8\u9500\u7cfb\u7edf\u547d\u540d\u670d\u52a1\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        this.unregisterSystemRuntime(strDeploySystemId, iSystemRuntime);
    }

    protected void unregisterSystemRuntime(String strDeploySystemId, ISystemRuntime iSystemRuntime) throws Exception {
        if (iSystemRuntime instanceof IServiceSystemRuntime) {
            ((IServiceSystemRuntime)iSystemRuntime).shutdown();
        }
        super.unregisterSystemRuntime(strDeploySystemId);
    }

    protected void unregisterServiceAPIRequestMapping(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        if (this.getRequestMappingHandlerMapping() == null) {
            log.warn((Object)String.format("\u63a5\u53e3\u8bf7\u6c42\u6620\u5c04\u5904\u7406\u5bf9\u8c61\u65e0\u6548", new Object[0]));
            return;
        }
        List psSysServiceAPIs = iSystemRuntime.getPSSystem().getAllPSSysServiceAPIs();
        if (psSysServiceAPIs != null) {
            for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIs) {
                net.ibizsys.central.service.ISysServiceAPIRuntime iSysServiceAPIRuntime = iSystemRuntime.getSysServiceAPIRuntime(iPSSysServiceAPI.getCodeName(), true);
                if (iSysServiceAPIRuntime == null) {
                    log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u670d\u52a1\u63a5\u53e3[%2$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548\uff0c\u5ffd\u7565\u8bf7\u6c42\u5904\u7406\u6620\u5c04", deploySystem.getDeploySystemId(), iPSSysServiceAPI.getName()));
                    continue;
                }
                ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter = this.getSysServiceAPIRequestMappingAdapter(iSysServiceAPIRuntime);
                if (iSysServiceAPIRequestMappingAdapter == null) continue;
                if (iSysServiceAPIRuntime instanceof ISysServiceAPIRuntime) {
                    ((ISysServiceAPIRuntime)iSysServiceAPIRuntime).unregisterMapping(iSysServiceAPIRequestMappingAdapter);
                } else {
                    iSysServiceAPIRequestMappingAdapter.unregisterMapping(iSysServiceAPIRuntime);
                }
                String strServiceName = String.format("%1$s-%2$s", iSystemRuntime.getDeploySystemId(), iPSSysServiceAPI.getCodeName()).toLowerCase();
                this.unregisterNamingService(strServiceName);
            }
        }
    }

    protected void unregisterServletAppRequestMapping(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        String prefix = String.format("/%1$s/", this.getServletAppBaseUrl());
        List psApplications = iSystemRuntime.getPSSystem().getAllPSApps();
        if (psApplications != null) {
            for (IPSApplication iPSApplication : psApplications) {
                IApplicationRuntime iApplicationRuntime = iSystemRuntime.getApplicationRuntime(iPSApplication.getCodeName(), true);
                if (iApplicationRuntime == null) {
                    log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u524d\u7aef\u5e94\u7528[%2$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548\uff0c\u5ffd\u7565\u8bf7\u6c42\u5904\u7406\u6620\u5c04", deploySystem.getDeploySystemId(), iPSApplication.getName()));
                    continue;
                }
                if (!(iApplicationRuntime instanceof IServletAppRuntime)) continue;
                IServletAppRuntime iServletAppRuntime = (IServletAppRuntime)iApplicationRuntime;
                String url = iServletAppRuntime.getBaseUrl();
                if (url.indexOf(prefix) != 0) {
                    log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u524d\u7aef\u5e94\u7528[%2$s]\u670d\u52a1\u524d\u7f00[%3$s]\u4e0d\u4e00\u81f4\uff0c\u5ffd\u7565\u6ce8\u9500", deploySystem.getDeploySystemId(), iApplicationRuntime.getName(), url));
                    continue;
                }
                url = url.substring(prefix.length());
                this.servletAppRuntimeMap.remove(url + "/**", iServletAppRuntime);
                String strServiceName = String.format("%1$s-app-%2$s", iSystemRuntime.getDeploySystemId(), iPSApplication.getCodeName()).toLowerCase();
                this.unregisterNamingService(strServiceName);
            }
        }
    }

    protected void unregisterServiceAppRequestMapping(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        if (this.getRequestMappingHandlerMapping() == null) {
            log.warn((Object)String.format("\u63a5\u53e3\u8bf7\u6c42\u6620\u5c04\u5904\u7406\u5bf9\u8c61\u65e0\u6548", new Object[0]));
            return;
        }
        List psApplications = iSystemRuntime.getPSSystem().getAllPSApps();
        if (psApplications != null) {
            for (IPSApplication iPSApplication : psApplications) {
                IApplicationRuntime iApplicationRuntime = iSystemRuntime.getApplicationRuntime(iPSApplication.getCodeName(), true);
                if (iApplicationRuntime == null) {
                    log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u524d\u7aef\u5e94\u7528[%2$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548\uff0c\u5ffd\u7565\u8bf7\u6c42\u5904\u7406\u6620\u5c04", deploySystem.getDeploySystemId(), iPSApplication.getName()));
                    continue;
                }
                if (!(iApplicationRuntime instanceof IServiceAppRuntime)) continue;
                IServiceAppRuntime iServiceAppRuntime = (IServiceAppRuntime)iApplicationRuntime;
                ISysServiceAPIRequestMappingAdapter iSysServiceAPIRequestMappingAdapter = this.getApplicationRequestMappingAdapter(iServiceAppRuntime);
                iServiceAppRuntime.unregisterMapping(iSysServiceAPIRequestMappingAdapter);
                String strServiceName = String.format("%1$s-app-%2$s", iSystemRuntime.getDeploySystemId(), iPSApplication.getCodeName()).toLowerCase();
                this.unregisterNamingService(strServiceName);
            }
        }
    }

    protected ISysServiceAPIRequestMappingAdapter getSysServiceAPIRequestMappingAdapter(net.ibizsys.central.service.ISysServiceAPIRuntime iSysServiceAPIRuntime) throws Exception {
        if (this.iSysServiceAPIRequestMappingAdapter == null) {
            StandardSysServiceAPIRequestMappingAdapter standardSysServiceAPIRequestMappingAdapter = new StandardSysServiceAPIRequestMappingAdapter();
            standardSysServiceAPIRequestMappingAdapter.init(this.getSystemGatewayContext(), this.getRequestMappingHandlerMapping(), this.getSysServiceAPIDocAdapter());
            this.iSysServiceAPIRequestMappingAdapter = standardSysServiceAPIRequestMappingAdapter;
        }
        return this.iSysServiceAPIRequestMappingAdapter;
    }

    protected ISysServiceAPIRequestMappingAdapter getApplicationRequestMappingAdapter(IApplicationRuntime iApplicationRuntime) throws Exception {
        if (this.iSysServiceAPIRequestMappingAdapter == null) {
            StandardSysServiceAPIRequestMappingAdapter standardSysServiceAPIRequestMappingAdapter = new StandardSysServiceAPIRequestMappingAdapter();
            standardSysServiceAPIRequestMappingAdapter.init(this.getSystemGatewayContext(), this.getRequestMappingHandlerMapping(), this.getSysServiceAPIDocAdapter());
            this.iSysServiceAPIRequestMappingAdapter = standardSysServiceAPIRequestMappingAdapter;
        }
        return this.iSysServiceAPIRequestMappingAdapter;
    }

    public boolean fillDataSourceInfo(ISysDBSchemeRuntime iSysDBSchemeRuntime) {
        return super.fillDataSourceInfo(iSysDBSchemeRuntime);
    }

    protected void registerDataSources(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        List psSysDBSchemes = iSystemRuntime.getPSSystem().getAllPSSysDBSchemes();
        if (ObjectUtils.isEmpty((Object)psSysDBSchemes)) {
            log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u672a\u5b9a\u4e49\u6570\u636e\u5e93\u4f53\u7cfb\u7ed3\u6784", deploySystem.getDeploySystemId()));
            return;
        }
        for (IPSSysDBScheme iPSSysDBScheme : psSysDBSchemes) {
            ISysDBSchemeRuntime iSysDBSchemeRuntime = iSystemRuntime.getSysDBSchemeRuntime(iPSSysDBScheme);
            String strDBInstTag = iPSSysDBScheme.getDBInstTag();
            if (!StringUtils.hasLength((String)strDBInstTag)) continue;
            if (!strDBInstTag.equals(iSysDBSchemeRuntime.getDataSourceTag())) {
                log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u6570\u636e\u5e93[%2$s]\u6307\u5b9a\u6570\u636e\u6e90[%3$s]\uff0c\u5ffd\u7565\u9ed8\u8ba4\u6307\u5b9a[%4$s]", deploySystem.getDeploySystemId(), iPSSysDBScheme.getName(), iSysDBSchemeRuntime.getDataSourceTag(), strDBInstTag));
                continue;
            }
            if (this.registerDBInst(strDBInstTag) != null) continue;
            log.warn((Object)String.format("\u672a\u5b9a\u4e49\u6570\u636e\u5e93\u5b9e\u4f8b[%1$s]\u914d\u7f6e\uff0c\u7cfb\u7edf[%2$s]\u6570\u636e\u5e93[%3$s]\u8bbf\u95ee\u53ef\u80fd\u4f1a\u51fa\u73b0\u95ee\u9898", strDBInstTag, deploySystem.getDeploySystemId(), iPSSysDBScheme.getName()));
        }
        boolean bUpdateDBScheme = DataTypeUtils.getBooleanValue((Object)deploySystem.getUpdateDBSchema(), (Boolean)false);
        if (!bUpdateDBScheme) {
            log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u5ffd\u7565\u53d1\u5e03\u6570\u636e\u5e93\u7ed3\u6784", deploySystem.getDeploySystemId()));
            return;
        }
        if (this.getSysDBSchemeSyncAdapter() != null && bUpdateDBScheme) {
            for (IPSSysDBScheme iPSSysDBScheme : psSysDBSchemes) {
                ISysDBSchemeRuntime iSysDBSchemeRuntime = iSystemRuntime.getSysDBSchemeRuntime(iPSSysDBScheme);
                DataSource dataSource = this.dataSourceMap.get(iSysDBSchemeRuntime.getDataSourceTag());
                if (dataSource == null) {
                    log.warn((Object)String.format("\u7cfb\u7edf[%1$s]\u6570\u636e\u5e93[%2$s]\u6307\u5b9a\u6570\u636e\u6e90[%3$s]\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u53d1\u5e03\u7ed3\u6784", deploySystem.getDeploySystemId(), iPSSysDBScheme.getName(), iSysDBSchemeRuntime.getDataSourceTag()));
                    continue;
                }
                try {
                    this.getSysDBSchemeSyncAdapter().sync(iSystemRuntime, iSysDBSchemeRuntime, dataSource, null);
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u540c\u6b65\u7cfb\u7edf[%1$s]\u6570\u636e\u5e93[%2$s]\u7ed3\u6784\u53d1\u751f\u5f02\u5e38\uff0c%3$s", iSystemRuntime.getDeploySystemId(), iSysDBSchemeRuntime.getDSLink(), ex.getMessage()), ex);
                }
            }
        }
    }

    protected javax.sql.DataSource registerDBInst(String strDBInstTag) throws Exception {
        ConfigEntity configEntity = this.dbInstConfigMap.get(strDBInstTag);
        if (configEntity == null) {
            String strDBInstConfigKey = String.format("%1$s%2$s", "dbinst-", strDBInstTag);
            String strConfig = this.getConfig(strDBInstConfigKey);
            if (!StringUtils.hasLength((String)strConfig)) {
                log.warn((Object)String.format("\u672a\u5b9a\u4e49\u6570\u636e\u5e93\u5b9e\u4f8b[%1$s]\u914d\u7f6e\uff0c\u8bbf\u95ee\u53ef\u80fd\u4f1a\u51fa\u73b0\u95ee\u9898", strDBInstConfigKey));
                return null;
            }
            configEntity = new ConfigEntity(strConfig);
            String strDBInstConfigExKey = String.format("%1$s%2$s-ex", "dbinst-", strDBInstTag);
            String strConfigEx = this.getConfig(strDBInstConfigExKey);
            if (StringUtils.hasLength((String)strConfigEx)) {
                ConfigEntity configexEntity = new ConfigEntity(strConfigEx);
                configexEntity.copyTo(configEntity);
            }
            DataSource dataSource = new DataSource();
            configEntity.copyTo((IEntity)dataSource);
            if (ObjectUtils.isEmpty((Object)dataSource.getJdbcUrl())) {
                dataSource.setJdbcUrl((String)dataSource.get("url"));
            }
            dataSource.setDataSourceId(strDBInstTag);
            this.dataSourceMap.put(dataSource.getDataSourceId(), dataSource);
            this.registerDataSource(dataSource);
            this.dbInstConfigMap.put(strDBInstTag, configEntity);
        }
        return this.getDataSource(strDBInstTag, true);
    }

    protected void registerAppGatewayRoutes(DeploySystem deploySystem, ISystemRuntime iSystemRuntime) throws Exception {
        List psApplications;
        boolean bEnableExtension = false;
        if (iSystemRuntime instanceof IServiceSystemRuntime) {
            bEnableExtension = ((IServiceSystemRuntime)iSystemRuntime).isEnableExtension();
        }
        if (!ObjectUtils.isEmpty((Object)(psApplications = iSystemRuntime.getPSSystem().getAllPSApps()))) {
            for (IPSApplication iPSApplication : psApplications) {
                ObjectNode objectNode = null;
                if (iPSApplication.getDynaSysMode() == PSModelEnums.DynaSysMode.DISABLED.value) {
                    objectNode = GatewayUtils.getAppGatewayNode(iSystemRuntime.getDeploySystemId(), iSystemRuntime.getServiceId(), iPSApplication);
                    if (objectNode == null) {
                        log.warn((Object)String.format("\u90e8\u7f72\u7cfb\u7edf\u5e94\u7528[%1$s][%2$s]\u672a\u63d0\u4f9b\u8def\u7531\u914d\u7f6e", iSystemRuntime.getDeploySystemId(), iPSApplication.getName()));
                        continue;
                    }
                } else {
                    List psSysRefs;
                    objectNode = GatewayUtils.getAppGatewayNode(iSystemRuntime.getDeploySystemId(), iSystemRuntime.getServiceId(), iPSApplication, bEnableExtension);
                    if (objectNode == null) {
                        log.warn((Object)String.format("\u90e8\u7f72\u7cfb\u7edf\u5e94\u7528[%1$s][%2$s]\u672a\u63d0\u4f9b\u8def\u7531\u914d\u7f6e", iSystemRuntime.getDeploySystemId(), iPSApplication.getName()));
                        continue;
                    }
                    if (bEnableExtension && !ObjectUtils.isEmpty((Object)(psSysRefs = iSystemRuntime.getPSSystem().getAllPSSysRefs()))) {
                        for (IPSSysRef iPSSysRef : psSysRefs) {
                            ObjectNode subObjectNode;
                            String strDeploySystemId;
                            List psApplicationList;
                            ISysRefRuntime iSysRefRuntime = iSystemRuntime.getSysRefRuntime(iPSSysRef);
                            if (!(iSysRefRuntime instanceof IExtensionSysRefRuntime)) continue;
                            IExtensionSysRefRuntime iExtensionSysRefRuntime = (IExtensionSysRefRuntime)iSysRefRuntime;
                            if (PSModelEnums.SysRefType.EXTENSION_DEVSYS.value.equals(iExtensionSysRefRuntime.getPSSysRef().getSysRefType())) {
                                psApplicationList = iExtensionSysRefRuntime.getPSSystemService().getPSSystem().getAllPSApps();
                                if (ObjectUtils.isEmpty((Object)psApplicationList)) continue;
                                for (IPSApplication subPSApplication : psApplicationList) {
                                    strDeploySystemId = String.format("%1$s__%2$s", iExtensionSysRefRuntime.getExtensionTag(), iPSApplication.getCodeName()).toLowerCase();
                                    subObjectNode = GatewayUtils.getAppGatewayNode(strDeploySystemId, iSystemRuntime.getServiceId(), subPSApplication, bEnableExtension);
                                    if (subObjectNode == null) {
                                        log.warn((Object)String.format("\u90e8\u7f72\u7cfb\u7edf\u6269\u5c55\u5e94\u7528[%1$s][%2$s][%3$s]\u672a\u63d0\u4f9b\u8def\u7531\u914d\u7f6e", iSystemRuntime.getDeploySystemId(), iExtensionSysRefRuntime.getName(), iPSApplication.getName()));
                                        continue;
                                    }
                                    objectNode = GatewayUtils.appendAppGatewayNode(objectNode, subObjectNode);
                                }
                                continue;
                            }
                            if (!PSModelEnums.SysRefType.EXTENSION_DEVSYS_PSMODELTOOL.value.equals(iExtensionSysRefRuntime.getPSSysRef().getSysRefType()) || ObjectUtils.isEmpty((Object)(psApplicationList = iExtensionSysRefRuntime.getPSSystemService().getPSSystem().getAllPSApps()))) continue;
                            for (IPSApplication subPSApplication : psApplicationList) {
                                strDeploySystemId = String.format("%1$s__%2$s", iExtensionSysRefRuntime.getExtensionTag(), iPSApplication.getCodeName()).toLowerCase();
                                subObjectNode = GatewayUtils.getPSModelToolAppGatewayNode(strDeploySystemId, iSystemRuntime.getServiceId(), subPSApplication);
                                if (subObjectNode == null) {
                                    log.warn((Object)String.format("\u90e8\u7f72\u7cfb\u7edf\u6269\u5c55\u5e94\u7528[%1$s][%2$s][%3$s]\u672a\u63d0\u4f9b\u8def\u7531\u914d\u7f6e", iSystemRuntime.getDeploySystemId(), iExtensionSysRefRuntime.getName(), iPSApplication.getName()));
                                    continue;
                                }
                                objectNode = GatewayUtils.appendAppGatewayNode(objectNode, subObjectNode);
                            }
                        }
                    }
                }
                String strConfigId = String.format("deployapp-%1$s-%2$s", iSystemRuntime.getDeploySystemId(), iPSApplication.getCodeName()).toLowerCase();
                this.publishConfig(strConfigId, objectNode);
            }
        }
    }

    protected V2DeploySystem getV2DeploySystem(DeploySystem deploySystem) throws Exception {
        boolean bExtension = DataTypeUtils.getBooleanValue((Object)deploySystem.getExtension(), (Boolean)false);
        if (!bExtension) {
            return null;
        }
        return this.getCloudExtensionClient().getDeploySystem(deploySystem.getDeploySystemId());
    }

    protected V2DataSource getV2DataSource(String strDataSourceId) throws Exception {
        return this.getCloudExtensionClient().getDataSource(strDataSourceId);
    }

    protected ICloudExtensionClient getCloudExtensionClient() throws Exception {
        if (this.iCloudExtensionClient == null) {
            ISysCloudClientUtilRuntime iSysCloudClientRuntime = (ISysCloudClientUtilRuntime)this.getHubSystemRuntime(false).getSysUtilRuntime(ISysCloudClientUtilRuntime.class, false);
            this.iCloudExtensionClient = (ICloudExtensionClient)iSysCloudClientRuntime.getServiceClient("EXTENSION", ICloudExtensionClient.class, true);
        }
        return this.iCloudExtensionClient;
    }

    @Override
    public <T extends ICloudUtilRuntime> T getCloudUtilRuntime(Class<?> systemCls, Class<T> cls, boolean bTryMode) {
        return (T)((ICloudUtilRuntime)this.getSysUtilRuntime(systemCls, cls, bTryMode));
    }

    public <T> T getSysUtilRuntime(Class<?> systemCls, Class<T> cls, boolean bTryMode) {
        Object t;
        ISystemRuntime iSystemRuntime;
        if (systemCls != null && (iSystemRuntime = (ISystemRuntime)this.getSystemRuntime(systemCls, true)) != null) {
            return (T)iSystemRuntime.getSysUtilRuntime(cls, bTryMode);
        }
        if (this.getHubSystemRuntime(true) != null && (t = this.getHubSystemRuntime(false).getSysUtilRuntime(cls, true)) != null && !(t instanceof ISysUtilContainerOnly)) {
            return (T)t;
        }
        for (ISystemRuntime iSystemRuntime2 : this.getSystemRuntimes()) {
            Object t2;
            if (iSystemRuntime2 == this.getHubSystemRuntime(true) || !(iSystemRuntime2 instanceof IServiceSystemRuntime ? (t2 = ((IServiceSystemRuntime)iSystemRuntime2).getSysUtilRuntime(cls, true, true)) != null && !(t2 instanceof ISysUtilContainerOnly) : (t2 = iSystemRuntime2.getSysUtilRuntime(cls, true)) != null && !(t2 instanceof ISysUtilContainerOnly))) continue;
            return (T)t2;
        }
        if (!bTryMode && this.getHubSystemRuntime(true) != null) {
            return (T)this.getHubSystemRuntime(false).getSysUtilRuntime(cls, false);
        }
        if (bTryMode) {
            return null;
        }
        throw new SystemGatewayException((ISystemGateway)this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6\u8fd0\u884c\u65f6\u5bf9\u8c61[%1$s]", cls.getCanonicalName()));
    }

    @Override
    public boolean doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        UserContext.setCurrent(null);
        SecurityContextHolder.getContext().setAuthentication(null);
        if (this.getServiceHubFilter() == null) {
            return true;
        }
        if (this.ignoreAuthPatternSet != null) {
            String strRequestURI = ((HttpServletRequest)request).getRequestURI();
            for (String strPattern : this.ignoreAuthPatternSet) {
                if (!this.pathMatcher.match(strPattern, strRequestURI)) continue;
                request.setAttribute("__IGNOREAUTHPATTERN__", (Object)strPattern);
                if (this.getSysServiceAPIDocAdapter() != null && strRequestURI.equals("/v3/api-docs")) {
                    return this.getSysServiceAPIDocAdapter().outputOpenAPIDoc((HttpServletRequest)request, (HttpServletResponse)response);
                }
                return true;
            }
        }
        return this.getServiceHubFilter().doFilter(request, response);
    }

    @Override
    public boolean redoFilter() throws IOException, ServletException {
        if (this.getServiceHubFilter() == null) {
            return false;
        }
        return this.getServiceHubFilter().redoFilter();
    }

    @Override
    public void registerIgnoreAuthPattern(String ignoreAuthPattern) {
        if (this.ignoreAuthPatternSet == null) {
            this.ignoreAuthPatternSet = new HashSet<String>();
        }
        this.ignoreAuthPatternSet.addAll(Arrays.asList(ignoreAuthPattern.split("\\s*,\\s*")));
    }

    @Override
    public void unregisterIgnoreAuthPattern(String ignoreAuthPattern) {
        if (this.ignoreAuthPatternSet == null) {
            return;
        }
        this.ignoreAuthPatternSet.removeAll(Arrays.asList(ignoreAuthPattern.split("\\s*,\\s*")));
    }

    protected void setServiceHubFilter(IServiceHubFilter iServiceHubFilter) {
        this.realServiceHubFilter = iServiceHubFilter;
    }

    protected IServiceHubFilter getServiceHubFilter() {
        return this.realServiceHubFilter;
    }

    @Override
    public IHubSystemRuntime getHubSystemRuntime() {
        return this.getHubSystemRuntime(false);
    }

    @Override
    public IHubSystemRuntime getHubSystemRuntime(boolean bTryMode) {
        if (this.hubSystemRuntime != null || bTryMode) {
            return this.hubSystemRuntime;
        }
        throw new SystemGatewayException((ISystemGateway)this, String.format("\u672a\u5b9a\u4e49\u670d\u52a1\u603b\u7ebf\u7cfb\u7edf", new Object[0]));
    }

    protected void setHubSystemRuntime(IHubSystemRuntime hubSystemRuntime) {
        this.hubSystemRuntime = hubSystemRuntime;
    }

    @Override
    public void registerNamingService(String strServiceId) {
        this.registerNamingService(strServiceId, this.strIPAddress, this.port);
    }

    @Override
    public void registerNamingService(String strServiceId, String strIp, int nPort) {
        if (!this.getServiceHubSetting().isRegisterNamingService()) {
            log.warn((Object)String.format("\u5ffd\u7565\u6ce8\u518c\u547d\u540d\u670d\u52a1[%1$s]", strServiceId));
            return;
        }
        if (this.namingService == null) {
            throw new SystemGatewayException((ISystemGateway)this, "\u547d\u540d\u670d\u52a1\u5bf9\u8c61\u65e0\u6548");
        }
        try {
            if (this.isEnableDebug()) {
                log.warn((Object)String.format("\u8c03\u8bd5\u6a21\u5f0f\u8c03\u6574\u547d\u540d\u670d\u52a1[%1$s] ==> [%1$s-debug]", strServiceId));
                strServiceId = String.format("%1$s-debug", strServiceId);
                this.namingService.registerInstance(strServiceId, this.nacosDiscoveryProperties.getGroup(), strIp, nPort);
            } else {
                this.namingService.registerInstance(strServiceId, this.nacosDiscoveryProperties.getGroup(), strIp, nPort);
            }
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u6ce8\u518c\u547d\u540d\u670d\u52a1[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strServiceId, ex.getMessage()), (Throwable)ex);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u6ce8\u518c\u547d\u540d\u670d\u52a1[%1$s][%3$s:%4$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strServiceId, ex.getMessage(), strIp, nPort), (Throwable)ex);
        }
    }

    @Override
    public void unregisterNamingService(String strServiceId) {
        this.unregisterNamingService(strServiceId, this.strIPAddress, this.port);
    }

    @Override
    public void unregisterNamingService(String strServiceId, String strIp, int nPort) {
        if (!this.getServiceHubSetting().isRegisterNamingService()) {
            log.warn((Object)String.format("\u5ffd\u7565\u6ce8\u9500\u547d\u540d\u670d\u52a1[%1$s]", strServiceId));
            return;
        }
        if (this.namingService == null) {
            throw new SystemGatewayException((ISystemGateway)this, "\u547d\u540d\u670d\u52a1\u5bf9\u8c61\u65e0\u6548");
        }
        try {
            if (this.isEnableDebug()) {
                strServiceId = String.format("%1$s-debug", strServiceId);
            }
            this.namingService.deregisterInstance(strServiceId, this.nacosDiscoveryProperties.getGroup(), strIp, nPort);
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u6ce8\u518c\u547d\u540d\u670d\u52a1[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strServiceId, ex.getMessage()), (Throwable)ex);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u6ce8\u9500\u547d\u540d\u670d\u52a1[%1$s][%3$s:%4$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strServiceId, ex.getMessage(), strIp, nPort), (Throwable)ex);
        }
    }

    @Override
    public void publishConfig(String strConfigId, ObjectNode objectNode) {
        Assert.hasLength((String)strConfigId, (String)"\u4f20\u5165\u952e\u540d\u65e0\u6548");
        if (!this.getServiceHubSetting().isPublishConfig()) {
            log.warn((Object)String.format("\u5ffd\u7565\u53d1\u5e03\u914d\u7f6e[%1$s]", strConfigId));
            return;
        }
        String strBackupConfigId = strConfigId;
        if (!strBackupConfigId.equals(strConfigId = NacosConfigUtils.getDataId(strBackupConfigId))) {
            log.warn((Object)String.format("\u952e\u540d[%1$s]\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff0c\u8f6c\u6362\u81f3[%2$s]\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u952e\u540d\u51b2\u7a81", strBackupConfigId, strConfigId));
        }
        ConfigService configService = this.nacosConfigManager.getConfigService();
        try {
            String strContent = objectNode.toPrettyString();
            String strLastContent = configService.getConfig(strConfigId, this.nacosConfigProperties.getGroup(), 5000L);
            if (DataTypeUtils.compare((int)25, (Object)strContent, (Object)strLastContent) == 0L) {
                log.warn((Object)String.format("\u914d\u7f6e\u9879[%1$s]\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u5ffd\u7565\u53d1\u5e03", strConfigId));
                return;
            }
            configService.publishConfig(strConfigId, this.nacosConfigProperties.getGroup(), strContent, ConfigType.JSON.toString());
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u53d1\u5e03\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u53d1\u5e03\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void publishConfig(String strConfigId, Map map) {
        Assert.hasLength((String)strConfigId, (String)"\u4f20\u5165\u952e\u540d\u65e0\u6548");
        if (!this.getServiceHubSetting().isPublishConfig()) {
            log.warn((Object)String.format("\u5ffd\u7565\u53d1\u5e03\u914d\u7f6e[%1$s]", strConfigId));
            return;
        }
        String strBackupConfigId = strConfigId;
        if (!strBackupConfigId.equals(strConfigId = NacosConfigUtils.getDataId(strBackupConfigId))) {
            log.warn((Object)String.format("\u952e\u540d[%1$s]\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff0c\u8f6c\u6362\u81f3[%2$s]\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u952e\u540d\u51b2\u7a81", strBackupConfigId, strConfigId));
        }
        ConfigService configService = this.nacosConfigManager.getConfigService();
        try {
            Yaml yaml = new Yaml();
            String strContent = yaml.dumpAsMap((Object)map);
            String strLastContent = configService.getConfig(strConfigId, this.nacosConfigProperties.getGroup(), 5000L);
            if (DataTypeUtils.compare((int)25, (Object)strContent, (Object)strLastContent) == 0L) {
                log.warn((Object)String.format("\u914d\u7f6e\u9879[%1$s]\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u5ffd\u7565\u53d1\u5e03", strConfigId));
                return;
            }
            configService.publishConfig(strConfigId, this.nacosConfigProperties.getGroup(), strContent, ConfigType.YAML.toString());
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u53d1\u5e03\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u53d1\u5e03\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void publishConfig(String strConfigId, String strContent) {
        Assert.hasLength((String)strConfigId, (String)"\u4f20\u5165\u952e\u540d\u65e0\u6548");
        if (!this.getServiceHubSetting().isPublishConfig()) {
            log.warn((Object)String.format("\u5ffd\u7565\u53d1\u5e03\u914d\u7f6e[%1$s]", strConfigId));
            return;
        }
        String strBackupConfigId = strConfigId;
        if (!strBackupConfigId.equals(strConfigId = NacosConfigUtils.getDataId(strBackupConfigId))) {
            log.warn((Object)String.format("\u952e\u540d[%1$s]\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff0c\u8f6c\u6362\u81f3[%2$s]\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u952e\u540d\u51b2\u7a81", strBackupConfigId, strConfigId));
        }
        ConfigService configService = this.nacosConfigManager.getConfigService();
        try {
            String strLastContent = configService.getConfig(strConfigId, this.nacosConfigProperties.getGroup(), 5000L);
            if (DataTypeUtils.compare((int)25, (Object)strContent, (Object)strLastContent) == 0L) {
                log.warn((Object)String.format("\u914d\u7f6e\u9879[%1$s]\u6ca1\u6709\u53d1\u751f\u53d8\u5316\uff0c\u5ffd\u7565\u53d1\u5e03", strConfigId));
                return;
            }
            if (strContent == null) {
                strContent = "";
            }
            if (strContent.indexOf("{") == 0) {
                configService.publishConfig(strConfigId, this.nacosConfigProperties.getGroup(), strContent, ConfigType.JSON.toString());
            } else {
                configService.publishConfig(strConfigId, this.nacosConfigProperties.getGroup(), strContent, ConfigType.YAML.toString());
            }
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u53d1\u5e03\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u53d1\u5e03\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public String getConfig(String strConfigId) {
        Assert.hasLength((String)strConfigId, (String)"\u4f20\u5165\u952e\u540d\u65e0\u6548");
        String strBackupConfigId = strConfigId;
        strConfigId = NacosConfigUtils.getDataId(strBackupConfigId);
        if (!strBackupConfigId.equals(strConfigId)) {
            log.warn((Object)String.format("\u952e\u540d[%1$s]\u5305\u542b\u975e\u6cd5\u5b57\u7b26\uff0c\u8f6c\u6362\u81f3[%2$s]\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u952e\u540d\u51b2\u7a81", strBackupConfigId, strConfigId));
        }
        ConfigService configService = this.nacosConfigManager.getConfigService();
        try {
            return configService.getConfig(strConfigId, this.nacosConfigProperties.getGroup(), 5000L);
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u83b7\u53d6\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u83b7\u53d6\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void addConfigListener(final String strConfigId, final IConfigListener listener) {
        Listener l = new Listener(){

            public Executor getExecutor() {
                return listener.getExecutor();
            }

            public void receiveConfigInfo(String configInfo) {
                log.debug((Object)String.format("\u914d\u7f6e\u9879[%1$s]\u53d1\u751f\u53d8\u5316", strConfigId));
                listener.receiveConfigInfo(configInfo);
            }
        };
        ConfigService configService = this.nacosConfigManager.getConfigService();
        try {
            configService.addListener(strConfigId, this.nacosConfigProperties.getGroup(), l);
            this.configListenerMap.put(listener, l);
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u4fa6\u542c\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u4fa6\u542c\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void removeConfigListener(String strConfigId, IConfigListener listener) {
        Listener l = this.configListenerMap.get(listener);
        if (listener == null) {
            log.warn((Object)String.format("\u672a\u6ce8\u518c\u4fa6\u542c\u5668[%1$s]", listener));
            return;
        }
        ConfigService configService = this.nacosConfigManager.getConfigService();
        try {
            configService.removeListener(strConfigId, this.nacosConfigProperties.getGroup(), l);
            this.configListenerMap.remove(listener);
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u53d6\u6d88\u4fa6\u542c\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u53d6\u6d88\u4fa6\u542c\u914d\u7f6e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strConfigId, ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void requireCloudUtilRuntime(Class<?> systemRuntimeCls, Class<? extends ICloudUtilRuntime> cloudUtilCls) {
        this.requiredCloudUtilRuntimeMap.put(cloudUtilCls, systemRuntimeCls);
    }

    @Override
    public AppData invokeGetAppData(String strDeploySystemId, String strSystemTag, String strOrgId, IAuthenticationUser iAuthenticationUser, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strDeploySystemId);
        if (iSystemRuntime instanceof IServiceSystemRuntime) {
            return ((IServiceSystemRuntime)iSystemRuntime).invokeGetAppData(strSystemTag, strOrgId, iAuthenticationUser, objTag);
        }
        throw new SystemGatewayException((ISystemGateway)this, String.format("\u90e8\u7f72\u7cfb\u7edf[%1$s]\u4e0d\u652f\u6301\u6b64\u8c03\u7528", strDeploySystemId));
    }

    @Override
    public AppData invokeGetAppData(String strDeploySystemId, String strDCSystemTag, IAuthenticationUser iAuthenticationUser, Object objTag) throws Throwable {
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strDeploySystemId);
        if (iSystemRuntime instanceof IServiceSystemRuntime) {
            return ((IServiceSystemRuntime)iSystemRuntime).invokeGetAppData(strDCSystemTag, iAuthenticationUser, objTag);
        }
        throw new SystemGatewayException((ISystemGateway)this, String.format("\u90e8\u7f72\u7cfb\u7edf[%1$s]\u4e0d\u652f\u6301\u6b64\u8c03\u7528", strDeploySystemId));
    }

    @Override
    public Object invokeDevOpsAction(String strDeploySystemId, String strAction, Object objBody, String strKey, IUserContext iUserContext, Object objTag) throws Throwable {
        IAuthenticationUser authenticationUser = AuthenticationUser.getCurrentMust();
        if (!(AuthenticationUser.isSuperuser(authenticationUser) || AuthenticationUser.isDevuser(authenticationUser) || iUserContext.isSuperuser())) {
            throw new SystemGatewayException((ISystemGateway)this, "\u5fc5\u987b\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c", 2);
        }
        ISystemRuntime iSystemRuntime = this.getSystemRuntime(strDeploySystemId);
        ISysDevOpsUtilRuntime iSysDevOpsUtilRuntime = (ISysDevOpsUtilRuntime)iSystemRuntime.getSysUtilRuntime(ISysDevOpsUtilRuntime.class, true);
        if (iSysDevOpsUtilRuntime != null) {
            if (!(iSysDevOpsUtilRuntime instanceof ISysUtilContainerOnly) && iSysDevOpsUtilRuntime instanceof IHubSysDevOpsUtilRuntime) {
                return ((IHubSysDevOpsUtilRuntime)((Object)iSysDevOpsUtilRuntime)).executeAction(iSystemRuntime, strAction, objBody, strKey, objTag);
            }
            return iSysDevOpsUtilRuntime.executeAction(strAction, objBody, strKey, objTag);
        }
        IHubSysDevOpsUtilRuntime iHubSysDevOpsUtilRuntime = (IHubSysDevOpsUtilRuntime)this.getHubSystemRuntime().getSysUtilRuntime(IHubSysDevOpsUtilRuntime.class, false);
        return iHubSysDevOpsUtilRuntime.executeAction(iSystemRuntime, strAction, objBody, strKey, objTag);
    }

    protected ISystemRuntime reloadDeploySystem(DeploySystem deploySystem, String strConfigInfo) {
        ISystemRuntime iSystemRuntime = this.getLoadedSystemRuntime(deploySystem.getDeploySystemId(), true);
        if (iSystemRuntime != null) {
            this.logEvent(20000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u6267\u884c\u91cd\u65b0\u90e8\u7f72", this.getId(), deploySystem.getDeploySystemId()), (Object)deploySystem);
            try {
                this.unregisterSystemRuntime(deploySystem, iSystemRuntime);
                this.logEvent(20000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u5378\u8f7d\u6210\u529f", this.getId(), deploySystem.getDeploySystemId()), (Object)deploySystem);
            }
            catch (Throwable ex) {
                this.logEvent(40000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u5378\u8f7d\u53d1\u751f\u5f02\u5e38\uff0c %3$s", this.getId(), deploySystem.getDeploySystemId(), ex.getMessage()), (Object)deploySystem);
                throw new SystemGatewayException((ISystemGateway)this, String.format("\u6ce8\u9500\u7cfb\u7edf[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", deploySystem.getDeploySystemId(), ex.getMessage()), ex);
            }
            iSystemRuntime = null;
        }
        try {
            iSystemRuntime = this.registerDeploySystem(deploySystem);
            this.logEvent(20000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u90e8\u7f72\u6210\u529f", this.getId(), deploySystem.getDeploySystemId()), (Object)deploySystem);
        }
        catch (Throwable ex) {
            this.logEvent(40000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u90e8\u7f72\u53d1\u751f\u5f02\u5e38\uff0c %3$s", this.getId(), deploySystem.getDeploySystemId(), ex.getMessage()), (Object)deploySystem);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u6ce8\u518c\u7cfb\u7edf[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", deploySystem.getDeploySystemId(), ex.getMessage()), ex);
        }
        log.info((Object)String.format("\u91cd\u65b0\u52a0\u8f7d\u7cfb\u7edf[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u5b8c\u6210", deploySystem.getDeploySystemId()));
        return iSystemRuntime;
    }

    @Override
    public Resource resolveWebResource(HttpServletRequest request, String requestPath) {
        for (Map.Entry<String, IServletAppRuntime> entry : this.servletAppRuntimeMap.entrySet()) {
            if (!this.pathMatcher.match(entry.getKey(), requestPath)) continue;
            return entry.getValue().resolveResource(request, requestPath);
        }
        return null;
    }

    @Override
    public IPSSystemService getPSSystemService(String serviceId, boolean tryMode) {
        DeploySystem deploySystem = new DeploySystem();
        deploySystem.setDeploySystemId(serviceId);
        deploySystem.setModelPath("__REMOTE__");
        try {
            return this.getPSSystemService(deploySystem, tryMode);
        }
        catch (Exception ex) {
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u83b7\u53d6\u6307\u5b9a\u670d\u52a1\u7cfb\u7edf[%1$s]\u6a21\u578b\u53d1\u751f\u5f02\u5e38\uff0c%2$s", serviceId, ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public List<ServiceInstance> getNamingServiceInstances(String strServiceId) {
        if (this.namingService == null) {
            throw new SystemGatewayException((ISystemGateway)this, "\u547d\u540d\u670d\u52a1\u5bf9\u8c61\u65e0\u6548");
        }
        try {
            List instanceList = this.namingService.selectInstances(strServiceId, this.nacosDiscoveryProperties.getGroup(), true);
            if (!ObjectUtils.isEmpty((Object)instanceList)) {
                ArrayList<ServiceInstance> list = new ArrayList<ServiceInstance>();
                for (Instance instance : instanceList) {
                    ServiceInstance serviceInstance = new ServiceInstance();
                    serviceInstance.setServiceName(strServiceId);
                    serviceInstance.setIp(instance.getIp());
                    serviceInstance.setPort(instance.getPort());
                    list.add(serviceInstance);
                }
                return list;
            }
            return null;
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u83b7\u53d6\u547d\u540d\u670d\u52a1[%1$s]\u5b9e\u4f8b\u6e05\u5355\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strServiceId, ex.getMessage()), (Throwable)ex);
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u83b7\u53d6\u547d\u540d\u670d\u52a1[%1$s]\u5b9e\u4f8b\u6e05\u5355\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strServiceId, ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public ISystemRuntime reloadSystemRuntime(String serviceId) {
        Assert.hasLength((String)serviceId, (String)"\u672a\u4f20\u5165\u7cfb\u7edf\u6807\u8bc6");
        DeploySystem reloadDeploySystem = null;
        List<DeploySystem> deploySystemList = this.getServiceHubSetting().getDeploySystems();
        if (deploySystemList != null) {
            for (DeploySystem deploySystem : deploySystemList) {
                if (!serviceId.equalsIgnoreCase(deploySystem.getDeploySystemId())) continue;
                reloadDeploySystem = deploySystem;
                break;
            }
        }
        if (reloadDeploySystem == null) {
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u90e8\u7f72\u7cfb\u7edf[%1$s]", serviceId));
        }
        return this.reloadDeploySystem(reloadDeploySystem, null);
    }

    @Override
    public ISystemRuntime getLoadedSystemRuntime(String strDeploySystemId) {
        return this.getLoadedSystemRuntime(strDeploySystemId, false);
    }

    protected synchronized void reloadServiceHub(String strConfigInfo) {
        try {
            this.onReloadServiceHub(strConfigInfo);
            this.logEvent(20000, String.format("\u670d\u52a1\u603b\u7ebf[%1$s]\u91cd\u65b0\u90e8\u7f72\u6210\u529f", this.getId()));
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u91cd\u65b0\u52a0\u8f7d\u670d\u52a1\u603b\u7ebf\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            this.logEvent(10000, String.format("\u670d\u52a1\u603b\u7ebf[%1$s]\u91cd\u65b0\u90e8\u7f72\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getId(), ex.getMessage()), ex);
        }
    }

    protected void onReloadServiceHub(String strConfigInfo) throws Throwable {
        List<DeploySystem> list;
        List<DeploySystem> lastDeploySystemList = this.getServiceHubSetting().getDeploySystems();
        List<DataSource> lastDataSourceList = this.getServiceHubSetting().getDataSources();
        HashMap<String, DeploySystem> lastDeploySystemMap = new HashMap<String, DeploySystem>();
        if (!ObjectUtils.isEmpty(lastDeploySystemList)) {
            for (DeploySystem deploySystem : lastDeploySystemList) {
                lastDeploySystemMap.put(deploySystem.getDeploySystemId(), deploySystem);
            }
        }
        this.getServiceHubSetting().reloadConfig();
        List<DataSource> dataSourceList = this.getServiceHubSetting().getDataSources();
        if (!ObjectUtils.isEmpty(dataSourceList)) {
            for (DataSource ds : dataSourceList) {
                try {
                    if (this.dataSourceMap.containsKey(ds.getDataSourceId())) continue;
                    this.dataSourceMap.put(ds.getDataSourceId(), ds);
                    this.registerDataSource(ds);
                }
                catch (Exception ex) {
                    throw new Exception(String.format("\u6ce8\u518c\u6570\u636e\u6e90[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", ds.getDataSourceId(), ex.getMessage()), ex);
                }
            }
        }
        if (!ObjectUtils.isEmpty(list = this.getServiceHubSetting().getDeploySystems())) {
            for (final DeploySystem deploySystem : list) {
                DeploySystem lastDeploySystem = (DeploySystem)((Object)lastDeploySystemMap.remove(deploySystem.getDeploySystemId()));
                if (lastDeploySystem != null && this.getLoadedSystemRuntime(deploySystem.getDeploySystemId(), true) == null) {
                    lastDeploySystem = null;
                }
                if (lastDeploySystem != null) continue;
                final String strConfigId = String.format("%1$s%2$s-ver", "deploysystem-", deploySystem.getDeploySystemId());
                String strConfig = this.getConfig(strConfigId);
                if (strConfig == null) {
                    strConfig = "";
                }
                this.deploySystemVerMap.put(strConfigId, strConfig);
                this.logEvent(20000, String.format("\u670d\u52a1\u603b\u7ebf[%1$s]\u5b89\u88c5\u670d\u52a1\u7cfb\u7edf[%2$s]", this.getId(), deploySystem.getDeploySystemId()));
                this.reloadDeploySystem(deploySystem, strConfigInfo);
                IConfigListener iConfigListener = new IConfigListener(){

                    @Override
                    public Executor getExecutor() {
                        return null;
                    }

                    @Override
                    public void receiveConfigInfo(String configInfo) {
                        String strConfig = (String)ServiceHubBase.this.deploySystemVerMap.get(strConfigId);
                        if (configInfo == null) {
                            configInfo = "";
                        }
                        if (configInfo.equals(strConfig)) {
                            log.debug((Object)String.format("\u90e8\u7f72\u7cfb\u7edf[%1$s]\u63a5\u6536\u5230\u7248\u672c\u53d8\u5316\uff0c\u4f46\u914d\u7f6e\u5185\u5bb9\u4e00\u81f4\uff0c\u5ffd\u7565", deploySystem.getDeploySystemId()));
                            ServiceHubBase.this.logEvent(20000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u63a5\u6536\u5230\u7248\u672c\u53d8\u5316\uff0c\u4f46\u914d\u7f6e\u5185\u5bb9\u4e00\u81f4\uff0c\u5ffd\u7565\u91cd\u65b0\u90e8\u7f72", ServiceHubBase.this.getId(), deploySystem.getDeploySystemId()), (Object)deploySystem);
                            return;
                        }
                        ServiceHubBase.this.deploySystemVerMap.put(strConfigId, configInfo);
                        log.debug((Object)String.format("\u90e8\u7f72\u7cfb\u7edf[%1$s]\u7248\u672c\u53d1\u751f\u53d8\u5316", deploySystem.getDeploySystemId()));
                        ServiceHubBase.this.logEvent(20000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u63a5\u6536\u5230\u7248\u672c\u53d8\u5316\uff0c\u91cd\u65b0\u90e8\u7f72", ServiceHubBase.this.getId(), deploySystem.getDeploySystemId()), (Object)deploySystem);
                        if (ServiceHubBase.this.isInstalled()) {
                            ServiceHubBase.this.reloadDeploySystem(deploySystem, configInfo);
                        } else {
                            log.warn((Object)String.format("\u670d\u52a1\u603b\u7ebf\u672a\u5b89\u88c5\u5b8c\u6210\uff0c\u5ffd\u7565\u90e8\u7f72\u7cfb\u7edf\u7248\u672c\u53d8\u5316", new Object[0]));
                        }
                    }
                };
                this.addConfigListener(strConfigId, iConfigListener);
                this.deploySystemVerListenerMap.put(strConfigId, iConfigListener);
            }
        }
        lastDeploySystemMap.remove("gateway");
        for (final DeploySystem deploySystem : lastDeploySystemMap.values()) {
            IConfigListener iConfigListener;
            String strConfigId = String.format("%1$s%2$s-ver", "deploysystem-", deploySystem.getDeploySystemId());
            ISystemRuntime iSystemRuntime = this.getLoadedSystemRuntime(deploySystem.getDeploySystemId(), true);
            if (iSystemRuntime != null) {
                try {
                    this.logEvent(20000, String.format("\u670d\u52a1\u603b\u7ebf[%1$s]\u79fb\u9664\u670d\u52a1\u7cfb\u7edf[%2$s]", this.getId(), deploySystem.getDeploySystemId()));
                    this.unregisterSystemRuntime(deploySystem, iSystemRuntime);
                    this.logEvent(20000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u5378\u8f7d\u6210\u529f", this.getId(), deploySystem.getDeploySystemId()), (Object)deploySystem);
                }
                catch (Throwable ex) {
                    this.logEvent(40000, String.format("\u670d\u52a1\u7cfb\u7edf[%2$s@%1$s]\u5378\u8f7d\u53d1\u751f\u5f02\u5e38\uff0c %3$s", this.getId(), deploySystem.getDeploySystemId(), ex.getMessage()), (Object)deploySystem);
                    throw new SystemGatewayException((ISystemGateway)this, String.format("\u6ce8\u9500\u7cfb\u7edf[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", deploySystem.getDeploySystemId(), ex.getMessage()), ex);
                }
                iSystemRuntime = null;
            }
            if ((iConfigListener = this.deploySystemVerListenerMap.remove(strConfigId)) == null) continue;
            this.removeConfigListener(strConfigId, iConfigListener);
        }
    }

    @Override
    public ISystemRuntime registerSystemRuntime(DeploySystem deploySystem) {
        Assert.notNull((Object)((Object)deploySystem), (String)"\u4f20\u5165\u90e8\u7f72\u7cfb\u7edf\u6570\u636e\u5bf9\u8c61\u65e0\u6548");
        try {
            return this.registerDeploySystem(deploySystem);
        }
        catch (Exception ex) {
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u6ce8\u518c\u90e8\u7f72\u7cfb\u7edf[%1$s]\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", deploySystem.getDeploySystemId(), ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void unregisterSystemRuntime(DeploySystem deploySystem) {
        Assert.notNull((Object)((Object)deploySystem), (String)"\u4f20\u5165\u90e8\u7f72\u7cfb\u7edf\u6570\u636e\u5bf9\u8c61\u65e0\u6548");
        try {
            ISystemRuntime iSystemRuntime = this.getLoadedSystemRuntime(deploySystem.getDeploySystemId(), false);
            this.unregisterSystemRuntime(deploySystem, iSystemRuntime);
        }
        catch (Exception ex) {
            throw new SystemGatewayException((ISystemGateway)this, String.format("\u6ce8\u9500\u90e8\u7f72\u7cfb\u7edf[%1$s]\u8fd0\u884c\u65f6\u53d1\u751f\u5f02\u5e38\uff0c%2$s", deploySystem.getDeploySystemId(), ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public String getServiceUrl() {
        return String.format("http://%1$s:%2$s", this.strIPAddress, this.port);
    }

    @Override
    public String getIPAddress() {
        return this.strIPAddress;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getId() {
        return this.getServiceHubSetting().getId();
    }

    protected String getLogCat() {
        return LOGCAT;
    }

    public void logEvent(int nLogLevel, String strInfo) {
        this.logEvent(nLogLevel, strInfo, null);
    }

    public void logEvent(int nLogLevel, String strInfo, Object objData) {
        this.logEvent(nLogLevel, LOGCAT, strInfo, objData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logEvent(int nLogLevel, String strCat, String strInfo, Object objData) {
        boolean bDisabled = EmployeeContext.isCurrentDisabled();
        try {
            EmployeeContext.setCurrentDisabled(true);
            IHubSystemRuntime iHubSystemRuntime = this.getHubSystemRuntime(true);
            if (iHubSystemRuntime != null) {
                if (objData instanceof DeploySystem) {
                    Log log = new Log();
                    log.setSystemId(((DeploySystem)((Object)objData)).getDeploySystemId());
                    log.set("dcsystemid", (Object)((DeploySystem)((Object)objData)).getDeploySystemId());
                    objData = log;
                }
                iHubSystemRuntime.logEvent(nLogLevel, strCat, strInfo, objData);
                return;
            }
            switch (nLogLevel) {
                case 20000: {
                    log.info((Object)strInfo);
                    return;
                }
                case 10000: {
                    log.debug((Object)strInfo);
                    return;
                }
                case 30000: {
                    log.warn((Object)strInfo);
                    return;
                }
                case 40000: {
                    if (objData instanceof Throwable) {
                        log.error((Object)strInfo, (Throwable)objData);
                        return;
                    }
                    log.error((Object)strInfo);
                    return;
                }
            }
            return;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u65e5\u5fd7\u4e8b\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            return;
        }
        finally {
            EmployeeContext.setCurrentDisabled(bDisabled);
        }
    }
}

