/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.wf;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.central.cloud.core.util.domain.WFMember;
import net.ibizsys.central.cloud.core.wf.IWFRoleRuntime;
import net.ibizsys.central.cloud.core.wf.WFRoleRuntimeBase;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.util.EntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.wf.IPSWFDEDataSetRole;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;

public class WFDEDataSetRoleRuntime
extends WFRoleRuntimeBase
implements IWFRoleRuntime {
    private static final Log log = LogFactory.getLog(WFDEDataSetRoleRuntime.class);
    private IPSWFDEDataSetRole iPSWFDEDataSetRole = null;
    private IPSDataEntity iPSDataEntity = null;
    private IPSDEDataSet iPSDEDataSet = null;
    private IPSDEField iWFUserIdDEF = null;
    private IPSDEField iWFUserNameDEF = null;

    protected void onInit() throws Exception {
        if (!(this.getPSWFRole() instanceof IPSWFDEDataSetRole)) {
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u6d41\u7a0b\u89d2\u8272[%1$s]\u7c7b\u578b\u4e0d\u6b63\u786e", this.getPSWFRole().getName()));
        }
        this.iPSWFDEDataSetRole = (IPSWFDEDataSetRole)this.getPSWFRole();
        this.iPSDataEntity = this.iPSWFDEDataSetRole.getPSDataEntityMust();
        this.iPSDEDataSet = this.iPSWFDEDataSetRole.getPSDEDataSetMust();
        this.iWFUserIdDEF = this.iPSWFDEDataSetRole.getWFUserIdPSDEFMust();
        this.iWFUserNameDEF = this.iPSWFDEDataSetRole.getWFUserNamePSDEFMust();
        super.onInit();
    }

    protected IPSWFDEDataSetRole getPSWFDEDataSetRole() {
        return this.iPSWFDEDataSetRole;
    }

    protected void setPSWFDEDataSetRole(IPSWFDEDataSetRole iPSWFDEDataSetRole) {
        this.iPSWFDEDataSetRole = iPSWFDEDataSetRole;
    }

    protected IPSDataEntity getPSDataEntity() {
        return this.iPSDataEntity;
    }

    protected void setPSDataEntity(IPSDataEntity iPSDataEntity) {
        this.iPSDataEntity = iPSDataEntity;
    }

    protected IPSDEDataSet getPSDEDataSet() {
        return this.iPSDEDataSet;
    }

    protected void setPSDEDataSet(IPSDEDataSet iPSDEDataSet) {
        this.iPSDEDataSet = iPSDEDataSet;
    }

    protected IPSDEField getWFUserIdDEF() {
        return this.iWFUserIdDEF;
    }

    protected void setWFUserIdDEF(IPSDEField iWFUserIdDEF) {
        this.iWFUserIdDEF = iWFUserIdDEF;
    }

    protected IPSDEField getWFUserNameDEF() {
        return this.iWFUserNameDEF;
    }

    protected void setWFUserNameDEF(IPSDEField iWFUserNameDEF) {
        this.iWFUserNameDEF = iWFUserNameDEF;
    }

    @Override
    protected List<WFMember> onGetWFMembers(IEntity iEntity) throws Throwable {
        ArrayList<WFMember> emps = new ArrayList<WFMember>();
        IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.iPSDataEntity.getId());
        ISearchContextDTO searchContext = iDataEntityRuntime.createSearchContext();
        if (iEntity != null && iEntity.any() != null) {
            searchContext.any().putAll(iEntity.any());
        }
        searchContext.all();
        Page result = (Page)iDataEntityRuntime.fetchDataSet(this.iPSDEDataSet.getName(), this.iPSDEDataSet, new Object[]{searchContext});
        if (!ObjectUtils.isEmpty((Object)result.getContent())) {
            for (Object obj : result.getContent()) {
                if (!(obj instanceof EntityDTO)) continue;
                EntityDTO data = (EntityDTO)obj;
                Object userIdObj = data.get(this.iWFUserIdDEF.getName());
                Object userNameObj = data.get(this.iWFUserNameDEF.getName());
                if (userIdObj == null) continue;
                WFMember emp = new WFMember();
                emp.setUserId(String.valueOf(userIdObj));
                if (userNameObj != null) {
                    emp.setPersonName(String.valueOf(userNameObj));
                }
                emps.add(emp);
            }
        }
        return emps;
    }
}

