/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.util.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.central.cloud.core.util.ConfigEntity;
import net.ibizsys.central.cloud.core.util.domain.DeployApp;
import net.ibizsys.runtime.util.DateUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AppHub
extends ConfigEntity {
    public static final String FIELD_APPHUBID = "apphubid";
    public static final String FIELD_DEPLOYAPPS = "deployapps";
    public static final String FIELD_MODELSTAMP = "modelstamp";

    public AppHub(String strContent) {
        super(strContent);
        if (!StringUtils.hasLength((String)this.getModelStamp())) {
            this.setModelStamp(DateUtils.getCurTimeString());
        }
    }

    @JsonIgnore
    public String getAppHubId() {
        Object objValue = this.get(FIELD_APPHUBID);
        if (objValue == null) {
            return null;
        }
        return (String)objValue;
    }

    @JsonProperty(value="apphubid")
    public void setAppHubId(String value) {
        this.set(FIELD_APPHUBID, value);
    }

    @JsonIgnore
    public boolean isAppHubIdDirty() {
        return this.contains(FIELD_APPHUBID);
    }

    @JsonIgnore
    public List<DeployApp> getDeployApps() {
        Object value = this.get(FIELD_DEPLOYAPPS);
        if (value instanceof List) {
            List list = (List)value;
            if (ObjectUtils.isEmpty((Object)list)) {
                return null;
            }
            for (Object item : list) {
                if (!(item instanceof DeployApp)) continue;
                return list;
            }
            ArrayList<DeployApp> deployAppList = new ArrayList<DeployApp>();
            this.set(FIELD_DEPLOYAPPS, deployAppList);
            for (Object item : list) {
                String[] apps;
                if (ObjectUtils.isEmpty(item)) continue;
                String strSubApp = item.toString();
                String[] items = strSubApp.split("[:]");
                if (items.length != 2 || !StringUtils.hasLength((String)items[0]) || !StringUtils.hasLength((String)items[1])) {
                    throw new RuntimeException(String.format("\u5185\u5bb9[%1$s]\u683c\u5f0f\u4e0d\u6b63\u786e", strSubApp));
                }
                for (String app : apps = items[1].split("[,]")) {
                    DeployApp deployApp;
                    if (!StringUtils.hasLength((String)app)) continue;
                    String[] menus = app.split("[@]");
                    if (menus.length == 2) {
                        deployApp = new DeployApp();
                        deployApp.setDeploySystemId(items[0]);
                        deployApp.setSubAppMenuTag(menus[0]);
                        deployApp.setAppId(menus[1]);
                        deployApp.setDeployAppId(String.format("%1$s__%2$s__%3$s", items[0], menus[1], menus[0]).toLowerCase());
                        deployAppList.add(deployApp);
                        continue;
                    }
                    deployApp = new DeployApp();
                    deployApp.setDeploySystemId(items[0]);
                    deployApp.setAppId(app);
                    deployApp.setDeployAppId(String.format("%1$s__%2$s", items[0], app).toLowerCase());
                    deployAppList.add(deployApp);
                }
            }
            return deployAppList;
        }
        return null;
    }

    @JsonIgnore
    public String getModelStamp() {
        Object objValue = this.get(FIELD_MODELSTAMP);
        if (objValue == null) {
            return null;
        }
        return (String)objValue;
    }

    @JsonProperty(value="modelstamp")
    public void setModelStamp(String value) {
        this.set(FIELD_MODELSTAMP, value);
    }

    @JsonIgnore
    public boolean isModelStampDirty() {
        return this.contains(FIELD_MODELSTAMP);
    }
}

