/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;

public class RestUtils {
    private static final Log log = LogFactory.getLog(RestUtils.class);
    public static final String HEADER_X_PAGE = "x-page";
    public static final String HEADER_PER_PAGE = "x-per-page";
    public static final String HEADER_X_TOTAL = "x-total";

    public static <T> ResponseEntity<Collection<T>> sendBackPage(Page<T> page, Class<T> cls) {
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).header(HEADER_X_PAGE, new String[]{String.valueOf(page.getPageable().getPageNumber())})).header(HEADER_PER_PAGE, new String[]{String.valueOf(page.getPageable().getPageSize())})).header(HEADER_X_TOTAL, new String[]{String.valueOf(page.getTotalElements())})).body((Object)page.getContent());
    }

    public static ResponseEntity<Collection<?>> sendBackPage(Page<?> page) {
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).header(HEADER_X_PAGE, new String[]{String.valueOf(page.getPageable().getPageNumber())})).header(HEADER_PER_PAGE, new String[]{String.valueOf(page.getPageable().getPageSize())})).header(HEADER_X_TOTAL, new String[]{String.valueOf(page.getTotalElements())})).body((Object)page.getContent());
    }

    public static Map<String, Object> queryString2Map(String queryString) {
        return RestUtils.queryString2Map(queryString, true);
    }

    public static Map<String, Object> queryString2Map(String queryString, boolean bDecode) {
        String[] params;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (!StringUtils.hasLength((String)queryString)) {
            return map;
        }
        for (String paramPair : params = queryString.split("&")) {
            String strValue;
            String strKey;
            String[] keyAndValue = paramPair.split("=");
            if (keyAndValue.length != 2) continue;
            if (bDecode) {
                try {
                    strKey = URLDecoder.decode(keyAndValue[0], "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    strKey = keyAndValue[0];
                    log.error((Object)ex);
                }
                try {
                    strValue = URLDecoder.decode(keyAndValue[1], "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    strValue = keyAndValue[1];
                    log.error((Object)ex);
                }
            } else {
                strKey = keyAndValue[0];
                strValue = keyAndValue[1];
            }
            map.put(strKey, strValue);
        }
        return map;
    }

    public static Map<String, String> header2Map(HttpServletRequest httpServletRequest) {
        return RestUtils.header2Map(httpServletRequest, true);
    }

    public static Map<String, String> header2Map(HttpServletRequest httpServletRequest, boolean bDecode) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration en = httpServletRequest.getHeaderNames();
        while (en.hasMoreElements()) {
            String strKey = (String)en.nextElement();
            String strValue = httpServletRequest.getHeader(strKey);
            if (bDecode) {
                try {
                    strValue = URLDecoder.decode(strValue, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    log.error((Object)ex);
                }
            }
            map.put(strKey.toLowerCase(), strValue);
        }
        return map;
    }

    public static void downloadFile(HttpServletResponse response, File file) throws Exception {
        RestUtils.downloadFile(response, file, false);
    }

    public static void downloadFile(HttpServletResponse response, File file, boolean enableCache) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(file);){
            RestUtils.downloadFile(response, file.getName(), inputStream, enableCache);
        }
    }

    public static void downloadFile(HttpServletResponse response, String fileName, InputStream inputStream, boolean enableCache) throws Exception {
        response.setHeader("Content-Disposition", "attachment;filename=" + RestUtils.getDownloadFileName(fileName));
        if (!enableCache) {
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
        }
        RestUtils.sendResponse(response, inputStream);
    }

    public static String getDownloadFileName(String fileName) {
        try {
            return new String(fileName.getBytes("utf-8"), "iso8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)ex);
            return fileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendResponse(HttpServletResponse response, InputStream inputStream) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(inputStream);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }
}

