/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.ibizsys.central.cloud.core.util.domain.ChatMessage;
import net.ibizsys.central.cloud.core.util.domain.ChatMessageRole;
import org.apache.tools.ant.filters.StringInputStream;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChatMessagesBuilder {
    private List<ChatMessage> list = new ArrayList<ChatMessage>();

    public ChatMessagesBuilder user(String strMessage) {
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setRole(ChatMessageRole.USER.getValue());
        chatMessage.setContent(strMessage);
        this.list.add(chatMessage);
        return this;
    }

    public ChatMessagesBuilder assistant(String strMessage) {
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setRole(ChatMessageRole.ASSISTANT.getValue());
        chatMessage.setContent(strMessage);
        this.list.add(chatMessage);
        return this;
    }

    public ChatMessagesBuilder system(String strMessage) {
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.setRole(ChatMessageRole.SYSTEM.getValue());
        chatMessage.setContent(strMessage);
        this.list.add(chatMessage);
        return this;
    }

    public ChatMessagesBuilder xml(String strXmlMessages) throws Exception {
        if (!StringUtils.hasLength((String)strXmlMessages)) {
            return this;
        }
        strXmlMessages = strXmlMessages.trim();
        String strXML = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<CHATMESSAGES>\r\n%1$s\r\n</CHATMESSAGES>", strXmlMessages);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (StringInputStream is = new StringInputStream(strXML, "UTF-8");){
            Document document = builder.parse((InputStream)is);
            Element root = document.getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String nodeName = element.getNodeName();
                String nodeValue = element.getTextContent();
                if (StringUtils.hasLength((String)nodeValue)) {
                    nodeValue = nodeValue.replace("\r\n", "\n");
                    nodeValue = nodeValue.replace("\r", "\n");
                    nodeValue = StringUtils.trimLeadingCharacter((String)nodeValue, (char)'\n');
                    nodeValue = StringUtils.trimTrailingCharacter((String)nodeValue, (char)'\n');
                }
                if (ChatMessageRole.SYSTEM.getValue().equalsIgnoreCase(nodeName)) {
                    this.system(nodeValue);
                    continue;
                }
                if (ChatMessageRole.USER.getValue().equalsIgnoreCase(nodeName)) {
                    this.user(nodeValue);
                    continue;
                }
                if (ChatMessageRole.ASSISTANT.getValue().equalsIgnoreCase(nodeName)) {
                    this.assistant(nodeValue);
                    continue;
                }
                throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8282\u70b9[%1$s]", nodeName));
            }
        }
        return this;
    }

    public List<ChatMessage> build() {
        return this.build(null);
    }

    public List<ChatMessage> build(List<ChatMessage> dst) {
        if (dst == null) {
            dst = new ArrayList<ChatMessage>();
        }
        dst.addAll(this.list);
        return dst;
    }
}

