/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.sysutil;

import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultClock;
import java.security.Key;
import java.security.PublicKey;
import java.util.Date;
import java.util.function.Function;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.sysutil.SysUAAUtilRuntimeBase;
import net.ibizsys.central.service.client.IWebClientRep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JWTSysUAAUtilRuntime
extends SysUAAUtilRuntimeBase {
    private static final Log log = LogFactory.getLog(JWTSysUAAUtilRuntime.class);
    public static final String NEWRT_UAASERVICE_SIGNATUREKEY_URL = "lb://uaa-api/auths/signaturekey";
    protected static final String SIGNATURE_RSA = "RSA";
    protected static final String SIGNATURE_MAC = "MAC";
    private Clock clock = DefaultClock.INSTANCE;
    private String secret;
    private String signature;
    private boolean enableNewRTUAA = false;
    private String publicKeyString = null;

    protected String getSecret() {
        return this.secret;
    }

    protected void setSecret(String secret) {
        this.secret = secret;
    }

    protected Clock getClock() {
        return this.clock;
    }

    protected void setClock(Clock clock) {
        this.clock = clock;
    }

    protected boolean isEnableNewRTUAA() {
        return this.enableNewRTUAA;
    }

    protected void setEnableNewRTUAA(boolean enableNewRTUAA) {
        this.enableNewRTUAA = enableNewRTUAA;
    }

    protected String getSignature() {
        return this.signature;
    }

    protected void setSignature(String signature) {
        this.signature = signature;
    }

    @Override
    protected void onPrepareDefaultSetting() throws Exception {
        this.setEnableNewRTUAA(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".newrtuaa", this.isEnableNewRTUAA()));
        if (!StringUtils.hasLength((String)this.getSignature())) {
            this.setSignature(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".signature", SIGNATURE_RSA));
        }
        if (!StringUtils.hasLength((String)this.getSecret())) {
            this.setSecret(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".secret", "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAKaTz4pgOR/p0RjlczM0dErf4ZUNziE/HJcfKDLPu77Gs2EJdDK0uGfPI3GX/eRwX9L9bTZJtz9sX2fkRqRt3gWnsMypT2P/cO/2GgtRCPHRFD7BI+Df32isEJZ6M4kD9tyKLw8Y9KuP0C20ZMMDeCrrbjMagMMrwTOM4/4eFjzVAgMBAAECgYEAnH3mj2hgolOmhg4hkOxpiGIV6lMi4OcKtAqoWDwCdHL12GbqTCytxZC7Cp+w/Wh5DZ3aeRL93c6xPsgdeaJh3kYa4ooo6b5tFHPU63VU5MBgwGzi26/6GB4GCXxGMB+SxmdigDmmPIYbXD+jO2oj1s8hj+DOE4U2fIjeZ//DumECQQDlA74KHNZlKxoWl0FoHCgcIHFBZcQWKO3puhrH7VsRYI7CVVguE57NBT6QvAmU9r32PDt64tS0Qd1sCrk4uEqtAkEAujSj/cwF4ctQZCbUoMMzK/mw8ZxW3M6VK3urbq8fyFJ2iT2aLV3jE3+tnDdpezcfnbs/9SVXeFmJpdg/L7hnyQJAQyxo1qCExmHxIgU1uyrfHPjrH2qRLIrO1gqvhkr5tkwjM59C4SkCIFLUejGdgeMp7wrVy4KzLzhOkT1H/PoZdQJAEbKxJ409veFKKcq7CPCkq3hXBg/a/a+w4+okOCfy+GJGG/M79TXoQFExWhi2MNzjZ2WFxbIf5zNzbszn7Iw1aQJBAIXpKrQ0sLxr0rFzsoHBrobPcnQeutzypQNTPkoItILVP9pWz+aUfIKnOHEC5GAdD2LPZZ/pF7ixdRd9nBab+pk=}"));
        }
        super.onPrepareDefaultSetting();
    }

    @Override
    protected boolean onValidateToken(String token, IAuthenticationUser iAuthenticationUser) throws Throwable {
        String strUserName = this.getUsernameFromToken(token);
        if (!strUserName.contentEquals(iAuthenticationUser.getUsername())) {
            return false;
        }
        Date expiration = this.getExpirationDateFromToken(token);
        if (expiration.before(this.clock.now())) {
            return false;
        }
        if (this.isEnableNewRTUAA()) {
            if (ObjectUtils.isEmpty((Object)this.getSignature()) || SIGNATURE_MAC.equalsIgnoreCase(this.getSignature())) {
                return this.validateTokenByMAC(token, iAuthenticationUser);
            }
            if (SIGNATURE_RSA.equalsIgnoreCase(this.signature)) {
                return this.validateTokenByRSA(token, iAuthenticationUser);
            }
            throw new Exception(String.format("RT\u9a8c\u8bc1\u8bbf\u95ee\u4ee4\u724c\u51fa\u9519\uff0c\u7b7e\u540d\u6682\u672a\u652f\u6301[%1$s]\u52a0\u5bc6\u7b97\u6cd5", this.signature));
        }
        return true;
    }

    @Override
    protected String onGetUsernameFromToken(String token) throws Throwable {
        if (!this.isEnableNewRTUAA()) {
            return this.getClaimFromToken(token, Claims::getSubject);
        }
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
        return claimsSet.getSubject();
    }

    @Override
    protected Date onGetExpirationDateFromToken(String token) throws Throwable {
        if (!this.isEnableNewRTUAA()) {
            return this.getClaimFromToken(token, Claims::getExpiration);
        }
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
        return claimsSet.getExpirationTime();
    }

    protected <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) throws Throwable {
        Claims claims = this.getAllClaimsFromToken(token);
        return claimsResolver.apply(claims);
    }

    protected Claims getAllClaimsFromToken(String token) throws Throwable {
        PublicKey publicKey = this.getPublicKey(this.getPublicKeyString());
        return (Claims)Jwts.parser().setSigningKey((Key)publicKey).parseClaimsJws(token).getBody();
    }

    protected boolean validateTokenByMAC(String token, IAuthenticationUser iAuthenticationUser) throws Throwable {
        if (!StringUtils.hasLength((String)this.getSecret())) {
            throw new Exception("RT token\u9a8c\u8bc1\u5931\u8d25\uff0c\u672a\u6307\u5b9asecret");
        }
        Date now = new Date();
        MACVerifier verifier = new MACVerifier(this.getSecret());
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
        return signedJWT.verify((JWSVerifier)verifier) && now.before(claimsSet.getExpirationTime());
    }

    protected boolean validateTokenByRSA(String token, IAuthenticationUser iAuthenticationUser) throws Throwable {
        String signatureKey = this.getPublicKeyString();
        Date now = new Date();
        RSAKey publicJWK = RSAKey.parse((String)signatureKey);
        RSASSAVerifier verifier = new RSASSAVerifier(publicJWK);
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
        if (!signedJWT.verify((JWSVerifier)verifier)) {
            return false;
        }
        if (now.after(claimsSet.getExpirationTime())) {
            throw new Exception(String.format("\u8bbf\u95ee\u4ee4\u724c\u5df2\u8fc7\u671f\uff0c\u4ee4\u724c\u6709\u6548\u671f\u4e3a[%1$s]\uff0c\u5f53\u524d\u65f6\u95f4\u4e3a[%2$s]", claimsSet.getExpirationTime(), now));
        }
        return true;
    }

    @Override
    protected String getPublicKeyString() throws Throwable {
        if (!this.isEnableNewRTUAA()) {
            return super.getPublicKeyString();
        }
        if (StringUtils.hasLength((String)this.publicKeyString)) {
            return this.publicKeyString;
        }
        try {
            IWebClientRep rep = this.getSystemRuntime().getDefaultWebClient().get(NEWRT_UAASERVICE_SIGNATUREKEY_URL);
            if (rep == null || !StringUtils.hasLength((String)((String)rep.getBody()))) {
                throw new Exception("\u8fd4\u56de\u503c\u65e0\u6548");
            }
            this.publicKeyString = (String)rep.getBody();
            return this.publicKeyString;
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u8bf7\u6c42\u7b7e\u540d\u5bc6\u94a5\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }
}

