/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.controller;

import javax.annotation.PostConstruct;
import net.ibizsys.central.ISystemGateway;
import net.ibizsys.central.SystemGatewayException;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.ErrorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={""})
@ConditionalOnProperty(prefix="ibiz.servicehub", name={"localgateway"}, havingValue="true", matchIfMissing=true)
public class LocalGatewayRestController {
    private static final Log log = LogFactory.getLog(LocalGatewayRestController.class);
    public static final String LOCALIP = "127.0.0.1";
    @Autowired
    IServiceHub iServiceHub;

    @PostConstruct
    protected void postConstruct() {
        this.iServiceHub.registerIgnoreAuthPattern("/local/**");
        log.debug((Object)String.format("\u672c\u5730\u7f51\u5173\u670d\u52a1\u5df2\u7ecf\u542f\u52a8", new Object[0]));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/local/{systemid}/{entity}/{method}", "/local/{systemid}/{entity}/{method}/{key}"})
    public ResponseEntity<Object> call(@PathVariable(name="systemid", required=true) String systemid, @PathVariable(name="entity", required=true) String entity, @PathVariable(name="method", required=true) String method, @PathVariable(name="key", required=false) String key, @RequestBody(required=false) Object requestData) {
        try {
            Object obj = this.iServiceHub.invokeDEMethod(systemid, entity, method, ObjectUtils.isEmpty((Object)requestData) ? key : requestData, this.getUserContext(systemid), null);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(obj);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new SystemGatewayException((ISystemGateway)this.iServiceHub, String.format("\u8c03\u7528\u7cfb\u7edf\u670d\u52a1\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c%s", e.getMessage()), e);
        }
    }

    protected IUserContext getUserContext(String systemid) throws Exception {
        String ipaddr = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            ipaddr = ((ServletRequestAttributes)requestAttributes).getRequest().getRemoteAddr();
        }
        if (!this.testLocalIp(ipaddr)) {
            throw new ErrorException("\u672a\u6388\u6743\u8bbf\u95eeIP", 2);
        }
        Employee dcEmployee = new Employee();
        EmployeeContext.fillEmployee(dcEmployee, ((ServletRequestAttributes)requestAttributes).getRequest());
        EmployeeContext employeeContext = new EmployeeContext(dcEmployee, null, systemid);
        return employeeContext;
    }

    protected boolean testLocalIp(String ipaddr) {
        return LOCALIP.equals(ipaddr);
    }
}

