/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.controller;

import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.service.util.MethodHandlerBase;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.cloud.core.util.error.InternalServerErrorException;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.SystemRuntimeHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={""})
public class CallbackRestController {
    private static final Log log = LogFactory.getLog(CallbackRestController.class);
    @Autowired
    IServiceHub iServiceHub;

    @PostConstruct
    protected void postConstruct() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, value={"/wfcallback/{system}/{entity}/{type}/{action}/{token}"})
    public ResponseEntity<Object> wfCallback(@PathVariable(value="system") String system, @PathVariable(value="entity") String entity, @PathVariable(value="type") String actiontype, @PathVariable(value="action") String action, @PathVariable(value="token") String token, @RequestBody Object objData, HttpServletRequest httpServletRequest) {
        ResponseEntity responseEntity;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dename", entity);
        params.put("dEName", entity);
        params.put("actiontype", actiontype);
        params.put("action", action);
        if (objData != null) {
            params.put("data", objData);
        }
        String strParam = MethodHandlerBase.MAPPER.writeValueAsString(params);
        ISystemRuntime iSystemRuntime = this.iServiceHub.getSystemRuntime(system);
        try {
            SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
            Object objRet = iSystemRuntime.invokeBackendTask("PREDEFINED", "WFCALLBACK", null, strParam, (IUserContext)EmployeeContext.getCurrentMust(), null);
            responseEntity = ResponseEntity.ok((Object)objRet);
        }
        catch (Throwable throwable) {
            try {
                SystemRuntimeHolder.poll();
                throw throwable;
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5904\u7406\u5de5\u4f5c\u6d41\u56de\u8c03\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                throw new InternalServerErrorException(ex.getMessage());
            }
        }
        SystemRuntimeHolder.poll();
        return responseEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, value={"/taskcallback/{system}/{tasktype}/{tasktag}"})
    public ResponseEntity<Object> taskCallback(@RequestHeader(value="srfsystemid") String srfsystemid, @RequestHeader(value="srfdcid") String srfdcid, @RequestHeader(value="srfdcsystemid") String srfdcsystemid, @PathVariable(value="system") String system, @PathVariable(value="tasktype") String tasktype, @PathVariable(value="tasktag") String tasktag, @RequestBody(required=false) Object objData, HttpServletRequest httpServletRequest) {
        Employee dcEmployee = new Employee();
        dcEmployee.setSrfdcid(srfdcid);
        EmployeeContext.fillEmployee(dcEmployee, httpServletRequest);
        EmployeeContext employeeContext = new EmployeeContext(dcEmployee, null, srfsystemid);
        UserContext.setCurrent((IUserContext)employeeContext);
        try {
            ResponseEntity responseEntity;
            HashMap params = new HashMap();
            String strParam = MethodHandlerBase.MAPPER.writeValueAsString(params);
            ISystemRuntime iSystemRuntime = this.iServiceHub.getSystemRuntime(system);
            try {
                SystemRuntimeHolder.push((net.ibizsys.runtime.ISystemRuntime)iSystemRuntime);
                Object objRet = iSystemRuntime.invokeBackendTask(tasktype, tasktag, null, strParam, (IUserContext)employeeContext, null);
                responseEntity = ResponseEntity.ok((Object)objRet);
            }
            catch (Throwable throwable) {
                try {
                    SystemRuntimeHolder.poll();
                    throw throwable;
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u5904\u7406\u4efb\u52a1\u56de\u8c03\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                    throw new InternalServerErrorException(ex.getMessage());
                }
            }
            SystemRuntimeHolder.poll();
            return responseEntity;
        }
        finally {
            UserContext.setCurrent(null);
        }
    }
}

