/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.configuration;

import java.util.Arrays;
import java.util.Collections;
import net.ibizsys.central.cloud.core.IServiceHub;
import net.ibizsys.central.cloud.core.app.util.PathResourceResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.servlet.resource.ResourceResolver;

@Configuration
public class ServletAppConfig {
    @Autowired
    IServiceHub serviceHub;

    @Bean
    public SimpleUrlHandlerMapping faviconHandlerMapping() {
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        mapping.setOrder(-2147483647);
        mapping.setUrlMap(Collections.singletonMap(String.format("/%1$s/**", this.serviceHub.getServletAppBaseUrl()), this.webResourceHttpRequestHandler()));
        return mapping;
    }

    @Bean
    public ResourceHttpRequestHandler webResourceHttpRequestHandler() {
        ResourceHttpRequestHandler requestHandler = new ResourceHttpRequestHandler();
        requestHandler.setResourceResolvers(Arrays.asList(new ResourceResolver[]{new PathResourceResolver(this.serviceHub)}));
        return requestHandler;
    }
}

