/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.spring.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import net.ibizsys.central.cloud.core.service.util.MethodHandlerBase;
import net.ibizsys.central.service.client.WebClientBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
public class JacksonSerializerConfig {
    private static final Log log = LogFactory.getLog(JacksonSerializerConfig.class);
    private static final String PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_ZONE = "GMT+8";
    @Autowired
    Jackson2ObjectMapperBuilder jackson2ObjectMapperBuilder;

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(List<HttpMessageConverter<?>> converters) {
        ObjectMapper objectMapper;
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        MethodHandlerBase.MAPPER = objectMapper = this.getObjectMapper();
        WebClientBase.MAPPER = objectMapper;
        WebClientBase.OUTMAPPER = this.getObjectMapper2();
        converter.setObjectMapper(objectMapper);
        return converter;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = this.jackson2ObjectMapperBuilder.build();
        objectMapper.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        String[] patternArr = PATTERN.split(" ");
        module.addSerializer(java.util.Date.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(false), (DateFormat)new SimpleDateFormat(PATTERN)));
        module.addSerializer(Timestamp.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(false), (DateFormat)new SimpleDateFormat(PATTERN)));
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(false), (DateFormat)new SimpleDateFormat(PATTERN)));
        module.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        module.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        module.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        module.addDeserializer(java.util.Date.class, (JsonDeserializer)new DateDeserializers.DateDeserializer(){

            public java.util.Date deserialize(JsonParser jsonParser, DeserializationContext ctxt) {
                try {
                    String text = jsonParser.getText().trim();
                    SimpleDateFormat sdf = new SimpleDateFormat(JacksonSerializerConfig.PATTERN);
                    return sdf.parse(text);
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                    throw new RuntimeException(ex);
                }
            }
        });
        module.addDeserializer(Timestamp.class, (JsonDeserializer)new DateDeserializers.TimestampDeserializer(){

            public Timestamp deserialize(JsonParser jsonParser, DeserializationContext ctxt) {
                try {
                    String text = jsonParser.getText().trim();
                    SimpleDateFormat sdf = new SimpleDateFormat(JacksonSerializerConfig.PATTERN);
                    return new Timestamp(sdf.parse(text).getTime());
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                    throw new RuntimeException(ex);
                }
            }
        });
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializers.SqlDateDeserializer(){

            public Date deserialize(JsonParser jsonParser, DeserializationContext ctxt) {
                try {
                    String text = jsonParser.getText().trim();
                    SimpleDateFormat sdf = new SimpleDateFormat(JacksonSerializerConfig.PATTERN);
                    return new Date(sdf.parse(text).getTime());
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                    throw new RuntimeException(ex);
                }
            }
        });
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    private ObjectMapper getObjectMapper2() {
        ObjectMapper objectMapper = this.jackson2ObjectMapperBuilder.build();
        objectMapper.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        String[] patternArr = PATTERN.split(" ");
        module.addSerializer(java.util.Date.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(false), (DateFormat)new SimpleDateFormat(PATTERN)));
        module.addSerializer(Timestamp.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(false), (DateFormat)new SimpleDateFormat(PATTERN)));
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(false), (DateFormat)new SimpleDateFormat(PATTERN)));
        module.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        module.addSerializer(BigInteger.class, (JsonSerializer)ToStringSerializer.instance);
        module.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        module.addDeserializer(java.util.Date.class, (JsonDeserializer)new DateDeserializers.DateDeserializer(){

            public java.util.Date deserialize(JsonParser jsonParser, DeserializationContext ctxt) {
                try {
                    String text = jsonParser.getText().trim();
                    SimpleDateFormat sdf = new SimpleDateFormat(JacksonSerializerConfig.PATTERN);
                    return sdf.parse(text);
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                    throw new RuntimeException(ex);
                }
            }
        });
        module.addDeserializer(Timestamp.class, (JsonDeserializer)new DateDeserializers.TimestampDeserializer(){

            public Timestamp deserialize(JsonParser jsonParser, DeserializationContext ctxt) {
                try {
                    String text = jsonParser.getText().trim();
                    SimpleDateFormat sdf = new SimpleDateFormat(JacksonSerializerConfig.PATTERN);
                    return new Timestamp(sdf.parse(text).getTime());
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                    throw new RuntimeException(ex);
                }
            }
        });
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializers.SqlDateDeserializer(){

            public Date deserialize(JsonParser jsonParser, DeserializationContext ctxt) {
                try {
                    String text = jsonParser.getText().trim();
                    SimpleDateFormat sdf = new SimpleDateFormat(JacksonSerializerConfig.PATTERN);
                    return new Date(sdf.parse(text).getTime());
                }
                catch (Exception ex) {
                    log.debug((Object)ex);
                    throw new RuntimeException(ex);
                }
            }
        });
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }
}

