/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.service;

import net.ibizsys.central.cloud.core.service.SysRestServiceAPIRuntimeBase;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.service.ISysServiceAPIRuntime;
import net.ibizsys.central.service.SysServiceAPIRuntimeException;
import net.ibizsys.runtime.security.IUserContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class LocalSysRestServiceAPIRuntimeBase
extends SysRestServiceAPIRuntimeBase {
    private static final Log log = LogFactory.getLog(LocalSysRestServiceAPIRuntimeBase.class);
    public static final String LOCALIP = "127.0.0.1";

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    protected void registerIgnoreAuthPatterns() {
        String serviceUrl = this.getBaseUrl();
        if (StringUtils.hasLength((String)serviceUrl)) {
            serviceUrl = serviceUrl + "/**";
            ServiceHub.getInstance().registerIgnoreAuthPattern(serviceUrl);
            log.debug((Object)String.format("\u5ffd\u7565\u8ba4\u8bc1\u8def\u5f84[%s]", serviceUrl));
        }
    }

    @Override
    protected void testAccessUser() throws Throwable {
        String ipaddr = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            ipaddr = ((ServletRequestAttributes)requestAttributes).getRequest().getRemoteAddr();
        }
        if (!this.testLocalIp(ipaddr)) {
            throw new SysServiceAPIRuntimeException((ISysServiceAPIRuntime)this, "\u672a\u6388\u6743\u8bbf\u95eeIP", 2);
        }
    }

    protected boolean testLocalIp(String ipaddr) {
        return LOCALIP.equals(ipaddr);
    }

    protected IUserContext getUserContext() {
        return this.getSystemRuntime().createDefaultUserContext();
    }
}

