/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.security;

import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.ibizsys.central.cloud.core.security.AuthenticationUser;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.servlet.IServiceHubFilter;
import net.ibizsys.central.cloud.core.spring.rt.ServiceHub;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.central.cloud.core.util.domain.MetaDynaModel;
import net.ibizsys.central.cloud.core.util.error.UnauthorizedException;
import net.ibizsys.central.security.UserContextRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EmployeeContext
extends UserContextRuntime
implements IEmployeeContext {
    private static final Log log = LogFactory.getLog(EmployeeContext.class);
    private Employee employee = null;
    private MetaDynaModel dcDynaModel = null;
    private String systemid = null;
    private String dcsystemid = null;
    private String uaausername = null;
    private String uaauserid = null;
    private String mqtttopic = null;
    private String globalsessionid = null;
    private Map<String, Object> sessionParams = new HashMap<String, Object>();
    private Collection<? extends GrantedAuthority> authorities = null;
    private static ThreadLocal<Boolean> currentDisabled = new ThreadLocal();

    public EmployeeContext(Employee employee, MetaDynaModel dcDynaModel, String systemid) {
        this(employee, dcDynaModel, systemid, null);
    }

    public EmployeeContext(Employee employee, MetaDynaModel dcDynaModel, String systemid, Collection<? extends GrantedAuthority> authorities) {
        this(employee, dcDynaModel, systemid, authorities, null);
    }

    public EmployeeContext(Employee employee, MetaDynaModel dcDynaModel, String systemid, Collection<? extends GrantedAuthority> authorities, Map<String, Object> session) {
        Assert.notNull((Object)((Object)employee), (String)"\u4f20\u5165\u673a\u6784\u4eba\u5458\u5bf9\u8c61\u65e0\u6548");
        this.setEmployee(employee);
        this.setMetaDynaModel(dcDynaModel);
        this.setSystemid(systemid);
        this.setAuthorities(authorities);
        this.setSuperuser(this.getEmployee().getSuperUser() != null && this.getEmployee().getSuperUser() == 1);
        if (this.isSuperuser()) {
            this.setSystemadmin(true);
        }
        this.setDcsystemid(this.getEmployee().getDCSystemId());
        this.setTenant(this.getEmployee().getSrfdcid());
        this.setUserid(this.getEmployee().getUserId());
        this.setUsername(this.getEmployee().getPersonName());
        this.setUsercode(this.getEmployee().getUserCode());
        this.setUaauserid(this.getEmployee().getUAAUserId());
        this.setUaausername(this.getEmployee().getUAAUserName());
        this.setOrgid(this.getEmployee().getOrgId());
        this.setOrgname(this.getEmployee().getOrgName());
        this.setOrgcode(this.getEmployee().getOrgCode());
        this.setDeptid(this.getEmployee().getMDeptId());
        this.setDeptname(this.getEmployee().getMDeptName());
        this.setDeptcode(this.getEmployee().getMDeptCode());
        this.setPorg(this.getEmployee().getPOrgIds());
        this.setPdept(this.getEmployee().getPDeptIds());
        this.setSorg(this.getEmployee().getSOrgIds());
        this.setSdept(this.getEmployee().getSDeptIds());
        this.setMqtttopic(this.getEmployee().getMqttTopic());
        this.setGlobalsessionid(this.getEmployee().getGlobalSessionId());
        this.getSessionParams().put("srfpersonid", this.getUserid());
        this.getSessionParams().put("srfpersonname", this.getUsername());
        this.getSessionParams().put("srfdcid", this.getTenant());
        this.getSessionParams().put("srfsystemid", this.getSystemid());
        this.getSessionParams().put("srfdcsystemid", this.getDcsystemid());
        this.getSessionParams().put("srforgsectorid", this.getDeptid());
        this.getSessionParams().put("srforgsectorcode", this.getDeptcode());
        this.getSessionParams().put("srforgsectorname", this.getDeptname());
        this.getSessionParams().put("srforgid", this.getOrgid());
        this.getSessionParams().put("srforgcode", this.getOrgcode());
        this.getSessionParams().put("srforgname", this.getOrgname());
        this.getSessionParams().put("srfuserid", this.getUserid());
        this.getSessionParams().put("srfusername", this.getUsername());
        this.getSessionParams().put("srfporg", this.getPorg());
        this.getSessionParams().put("srfsorg", this.getSorg());
        this.getSessionParams().put("srfpdept", this.getPdept());
        this.getSessionParams().put("srfsdept", this.getSdept());
        this.getSessionParams().put("srfusercode", this.getUsercode());
        this.getSessionParams().put("srfuaauserid", this.getUaauserid());
        if (!ObjectUtils.isEmpty(session)) {
            this.getSessionParams().putAll(session);
        }
        if (this.getMetaDynaModel() != null) {
            // empty if block
        }
    }

    @Override
    public Employee getEmployee() {
        return this.employee;
    }

    protected void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @Override
    public MetaDynaModel getMetaDynaModel() {
        return this.dcDynaModel;
    }

    protected void setMetaDynaModel(MetaDynaModel dcDynaModel) {
        this.dcDynaModel = dcDynaModel;
    }

    public Map<String, Object> getSessionParams() {
        return this.sessionParams;
    }

    @Override
    public String getSystemid() {
        return this.systemid;
    }

    protected void setSystemid(String systemid) {
        this.systemid = systemid;
    }

    @Override
    public String getDcsystemid() {
        return this.dcsystemid;
    }

    protected void setDcsystemid(String dcsystemid) {
        this.dcsystemid = dcsystemid;
    }

    @Override
    public String getUaausername() {
        return this.uaausername;
    }

    protected void setUaausername(String uaausername) {
        this.uaausername = uaausername;
    }

    @Override
    public String getUaauserid() {
        return this.uaauserid;
    }

    protected void setUaauserid(String uaauserid) {
        this.uaauserid = uaauserid;
    }

    @Override
    public String getMqtttopic() {
        return this.mqtttopic;
    }

    protected void setMqtttopic(String mqtttopic) {
        this.mqtttopic = mqtttopic;
    }

    @Override
    public String getGlobalsessionid() {
        return this.globalsessionid;
    }

    protected void setGlobalsessionid(String globalsessionid) {
        this.globalsessionid = globalsessionid;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    protected void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public static boolean isCurrentDisabled() {
        if (currentDisabled.get() == null) {
            return false;
        }
        return currentDisabled.get();
    }

    public static void setCurrentDisabled(boolean bDisabled) {
        currentDisabled.set(bDisabled);
    }

    public static IEmployeeContext getCurrent() {
        IEmployeeContext iEmployeeContext;
        if (EmployeeContext.isCurrentDisabled()) {
            return null;
        }
        if (UserContext.getCurrent() instanceof IEmployeeContext) {
            return (IEmployeeContext)UserContext.getCurrent();
        }
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            Object credentials = SecurityContextHolder.getContext().getAuthentication().getDetails();
            if (credentials instanceof IEmployeeContext) {
                return (IEmployeeContext)credentials;
            }
            credentials = SecurityContextHolder.getContext().getAuthentication().getCredentials();
            if (credentials instanceof IEmployeeContext) {
                return (IEmployeeContext)credentials;
            }
        }
        if (AuthenticationUser.getCurrent() != null && (iEmployeeContext = AuthenticationUser.getCurrent().getEmployeeContext()) != null) {
            return iEmployeeContext;
        }
        if (ServiceHub.getInstance() instanceof IServiceHubFilter) {
            try {
                if (((IServiceHubFilter)((Object)ServiceHub.getInstance())).redoFilter()) {
                    return (IEmployeeContext)UserContext.getCurrent();
                }
            }
            catch (Exception ex) {
                log.error((Object)String.format("\u91cd\u505a\u8fc7\u6ee4\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            }
        }
        return null;
    }

    public static IEmployeeContext getCurrentMust() {
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrent();
        if (iEmployeeContext == null) {
            throw new UnauthorizedException("\u5f53\u524d\u673a\u6784\u7528\u6237\u4e0a\u4e0b\u6587\u65e0\u6548");
        }
        return iEmployeeContext;
    }

    public static void setCurrent(IEmployeeContext iEmployeeContext) {
        UserContext.setCurrent((IUserContext)iEmployeeContext);
    }

    public static void fillEmployee(Employee dcEmployee, HttpServletRequest httpServletRequest) {
        String strValue = httpServletRequest.getHeader("srfdcid");
        if (StringUtils.hasLength((String)strValue)) {
            dcEmployee.setSrfdcid(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfdcsystemid")))) {
            dcEmployee.setDCSystemId(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srforgid")))) {
            dcEmployee.setOrgId(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srforgcode")))) {
            dcEmployee.setOrgCode(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfdeptid")))) {
            dcEmployee.setMDeptId(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfdeptcode")))) {
            dcEmployee.setMDeptCode(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfporgids")))) {
            dcEmployee.setPOrgIds(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfsorgids")))) {
            dcEmployee.setSOrgIds(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfpdeptids")))) {
            dcEmployee.setPDeptIds(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfsdeptids")))) {
            dcEmployee.setSDeptIds(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfuserid")))) {
            dcEmployee.setUserId(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfusercode")))) {
            dcEmployee.setUserCode(strValue);
        }
        if (StringUtils.hasLength((String)(strValue = httpServletRequest.getHeader("srfusername")))) {
            try {
                dcEmployee.setPersonName(URLDecoder.decode(strValue, "UTF-8"));
            }
            catch (Exception ex) {
                log.error((Object)ex);
                dcEmployee.setPersonName(strValue);
            }
        }
    }

    public boolean testSysUniRes(String strUniResCode) {
        if (this.isSuperuser()) {
            return true;
        }
        if (ObjectUtils.isEmpty(this.authorities)) {
            return false;
        }
        if (this.authorities.stream().filter(grantedAuthority -> grantedAuthority.getAuthority().equalsIgnoreCase(strUniResCode)).count() > 0L) {
            return true;
        }
        return super.testSysUniRes(strUniResCode);
    }
}

