/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.ibizsys.central.cloud.core.security.IAuthenticationUser;
import net.ibizsys.central.cloud.core.security.IAuthenticationUserRuntime;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.User;
import net.ibizsys.central.cloud.core.util.error.UnauthorizedException;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.EntityUtils;
import net.ibizsys.runtime.util.IEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthenticationUser
implements IAuthenticationUser,
IAuthenticationUserRuntime {
    private String userid = null;
    private String username = null;
    private String password = null;
    private boolean accountNonExpired = true;
    private boolean accountNonLocked = true;
    private boolean credentialsNonExpired = true;
    private boolean enabled = true;
    private String personid = null;
    private String personname = null;
    private String state = null;
    private int superuser = 0;
    private int apiuser = 0;
    private int devuser = 0;
    private int anonymoususer = 0;
    private String loginname = null;
    private String token = null;
    private String refreshtoken = null;
    private String email = null;
    private String scope = null;
    private int expirein = -1;
    private IEmployeeContext employeeContext = null;
    private Map<String, Object> sessionParams = new HashMap<String, Object>();
    private Collection<? extends GrantedAuthority> authorities = null;

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    @Override
    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getLoginname() {
        return this.loginname;
    }

    public void setLoginname(String loginname) {
        this.loginname = loginname;
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.credentialsNonExpired = credentialsNonExpired;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getPersonid() {
        return this.personid;
    }

    public void setPersonid(String personid) {
        this.personid = personid;
    }

    @Override
    public String getPersonname() {
        return this.personname;
    }

    public void setPersonname(String personname) {
        this.personname = personname;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    @Override
    public int getSuperuser() {
        return this.superuser;
    }

    public void setSuperuser(int superuser) {
        this.superuser = superuser;
    }

    @Override
    public int getApiuser() {
        return this.apiuser;
    }

    public void setApiuser(int apiuser) {
        this.apiuser = apiuser;
    }

    @Override
    public int getDevuser() {
        return this.devuser;
    }

    public void setDevuser(int devuser) {
        this.devuser = devuser;
    }

    @Override
    public int getAnonymoususer() {
        return this.anonymoususer;
    }

    public void setAnonymoususer(int anonymoususer) {
        this.anonymoususer = anonymoususer;
    }

    @Override
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public String getRefreshtoken() {
        return this.refreshtoken;
    }

    @Override
    public void setRefreshtoken(String refreshtoken) {
        this.refreshtoken = refreshtoken;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public int getExpirein() {
        return this.expirein;
    }

    @Override
    public void setExpirein(int nExpirein) {
        this.expirein = nExpirein;
    }

    @Override
    public IEmployeeContext getEmployeeContext() {
        return this.employeeContext;
    }

    @Override
    public void setEmployeeContext(IEmployeeContext employeeContext) {
        this.employeeContext = employeeContext;
    }

    public Map<String, Object> getSessionParams() {
        return this.sessionParams;
    }

    protected void setSessionParams(Map<String, Object> sessionParams) {
        this.sessionParams = sessionParams;
    }

    public static IAuthenticationUser getCurrent() {
        if (SecurityContextHolder.getContext() == null || SecurityContextHolder.getContext().getAuthentication() == null || SecurityContextHolder.getContext().getAuthentication().getPrincipal() == null) {
            return null;
        }
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof IAuthenticationUser) {
            return (IAuthenticationUser)principal;
        }
        return null;
    }

    public static IAuthenticationUser getCurrentMust() {
        IAuthenticationUser authenticationUser = AuthenticationUser.getCurrent();
        if (authenticationUser == null) {
            throw new UnauthorizedException("\u5f53\u524d\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f\u65e0\u6548");
        }
        return authenticationUser;
    }

    public static void setCurrent(IAuthenticationUser iAuthenticationUser) {
        AuthenticationUser.setCurrent(iAuthenticationUser, null);
    }

    public static void setCurrent(IAuthenticationUser iAuthenticationUser, IEmployeeContext iEmployeeContext) {
        if (iAuthenticationUser != null) {
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)iAuthenticationUser, (Object)iEmployeeContext, iAuthenticationUser.getAuthorities());
            authentication.setDetails((Object)iEmployeeContext);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        } else {
            SecurityContextHolder.getContext().setAuthentication(null);
        }
        UserContext.setCurrent((IUserContext)iEmployeeContext);
    }

    public String toString() {
        return String.format("AuthenticationUser[%1$s]", this.getUsername());
    }

    public static AuthenticationUser from(User user) {
        AuthenticationUser authenticationUser = new AuthenticationUser();
        int superuser = DataTypeUtils.asInteger((Object)user.getSuperUser(), (Integer)0);
        EntityUtils.copyTo((IEntity)user, (Object)authenticationUser);
        if (superuser == 2) {
            authenticationUser.setSuperuser(0);
            authenticationUser.setDevuser(1);
        }
        return authenticationUser;
    }

    public static boolean isSuperuser(IAuthenticationUser authenticationUser) {
        return authenticationUser.getSuperuser() == 1;
    }

    public static boolean isDevuser(IAuthenticationUser authenticationUser) {
        return authenticationUser.getDevuser() == 1;
    }

    public static boolean isApiuser(IAuthenticationUser authenticationUser) {
        return authenticationUser.getApiuser() == 1;
    }
}

