/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.eai;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import net.ibizsys.central.cloud.core.eai.ISysEAIAgentRuntime;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.util.domain.Employee;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.domain.DataSyncOut;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class SysEAIAgentRuntimeBase
extends net.ibizsys.central.eai.SysEAIAgentRuntimeBase
implements ISysEAIAgentRuntime {
    private static final Log log = LogFactory.getLog(SysEAIAgentRuntimeBase.class);

    protected void onFillSendData(ObjectNode packageNode, String strSendData, DataSyncOut[] dataSyncOuts) throws Throwable {
        super.onFillSendData(packageNode, strSendData, dataSyncOuts);
        IEmployeeContext iEmployeeContext = EmployeeContext.getCurrent();
        if (iEmployeeContext == null) {
            return;
        }
        ObjectNode empNode = packageNode.putObject("emp");
        if (StringUtils.hasLength((String)iEmployeeContext.getTenant())) {
            empNode.put("tenant", iEmployeeContext.getTenant());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getSystemid())) {
            empNode.put("systemid", iEmployeeContext.getSystemid());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getDcsystemid())) {
            empNode.put("dcsystemid", iEmployeeContext.getDcsystemid());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getOrgid())) {
            empNode.put("orgid", iEmployeeContext.getOrgid());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getOrgcode())) {
            empNode.put("orgcode", iEmployeeContext.getOrgcode());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getOrgname())) {
            empNode.put("orgname", iEmployeeContext.getOrgname());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getDeptid())) {
            empNode.put("deptid", iEmployeeContext.getDeptid());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getDeptcode())) {
            empNode.put("deptcode", iEmployeeContext.getDeptcode());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getDeptname())) {
            empNode.put("deptname", iEmployeeContext.getDeptname());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getUserid())) {
            empNode.put("userid", iEmployeeContext.getUserid());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getUsername())) {
            empNode.put("username", iEmployeeContext.getUsername());
        }
        if (StringUtils.hasLength((String)iEmployeeContext.getUsercode())) {
            empNode.put("usercode", iEmployeeContext.getUsercode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRecv(String strTopic, String strData, Map<String, Object> map) throws Throwable {
        IEmployeeContext lastEmployeeContext = EmployeeContext.getCurrent();
        if (!this.isRawDataMode()) {
            Object emp;
            if (map == null) {
                map = this.getRecvDataMap(strData);
            }
            if ((emp = map.get("emp")) instanceof Map) {
                Map empMap = (Map)emp;
                Employee employee = new Employee();
                String strSystemId = DataTypeUtils.getStringValue(empMap.get("systemid"), null);
                employee.setSrfdcid(DataTypeUtils.getStringValue(empMap.get("tenant"), null));
                employee.setDCSystemId(DataTypeUtils.getStringValue(empMap.get("dcsystemid"), null));
                employee.setUserId(DataTypeUtils.getStringValue(empMap.get("userid"), null));
                employee.setPersonName(DataTypeUtils.getStringValue(empMap.get("username"), null));
                employee.setUserCode(DataTypeUtils.getStringValue(empMap.get("usercode"), null));
                employee.setOrgId(DataTypeUtils.getStringValue(empMap.get("orgid"), null));
                employee.setOrgName(DataTypeUtils.getStringValue(empMap.get("orgname"), null));
                employee.setOrgCode(DataTypeUtils.getStringValue(empMap.get("orgcode"), null));
                employee.setMDeptId(DataTypeUtils.getStringValue(empMap.get("deptid"), null));
                employee.setMDeptName(DataTypeUtils.getStringValue(empMap.get("deptname"), null));
                employee.setMDeptCode(DataTypeUtils.getStringValue(empMap.get("deptcode"), null));
                EmployeeContext.setCurrent(new EmployeeContext(employee, null, strSystemId));
            }
        }
        try {
            super.onRecv(strTopic, strData, map);
        }
        finally {
            EmployeeContext.setCurrent(lastEmployeeContext);
        }
    }
}

