/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.cloud.core.dataentity.wf;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ibizsys.central.cloud.core.dataentity.wf.IDEWFRuntime;
import net.ibizsys.central.cloud.core.security.EmployeeContext;
import net.ibizsys.central.cloud.core.security.IEmployeeContext;
import net.ibizsys.central.cloud.core.sysutil.ISysCloudClientUtilRuntime;
import net.ibizsys.central.cloud.core.sysutil.ISysWFUtilRuntime;
import net.ibizsys.central.cloud.core.util.domain.WFEditableFields;
import net.ibizsys.central.cloud.core.util.domain.WFInstance;
import net.ibizsys.central.cloud.core.util.domain.WFTaskWay;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.service.client.IWebClientRep;
import net.ibizsys.central.util.IEntity;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.EntityUtils;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DEWFRuntime
extends net.ibizsys.central.dataentity.wf.DEWFRuntime
implements IDEWFRuntime {
    private static final Log log = LogFactory.getLog(DEWFRuntime.class);
    private ISysWFUtilRuntime iSysWFUtilRuntime = null;
    private String strCloudServiceId = null;
    private boolean bCalcCloudServiceId = false;
    private ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime = null;

    protected void onInit() throws Exception {
        super.onInit();
        if (this.getSysCloudClientUtilRuntime(true) == null) {
            this.prepareSysCloudClientUtilRuntime(false);
        }
    }

    protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime() {
        return this.getSysCloudClientUtilRuntime(false);
    }

    protected ISysCloudClientUtilRuntime getSysCloudClientUtilRuntime(boolean bTryMode) {
        if (this.iSysCloudClientUtilRuntime != null || bTryMode) {
            return this.iSysCloudClientUtilRuntime;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, "\u672a\u6307\u5b9a\u7cfb\u7edf\u4e91\u4f53\u7cfb\u5ba2\u6237\u7aef\u7ec4\u4ef6");
    }

    protected void setSysCloudClientUtilRuntime(ISysCloudClientUtilRuntime iSysCloudClientUtilRuntime) {
        this.iSysCloudClientUtilRuntime = iSysCloudClientUtilRuntime;
    }

    protected void prepareSysCloudClientUtilRuntime(boolean bTryMode) throws Exception {
        this.setSysCloudClientUtilRuntime((ISysCloudClientUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysCloudClientUtilRuntime.class, bTryMode));
    }

    protected String getCloudServiceId() {
        if (this.bCalcCloudServiceId) {
            return this.strCloudServiceId;
        }
        if (this.getDataEntityRuntime().getSubSysServiceAPIRuntime() != null && PSModelEnums.ServiceType.IBIZCLOUD.value.equals(this.getDataEntityRuntime().getSubSysServiceAPIRuntime().getServiceType())) {
            this.strCloudServiceId = this.getDataEntityRuntime().getSubSysServiceAPIRuntime().getServiceParam();
        }
        this.bCalcCloudServiceId = true;
        return this.strCloudServiceId;
    }

    protected ISysWFUtilRuntime getSysWFUtilRuntime() {
        if (this.iSysWFUtilRuntime == null) {
            this.iSysWFUtilRuntime = (ISysWFUtilRuntime)this.getSystemRuntime().getSysUtilRuntime(ISysWFUtilRuntime.class, false);
        }
        return this.iSysWFUtilRuntime;
    }

    public void start(Object arg0, IPSDEAction iPSDEAction, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
        Object objKey = null;
        WFInstance wfInstance = new WFInstance();
        if (arg0 instanceof IEntityBase) {
            objKey = this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)arg0);
            if (this.getDataEntityRuntime().getMajorPSDEField() != null) {
                wfInstance.setName(String.format("%1$s", this.getDataEntityRuntime().getFieldValue((IEntityBase)arg0, this.getDataEntityRuntime().getMajorPSDEField())));
            }
        } else {
            objKey = arg0;
        }
        if (arg0 instanceof IEntityDTO) {
            IEntityDTO iEntityDTO = (IEntityDTO)arg0;
            LinkedHashMap data = new LinkedHashMap();
            iEntityDTO.copyTo(data, true);
            wfInstance.setActiveData(data);
        }
        String strWorkflowCodeName = this.getPSDEWF().getPSWorkflowMust().getCodeName();
        String strDEName = this.getDataEntityRuntime().getName();
        wfInstance.setProcessDefinitionKey(strWorkflowCodeName);
        log.debug((Object)String.format("\u542f\u52a8\u5b9e\u4f53[%1$s]\u5de5\u4f5c\u6d41[%2$s]", strDEName, strWorkflowCodeName));
        this.getSysWFUtilRuntime().startWFInstance(strDEName, objKey, wfInstance);
    }

    public Object submit(Object arg0, String wfAction, Map<String, Object> params, IPSDEAction iPSDEAction, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
        Object objKey = null;
        WFTaskWay wfTaskWay = new WFTaskWay();
        objKey = arg0 instanceof IEntityBase ? this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)arg0) : arg0;
        String strWorkflowCodeName = this.getPSDEWF().getPSWorkflowMust().getCodeName();
        String strDEName = this.getDataEntityRuntime().getName();
        if (!ObjectUtils.isEmpty(params)) {
            EntityUtils.copyTo(params, (Object)((Object)wfTaskWay));
        }
        log.debug((Object)String.format("\u63d0\u4ea4\u5b9e\u4f53[%1$s]\u5de5\u4f5c\u6d41[%2$s]\u64cd\u4f5c[%3$s]", strDEName, strWorkflowCodeName, wfAction));
        return this.getSysWFUtilRuntime().submitWFTaskWay(strDEName, objKey, wfAction, wfTaskWay);
    }

    public void register(Object arg0, IPSDEAction iPSDEAction, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
        Object objKey = null;
        WFInstance wfInstance = new WFInstance();
        if (arg0 instanceof IEntityBase) {
            objKey = this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)arg0);
            if (this.getDataEntityRuntime().getMajorPSDEField() != null) {
                wfInstance.setName(String.format("%1$s", this.getDataEntityRuntime().getFieldValue((IEntityBase)arg0, this.getDataEntityRuntime().getMajorPSDEField())));
            }
        } else {
            objKey = arg0;
        }
        if (arg0 instanceof IEntityDTO) {
            IEntityDTO iEntityDTO = (IEntityDTO)arg0;
            LinkedHashMap data = new LinkedHashMap();
            iEntityDTO.copyTo(data, true);
            wfInstance.setActiveData(data);
            String strWorkflowCodeName = this.getPSDEWF().getPSWorkflowMust().getCodeName();
            wfInstance.setProcessDefinitionKey(strWorkflowCodeName);
            wfInstance.setProcessDefinitionName(this.getPSDEWF().getPSWorkflowMust().getName());
        }
        this.getSysWFUtilRuntime().registerWFInstance(this.getDataEntityRuntime().getName(), objKey, wfInstance);
    }

    public void unregister(Object arg0, IPSDEAction iPSDEAction, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
        Object objKey = null;
        objKey = arg0 instanceof IEntityBase ? this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)arg0) : arg0;
        this.getSysWFUtilRuntime().unregisterWFInstance(this.getDataEntityRuntime().getName(), objKey);
    }

    public void fillWFTag(Object arg0, IPSDEAction iPSDEAction, IDynaInstRuntime iDynaInstRuntime, Object objRet) throws Throwable {
        Object objKey = null;
        objKey = arg0 instanceof IEntityBase ? this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)arg0) : arg0;
        try {
            WFInstance wfInstance = this.getSysWFUtilRuntime().getWFInstanceByBusinessKey(this.getDataEntityRuntime().getName(), objKey);
            if (wfInstance != null) {
                String strProcessDefinitionKey = (String)wfInstance.get("processDefinitionKey".toLowerCase());
                String[] wfParams = strProcessDefinitionKey.split("-");
                String srfWFTag = "";
                if (wfParams.length > 1) {
                    String strWFVersion = wfParams[wfParams.length - 1];
                    srfWFTag = strWFVersion.substring(0, strWFVersion.lastIndexOf("v"));
                } else {
                    srfWFTag = strProcessDefinitionKey;
                }
                if (objRet instanceof IEntity) {
                    ((IEntity)objRet).set("srfwftag", srfWFTag);
                    ((IEntity)objRet).set("processdefinitionkey", strProcessDefinitionKey);
                    ((IEntity)objRet).set("taskdefinitionkey", (String)wfInstance.get("curstepid".toLowerCase()));
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)String.format("\u5b9e\u4f53[%1$s]\u6570\u636e[%2$s]\u586b\u5145\u5de5\u4f5c\u6d41\u6807\u8bb0\u5f02\u5e38", this.getDataEntityRuntime().getName(), objKey));
        }
    }

    @Override
    public int getAccessMode(Object arg0, Object actionData) throws Throwable {
        Object objKey = null;
        objKey = arg0 instanceof IEntityBase ? this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)arg0) : arg0;
        return this.getSysWFUtilRuntime().getWFInstanceAccessMode(this.getDataEntityRuntime().getName(), objKey);
    }

    @Override
    public WFEditableFields getEditableFields(Object arg0, Object actionData) throws Throwable {
        Object objKey = null;
        objKey = arg0 instanceof IEntityBase ? this.getDataEntityRuntime().getKeyFieldValue((IEntityBase)arg0) : arg0;
        return this.getSysWFUtilRuntime().getWFInstanceEditableFields(this.getDataEntityRuntime().getName(), objKey);
    }

    public void init(Object arg0, IPSDEAction iPSDEAction, Object actionData) throws Throwable {
        String strServiceId = this.getCloudServiceId();
        if (StringUtils.hasLength((String)strServiceId)) {
            this.executeWFCallback(strServiceId, "wfInit", arg0);
            return;
        }
        super.init(arg0, iPSDEAction, actionData);
    }

    public void update(Object arg0, IPSDEAction iPSDEAction, Object actionData) throws Throwable {
        String strServiceId = this.getCloudServiceId();
        if (StringUtils.hasLength((String)strServiceId)) {
            this.executeWFCallback(strServiceId, "wfUpdate", arg0);
            return;
        }
        super.update(arg0, iPSDEAction, actionData);
    }

    public void rollback(Object arg0, IPSDEAction iPSDEAction, Object actionData) throws Throwable {
        String strServiceId = this.getCloudServiceId();
        if (StringUtils.hasLength((String)strServiceId)) {
            this.executeWFCallback(strServiceId, "wfRollback", arg0);
            return;
        }
        super.rollback(arg0, iPSDEAction, actionData);
    }

    public void error(Object arg0, IPSDEAction iPSDEAction, Object actionData) throws Throwable {
        String strServiceId = this.getCloudServiceId();
        if (StringUtils.hasLength((String)strServiceId)) {
            this.executeWFCallback(strServiceId, "wfError", arg0);
            return;
        }
        super.error(arg0, iPSDEAction, actionData);
    }

    public void finish(Object arg0, IPSDEAction iPSDEAction, Object actionData) throws Throwable {
        String strServiceId = this.getCloudServiceId();
        if (StringUtils.hasLength((String)strServiceId)) {
            this.executeWFCallback(strServiceId, "wfFinish", arg0);
            return;
        }
        super.finish(arg0, iPSDEAction, actionData);
    }

    protected void executeWFCallback(String strSystemTag, String strAction, Object objData) throws Throwable {
        this.executeWFCallback(strSystemTag, this.getDataEntityRuntime().getName(), "WFACTION", strAction, objData, String.class, null);
    }

    protected <T> IWebClientRep<T> executeWFCallback(String strSystemTag, String strDataEntity, String strType, String strAction, Object objData, Class<T> cls, String strAppTag) throws Throwable {
        IEmployeeContext employeeContext = EmployeeContext.getCurrentMust();
        HashMap<String, String> uriParams = new HashMap<String, String>();
        HashMap headers = new HashMap();
        uriParams.put("systemid", employeeContext.getSystemid());
        uriParams.put("dcsystemid", employeeContext.getDcsystemid());
        uriParams.put("orgid", employeeContext.getOrgid());
        uriParams.put("system", strSystemTag);
        uriParams.put("app", strAppTag);
        uriParams.put("entity", strDataEntity);
        uriParams.put("action", strAction);
        uriParams.put("type", strType);
        String strServiceId = strSystemTag.toLowerCase();
        String strUrl = String.format("lb://servicehub-%1$s/wfcallback/%2$s/{entity}/{type}/{action}/xxcc", strServiceId, strServiceId);
        return this.getWebClient(String.format("lb://servicehub-%1$s", strServiceId)).post(strUrl, uriParams, headers, null, objData, null, cls, null);
    }

    protected IWebClient getWebClient(String strServiceType) {
        return this.getSysCloudClientUtilRuntime().getServiceClient(strServiceType);
    }
}

